/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.substance;

import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.UIManager;
import javax.swing.plaf.basic.BasicSplitPaneDivider;
import org.jvnet.substance.SubstanceFillBackgroundDelegate;
import org.jvnet.substance.SubstanceImageCreator;
import org.jvnet.substance.SubstanceSplitPaneUI;
import org.jvnet.substance.utils.SubstanceCoreUtilities;

public class SubstanceSplitPaneDivider
extends BasicSplitPaneDivider {
    private SubstanceFillBackgroundDelegate bgDelegate = new SubstanceFillBackgroundDelegate();
    private int inset = 2;

    public SubstanceSplitPaneDivider(SubstanceSplitPaneUI ui) {
        super(ui);
        this.splitPane.setBackground(UIManager.getColor("SplitPane.dividerFocusColor"));
    }

    public void paint(Graphics g) {
        if (SubstanceCoreUtilities.hasFlatProperty(this.splitPane)) {
            this.bgDelegate.update(g, this.splitPane);
        }
        if (this.splitPane.getOrientation() == 0) {
            int bumpWidth = Math.max(20, this.getWidth() / 10);
            BufferedImage bumps = SubstanceImageCreator.getDragImage(bumpWidth, 6);
            g.drawImage(bumps, (this.getWidth() - bumps.getWidth()) / 2, (this.getHeight() - bumps.getHeight()) / 2, null);
        } else {
            int bumpHeight = Math.max(20, this.getHeight() / 10);
            BufferedImage bumps = SubstanceImageCreator.getDragImage(8, bumpHeight);
            g.drawImage(bumps, (this.getWidth() - bumps.getWidth()) / 2, (this.getHeight() - bumps.getHeight()) / 2, null);
        }
        super.paint(g);
    }

    protected JButton createLeftOneTouchButton() {
        Icon verticalSplit = SubstanceImageCreator.getArrowIcon(7, 5, 1, SubstanceCoreUtilities.getActiveScheme(this.splitPane));
        Icon horizontalSplit = SubstanceImageCreator.getArrowIcon(7, 5, 7, SubstanceCoreUtilities.getActiveScheme(this.splitPane));
        JButton b = new JButton(this.splitPane.getOrientation() == 0 ? verticalSplit : horizontalSplit){

            public boolean isFocusable() {
                return false;
            }
        };
        b.putClientProperty("substancelaf.buttonpaintnever", Boolean.TRUE);
        b.setRequestFocusEnabled(false);
        b.setCursor(Cursor.getPredefinedCursor(12));
        b.setFocusPainted(false);
        b.setBorderPainted(false);
        return b;
    }

    protected JButton createRightOneTouchButton() {
        Icon verticalSplit = SubstanceImageCreator.getArrowIcon(7, 5, 5, SubstanceCoreUtilities.getActiveScheme(this.splitPane));
        Icon horizontalSplit = SubstanceImageCreator.getArrowIcon(7, 5, 3, SubstanceCoreUtilities.getActiveScheme(this.splitPane));
        JButton b = new JButton(this.splitPane.getOrientation() == 0 ? verticalSplit : horizontalSplit){

            public boolean isFocusable() {
                return false;
            }
        };
        b.putClientProperty("substancelaf.buttonpaintnever", Boolean.TRUE);
        b.setCursor(Cursor.getPredefinedCursor(12));
        b.setFocusPainted(false);
        b.setBorderPainted(false);
        b.setRequestFocusEnabled(false);
        return b;
    }

    public void updateOneTouchButtons(int orientation) {
        if (orientation == 0) {
            if (this.leftButton != null) {
                this.leftButton.setIcon(SubstanceImageCreator.getArrowIcon(7, 5, 1, SubstanceCoreUtilities.getActiveScheme(this.splitPane)));
            }
            if (this.rightButton != null) {
                this.rightButton.setIcon(SubstanceImageCreator.getArrowIcon(7, 5, 5, SubstanceCoreUtilities.getActiveScheme(this.splitPane)));
            }
        } else {
            if (this.leftButton != null) {
                this.leftButton.setIcon(SubstanceImageCreator.getArrowIcon(7, 5, 7, SubstanceCoreUtilities.getActiveScheme(this.splitPane)));
            }
            if (this.rightButton != null) {
                this.rightButton.setIcon(SubstanceImageCreator.getArrowIcon(7, 5, 3, SubstanceCoreUtilities.getActiveScheme(this.splitPane)));
            }
        }
    }
}

