/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.substance;

import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JInternalFrame;
import javax.swing.JMenuBar;
import javax.swing.JTabbedPane;
import org.jvnet.lafwidget.LafWidgetSupport;
import org.jvnet.lafwidget.utils.LafConstants;
import org.jvnet.substance.SubstanceDesktopIconUI;
import org.jvnet.substance.SubstanceImageCreator;
import org.jvnet.substance.SubstanceLookAndFeel;
import org.jvnet.substance.SubstanceTabbedPaneUI;
import org.jvnet.substance.SubstanceTitlePane;
import org.jvnet.substance.color.ColorScheme;
import org.jvnet.substance.theme.SubstanceTheme;
import org.jvnet.substance.utils.SubstanceCoreUtilities;

public class SubstanceWidgetSupport
extends LafWidgetSupport {
    public JComponent getComponentForHover(JInternalFrame.JDesktopIcon desktopIcon) {
        SubstanceDesktopIconUI ui = (SubstanceDesktopIconUI)desktopIcon.getUI();
        return ui.getComponentForHover();
    }

    public boolean toInstallMenuSearch(JMenuBar menuBar) {
        if (!SubstanceLookAndFeel.toShowExtraElements()) {
            return false;
        }
        return !(menuBar instanceof SubstanceTitlePane.SubstanceMenuBar);
    }

    public Icon getSearchIcon(int dimension, ComponentOrientation componentOrientation) {
        return SubstanceImageCreator.getSearchIcon(dimension, SubstanceCoreUtilities.getDefaultScheme(null), componentOrientation.isLeftToRight());
    }

    public Icon getNumberIcon(int number) {
        return SubstanceImageCreator.getHexaMarker(number, SubstanceCoreUtilities.getActiveTheme(null));
    }

    public void markButtonAsFlat(AbstractButton button) {
        button.putClientProperty("substancelaf.componentFlat", Boolean.TRUE);
    }

    public int getRolloverTabIndex(JTabbedPane tabbedPane) {
        SubstanceTabbedPaneUI ui = (SubstanceTabbedPaneUI)tabbedPane.getUI();
        return ui.getRolloverTabIndex();
    }

    public void setTabAreaInsets(JTabbedPane tabbedPane, Insets tabAreaInsets) {
        SubstanceTabbedPaneUI ui = (SubstanceTabbedPaneUI)tabbedPane.getUI();
        ui.setTabAreaInsets(tabAreaInsets);
    }

    public Insets getTabAreaInsets(JTabbedPane tabbedPane) {
        SubstanceTabbedPaneUI ui = (SubstanceTabbedPaneUI)tabbedPane.getUI();
        return ui.getTabAreaInsets();
    }

    public Rectangle getTabRectangle(JTabbedPane tabbedPane, int tabIndex) {
        SubstanceTabbedPaneUI ui = (SubstanceTabbedPaneUI)tabbedPane.getUI();
        return ui.getTabRectangle(tabIndex);
    }

    public void paintPasswordStrengthMarker(Graphics g, int x, int y, int width, int height, LafConstants.PasswordStrength pStrength) {
        Graphics2D g2 = (Graphics2D)g.create();
        ColorScheme colorScheme = null;
        if (pStrength == LafConstants.PasswordStrength.WEAK) {
            colorScheme = SubstanceTheme.ORANGE;
        }
        if (pStrength == LafConstants.PasswordStrength.MEDIUM) {
            colorScheme = SubstanceTheme.YELLOW;
        }
        if (pStrength == LafConstants.PasswordStrength.STRONG) {
            colorScheme = SubstanceTheme.GREEN;
        }
        if (colorScheme != null) {
            SubstanceImageCreator.paintRectangularBackground(g, x, y, width, height, colorScheme, true, false);
        }
        g2.dispose();
    }

    public boolean hasLockIcon(Component comp) {
        if (!SubstanceLookAndFeel.toShowExtraElements()) {
            return false;
        }
        return super.hasLockIcon(comp);
    }

    public Icon getLockIcon() {
        return SubstanceImageCreator.getSmallLockIcon(SubstanceCoreUtilities.getDefaultScheme(null));
    }
}

