/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.substance.painter.noise;

import java.awt.Color;
import java.awt.image.BufferedImage;
import java.awt.image.ConvolveOp;
import java.awt.image.DataBufferInt;
import java.awt.image.Kernel;
import org.jvnet.substance.color.ColorScheme;
import org.jvnet.substance.painter.noise.NoiseFilter;
import org.jvnet.substance.utils.PerlinNoiseGenerator;
import org.jvnet.substance.utils.SubstanceColorUtilities;

public class NoiseFactory {
    public static BufferedImage getNoiseImage(ColorScheme colorScheme1, ColorScheme colorScheme2, int width, int height, double xFactor, double yFactor, boolean hasConstantZ, NoiseFilter noiseFilter, boolean toBlur) {
        Color c1_1 = SubstanceColorUtilities.getInterpolatedColor(colorScheme1.getMidColor(), colorScheme1.getLightColor(), 0.6);
        Color c2_1 = colorScheme1.getLightColor();
        Color c3_1 = colorScheme1.getUltraLightColor();
        Color c1_2 = SubstanceColorUtilities.getInterpolatedColor(colorScheme2.getMidColor(), colorScheme2.getLightColor(), 0.6);
        Color c2_2 = colorScheme2.getLightColor();
        Color c3_2 = colorScheme2.getUltraLightColor();
        Color c1 = SubstanceColorUtilities.getInterpolatedColor(c1_1, c1_2, 0.1);
        Color c2 = SubstanceColorUtilities.getInterpolatedColor(c2_1, c2_2, 0.5);
        Color c3 = SubstanceColorUtilities.getInterpolatedColor(c3_1, c3_2, 0.9);
        BufferedImage dst = new BufferedImage(width, height, 2);
        int[] dstBuffer = ((DataBufferInt)dst.getRaster().getDataBuffer()).getData();
        double m2 = xFactor * (double)width * xFactor * (double)width + yFactor * (double)height * yFactor * (double)height;
        int pos = 0;
        for (int j = 0; j < height; ++j) {
            double jj = yFactor * (double)j;
            for (int i = 0; i < width; ++i) {
                double ii = xFactor * (double)i;
                double z = hasConstantZ ? 1.0 : Math.sqrt(m2 - ii * ii - jj * jj);
                double noise = 0.5 + 0.5 * PerlinNoiseGenerator.noise(ii, jj, z);
                if (noiseFilter != null) {
                    noise = noiseFilter.apply(i, j, z, noise);
                }
                dstBuffer[pos++] = noise < 0.5 ? SubstanceColorUtilities.getInterpolatedRGB(c2, c1, 2.0 * noise) : SubstanceColorUtilities.getInterpolatedRGB(c3, c2, 2.0 * (noise - 0.5));
            }
        }
        if (toBlur) {
            ConvolveOp convolve = new ConvolveOp(new Kernel(3, 3, new float[]{0.08f, 0.08f, 0.08f, 0.08f, 0.38f, 0.08f, 0.08f, 0.08f, 0.08f}), 1, null);
            dst = convolve.filter(dst, null);
        }
        return dst;
    }
}

