/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.substance.theme;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.UIDefaults;
import javax.swing.border.LineBorder;
import javax.swing.plaf.BorderUIResource;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.IconUIResource;
import javax.swing.plaf.InsetsUIResource;
import javax.swing.plaf.basic.BasicBorders;
import javax.swing.plaf.metal.DefaultMetalTheme;
import org.jvnet.substance.SubstanceBorder;
import org.jvnet.substance.SubstanceDefaultListCellRenderer;
import org.jvnet.substance.SubstanceIconFactory;
import org.jvnet.substance.SubstanceImageCreator;
import org.jvnet.substance.SubstanceLookAndFeel;
import org.jvnet.substance.SubstancePaneBorder;
import org.jvnet.substance.SubstanceToolBarBorder;
import org.jvnet.substance.color.AquaColorScheme;
import org.jvnet.substance.color.BottleGreenColorScheme;
import org.jvnet.substance.color.ColorScheme;
import org.jvnet.substance.color.DarkGrayColorScheme;
import org.jvnet.substance.color.DarkMetallicColorScheme;
import org.jvnet.substance.color.InvertedColorScheme;
import org.jvnet.substance.color.LightGrayColorScheme;
import org.jvnet.substance.color.MetallicColorScheme;
import org.jvnet.substance.color.SunGlareColorScheme;
import org.jvnet.substance.color.SunfireRedColorScheme;
import org.jvnet.substance.theme.MixedThemeInfo;
import org.jvnet.substance.theme.SubstanceInvertedTheme;
import org.jvnet.substance.theme.SubstanceMixBiTheme;
import org.jvnet.substance.theme.SubstanceSaturatedTheme;
import org.jvnet.substance.theme.SubstanceShadeTheme;
import org.jvnet.substance.theme.SubstanceTintTheme;
import org.jvnet.substance.theme.SubstanceToneTheme;
import org.jvnet.substance.theme.ThemeInfo;
import org.jvnet.substance.utils.SubstanceColorUtilities;
import org.jvnet.substance.utils.SubstanceConstants;
import org.jvnet.substance.utils.SubstanceCoreUtilities;

public class SubstanceTheme
extends DefaultMetalTheme {
    private ColorUIResource PRIMARY1;
    private ColorUIResource PRIMARY2;
    private ColorUIResource PRIMARY3;
    private ColorUIResource SECONDARY1;
    private ColorUIResource SECONDARY2;
    private ColorUIResource SECONDARY3;
    private ColorUIResource WHITE;
    private ColorScheme colorScheme;
    private ThemeKind kind;
    private String displayName;
    private static Map<String, SubstanceTheme> allThemes = new HashMap<String, SubstanceTheme>();
    public static ColorScheme AQUA = new AquaColorScheme();
    public static ColorScheme GREEN = new BottleGreenColorScheme();
    public static ColorScheme YELLOW = new SunGlareColorScheme();
    public static ColorScheme ORANGE = new SunfireRedColorScheme();
    private static ColorScheme METALLIC_SCHEME = new MetallicColorScheme();
    private static ColorScheme INVERTED_METALLIC_SCHEME = new InvertedColorScheme(METALLIC_SCHEME);
    private static ColorScheme DARK_METALLIC_SCHEME = new DarkMetallicColorScheme();
    private static ColorScheme DARK_GRAY_SCHEME = new DarkGrayColorScheme();
    private static ColorScheme LIGHT_GRAY_SCHEME = new LightGrayColorScheme();
    private static ColorScheme INVERTED_LIGHT_GRAY_SCHEME = new InvertedColorScheme(LIGHT_GRAY_SCHEME);
    private static SubstanceTheme METALLIC = new SubstanceTheme(METALLIC_SCHEME, "Metallic", ThemeKind.COLD);
    private static SubstanceTheme INVERTED_METALLIC = new SubstanceTheme(INVERTED_METALLIC_SCHEME, "Inverted Metallic", ThemeKind.INVERTED);
    private static SubstanceTheme DARK_METALLIC = new SubstanceTheme(DARK_METALLIC_SCHEME, "Dark Metallic", ThemeKind.DARK);
    private static SubstanceTheme DARK_GRAY = new SubstanceTheme(DARK_GRAY_SCHEME, "Dark Gray", ThemeKind.DARK);
    private static SubstanceTheme LIGHT_GRAY = new SubstanceTheme(LIGHT_GRAY_SCHEME, "Light Gray", ThemeKind.COLD);
    private static SubstanceTheme INVERTED_LIGHT_GRAY = new SubstanceTheme(INVERTED_LIGHT_GRAY_SCHEME, "Inverted Light Gray", ThemeKind.INVERTED);

    public SubstanceTheme(ColorScheme colorScheme, String displayName, ThemeKind themeKind) {
        this.kind = themeKind;
        this.colorScheme = colorScheme;
        this.displayName = displayName;
        this.PRIMARY1 = new ColorUIResource(this.colorScheme.getMidColor());
        this.PRIMARY2 = new ColorUIResource(this.colorScheme.getLightColor());
        this.PRIMARY3 = new ColorUIResource(this.colorScheme.getExtraLightColor());
        this.SECONDARY1 = new ColorUIResource(SubstanceTheme.getDefaultColorScheme(themeKind).getMidColor());
        this.SECONDARY2 = new ColorUIResource(SubstanceTheme.getDefaultColorScheme(themeKind).getLightColor());
        this.SECONDARY3 = new ColorUIResource(SubstanceTheme.getDefaultColorScheme(themeKind).getExtraLightColor());
        this.WHITE = new ColorUIResource(this.colorScheme.getUltraLightColor().brighter());
        if (colorScheme instanceof AquaColorScheme) {
            AQUA = colorScheme;
        }
        allThemes.put(displayName, this);
    }

    public ColorScheme getColorScheme() {
        return this.colorScheme;
    }

    public String getThemeName() {
        return this.getDisplayName();
    }

    public void addCustomEntriesToTable(UIDefaults table) {
        if (table == null) {
            return;
        }
        super.addCustomEntriesToTable(table);
        UIDefaults.LazyValue menuArrowIcon = new UIDefaults.LazyValue(){

            public Object createValue(UIDefaults table) {
                return new Icon(){
                    Icon ltrIcon = SubstanceImageCreator.getArrowIcon(7, 5, 3, SubstanceCoreUtilities.getDefaultScheme(null));
                    Icon rtlIcon = SubstanceImageCreator.getArrowIcon(7, 5, 7, SubstanceCoreUtilities.getDefaultScheme(null));

                    public int getIconHeight() {
                        return 7;
                    }

                    public int getIconWidth() {
                        return 5;
                    }

                    public void paintIcon(Component c, Graphics g, int x, int y) {
                        if (c.getComponentOrientation().isLeftToRight()) {
                            this.ltrIcon.paintIcon(c, g, x, y);
                        } else {
                            this.rtlIcon.paintIcon(c, g, x, y);
                        }
                    }
                };
            }
        };
        UIDefaults.ActiveValue listCellRendererActiveValue = new UIDefaults.ActiveValue(){

            public Object createValue(UIDefaults table) {
                return new SubstanceDefaultListCellRenderer.SubstanceUIResource();
            }
        };
        ColorUIResource controlText = new ColorUIResource(this.colorScheme.getLightColor());
        final ColorUIResource foregroundColor = new ColorUIResource(SubstanceColorUtilities.getForegroundColor(this));
        ColorUIResource backgroundColor = new ColorUIResource(SubstanceColorUtilities.getBackgroundColor(this));
        ColorUIResource backgroundLightColor = new ColorUIResource(backgroundColor.brighter());
        ColorUIResource disabledForegroundColor = new ColorUIResource(SubstanceColorUtilities.getDisabledForegroundColor(this));
        ColorUIResource lineColor = new ColorUIResource(SubstanceColorUtilities.getLineColor(this));
        ColorUIResource selectionBackgroundColor = new ColorUIResource(SubstanceColorUtilities.getSelectionBackgroundColor(this));
        ColorUIResource selectionForegroundColor = new ColorUIResource(SubstanceColorUtilities.getSelectionForegroundColor(this));
        BorderUIResource.CompoundBorderUIResource regularMarginBorder = new BorderUIResource.CompoundBorderUIResource(new SubstanceBorder(), new BasicBorders.MarginBorder());
        SubstanceBorder regularBorder = new SubstanceBorder(1);
        BorderUIResource.CompoundBorderUIResource textBorder = new BorderUIResource.CompoundBorderUIResource(new SubstanceBorder(), new BasicBorders.MarginBorder());
        ColorScheme activeScheme = this.getActiveTheme().getColorScheme();
        final SubstanceTheme topDecorationTheme = this;
        Object[] defaults = new Object[]{"control", controlText, "Button.disabledText", disabledForegroundColor, "Button.foreground", foregroundColor, "Button.margin", new InsetsUIResource(0, 0, 0, 0), "CheckBox.background", backgroundColor, "CheckBox.disabledText", disabledForegroundColor, "CheckBox.foreground", foregroundColor, "CheckBoxMenuItem.acceleratorForeground", foregroundColor, "CheckBoxMenuItem.acceleratorSelectionForeground", foregroundColor, "CheckBoxMenuItem.background", backgroundColor, "CheckBoxMenuItem.borderPainted", Boolean.FALSE, "CheckBoxMenuItem.checkIcon", new UIDefaults.LazyValue(){

            public Object createValue(UIDefaults table) {
                return new IconUIResource(SubstanceIconFactory.getCheckBoxMenuItemIcon(10));
            }
        }, "CheckBoxMenuItem.disabledForeground", disabledForegroundColor, "CheckBoxMenuItem.foreground", foregroundColor, "CheckBoxMenuItem.selectionForeground", foregroundColor, "ColorChooser.background", backgroundColor, "ColorChooser.foreground", foregroundColor, "ComboBox.background", backgroundLightColor, "ComboBox.border", textBorder, "ComboBox.foreground", foregroundColor, "ComboBox.selectionForeground", foregroundColor, "ComboBox.disabledBackground", backgroundLightColor, "ComboBox.disabledForeground", disabledForegroundColor, "DesktopIcon.border", regularMarginBorder, "DesktopIcon.width", new Integer(140), "Desktop.background", backgroundColor, "Desktop.foreground", foregroundColor, "Dialog.background", backgroundColor, "EditorPane.background", backgroundLightColor, "EditorPane.border", textBorder, "EditorPane.foreground", foregroundColor, "EditorPane.caretForeground", foregroundColor, "EditorPane.inactiveBackground", backgroundLightColor, "EditorPane.inactiveForeground", disabledForegroundColor, "EditorPane.selectionBackground", selectionBackgroundColor, "EditorPane.selectionForeground", selectionForegroundColor, "FileChooser.upFolderIcon", new UIDefaults.LazyValue(){

            public Object createValue(UIDefaults table) {
                return new ImageIcon(SubstanceImageCreator.getTreeNodeIcon(SubstanceTheme.this.isDark(), SubstanceConstants.TreeIcon.UP));
            }
        }, "FileChooser.newFolderIcon", new UIDefaults.LazyValue(){

            public Object createValue(UIDefaults table) {
                return new ImageIcon(SubstanceImageCreator.getTreeNodeIcon(SubstanceTheme.this.isDark(), SubstanceConstants.TreeIcon.NONE));
            }
        }, "FileChooser.homeFolderIcon", new UIDefaults.LazyValue(){

            public Object createValue(UIDefaults table) {
                return new ImageIcon(SubstanceImageCreator.getHomeIcon(SubstanceTheme.this.isDark()));
            }
        }, "FileView.computerIcon", new UIDefaults.LazyValue(){

            public Object createValue(UIDefaults table) {
                return new ImageIcon(SubstanceImageCreator.getComputerIcon());
            }
        }, "FileView.directoryIcon", new UIDefaults.LazyValue(){

            public Object createValue(UIDefaults table) {
                return new ImageIcon(SubstanceImageCreator.getTreeNodeIcon(SubstanceTheme.this.isDark(), SubstanceConstants.TreeIcon.CLOSED));
            }
        }, "FileView.fileIcon", new UIDefaults.LazyValue(){

            public Object createValue(UIDefaults table) {
                return new ImageIcon(SubstanceImageCreator.getTreeLeafIcon(SubstanceTheme.this.isDark()));
            }
        }, "FileView.floppyDriveIcon", new UIDefaults.LazyValue(){

            public Object createValue(UIDefaults table) {
                return new ImageIcon(SubstanceImageCreator.getFloppyIcon(SubstanceTheme.this.isDark()));
            }
        }, "FileView.hardDriveIcon", new UIDefaults.LazyValue(){

            public Object createValue(UIDefaults table) {
                return new ImageIcon(SubstanceImageCreator.getDiskIcon(SubstanceTheme.this.isDark()));
            }
        }, "FormattedTextField.background", backgroundLightColor, "FormattedTextField.border", textBorder, "FormattedTextField.caretForeground", foregroundColor, "FormattedTextField.foreground", foregroundColor, "FormattedTextField.inactiveBackground", backgroundLightColor, "FormattedTextField.inactiveForeground", disabledForegroundColor, "FormattedTextField.selectionBackground", selectionBackgroundColor, "FormattedTextField.selectionForeground", selectionForegroundColor, "InternalFrame.border", new BorderUIResource(new SubstancePaneBorder()), "InternalFrame.closeIcon", new UIDefaults.LazyValue(){

            public Object createValue(UIDefaults table) {
                return SubstanceImageCreator.getCloseIcon(topDecorationTheme);
            }
        }, "InternalFrame.iconifyIcon", new UIDefaults.LazyValue(){

            public Object createValue(UIDefaults table) {
                return SubstanceImageCreator.getMinimizeIcon(topDecorationTheme);
            }
        }, "InternalFrame.maximizeIcon", new UIDefaults.LazyValue(){

            public Object createValue(UIDefaults table) {
                return SubstanceImageCreator.getMaximizeIcon(topDecorationTheme);
            }
        }, "InternalFrame.minimizeIcon", new UIDefaults.LazyValue(){

            public Object createValue(UIDefaults table) {
                return SubstanceImageCreator.getRestoreIcon(topDecorationTheme);
            }
        }, "InternalFrame.paletteCloseIcon", new UIDefaults.LazyValue(){

            public Object createValue(UIDefaults table) {
                return SubstanceImageCreator.getCloseIcon(topDecorationTheme);
            }
        }, "Label.background", backgroundColor, "Label.foreground", foregroundColor, "Label.disabledForeground", disabledForegroundColor, "List.background", backgroundColor, "List.cellRenderer", listCellRendererActiveValue, "List.focusCellHighlightBorder", regularBorder, "List.foreground", foregroundColor, "List.selectionBackground", new ColorUIResource(activeScheme.getLightColor()), "List.selectionForeground", foregroundColor, "Menu.arrowIcon", menuArrowIcon, "Menu.background", backgroundColor, "Menu.borderPainted", Boolean.FALSE, "Menu.disabledForeground", disabledForegroundColor, "Menu.foreground", foregroundColor, "Menu.selectionForeground", foregroundColor, "MenuBar.background", backgroundColor, "MenuBar.border", null, "MenuItem.acceleratorForeground", foregroundColor, "MenuItem.acceleratorSelectionForeground", foregroundColor, "MenuItem.background", backgroundColor, "MenuItem.borderPainted", Boolean.FALSE, "MenuItem.disabledForeground", disabledForegroundColor, "MenuItem.foreground", foregroundColor, "MenuItem.selectionForeground", foregroundColor, "OptionPane.background", backgroundColor, "OptionPane.errorIcon", new UIDefaults.LazyValue(){

            public Object createValue(UIDefaults table) {
                return SubstanceImageCreator.getErrorMarkerIcon(31, SubstanceCoreUtilities.getOptionPaneColorScheme(0, SubstanceTheme.this.colorScheme));
            }
        }, "OptionPane.foreground", foregroundColor, "OptionPane.informationIcon", new UIDefaults.LazyValue(){

            public Object createValue(UIDefaults table) {
                return SubstanceImageCreator.getInfoMarkerIcon(32, SubstanceCoreUtilities.getOptionPaneColorScheme(1, SubstanceTheme.this.colorScheme));
            }
        }, "OptionPane.messageForeground", foregroundColor, "OptionPane.questionIcon", new UIDefaults.LazyValue(){

            public Object createValue(UIDefaults table) {
                return SubstanceImageCreator.getQuestionMarkerIcon(31, SubstanceCoreUtilities.getOptionPaneColorScheme(3, SubstanceTheme.this.colorScheme));
            }
        }, "OptionPane.warningIcon", new UIDefaults.LazyValue(){

            public Object createValue(UIDefaults table) {
                return SubstanceImageCreator.getWarningMarkerIcon(32, SubstanceCoreUtilities.getOptionPaneColorScheme(2, SubstanceTheme.this.colorScheme));
            }
        }, "Panel.background", backgroundColor, "Panel.foreground", foregroundColor, "PasswordField.background", backgroundLightColor, "PasswordField.border", textBorder, "PasswordField.caretForeground", foregroundColor, "PasswordField.foreground", foregroundColor, "PasswordField.inactiveBackground", backgroundLightColor, "PasswordField.inactiveForeground", disabledForegroundColor, "PasswordField.selectionBackground", selectionBackgroundColor, "PasswordField.selectionForeground", selectionForegroundColor, "PopupMenu.background", backgroundColor, "PopupMenu.border", regularMarginBorder, "ProgressBar.border", regularMarginBorder, "RadioButton.background", backgroundColor, "RadioButton.foreground", foregroundColor, "RadioButton.disabledText", disabledForegroundColor, "RadioButtonMenuItem.acceleratorForeground", foregroundColor, "RadioButtonMenuItem.acceleratorSelectionForeground", foregroundColor, "RadioButtonMenuItem.background", backgroundColor, "RadioButtonMenuItem.borderPainted", Boolean.FALSE, "RadioButtonMenuItem.checkIcon", new UIDefaults.LazyValue(){

            public Object createValue(UIDefaults table) {
                return new IconUIResource(SubstanceIconFactory.getRadioButtonMenuItemIcon(9));
            }
        }, "RadioButtonMenuItem.disabledForeground", disabledForegroundColor, "RadioButtonMenuItem.foreground", foregroundColor, "RadioButtonMenuItem.selectionForeground", foregroundColor, "RootPane.background", backgroundColor, "RootPane.border", new BorderUIResource(new SubstancePaneBorder()), "ScrollPane.background", backgroundColor, "ScrollPane.foreground", foregroundColor, "ScrollPane.border", regularMarginBorder, "Separator.background", backgroundColor, "Separator.foreground", lineColor, "Slider.altTrackColor", lineColor, "Slider.background", backgroundColor, "Slider.darkShadow", lineColor, "Slider.focus", lineColor, "Slider.foreground", lineColor, "Slider.highlight", backgroundLightColor, "Slider.horizontalThumbIcon", new UIDefaults.LazyValue(){

            public Object createValue(UIDefaults table) {
                return SubstanceIconFactory.getSliderHorizontalIcon(16, false);
            }
        }, "Slider.shadow", lineColor, "Slider.tickColor", foregroundColor, "Slider.verticalThumbIcon", new UIDefaults.LazyValue(){

            public Object createValue(UIDefaults table) {
                return SubstanceIconFactory.getSliderVerticalIcon(16, false);
            }
        }, "Spinner.border", regularMarginBorder, "Spinner.editorBorderPainted", Boolean.FALSE, "SplitPane.background", backgroundColor, "SplitPane.foreground", foregroundColor, "SplitPane.dividerFocusColor", backgroundColor, "SplitPaneDivider.draggingColor", backgroundColor, "TabbedPane.tabAreaBackground", backgroundColor, "TabbedPane.unselectedBackground", backgroundColor, "TabbedPane.background", backgroundColor, "TabbedPane.borderHightlightColor", new ColorUIResource(activeScheme.getMidColor()), "TabbedPane.contentAreaColor", new ColorUIResource(this.colorScheme.getUltraLightColor()), "TabbedPane.darkShadow", new ColorUIResource(activeScheme.getLightColor()), "TabbedPane.focus", foregroundColor, "TabbedPane.foreground", foregroundColor, "TabbedPane.highlight", new ColorUIResource(activeScheme.getLightColor()), "TabbedPane.light", new ColorUIResource(activeScheme.getLightColor()), "TabbedPane.selected", new ColorUIResource(activeScheme.getExtraLightColor()), "TabbedPane.selectHighlight", new ColorUIResource(activeScheme.getMidColor()), "TabbedPane.shadow", new ColorUIResource(activeScheme.getExtraLightColor()), "Table.background", backgroundLightColor, "Table.focusCellBackground", selectionBackgroundColor, "Table.focusCellForeground", foregroundColor, "Table.focusCellHighlightBorder", new UIDefaults.LazyValue(){

            public Object createValue(UIDefaults table) {
                return new BorderUIResource(new LineBorder(foregroundColor));
            }
        }, "Table.foreground", foregroundColor, "Table.gridColor", lineColor, "Table.scrollPaneBorder", regularMarginBorder, "Table.selectionBackground", selectionBackgroundColor, "Table.selectionForeground", selectionForegroundColor, "TableHeader.cellBorder", null, "TableHeader.foreground", foregroundColor, "TextArea.background", backgroundLightColor, "TextArea.border", textBorder, "TextArea.caretForeground", foregroundColor, "TextArea.foreground", foregroundColor, "TextArea.inactiveBackground", backgroundLightColor, "TextArea.inactiveForeground", disabledForegroundColor, "TextArea.selectionBackground", selectionBackgroundColor, "TextArea.selectionForeground", selectionForegroundColor, "TextField.background", backgroundLightColor, "TextField.border", textBorder, "TextField.caretForeground", foregroundColor, "TextField.foreground", foregroundColor, "TextField.inactiveBackground", backgroundLightColor, "TextField.inactiveForeground", disabledForegroundColor, "TextField.selectionBackground", selectionBackgroundColor, "TextField.selectionForeground", selectionForegroundColor, "TextPane.background", backgroundLightColor, "TextPane.border", textBorder, "TextPane.foreground", foregroundColor, "TextPane.caretForeground", foregroundColor, "TextPane.inactiveBackground", backgroundLightColor, "TextPane.inactiveForeground", disabledForegroundColor, "TextPane.selectionBackground", selectionBackgroundColor, "TextPane.selectionForeground", selectionForegroundColor, "TitledBorder.titleColor", foregroundColor, "ToggleButton.foreground", foregroundColor, "ToggleButton.disabledText", disabledForegroundColor, "ToolBar.background", backgroundColor, "ToolBar.border", new BorderUIResource(new SubstanceToolBarBorder()), "ToolBar.isRollover", Boolean.TRUE, "ToolBar.foreground", foregroundColor, "ToolTip.border", new UIDefaults.LazyValue(){

            public Object createValue(UIDefaults table) {
                return new LineBorder(foregroundColor);
            }
        }, "ToolTip.borderInactive", regularMarginBorder, "ToolTip.background", backgroundColor, "ToolTip.backgroundInactive", new ColorUIResource(SubstanceTheme.getDefaultColorScheme(this.kind).getExtraLightColor()), "ToolTip.foreground", foregroundColor, "ToolTip.foregroundInactive", disabledForegroundColor, "Tree.closedIcon", new UIDefaults.LazyValue(){

            public Object createValue(UIDefaults table) {
                return new IconUIResource(new ImageIcon(SubstanceImageCreator.getTreeNodeIcon(SubstanceCoreUtilities.isThemeDark(SubstanceTheme.this), SubstanceConstants.TreeIcon.CLOSED)));
            }
        }, "Tree.collapsedIcon", new UIDefaults.LazyValue(){

            public Object createValue(UIDefaults table) {
                return new IconUIResource(new ImageIcon(SubstanceImageCreator.getTreeIcon(SubstanceTheme.this.colorScheme, SubstanceCoreUtilities.isThemeDark(SubstanceTheme.this), true)));
            }
        }, "Tree.expandedIcon", new UIDefaults.LazyValue(){

            public Object createValue(UIDefaults table) {
                return new IconUIResource(new ImageIcon(SubstanceImageCreator.getTreeIcon(SubstanceTheme.this.colorScheme, SubstanceCoreUtilities.isThemeDark(SubstanceTheme.this), false)));
            }
        }, "Tree.leafIcon", new UIDefaults.LazyValue(){

            public Object createValue(UIDefaults table) {
                return new IconUIResource(new ImageIcon(SubstanceImageCreator.getTreeLeafIcon(SubstanceCoreUtilities.isThemeDark(SubstanceTheme.this))));
            }
        }, "Tree.openIcon", new UIDefaults.LazyValue(){

            public Object createValue(UIDefaults table) {
                return new IconUIResource(new ImageIcon(SubstanceImageCreator.getTreeNodeIcon(SubstanceCoreUtilities.isThemeDark(SubstanceTheme.this), SubstanceConstants.TreeIcon.OPENED)));
            }
        }, "Tree.background", backgroundColor, "Tree.selectionBackground", backgroundLightColor, "Tree.foreground", foregroundColor, "Tree.hash", lineColor, "Tree.selectionBorderColor", lineColor, "Tree.selectionForeground", foregroundColor, "Tree.textBackground", backgroundColor, "Tree.textForeground", foregroundColor, "Viewport.background", backgroundColor, "Viewport.foreground", foregroundColor};
        SubstanceCoreUtilities.putDefaults(table, defaults);
    }

    protected ColorUIResource getPrimary1() {
        return this.PRIMARY1;
    }

    protected ColorUIResource getPrimary2() {
        return this.PRIMARY2;
    }

    protected ColorUIResource getPrimary3() {
        return this.PRIMARY3;
    }

    protected ColorUIResource getSecondary1() {
        return this.SECONDARY1;
    }

    protected ColorUIResource getSecondary2() {
        return this.SECONDARY2;
    }

    protected ColorUIResource getSecondary3() {
        return this.SECONDARY3;
    }

    protected ColorUIResource getWhite() {
        return this.WHITE;
    }

    public ThemeKind getKind() {
        return this.kind;
    }

    public static ColorScheme getDefaultColorScheme(ThemeKind themeKind) {
        if (themeKind == ThemeKind.DARK) {
            return DARK_METALLIC_SCHEME;
        }
        if (themeKind == ThemeKind.INVERTED) {
            return INVERTED_LIGHT_GRAY_SCHEME;
        }
        return METALLIC_SCHEME;
    }

    private static SubstanceTheme getDefaultTheme(ThemeKind themeKind) {
        if (themeKind == ThemeKind.DARK) {
            return DARK_METALLIC;
        }
        if (themeKind == ThemeKind.INVERTED) {
            return INVERTED_LIGHT_GRAY;
        }
        return METALLIC;
    }

    public static ColorScheme getDisabledColorScheme(ThemeKind themeKind) {
        if (themeKind == ThemeKind.DARK) {
            return DARK_GRAY_SCHEME;
        }
        if (themeKind == ThemeKind.INVERTED) {
            return INVERTED_METALLIC_SCHEME;
        }
        return LIGHT_GRAY_SCHEME;
    }

    private static SubstanceTheme getDisabledTheme(ThemeKind themeKind) {
        if (themeKind == ThemeKind.DARK) {
            return DARK_GRAY;
        }
        if (themeKind == ThemeKind.INVERTED) {
            return INVERTED_METALLIC;
        }
        return LIGHT_GRAY;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public static SubstanceTheme getTheme(String displayName) {
        SubstanceTheme result = allThemes.get(displayName);
        if (result != null) {
            return result;
        }
        ThemeInfo themeInfo = SubstanceLookAndFeel.getAllThemes().get(displayName);
        if (themeInfo != null) {
            return SubstanceTheme.createInstance(themeInfo);
        }
        throw new IllegalStateException("Theme with display name '" + displayName + "' can not be found");
    }

    public ColorScheme getDefaultColorScheme() {
        return this.getDefaultTheme().getColorScheme();
    }

    public ColorScheme getDisabledColorScheme() {
        return this.getDisabledTheme().getColorScheme();
    }

    public SubstanceTheme getActiveTheme() {
        return this;
    }

    public SubstanceTheme getDefaultTheme() {
        return SubstanceTheme.getDefaultTheme(this.kind);
    }

    public SubstanceTheme getDisabledTheme() {
        return SubstanceTheme.getDisabledTheme(this.kind);
    }

    @Deprecated
    public boolean isDark() {
        return SubstanceCoreUtilities.isThemeDark(this);
    }

    public static SubstanceTheme addUserDefined(ColorScheme scheme, ThemeKind themeKind, String displayName) {
        SubstanceTheme userTheme = new SubstanceTheme(scheme, displayName, themeKind);
        return userTheme;
    }

    public Color getUltraDarkColor(int alpha) {
        return new Color(this.getColorScheme().getDarkColor().getRed(), this.getColorScheme().getDarkColor().getGreen(), this.getColorScheme().getDarkColor().getBlue(), alpha);
    }

    public Color getUltraLightColor(int alpha) {
        return new Color(this.getColorScheme().getUltraLightColor().getRed(), this.getColorScheme().getUltraLightColor().getGreen(), this.getColorScheme().getUltraLightColor().getBlue(), alpha);
    }

    public Color getWatermarkStampColor() {
        return SubstanceCoreUtilities.isThemeDark(this) ? this.getUltraLightColor(60) : this.getUltraDarkColor(25);
    }

    public static SubstanceTheme createInstance(ThemeInfo themeInfo) {
        ThemeKind themeKind = themeInfo.getThemeKind();
        if (themeKind == ThemeKind.MIXED) {
            try {
                Class<?> themeClass1 = Class.forName(((MixedThemeInfo)themeInfo).getFirstThemeClassName());
                if (themeClass1 == null) {
                    return null;
                }
                Object obj1 = themeClass1.newInstance();
                if (obj1 == null) {
                    return null;
                }
                if (!(obj1 instanceof SubstanceTheme)) {
                    return null;
                }
                Class<?> themeClass2 = Class.forName(((MixedThemeInfo)themeInfo).getSecondThemeClassName());
                if (themeClass2 == null) {
                    return null;
                }
                Object obj2 = themeClass2.newInstance();
                if (obj2 == null) {
                    return null;
                }
                if (!(obj2 instanceof SubstanceTheme)) {
                    return null;
                }
                SubstanceTheme origTheme1 = (SubstanceTheme)obj1;
                SubstanceTheme origTheme2 = (SubstanceTheme)obj2;
                SubstanceMixBiTheme mixedTheme = new SubstanceMixBiTheme(origTheme1, origTheme2);
                return mixedTheme;
            }
            catch (Exception exc) {
                return null;
            }
        }
        if (themeKind == ThemeKind.INVERTED) {
            try {
                Class<?> themeClass = Class.forName(themeInfo.getThemeClassName());
                if (themeClass == null) {
                    return null;
                }
                Object obj = themeClass.newInstance();
                if (obj == null) {
                    return null;
                }
                if (!(obj instanceof SubstanceTheme)) {
                    return null;
                }
                SubstanceTheme origTheme = (SubstanceTheme)obj;
                SubstanceInvertedTheme invertedTheme = new SubstanceInvertedTheme(origTheme);
                return invertedTheme;
            }
            catch (Exception exc) {
                return null;
            }
        }
        try {
            Class<?> themeClass = Class.forName(themeInfo.getThemeClassName());
            if (themeClass == null) {
                return null;
            }
            Object obj = themeClass.newInstance();
            if (obj == null) {
                return null;
            }
            if (!(obj instanceof SubstanceTheme)) {
                return null;
            }
            return (SubstanceTheme)obj;
        }
        catch (Exception exc) {
            return null;
        }
    }

    public SubstanceTheme tint(double tintFactor) {
        return new SubstanceTintTheme(this, tintFactor);
    }

    public SubstanceTheme tone(double toneFactor) {
        return new SubstanceToneTheme(this, toneFactor);
    }

    public SubstanceTheme shade(double shadeFactor) {
        return new SubstanceShadeTheme(this, shadeFactor);
    }

    public SubstanceTheme saturate(double saturateFactor) {
        return new SubstanceSaturatedTheme(this, saturateFactor);
    }

    public SubstanceTheme invert() {
        return new SubstanceInvertedTheme(this);
    }

    public SubstanceTheme getActiveTitlePaneTheme() {
        return this;
    }

    public SubstanceTheme getFirstTheme() {
        return this;
    }

    public SubstanceTheme getSecondTheme() {
        return this;
    }

    public String toString() {
        return this.getDisplayName();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ThemeKind {
        BRIGHT,
        COLD,
        DARK,
        INVERTED,
        MIXED;

    }
}

