/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.substance.utils;

import java.awt.Color;
import org.jvnet.substance.SubstanceLookAndFeel;
import org.jvnet.substance.color.ColorScheme;
import org.jvnet.substance.theme.SubstanceComplexTheme;
import org.jvnet.substance.theme.SubstanceTheme;
import org.jvnet.substance.utils.SubstanceCoreUtilities;

public class SubstanceColorUtilities {
    public static Color getTopBorderColor(ColorScheme scheme1, ColorScheme scheme2, double cycleCoef) {
        return SubstanceColorUtilities.getInterpolatedColor(scheme1.getUltraDarkColor(), scheme2.getUltraDarkColor(), cycleCoef);
    }

    public static Color getMidBorderColor(ColorScheme scheme1, ColorScheme scheme2, double cycleCoef) {
        return SubstanceColorUtilities.getInterpolatedColor(scheme1.getDarkColor(), scheme2.getDarkColor(), cycleCoef);
    }

    public static Color getBottomBorderColor(ColorScheme scheme1, ColorScheme scheme2, double cycleCoef) {
        return SubstanceColorUtilities.getInterpolatedColor(scheme1.getMidColor(), scheme2.getMidColor(), cycleCoef);
    }

    public static Color getTopFillColor(ColorScheme scheme1, ColorScheme scheme2, double cycleCoef, boolean useCyclePosAsInterpolation) {
        if (!useCyclePosAsInterpolation) {
            return SubstanceColorUtilities.getInterpolatedColor(scheme1.getDarkColor(), scheme2.getLightColor(), cycleCoef);
        }
        return SubstanceColorUtilities.getInterpolatedColor(scheme1.getDarkColor(), scheme2.getDarkColor(), cycleCoef);
    }

    public static Color getMidFillColor(ColorScheme scheme1, ColorScheme scheme2, double cycleCoef, boolean useCyclePosAsInterpolation) {
        if (!useCyclePosAsInterpolation) {
            return SubstanceColorUtilities.getInterpolatedColor(scheme1.getMidColor(), scheme2.getLightColor(), cycleCoef);
        }
        return SubstanceColorUtilities.getInterpolatedColor(scheme1.getMidColor(), scheme2.getMidColor(), cycleCoef);
    }

    public static Color getBottomFillColor(ColorScheme scheme1, ColorScheme scheme2, double cycleCoef, boolean useCyclePosAsInterpolation) {
        if (!useCyclePosAsInterpolation) {
            return SubstanceColorUtilities.getInterpolatedColor(scheme1.getUltraLightColor(), scheme2.getExtraLightColor(), cycleCoef);
        }
        return SubstanceColorUtilities.getInterpolatedColor(scheme1.getUltraLightColor(), scheme2.getUltraLightColor(), cycleCoef);
    }

    public static Color getTopShineColor(ColorScheme scheme1, ColorScheme scheme2, double cycleCoef, boolean useCyclePosAsInterpolation) {
        return SubstanceColorUtilities.getBottomFillColor(scheme1, scheme2, cycleCoef, useCyclePosAsInterpolation);
    }

    public static Color getBottomShineColor(ColorScheme scheme1, ColorScheme scheme2, double cycleCoef, boolean useCyclePosAsInterpolation) {
        if (!useCyclePosAsInterpolation) {
            return SubstanceColorUtilities.getInterpolatedColor(scheme1.getLightColor(), scheme2.getUltraLightColor(), cycleCoef);
        }
        return SubstanceColorUtilities.getInterpolatedColor(scheme1.getLightColor(), scheme2.getLightColor(), cycleCoef);
    }

    public static int getInterpolatedRGB(Color color1, Color color2, double color1Likeness) {
        int lr = color1.getRed();
        int lg = color1.getGreen();
        int lb = color1.getBlue();
        int la = color1.getAlpha();
        int dr = color2.getRed();
        int dg = color2.getGreen();
        int db = color2.getBlue();
        int da = color2.getAlpha();
        int r = (int)(color1Likeness * (double)lr + (1.0 - color1Likeness) * (double)dr);
        int g = (int)(color1Likeness * (double)lg + (1.0 - color1Likeness) * (double)dg);
        int b = (int)(color1Likeness * (double)lb + (1.0 - color1Likeness) * (double)db);
        int a = (int)(color1Likeness * (double)la + (1.0 - color1Likeness) * (double)da);
        r = Math.min(255, r);
        g = Math.min(255, g);
        b = Math.min(255, b);
        a = Math.min(255, a);
        r = Math.max(0, r);
        g = Math.max(0, g);
        b = Math.max(0, b);
        a = Math.max(0, a);
        return a << 24 | r << 16 | g << 8 | b;
    }

    public static Color getInterpolatedColor(Color color1, Color color2, double color1Likeness) {
        return new Color(SubstanceColorUtilities.getInterpolatedRGB(color1, color2, color1Likeness));
    }

    public static Color invertColor(Color color) {
        return new Color(255 - color.getRed(), 255 - color.getGreen(), 255 - color.getBlue(), color.getAlpha());
    }

    public static Color getBackgroundColor(SubstanceTheme theme) {
        if (theme instanceof SubstanceComplexTheme) {
            SubstanceComplexTheme sct = (SubstanceComplexTheme)theme;
            SubstanceTheme defTheme = sct.getDefaultTheme();
            switch (defTheme.getKind()) {
                case DARK: {
                    return defTheme.getColorScheme().getDarkColor().brighter();
                }
            }
            return defTheme.getColorScheme().getLightColor();
        }
        switch (theme.getKind()) {
            case DARK: {
                return theme.getColorScheme().getDarkColor().brighter();
            }
        }
        return theme.getDefaultColorScheme().getExtraLightColor();
    }

    public static Color getDisabledForegroundColor(SubstanceTheme theme) {
        switch (theme.getKind()) {
            case DARK: {
                return SubstanceColorUtilities.getInterpolatedColor(theme.getDefaultColorScheme().getForegroundColor(), theme.getColorScheme().getDarkColor(), 0.45);
            }
        }
        return SubstanceColorUtilities.getInterpolatedColor(theme.getDefaultColorScheme().getMidColor(), theme.getDefaultColorScheme().getDarkColor(), 0.7);
    }

    public static Color getSelectionBackgroundColor(SubstanceTheme theme) {
        switch (theme.getKind()) {
            case DARK: {
                return theme.getActiveTheme().getColorScheme().getUltraLightColor().brighter().brighter();
            }
        }
        return theme.getActiveTheme().getColorScheme().getExtraLightColor();
    }

    public static Color getLineColor(SubstanceTheme theme) {
        switch (theme.getKind()) {
            case DARK: {
                return theme.getColorScheme().getUltraLightColor();
            }
        }
        return theme.getColorScheme().getMidColor();
    }

    public static Color getSelectionForegroundColor(SubstanceTheme theme) {
        switch (theme.getKind()) {
            case DARK: {
                return theme.getActiveTheme().getColorScheme().getDarkColor();
            }
        }
        return theme.getActiveTheme().getColorScheme().getUltraDarkColor();
    }

    public static Color getWatermarkStampColor() {
        return SubstanceLookAndFeel.getTheme().getWatermarkStampColor();
    }

    public static Color getNegativeColor(Color color) {
        return new Color(color.getAlpha(), 255 - color.getRed(), 255 - color.getGreen(), 255 - color.getBlue());
    }

    public static Color getWatermarkLightColor() {
        return SubstanceColorUtilities.getWatermarkLightColor(1.0f);
    }

    public static Color getWatermarkLightColor(float coef) {
        int alpha;
        int n = alpha = SubstanceCoreUtilities.isThemeDark(SubstanceLookAndFeel.getTheme()) ? (int)(coef * 50.0f) : (int)(coef * 128.0f);
        if (alpha > 255) {
            alpha = 255;
        }
        return SubstanceLookAndFeel.getTheme().getUltraLightColor(alpha);
    }

    public static Color getWatermarkDarkColor() {
        return SubstanceCoreUtilities.isThemeDark(SubstanceLookAndFeel.getTheme()) ? SubstanceLookAndFeel.getTheme().getUltraDarkColor(50) : SubstanceLookAndFeel.getTheme().getUltraDarkColor(20);
    }

    public static Color getWatermarkStampColor(int alpha) {
        return SubstanceCoreUtilities.isThemeDark(SubstanceLookAndFeel.getTheme()) ? SubstanceLookAndFeel.getTheme().getUltraLightColor(alpha) : SubstanceLookAndFeel.getTheme().getUltraDarkColor(alpha);
    }

    public static Color getAlphaColor(Color color, int alpha) {
        return new Color(color.getRed(), color.getGreen(), color.getBlue(), alpha);
    }

    public static Color getSaturatedColor(Color color, double factor) {
        int r = color.getRed();
        int g = color.getGreen();
        int b = color.getBlue();
        if (r == g && r == b) {
            return color;
        }
        float[] hsbvals = new float[3];
        Color.RGBtoHSB(r, g, b, hsbvals);
        float sat = hsbvals[1];
        sat = factor > 0.0 ? (sat += (float)factor * (1.0f - sat)) : (sat += (float)factor * sat);
        return new Color(Color.HSBtoRGB(hsbvals[0], sat, hsbvals[2]));
    }

    public static Color getForegroundColor(SubstanceTheme theme) {
        return theme.getColorScheme().getForegroundColor();
    }

    public static Color getLighterColor(Color color, double diff) {
        int r = color.getRed() + (int)(diff * (double)(255 - color.getRed()));
        int g = color.getGreen() + (int)(diff * (double)(255 - color.getGreen()));
        int b = color.getBlue() + (int)(diff * (double)(255 - color.getBlue()));
        return new Color(r, g, b);
    }

    public static Color getDarkerColor(Color color, double diff) {
        int r = (int)((1.0 - diff) * (double)color.getRed());
        int g = (int)((1.0 - diff) * (double)color.getGreen());
        int b = (int)((1.0 - diff) * (double)color.getBlue());
        return new Color(r, g, b);
    }
}

