/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.substance.utils;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.FontMetrics;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JInternalFrame;
import javax.swing.JRootPane;
import javax.swing.JScrollBar;
import javax.swing.JSpinner;
import javax.swing.JTabbedPane;
import javax.swing.JToolBar;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import org.jvnet.substance.SubstanceComboBoxButton;
import org.jvnet.substance.SubstanceLookAndFeel;
import org.jvnet.substance.SubstanceScrollButton;
import org.jvnet.substance.SubstanceSpinnerButton;
import org.jvnet.substance.button.SubstanceButtonShaper;
import org.jvnet.substance.color.BaseColorScheme;
import org.jvnet.substance.color.BottleGreenColorScheme;
import org.jvnet.substance.color.ColorScheme;
import org.jvnet.substance.color.LightAquaColorScheme;
import org.jvnet.substance.color.SunfireRedColorScheme;
import org.jvnet.substance.color.SunsetColorScheme;
import org.jvnet.substance.combo.ComboPopupPrototypeCallback;
import org.jvnet.substance.painter.SubstanceGradientPainter;
import org.jvnet.substance.tabbed.TabCloseCallback;
import org.jvnet.substance.theme.SubstanceBlendBiTheme;
import org.jvnet.substance.theme.SubstanceInvertedTheme;
import org.jvnet.substance.theme.SubstanceMixBiTheme;
import org.jvnet.substance.theme.SubstanceTheme;
import org.jvnet.substance.theme.ThemeInfo;
import org.jvnet.substance.title.SubstanceTitlePainter;
import org.jvnet.substance.utils.ComponentState;
import org.jvnet.substance.utils.MemoryAnalyzer;
import org.jvnet.substance.utils.SubstanceConstants;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SubstanceCoreUtilities {
    private SubstanceCoreUtilities() {
    }

    public static String clipString(FontMetrics metrics, int availableWidth, String fullText) {
        if (metrics.stringWidth(fullText) <= availableWidth) {
            return fullText;
        }
        String ellipses = "...";
        int ellipsesWidth = metrics.stringWidth(ellipses);
        if (ellipsesWidth > availableWidth) {
            return "";
        }
        String starter = "";
        String ender = "";
        int w = fullText.length();
        int w2 = w / 2 + w % 2;
        String prevTitle = null;
        for (int i = 0; i < w2; ++i) {
            String newTitle;
            String newStarter = starter + fullText.charAt(i);
            String newEnder = ender;
            if (w - i > w2) {
                newEnder = fullText.charAt(w - i - 1) + newEnder;
            }
            if (metrics.stringWidth(newTitle = newStarter + ellipses + newEnder) > availableWidth) {
                return prevTitle;
            }
            starter = newStarter;
            ender = newEnder;
            prevTitle = newTitle;
        }
        return fullText;
    }

    public static boolean hasIcon(AbstractButton button) {
        return button.getIcon() != null;
    }

    public static boolean hasText(AbstractButton button) {
        String text = button.getText();
        return text != null && text.length() > 0;
    }

    public static boolean isComboBoxButton(AbstractButton button) {
        Container parent = button.getParent();
        return parent != null && (parent instanceof JComboBox || parent.getParent() instanceof JComboBox);
    }

    public static boolean isScrollBarButton(AbstractButton button) {
        Container parent = button.getParent();
        return parent != null && (parent instanceof JScrollBar || parent.getParent() instanceof JScrollBar);
    }

    public static boolean isSpinnerButton(AbstractButton button) {
        Container parent = button.getParent();
        if (!(button instanceof SubstanceSpinnerButton)) {
            return false;
        }
        return parent != null && (parent instanceof JSpinner || parent.getParent() instanceof JSpinner);
    }

    public static boolean isToolBarButton(AbstractButton button) {
        if (button instanceof SubstanceComboBoxButton) {
            return false;
        }
        if (button instanceof SubstanceSpinnerButton) {
            return false;
        }
        Container parent = button.getParent();
        return parent != null && (parent instanceof JToolBar || parent.getParent() instanceof JToolBar);
    }

    public static boolean isScrollButton(AbstractButton button) {
        return button instanceof SubstanceScrollButton;
    }

    public static SubstanceTheme getTheme(JComponent component) {
        JComponent jcomp;
        Object controlThemeObj;
        JComponent comp;
        if (component != null && (comp = component) instanceof JComponent && (controlThemeObj = (jcomp = comp).getClientProperty("substancelaf.theme")) != null) {
            if (controlThemeObj instanceof String) {
                return SubstanceTheme.getTheme((String)controlThemeObj);
            }
            if (controlThemeObj instanceof ThemeInfo) {
                return SubstanceTheme.createInstance((ThemeInfo)controlThemeObj);
            }
            if (controlThemeObj instanceof SubstanceTheme) {
                return (SubstanceTheme)controlThemeObj;
            }
        }
        return SubstanceLookAndFeel.getTheme();
    }

    public static SubstanceTheme getActiveTheme(JComponent component) {
        return SubstanceCoreUtilities.getTheme(component).getActiveTheme();
    }

    public static SubstanceTheme getDefaultTheme(JComponent component) {
        if (component != null && SubstanceCoreUtilities.isControlAlwaysPaintedActive(component)) {
            return SubstanceCoreUtilities.getActiveTheme(component);
        }
        return SubstanceCoreUtilities.getTheme(component).getDefaultTheme();
    }

    public static SubstanceTheme getDisabledTheme(JComponent component) {
        return SubstanceCoreUtilities.getTheme(component).getDisabledTheme();
    }

    public static ColorScheme getActiveScheme(JComponent component) {
        SubstanceTheme theme = SubstanceCoreUtilities.getActiveTheme(component);
        if (theme != null) {
            return theme.getColorScheme();
        }
        return null;
    }

    public static ColorScheme getDefaultScheme(JComponent component) {
        SubstanceTheme theme = SubstanceCoreUtilities.getDefaultTheme(component);
        if (theme != null) {
            return theme.getColorScheme();
        }
        return null;
    }

    public static ColorScheme getDisabledScheme(JComponent component) {
        SubstanceTheme theme = SubstanceCoreUtilities.getDisabledTheme(component);
        if (theme != null) {
            return theme.getColorScheme();
        }
        return null;
    }

    public static ColorScheme getActiveScheme(JComponent component, Container parent) {
        SubstanceTheme theme = SubstanceCoreUtilities.getActiveTheme(component);
        if (theme != null) {
            return theme.getColorScheme();
        }
        if (parent instanceof JComponent && (theme = SubstanceCoreUtilities.getActiveTheme((JComponent)parent)) != null) {
            return theme.getColorScheme();
        }
        return null;
    }

    public static boolean isControlAlwaysPaintedActive(JComponent comp) {
        Object buttonProp = comp.getClientProperty("substancelaf.paintactive");
        if (buttonProp != null) {
            if (Boolean.TRUE.equals(buttonProp)) {
                return true;
            }
            if (Boolean.FALSE.equals(buttonProp)) {
                return false;
            }
        }
        return Boolean.TRUE.equals(UIManager.get("substancelaf.paintactive"));
    }

    public static boolean isButtonNeverPainted(AbstractButton button) {
        Object buttonProp = button.getClientProperty("substancelaf.buttonpaintnever");
        if (buttonProp != null) {
            if (Boolean.TRUE.equals(buttonProp)) {
                return true;
            }
            if (Boolean.FALSE.equals(buttonProp)) {
                return false;
            }
        }
        return Boolean.TRUE.equals(UIManager.get("substancelaf.buttonpaintnever"));
    }

    public static SubstanceConstants.FocusKind getFocusKind(Component component) {
        while (component != null) {
            JComponent jcomp;
            Object jcompFocusKind;
            if (component instanceof JComponent && (jcompFocusKind = (jcomp = (JComponent)component).getClientProperty("substancelaf.focusKind")) instanceof SubstanceConstants.FocusKind) {
                return (SubstanceConstants.FocusKind)((Object)jcompFocusKind);
            }
            component = component.getParent();
        }
        Object globalFocusKind = UIManager.get("substancelaf.focusKind");
        if (globalFocusKind instanceof SubstanceConstants.FocusKind) {
            return (SubstanceConstants.FocusKind)((Object)globalFocusKind);
        }
        return SubstanceConstants.FocusKind.ALL_INNER;
    }

    public static SubstanceConstants.TabTextAlignmentKind getTabTextAlignmentKind(JTabbedPane tabPane) {
        Object jcompAlignmentKind = tabPane.getClientProperty("substancelaf.tabbedpanetextAlignmentKind");
        if (jcompAlignmentKind instanceof SubstanceConstants.TabTextAlignmentKind) {
            return (SubstanceConstants.TabTextAlignmentKind)((Object)jcompAlignmentKind);
        }
        Object globalAlignmentKind = UIManager.get("substancelaf.tabbedpanetextAlignmentKind");
        if (globalAlignmentKind instanceof SubstanceConstants.TabTextAlignmentKind) {
            return (SubstanceConstants.TabTextAlignmentKind)((Object)globalAlignmentKind);
        }
        return SubstanceConstants.TabTextAlignmentKind.DEFAULT;
    }

    public static boolean toDrawWatermark(Component component) {
        while (component != null) {
            if (component instanceof JComponent) {
                JComponent jcomp = (JComponent)component;
                Object obj = jcomp.getClientProperty("substancelaf.watermark.toignore");
                if (Boolean.TRUE.equals(obj)) {
                    return false;
                }
                if (Boolean.FALSE.equals(obj)) {
                    return true;
                }
            }
            component = component.getParent();
        }
        Object obj = UIManager.get("substancelaf.watermark.toignore");
        return !Boolean.TRUE.equals(obj);
    }

    public static SubstanceButtonShaper getButtonShaper(AbstractButton button) {
        SubstanceButtonShaper shaper = SubstanceLookAndFeel.getCurrentButtonShaper();
        Object customShaper = button.getClientProperty("substancelaf.buttonShaper");
        if (customShaper != null) {
            if (customShaper instanceof SubstanceButtonShaper) {
                return (SubstanceButtonShaper)customShaper;
            }
            if (customShaper instanceof String) {
                try {
                    shaper = (SubstanceButtonShaper)Class.forName((String)customShaper).newInstance();
                }
                catch (Exception exc) {
                    shaper = SubstanceLookAndFeel.getCurrentButtonShaper();
                }
            }
        }
        return shaper;
    }

    public static SubstanceGradientPainter getGradientPainter(AbstractButton button) {
        SubstanceGradientPainter painter = SubstanceLookAndFeel.getCurrentGradientPainter();
        Object customPainterClass = button.getClientProperty("substancelaf.gradientPainter");
        if (customPainterClass != null) {
            try {
                painter = (SubstanceGradientPainter)Class.forName((String)customPainterClass).newInstance();
            }
            catch (Exception exc) {
                painter = SubstanceLookAndFeel.getCurrentGradientPainter();
            }
        }
        return painter;
    }

    public static boolean isTabModified(Component tabComponent) {
        boolean isWindowModified = false;
        Component comp = tabComponent;
        if (comp instanceof JComponent) {
            JComponent jc = (JComponent)comp;
            isWindowModified = Boolean.TRUE.equals(jc.getClientProperty("windowModified"));
        }
        return isWindowModified;
    }

    public static SubstanceConstants.TabAnimationKind getTabAnimationKind(Component tabComponent) {
        JComponent jc;
        Object animObj;
        Component comp = tabComponent;
        if (comp instanceof JComponent && (animObj = (jc = (JComponent)comp).getClientProperty("substancelaf.tabbedpanetabAnimationKind")) instanceof SubstanceConstants.TabAnimationKind) {
            return (SubstanceConstants.TabAnimationKind)((Object)animObj);
        }
        return null;
    }

    public static boolean hasCloseButton(JTabbedPane tabbedPane, int tabIndex) {
        Object tabProp;
        int tabCount = tabbedPane.getTabCount();
        if (tabIndex < 0 || tabIndex >= tabCount) {
            return false;
        }
        Component tabComponent = tabbedPane.getComponentAt(tabIndex);
        if (tabComponent instanceof JComponent) {
            Object compProp = ((JComponent)tabComponent).getClientProperty("substancelaf.tabbedpanehasclosebuttons");
            if (Boolean.TRUE.equals(compProp)) {
                return true;
            }
            if (Boolean.FALSE.equals(compProp)) {
                return false;
            }
        }
        if (Boolean.TRUE.equals(tabProp = tabbedPane.getClientProperty("substancelaf.tabbedpanehasclosebuttons"))) {
            return true;
        }
        if (Boolean.FALSE.equals(tabProp)) {
            return false;
        }
        return UIManager.getBoolean("substancelaf.tabbedpanehasclosebuttons");
    }

    public static int getCloseButtonSize(JTabbedPane tabbedPane, int tabIndex) {
        Object compProp;
        int tabCount = tabbedPane.getTabCount();
        if (tabIndex < 0 || tabIndex >= tabCount) {
            return 11;
        }
        Component tabComponent = tabbedPane.getComponentAt(tabIndex);
        if (tabComponent instanceof JComponent && (compProp = ((JComponent)tabComponent).getClientProperty("substancelaf.tabbedpaneclosebuttonssize")) instanceof Integer) {
            return (Integer)compProp;
        }
        Object tabProp = tabbedPane.getClientProperty("substancelaf.tabbedpaneclosebuttonssize");
        if (tabProp instanceof Integer) {
            return (Integer)tabProp;
        }
        Object globalProp = UIManager.get("substancelaf.tabbedpaneclosebuttonssize");
        if (globalProp instanceof Integer) {
            return (Integer)globalProp;
        }
        return 11;
    }

    public static boolean toLayoutVertically(JTabbedPane tabbedPane) {
        int tabPlacement = tabbedPane.getTabPlacement();
        if (tabPlacement == 1 || tabPlacement == 3) {
            return false;
        }
        Object tabProp = tabbedPane.getClientProperty("substancelaf.tabbedpaneverticalOrientation");
        if (Boolean.TRUE.equals(tabProp)) {
            return true;
        }
        if (Boolean.FALSE.equals(tabProp)) {
            return false;
        }
        return UIManager.getBoolean("substancelaf.tabbedpaneverticalOrientation");
    }

    public static boolean toShowIconUnrotated(JTabbedPane tabbedPane, int tabIndex) {
        Object tabProp;
        int tabCount = tabbedPane.getTabCount();
        if (tabIndex < 0 || tabIndex >= tabCount) {
            return false;
        }
        Component tabComponent = tabbedPane.getComponentAt(tabIndex);
        if (tabComponent instanceof JComponent) {
            Object compProp = ((JComponent)tabComponent).getClientProperty("substancelaf.tabbedpaneverticalOrientationRotateIcons");
            if (Boolean.TRUE.equals(compProp)) {
                return true;
            }
            if (Boolean.FALSE.equals(compProp)) {
                return false;
            }
        }
        if (Boolean.TRUE.equals(tabProp = tabbedPane.getClientProperty("substancelaf.tabbedpaneverticalOrientationRotateIcons"))) {
            return true;
        }
        if (Boolean.FALSE.equals(tabProp)) {
            return false;
        }
        return UIManager.getBoolean("substancelaf.tabbedpaneverticalOrientationRotateIcons");
    }

    public static boolean toAnimateCloseIconOfModifiedTab(JTabbedPane tabbedPane, int tabIndex) {
        Object tabProp;
        int tabCount = tabbedPane.getTabCount();
        if (tabIndex < 0 || tabIndex >= tabCount) {
            return false;
        }
        if (!SubstanceCoreUtilities.hasCloseButton(tabbedPane, tabIndex)) {
            return false;
        }
        Component tabComponent = tabbedPane.getComponentAt(tabIndex);
        if (tabComponent instanceof JComponent) {
            Object compProp = ((JComponent)tabComponent).getClientProperty("substancelaf.tabbedpaneclosebuttonsmodifiedanimation");
            if (Boolean.TRUE.equals(compProp)) {
                return true;
            }
            if (Boolean.FALSE.equals(compProp)) {
                return false;
            }
        }
        if (Boolean.TRUE.equals(tabProp = tabbedPane.getClientProperty("substancelaf.tabbedpaneclosebuttonsmodifiedanimation"))) {
            return true;
        }
        if (Boolean.FALSE.equals(tabProp)) {
            return false;
        }
        return UIManager.getBoolean("substancelaf.tabbedpaneclosebuttonsmodifiedanimation");
    }

    public static BufferedImage getBlankImage(int width, int height) {
        if (MemoryAnalyzer.isRunning() && (width >= 100 || height >= 100)) {
            try {
                throw new Exception();
            }
            catch (Exception exc) {
                StringBuffer sb = new StringBuffer();
                StackTraceElement[] stack = exc.getStackTrace();
                int count = 0;
                for (StackTraceElement stackEntry : stack) {
                    if (count++ > 8) break;
                    sb.append(stackEntry.getClassName() + ".");
                    sb.append(stackEntry.getMethodName() + " [");
                    sb.append(stackEntry.getLineNumber() + "]");
                    sb.append("\n");
                }
                MemoryAnalyzer.enqueueUsage("Blank " + width + "*" + height + "\n" + sb.toString());
            }
        }
        BufferedImage image = new BufferedImage(width, height, 2);
        Graphics2D graphics = (Graphics2D)image.getGraphics().create();
        graphics.setColor(new Color(0, 0, 0, 0));
        graphics.setComposite(AlphaComposite.Src);
        graphics.fillRect(0, 0, width, height);
        graphics.dispose();
        return image;
    }

    public static boolean hasNoMinSizeProperty(AbstractButton button) {
        Object noMinSizeProperty = button.getClientProperty("substancelaf.buttonnominsize");
        if (Boolean.TRUE.equals(noMinSizeProperty)) {
            return true;
        }
        if (Boolean.FALSE.equals(noMinSizeProperty)) {
            return false;
        }
        return Boolean.TRUE.equals(UIManager.get("substancelaf.buttonnominsize"));
    }

    public static boolean hasFlatProperty(JComponent comp) {
        Object flatProperty = comp.getClientProperty("substancelaf.componentFlat");
        if (Boolean.TRUE.equals(flatProperty)) {
            return true;
        }
        if (Boolean.FALSE.equals(flatProperty)) {
            return false;
        }
        Container parent = comp.getParent();
        if (parent instanceof JComponent) {
            flatProperty = ((JComponent)parent).getClientProperty("substancelaf.componentFlat");
            if (Boolean.TRUE.equals(flatProperty)) {
                return true;
            }
            if (Boolean.FALSE.equals(flatProperty)) {
                return false;
            }
        }
        return false;
    }

    public static int getPopupFlyoutOrientation(JComboBox combobox) {
        Object comboProperty = combobox.getClientProperty("substancelaf.comboboxpopupFlyoutOrientation");
        if (comboProperty instanceof Integer) {
            return (Integer)comboProperty;
        }
        Object globalProperty = UIManager.get("substancelaf.comboboxpopupFlyoutOrientation");
        if (globalProperty instanceof Integer) {
            return (Integer)globalProperty;
        }
        return 5;
    }

    public static void makeNonOpaque(Component comp, Map<Component, Boolean> opaquenessSnapshot) {
        if (comp instanceof JComponent) {
            JComponent jcomp = (JComponent)comp;
            opaquenessSnapshot.put(comp, jcomp.isOpaque());
            jcomp.setOpaque(false);
        }
        if (comp instanceof Container) {
            Container cont = (Container)comp;
            for (int i = 0; i < cont.getComponentCount(); ++i) {
                SubstanceCoreUtilities.makeNonOpaque(cont.getComponent(i), opaquenessSnapshot);
            }
        }
    }

    public static void restoreOpaque(Component comp, Map<Component, Boolean> opaquenessSnapshot) {
        if (comp instanceof JComponent) {
            JComponent jcomp = (JComponent)comp;
            if (opaquenessSnapshot.containsKey(comp)) {
                jcomp.setOpaque(opaquenessSnapshot.get(comp));
            } else {
                jcomp.setOpaque(true);
            }
        }
        if (comp instanceof Container) {
            Container cont = (Container)comp;
            for (int i = 0; i < cont.getComponentCount(); ++i) {
                SubstanceCoreUtilities.restoreOpaque(cont.getComponent(i), opaquenessSnapshot);
            }
        }
    }

    public static BufferedImage createCompatibleImage(BufferedImage image) {
        GraphicsEnvironment e = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice d = e.getDefaultScreenDevice();
        GraphicsConfiguration c = d.getDefaultConfiguration();
        BufferedImage compatibleImage = c.createCompatibleImage(image.getWidth(), image.getHeight());
        Graphics g = compatibleImage.getGraphics();
        g.drawImage(image, 0, 0, null);
        g.dispose();
        return compatibleImage;
    }

    public static void putDefaults(UIDefaults table, Object[] keyValueList) {
        if (keyValueList == null) {
            return;
        }
        table.putDefaults(keyValueList);
    }

    public static boolean isToolbarButtonFlat(AbstractButton button) {
        JToolBar toolbar = null;
        for (Container comp = button; comp != null; comp = comp.getParent()) {
            if (!(comp instanceof JToolBar)) continue;
            toolbar = (JToolBar)comp;
            break;
        }
        if (toolbar == null) {
            return false;
        }
        return SubstanceCoreUtilities.isToolbarButtonFlat(button, toolbar);
    }

    public static boolean isToolbarButtonFlat(AbstractButton button, JToolBar toolbar) {
        Object isFlatProperty = button.getClientProperty("substancelaf.toolbarButtonFlat");
        if (Boolean.TRUE.equals(isFlatProperty)) {
            return true;
        }
        if (Boolean.FALSE.equals(isFlatProperty)) {
            return false;
        }
        isFlatProperty = toolbar.getClientProperty("substancelaf.toolbarButtonFlat");
        if (Boolean.TRUE.equals(isFlatProperty)) {
            return true;
        }
        if (Boolean.FALSE.equals(isFlatProperty)) {
            return false;
        }
        return !Boolean.FALSE.equals(UIManager.get("substancelaf.toolbarButtonFlat"));
    }

    public static TabCloseCallback getTabCloseCallback(MouseEvent me, JTabbedPane tabbedPane, int tabIndex) {
        Object compProp;
        int tabCount = tabbedPane.getTabCount();
        if (tabIndex < 0 || tabIndex >= tabCount) {
            return null;
        }
        Component tabComponent = tabbedPane.getComponentAt(tabIndex);
        if (tabComponent instanceof JComponent && (compProp = ((JComponent)tabComponent).getClientProperty("substancelaf.tabbedpanecloseCallback")) instanceof TabCloseCallback) {
            return (TabCloseCallback)compProp;
        }
        Object tabProp = tabbedPane.getClientProperty("substancelaf.tabbedpanecloseCallback");
        if (tabProp instanceof TabCloseCallback) {
            return (TabCloseCallback)tabProp;
        }
        Object globProp = UIManager.get("substancelaf.tabbedpanecloseCallback");
        if (globProp instanceof TabCloseCallback) {
            return (TabCloseCallback)globProp;
        }
        return null;
    }

    public static BufferedImage blendImages(BufferedImage imageLeft, BufferedImage imageRight, double start, double end) {
        int width = imageLeft.getWidth();
        if (width != imageRight.getWidth()) {
            throw new IllegalArgumentException("Widths are not the same: " + imageLeft.getWidth() + " and " + imageRight.getWidth());
        }
        int height = imageLeft.getHeight();
        if (height != imageRight.getHeight()) {
            throw new IllegalArgumentException("Heights are not the same: " + imageLeft.getHeight() + " and " + imageRight.getHeight());
        }
        BufferedImage result = SubstanceCoreUtilities.getBlankImage(width, height);
        Graphics2D graphics = (Graphics2D)result.getGraphics().create();
        int endX = (int)(end * (double)width);
        int startX = (int)(start * (double)width);
        int rampWidth = endX - startX;
        if (rampWidth == 0) {
            graphics.drawImage((Image)imageLeft, 0, 0, null);
            graphics.drawImage(imageRight, startX, 0, width, height, startX, 0, width, height, null);
        } else {
            BufferedImage rampRight = SubstanceCoreUtilities.getBlankImage(rampWidth, height);
            Graphics2D rampRightG = (Graphics2D)rampRight.getGraphics();
            rampRightG.setPaint(new GradientPaint(new Point(0, 0), new Color(0, 0, 0, 255), new Point(rampWidth, 0), new Color(0, 0, 0, 0)));
            rampRightG.fillRect(0, 0, rampWidth, height);
            BufferedImage tempRight = SubstanceCoreUtilities.getBlankImage(width - startX, height);
            Graphics2D tempRightG = (Graphics2D)tempRight.getGraphics();
            tempRightG.drawImage(imageRight, 0, 0, width - startX, height, startX, 0, width, height, null);
            tempRightG.setComposite(AlphaComposite.DstOut);
            tempRightG.drawImage((Image)rampRight, 0, 0, null);
            tempRightG.setComposite(AlphaComposite.SrcOver);
            graphics.drawImage((Image)imageLeft, 0, 0, null);
            graphics.drawImage((Image)tempRight, startX, 0, null);
        }
        graphics.dispose();
        return result;
    }

    public static String getSchemeId(ColorScheme colorScheme) {
        if (colorScheme instanceof BaseColorScheme) {
            BaseColorScheme base = (BaseColorScheme)colorScheme;
            return base.getId();
        }
        return colorScheme.getClass().getName();
    }

    public static ColorScheme getOptionPaneColorScheme(int messageType, ColorScheme mainScheme) {
        if (!SubstanceLookAndFeel.isToUseConstantThemesOnDialogs()) {
            return mainScheme;
        }
        switch (messageType) {
            case 1: {
                return new BottleGreenColorScheme();
            }
            case 3: {
                return new LightAquaColorScheme();
            }
            case 2: {
                return new SunsetColorScheme();
            }
            case 0: {
                return new SunfireRedColorScheme();
            }
        }
        return null;
    }

    public static boolean isThemeDark(SubstanceTheme theme) {
        if (theme instanceof SubstanceInvertedTheme) {
            return !SubstanceCoreUtilities.isThemeDark(((SubstanceInvertedTheme)theme).getOriginalTheme());
        }
        if (theme instanceof SubstanceMixBiTheme) {
            SubstanceMixBiTheme mix = (SubstanceMixBiTheme)theme;
            return SubstanceCoreUtilities.isThemeDark(mix.getOriginalFirstTheme()) || SubstanceCoreUtilities.isThemeDark(mix.getOriginalSecondTheme());
        }
        if (theme instanceof SubstanceBlendBiTheme) {
            SubstanceBlendBiTheme blend = (SubstanceBlendBiTheme)theme;
            return SubstanceCoreUtilities.isThemeDark(blend.getOriginalFirstTheme()) || SubstanceCoreUtilities.isThemeDark(blend.getOriginalSecondTheme());
        }
        return theme.getKind() == SubstanceTheme.ThemeKind.DARK;
    }

    public static ColorScheme getControlColorScheme(JComponent component, ComponentState.ColorSchemeKind colorSchemeKind) {
        if (colorSchemeKind == ComponentState.ColorSchemeKind.DISABLED) {
            return SubstanceCoreUtilities.getDisabledScheme(component);
        }
        if (colorSchemeKind == ComponentState.ColorSchemeKind.CURRENT) {
            return SubstanceCoreUtilities.getActiveScheme(component);
        }
        return SubstanceCoreUtilities.getDefaultScheme(component);
    }

    public static Object getComboPopupPrototypeDisplayValue(JComboBox combo) {
        Object objProp = combo.getClientProperty("substancelaf.comboPopupPrototype");
        if (objProp == null) {
            objProp = UIManager.get("substancelaf.comboPopupPrototype");
        }
        if (objProp == null) {
            return null;
        }
        if (objProp instanceof ComboPopupPrototypeCallback) {
            ComboPopupPrototypeCallback callback = (ComboPopupPrototypeCallback)objProp;
            return callback.getPopupPrototypeDisplayValue(combo);
        }
        return objProp;
    }

    public static SubstanceTitlePainter getTitlePainter(JRootPane rp) {
        Object custObj;
        if (rp != null && (custObj = rp.getClientProperty("substancelaf.titlePainter")) instanceof String) {
            String custStr = (String)custObj;
            try {
                Class<?> cl = Class.forName(custStr);
                Object custInst = cl.newInstance();
                if (custInst instanceof SubstanceTitlePainter) {
                    return (SubstanceTitlePainter)custInst;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return SubstanceLookAndFeel.getCurrentTitlePainter();
    }

    public static SubstanceTitlePainter getTitlePainter(JInternalFrame jif) {
        Object custObj = jif.getClientProperty("substancelaf.titlePainter");
        if (custObj instanceof String) {
            String custStr = (String)custObj;
            try {
                Class<?> cl = Class.forName(custStr);
                Object custInst = cl.newInstance();
                if (custInst instanceof SubstanceTitlePainter) {
                    return (SubstanceTitlePainter)custInst;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return SubstanceLookAndFeel.getCurrentTitlePainter();
    }

    public static float getToolbarButtonCornerRadius(AbstractButton button, Insets insets) {
        JToolBar toolbar = null;
        for (Container c = button.getParent(); c != null; c = c.getParent()) {
            if (!(c instanceof JToolBar)) continue;
            toolbar = (JToolBar)c;
            break;
        }
        if (toolbar == null) {
            return 2.0f;
        }
        int width = button.getWidth();
        int height = button.getHeight();
        if (insets != null) {
            width -= insets.left + insets.right;
            height -= insets.top + insets.bottom;
        }
        float maxRadius = width > height ? (float)height / 2.0f : (float)width / 2.0f;
        Object buttonProp = button.getClientProperty("substancelaf.cornerRadius");
        if (buttonProp instanceof Float) {
            return Math.min(maxRadius, ((Float)buttonProp).floatValue());
        }
        Object toolbarProp = toolbar.getClientProperty("substancelaf.cornerRadius");
        if (toolbarProp instanceof Float) {
            return Math.min(maxRadius, ((Float)toolbarProp).floatValue());
        }
        Object globalProp = UIManager.get("substancelaf.cornerRadius");
        if (globalProp instanceof Float) {
            return Math.min(maxRadius, ((Float)globalProp).floatValue());
        }
        return 2.0f;
    }
}

