#!/bin/bash

cmdline=$0
cd "$(dirname $cmdline)"
cmdline=$(basename $cmdline)

while [ -L "$cmdline" ]; do
	cmdline="$(readlink "$cmdline")"
done

cd "$(dirname $cmdline)"
cd ..

JAVA_EXEC=java

# Check for unsupported JVMs
JAVA_CLIENT=`${JAVA_EXEC} -version 2>&1`
if [ "`echo ${JAVA_CLIENT} | grep Blackdown`" != "" ]; then
	echo "Mercury does not run on Blackdown Java." >&2
	echo "Please, make sure to have the Sun Java version 1.5 or later installed." >&2
	exit 1
fi
if [ "`echo ${JAVA_CLIENT} | grep libgcj`" != "" ]; then
	echo "Mercury does not run on GNU Java." >&2
	echo "Please, make sure to have the Sun Java version 1.5 or later installed." >&2
	exit 1
fi



if (pidof compiz &> /dev/null) || (pidof compiz.real &> /dev/null) || (pidof beryl &> /dev/null); then
	 echo "- Adding Compiz/beryl compatibility mode."
	 AWT_TOOLKIT=MToolkit
else
	 unset AWT_TOOLKIT
fi

for file in `ls lib`
do
   classpath="lib/$file:$classpath"
done

java -Djava.library.path=jni:jni/jmf -Xmx512m -classpath $classpath com.dMSN.Main $*
