/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.javax.sdp.fields;

import gov.nist.core.GenericObject;
import gov.nist.core.GenericObjectList;
import gov.nist.javax.sdp.fields.SDPObject;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.LinkedList;
import java.util.ListIterator;

public class SDPObjectList
extends GenericObjectList {
    protected static final String SDPFIELDS_PACKAGE = "gov.nist.javax.sdp.fields";

    public Object clone() {
        SDPObjectList newObject = (SDPObjectList)super.clone();
        ListIterator li = this.listIterator();
        while (li.hasNext()) {
            Object listObj = li.next();
            Object clone_obj = SDPObjectList.makeClone(listObj);
            newObject.add(clone_obj);
        }
        Class<?> myclass = this.getClass();
        Field[] fields = myclass.getDeclaredFields();
        for (int i = 0; i < fields.length; ++i) {
            Field f = fields[i];
            int modifier = f.getModifiers();
            if (Modifier.isPrivate(modifier) || Modifier.isStatic(modifier) || Modifier.isInterface(modifier)) continue;
            Class<?> fieldType = f.getType();
            String fieldName = f.getName();
            String fname = fieldType.toString();
            try {
                if (fieldType.isPrimitive()) {
                    if (fname.compareTo("int") == 0) {
                        int intfield = f.getInt(this);
                        f.setInt(newObject, intfield);
                        continue;
                    }
                    if (fname.compareTo("short") == 0) {
                        short shortField = f.getShort(this);
                        f.setShort(newObject, shortField);
                        continue;
                    }
                    if (fname.compareTo("char") == 0) {
                        char charField = f.getChar(this);
                        f.setChar(newObject, charField);
                        continue;
                    }
                    if (fname.compareTo("long") == 0) {
                        long longField = f.getLong(this);
                        f.setLong(newObject, longField);
                        continue;
                    }
                    if (fname.compareTo("boolean") == 0) {
                        boolean booleanField = f.getBoolean(this);
                        f.setBoolean(newObject, booleanField);
                        continue;
                    }
                    if (fname.compareTo("double") == 0) {
                        double doubleField = f.getDouble(this);
                        f.setDouble(newObject, doubleField);
                        continue;
                    }
                    if (fname.compareTo("float") != 0) continue;
                    float floatField = f.getFloat(this);
                    f.setFloat(newObject, floatField);
                    continue;
                }
                Object obj = f.get(this);
                if (obj == null) continue;
                Object clone_obj = SDPObjectList.makeClone(obj);
                f.set(newObject, clone_obj);
                continue;
            }
            catch (IllegalAccessException ex1) {
                ex1.printStackTrace();
            }
        }
        return newObject;
    }

    public void mergeObjects(GenericObjectList mergeList) {
        if (!mergeList.getMyClass().equals(this.getMyClass())) {
            throw new IllegalArgumentException("class mismatch");
        }
        ListIterator it1 = this.listIterator();
        ListIterator it2 = mergeList.listIterator();
        while (it1.hasNext()) {
            GenericObject outerObj = (GenericObject)it1.next();
            while (it2.hasNext()) {
                Object innerObj = it2.next();
                outerObj.merge(innerObj);
            }
        }
    }

    public void add(SDPObject s) {
        super.add(s);
    }

    public SDPObjectList(String lname, String classname) {
        super(lname, classname);
    }

    public SDPObjectList() {
        super(null, "gov.nist.javax.sdp.fields.SDPObject");
    }

    public SDPObjectList(String lname) {
        super(lname, "gov.nist.javax.sdp.fields.SDPObject");
    }

    public GenericObject first() {
        return (SDPObject)super.first();
    }

    public GenericObject next() {
        return (SDPObject)super.next();
    }

    public GenericObject next(ListIterator li) {
        return (SDPObject)super.next(li);
    }

    public String encode() {
        String retval = "";
        SDPObject sdpObject = (SDPObject)this.first();
        while (sdpObject != null) {
            retval = retval + sdpObject.encode();
            sdpObject = (SDPObject)this.next();
        }
        return retval;
    }

    public String toString() {
        return this.encode();
    }

    public void replace(String objectText, GenericObject replacementObject, boolean matchSubstring) throws IllegalArgumentException {
        if (objectText == null || replacementObject == null) {
            throw new IllegalArgumentException("null argument");
        }
        ListIterator listIterator = this.listIterator();
        LinkedList ll = new LinkedList();
        while (listIterator.hasNext()) {
            Serializable gobj;
            Object obj = listIterator.next();
            if (GenericObject.isMySubclass(obj.getClass())) {
                gobj = (GenericObject)obj;
                if (!gobj.getClass().equals(replacementObject.getClass())) continue;
                if (!matchSubstring && ((GenericObject)gobj).encode().compareTo(objectText) == 0) {
                    ll.add(obj);
                    continue;
                }
                if (matchSubstring && ((GenericObject)gobj).encode().indexOf(objectText) >= 0) {
                    ll.add(obj);
                    continue;
                }
                ((GenericObject)gobj).replace(objectText, replacementObject, matchSubstring);
                continue;
            }
            if (!GenericObjectList.isMySubclass(obj.getClass()) || !(gobj = (GenericObjectList)obj).getClass().equals(replacementObject.getClass())) continue;
            if (!matchSubstring && ((GenericObjectList)gobj).encode().compareTo(objectText) == 0) {
                ll.add(obj);
                continue;
            }
            if (matchSubstring && ((GenericObjectList)gobj).encode().indexOf(objectText) >= 0) {
                ll.add(obj);
                continue;
            }
            ((GenericObjectList)gobj).replace(objectText, replacementObject, matchSubstring);
        }
        for (int i = 0; i < ll.size(); ++i) {
            Object obj = ll.get(i);
            this.remove(obj);
            this.add(i, replacementObject);
        }
    }

    public void replace(String objectText, GenericObjectList replacementObject, boolean matchSubstring) throws IllegalArgumentException {
        if (objectText == null || replacementObject == null) {
            throw new IllegalArgumentException("null argument");
        }
        ListIterator listIterator = this.listIterator();
        LinkedList ll = new LinkedList();
        while (listIterator.hasNext()) {
            Serializable gobj;
            Object obj = listIterator.next();
            if (GenericObject.isMySubclass(obj.getClass())) {
                gobj = (GenericObject)obj;
                if (!gobj.getClass().equals(replacementObject.getClass())) continue;
                if (!matchSubstring && ((GenericObject)gobj).encode().compareTo(objectText) == 0) {
                    ll.add(obj);
                    continue;
                }
                if (matchSubstring && ((GenericObject)gobj).encode().indexOf(objectText) >= 0) {
                    ll.add(obj);
                    continue;
                }
                ((GenericObject)gobj).replace(objectText, replacementObject, matchSubstring);
                continue;
            }
            if (!GenericObjectList.isMySubclass(obj.getClass()) || !(gobj = (GenericObjectList)obj).getClass().equals(replacementObject.getClass())) continue;
            if (!matchSubstring && ((GenericObjectList)gobj).encode().compareTo(objectText) == 0) {
                ll.add(obj);
                continue;
            }
            if (matchSubstring && ((GenericObjectList)gobj).encode().indexOf(objectText) >= 0) {
                ll.add(obj);
                continue;
            }
            ((GenericObjectList)gobj).replace(objectText, replacementObject, matchSubstring);
        }
        for (int i = 0; i < ll.size(); ++i) {
            Object obj = ll.get(i);
            this.remove(obj);
            this.add(i, replacementObject);
        }
    }
}

