/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.javax.sip.header;

import gov.nist.javax.sip.address.GenericURI;
import gov.nist.javax.sip.header.SIPObject;

public class RequestLine
extends SIPObject {
    protected GenericURI uri;
    protected String method;
    protected String sipVersion;

    public RequestLine() {
        this.sipVersion = "SIP/2.0";
    }

    public void setSIPVersion(String sipVersion) {
        this.sipVersion = sipVersion;
    }

    public String encode() {
        StringBuffer encoding = new StringBuffer();
        if (this.method != null) {
            encoding.append(this.method);
            encoding.append(" ");
        }
        if (this.uri != null) {
            encoding.append(this.uri.encode());
            encoding.append(" ");
        }
        encoding.append(this.sipVersion + "\r\n");
        return encoding.toString();
    }

    public GenericURI getUri() {
        return this.uri;
    }

    public RequestLine(GenericURI requestURI, String method) {
        this.uri = requestURI;
        this.method = method;
        this.sipVersion = "SIP/2.0";
    }

    public String getMethod() {
        return this.method;
    }

    public String getSipVersion() {
        return this.sipVersion;
    }

    public void setUri(GenericURI uri) {
        this.uri = uri;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public void setSipVersion(String s) {
        this.sipVersion = s;
    }

    public String getVersionMajor() {
        if (this.sipVersion == null) {
            return null;
        }
        String major = null;
        boolean slash = false;
        for (int i = 0; i < this.sipVersion.length() && this.sipVersion.charAt(i) != '.'; ++i) {
            if (slash) {
                major = major == null ? "" + this.sipVersion.charAt(i) : major + this.sipVersion.charAt(i);
            }
            if (this.sipVersion.charAt(i) != '/') continue;
            slash = true;
        }
        return major;
    }

    public String getVersionMinor() {
        if (this.sipVersion == null) {
            return null;
        }
        String minor = null;
        boolean dot = false;
        for (int i = 0; i < this.sipVersion.length(); ++i) {
            if (dot) {
                minor = minor == null ? "" + this.sipVersion.charAt(i) : minor + this.sipVersion.charAt(i);
            }
            if (this.sipVersion.charAt(i) != '.') continue;
            dot = true;
        }
        return minor;
    }

    public boolean equals(Object other) {
        boolean retval;
        if (!other.getClass().equals(this.getClass())) {
            return false;
        }
        RequestLine that = (RequestLine)other;
        try {
            retval = this.method.equals(that.method) && this.uri.equals(that.uri) && this.sipVersion.equals(that.sipVersion);
        }
        catch (NullPointerException ex) {
            retval = false;
        }
        return retval;
    }
}

