/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.javax.sip.stack;

import gov.nist.core.LogWriter;
import gov.nist.javax.sip.SipStackImpl;
import gov.nist.javax.sip.address.GenericURI;
import gov.nist.javax.sip.address.SipUri;
import gov.nist.javax.sip.header.RequestLine;
import gov.nist.javax.sip.header.Route;
import gov.nist.javax.sip.header.RouteList;
import gov.nist.javax.sip.message.SIPRequest;
import gov.nist.javax.sip.stack.HopImpl;
import gov.nist.javax.sip.stack.SIPMessageStack;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.ListIterator;
import javax.sip.ListeningPoint;
import javax.sip.SipStack;
import javax.sip.address.Hop;
import javax.sip.address.Router;
import javax.sip.address.SipURI;
import javax.sip.message.Request;

public class DefaultRouter
implements Router {
    protected SIPMessageStack sipStack;
    protected HopImpl defaultRoute;

    public DefaultRouter(SipStack sipStack, String defaultRoute) {
        this.sipStack = (SIPMessageStack)((Object)sipStack);
        if (defaultRoute != null) {
            this.defaultRoute = new HopImpl(defaultRoute);
        }
    }

    public DefaultRouter(SIPMessageStack sipStack, String defaultRoute) {
        this.sipStack = sipStack;
        if (defaultRoute != null) {
            this.defaultRoute = new HopImpl(defaultRoute);
        }
    }

    private boolean hopsBackToMe(String host, int port) {
        Iterator it = ((SipStackImpl)this.sipStack).getListeningPoints();
        while (it.hasNext()) {
            ListeningPoint lp = (ListeningPoint)it.next();
            if (!((SipStackImpl)this.sipStack).getIPAddress().equalsIgnoreCase(host) || lp.getPort() != port) continue;
            return true;
        }
        return false;
    }

    public ListIterator getNextHops(Request request) {
        SIPRequest sipRequest = (SIPRequest)request;
        RequestLine requestLine = sipRequest.getRequestLine();
        if (requestLine == null) {
            throw new IllegalArgumentException("Bad message");
        }
        GenericURI requestURI = requestLine.getUri();
        if (requestURI == null) {
            throw new IllegalArgumentException("Bad message: Null requestURI");
        }
        LinkedList<HopImpl> ll = null;
        RouteList routes = sipRequest.getRouteHeaders();
        if (routes != null) {
            int port;
            ll = new LinkedList<HopImpl>();
            Route route = (Route)routes.getFirst();
            SipUri uri = (SipUri)route.getAddress().getURI();
            if (uri.getHostPort().hasPort()) {
                this.sipStack.logWriter.logMessage("routeHeader = " + uri.encode());
                this.sipStack.logWriter.logMessage("port = " + uri.getHostPort().getPort());
                port = uri.getHostPort().getPort();
            } else {
                port = 5060;
            }
            String host = uri.getHost();
            String transport = uri.getTransportParam();
            if (transport == null) {
                transport = "udp";
            }
            HopImpl hop = new HopImpl(host, port, transport);
            ll.add(hop);
            if (LogWriter.needsLogging) {
                this.sipStack.logWriter.logMessage("We use the Route header to forward the message");
            }
        } else if (requestURI instanceof SipURI && ((SipURI)((Object)requestURI)).getMAddrParam() != null) {
            String maddr = ((SipURI)((Object)requestURI)).getMAddrParam();
            String transport = ((SipURI)((Object)requestURI)).getTransportParam();
            if (transport == null) {
                transport = "udp";
            }
            int port = 5060;
            HopImpl hop = new HopImpl(maddr, port, transport);
            hop.setURIRouteFlag();
            ll = new LinkedList();
            ll.add(hop);
            if (LogWriter.needsLogging) {
                this.sipStack.logWriter.logMessage("Added Hop = " + hop.toString());
            }
        } else if (requestURI instanceof SipURI) {
            String host = ((SipURI)((Object)requestURI)).getHost();
            int port = ((SipURI)((Object)requestURI)).getPort();
            if (port == -1) {
                port = 5060;
            }
            if (this.hopsBackToMe(host, port)) {
                return null;
            }
            String transport = ((SipURI)((Object)requestURI)).getTransportParam();
            if (transport == null) {
                transport = "udp";
            }
            HopImpl hop = new HopImpl(host, port, transport);
            ll = new LinkedList();
            ll.add(hop);
            if (LogWriter.needsLogging) {
                this.sipStack.logWriter.logMessage("Added Hop = " + hop.toString());
            }
        }
        if (this.defaultRoute != null) {
            if (ll == null) {
                ll = new LinkedList();
            }
            ll.add(this.defaultRoute);
            if (LogWriter.needsLogging) {
                this.sipStack.logWriter.logMessage("Added Hop = " + this.defaultRoute.toString());
            }
        }
        return ll == null ? null : ll.listIterator();
    }

    public Hop getOutboundProxy() {
        return this.defaultRoute;
    }

    public Hop getDefaultRoute() {
        return this.defaultRoute;
    }
}

