/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.javax.sip.stack;

import gov.nist.core.LogWriter;
import gov.nist.javax.sip.header.Via;
import gov.nist.javax.sip.header.ViaList;
import gov.nist.javax.sip.message.SIPMessage;
import gov.nist.javax.sip.message.SIPRequest;
import gov.nist.javax.sip.message.SIPResponse;
import gov.nist.javax.sip.stack.HopImpl;
import gov.nist.javax.sip.stack.MessageChannel;
import gov.nist.javax.sip.stack.PendingRecord;
import gov.nist.javax.sip.stack.SIPDialog;
import gov.nist.javax.sip.stack.SIPTransaction;
import gov.nist.javax.sip.stack.SIPTransactionStack;
import gov.nist.javax.sip.stack.ServerRequestInterface;
import java.io.IOException;
import java.text.ParseException;
import java.util.LinkedList;
import java.util.TimerTask;
import javax.sip.ServerTransaction;
import javax.sip.SipException;
import javax.sip.TransactionState;
import javax.sip.message.Response;

public class SIPServerTransaction
extends SIPTransaction
implements ServerRequestInterface,
ServerTransaction,
PendingRecord {
    protected boolean toListener;
    private LinkedList pendingRequests;
    private ServerRequestInterface requestOf;

    private void sendResponse(SIPResponse transactionResponse) throws IOException {
        if (transactionResponse.getTopmostVia().getParameter("received") == null) {
            super.sendMessage(transactionResponse);
        } else {
            Via via = transactionResponse.getTopmostVia();
            String host = via.getParameter("received");
            int port = via.getPort();
            if (port == -1) {
                port = 5060;
            }
            String transport = via.getTransport();
            HopImpl hop = new HopImpl(host + ":" + port + "/" + transport);
            MessageChannel messageChannel = ((SIPTransactionStack)this.getSIPStack()).createRawMessageChannel(hop);
            messageChannel.sendMessage(transactionResponse);
        }
    }

    protected SIPServerTransaction(SIPTransactionStack newSIPStack, MessageChannel newChannelToUse) {
        super(newSIPStack, newChannelToUse);
        if (LogWriter.needsLogging) {
            this.sipStack.logWriter.logMessage("Creating Server Transaction" + this);
            this.sipStack.logWriter.logStackTrace();
        }
        this.pendingRequests = new LinkedList();
    }

    public void setRequestInterface(ServerRequestInterface newRequestOf) {
        this.requestOf = newRequestOf;
    }

    public String getProcessingInfo() {
        return this.requestOf != null ? this.requestOf.getProcessingInfo() : null;
    }

    public MessageChannel getResponseChannel() {
        return this;
    }

    public boolean isMessagePartOfTransaction(SIPMessage messageToTest) {
        ViaList viaHeaders;
        boolean transactionMatches = false;
        if ((((SIPRequest)messageToTest).getMethod().equals("CANCEL") || ((SIPTransactionStack)this.getSIPStack()).isDialogCreated(((SIPRequest)messageToTest).getMethod()) || !this.isTerminated()) && (viaHeaders = messageToTest.getViaHeaders()) != null) {
            Via topViaHeader = (Via)viaHeaders.getFirst();
            String messageBranch = topViaHeader.getBranch();
            if (messageBranch != null && !messageBranch.startsWith("z9hG4bK")) {
                messageBranch = null;
            }
            if (messageBranch != null && this.getBranch() != null) {
                if (this.getBranch().equals(messageBranch) && topViaHeader.getSentBy().equals(((Via)this.getOriginalRequest().getViaHeaders().getFirst()).getSentBy())) {
                    transactionMatches = true;
                }
            } else {
                boolean skipTo;
                String originalFromTag = this.getOriginalRequest().getFrom().getTag();
                String thisFromTag = messageToTest.getFrom().getTag();
                boolean skipFrom = originalFromTag == null || thisFromTag == null;
                String originalToTag = this.getOriginalRequest().getTo().getTag();
                String thisToTag = messageToTest.getTo().getTag();
                boolean bl = skipTo = originalToTag == null || thisToTag == null;
                if (this.getOriginalRequest().getRequestURI().equals(((SIPRequest)messageToTest).getRequestURI()) && (skipFrom || originalFromTag.equals(thisFromTag)) && (skipTo || originalToTag.equals(thisToTag)) && this.getOriginalRequest().getCallId().getCallId().equals(messageToTest.getCallId().getCallId()) && this.getOriginalRequest().getCSeq().getSequenceNumber() == messageToTest.getCSeq().getSequenceNumber() && topViaHeader.equals(this.getOriginalRequest().getViaHeaders().getFirst())) {
                    transactionMatches = true;
                }
            }
        }
        return transactionMatches;
    }

    protected void map() {
        if (this.getRealState() == null || this.getRealState() == TransactionState.TRYING) {
            if (this.isInviteTransaction() && !this.isMapped) {
                this.isMapped = true;
                this.sipStack.timer.schedule((TimerTask)new SendTrying(this), 200L);
            } else {
                this.isMapped = true;
            }
        }
        this.sipStack.removePendingTransaction(this);
    }

    public boolean isTransactionMapped() {
        return this.isMapped;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processRequest(SIPRequest transactionRequest, MessageChannel sourceChannel) {
        block37: {
            boolean toTu = false;
            if (this.eventPending) {
                LinkedList linkedList = this.pendingRequests;
                synchronized (linkedList) {
                    if (this.pendingRequests.size() < 4) {
                        this.pendingRequests.add(new PendingRequest(transactionRequest, sourceChannel));
                    }
                }
                this.sipStack.putPending(this);
                return;
            }
            try {
                if (this.getRealState() == null) {
                    this.setOriginalRequest(transactionRequest);
                    this.setState(TransactionState.TRYING);
                    toTu = true;
                    if (this.isInviteTransaction() && this.isMapped) {
                        this.sendMessage(transactionRequest.createResponse(100, "Trying"));
                    }
                } else {
                    if (this.isInviteTransaction() && TransactionState.COMPLETED == this.getRealState() && transactionRequest.getMethod().equals("ACK")) {
                        this.setState(TransactionState.CONFIRMED);
                        this.disableRetransmissionTimer();
                        if (!this.isReliable()) {
                            if (this.lastResponse != null && this.lastResponse.getStatusCode() == 487) {
                                this.setState(TransactionState.TERMINATED);
                            } else {
                                this.enableTimeoutTimer(10);
                            }
                        } else {
                            this.setState(TransactionState.TERMINATED);
                        }
                        return;
                    }
                    if (transactionRequest.getMethod().equals(this.getOriginalRequest().getMethod())) {
                        if (TransactionState.PROCEEDING == this.getRealState() || TransactionState.COMPLETED == this.getRealState()) {
                            if (this.lastResponse != null) {
                                try {
                                    super.sendMessage(this.lastResponse);
                                }
                                catch (IOException e) {
                                    this.setState(TransactionState.TERMINATED);
                                    throw e;
                                }
                            }
                        } else if (transactionRequest.getMethod().equals("ACK") && this.requestOf != null) {
                            this.requestOf.processRequest(transactionRequest, this);
                        }
                        return;
                    }
                }
                if (TransactionState.COMPLETED != this.getRealState() && TransactionState.TERMINATED != this.getRealState() && this.requestOf != null) {
                    if (this.getOriginalRequest().getMethod().equals(transactionRequest.getMethod())) {
                        if (toTu) {
                            this.requestOf.processRequest(transactionRequest, this);
                        }
                    } else if (this.requestOf != null) {
                        this.requestOf.processRequest(transactionRequest, this);
                    }
                    break block37;
                }
                if (((SIPTransactionStack)this.getSIPStack()).isDialogCreated(this.getOriginalRequest().getMethod()) && this.getRealState() == TransactionState.TERMINATED && transactionRequest.getMethod().equals("ACK") && this.requestOf != null) {
                    SIPDialog thisDialog = this.dialog;
                    thisDialog.ackReceived(transactionRequest);
                    if (((SIPTransactionStack)this.getSIPStack()).retransmissionFilter) {
                        if (!thisDialog.ackProcessed) {
                            thisDialog.ackProcessed = true;
                            this.requestOf.processRequest(transactionRequest, this);
                        }
                    } else if (this.requestOf != null) {
                        this.requestOf.processRequest(transactionRequest, this);
                    }
                } else if (transactionRequest.getMethod().equals("CANCEL")) {
                    if (LogWriter.needsLogging) {
                        this.sipStack.logWriter.logMessage("Too late to cancel Transaction");
                    }
                    try {
                        this.sendMessage(transactionRequest.createResponse(200));
                    }
                    catch (IOException ex) {
                        // empty catch block
                    }
                }
                this.sipStack.logWriter.logMessage("Dropping request " + this.getRealState());
            }
            catch (IOException e) {
                this.raiseErrorEvent(2);
            }
        }
    }

    public void sendMessage(SIPMessage messageToSend) throws IOException {
        SIPResponse transactionResponse = (SIPResponse)messageToSend;
        int statusCode = transactionResponse.getStatusCode();
        SIPDialog dialog = this.dialog;
        try {
            if (this.getOriginalRequest().getTopmostVia().getBranch() != null) {
                transactionResponse.getTopmostVia().setBranch(this.getBranch());
            } else {
                transactionResponse.getTopmostVia().removeParameter("branch");
            }
            if (!this.getOriginalRequest().getTopmostVia().hasPort()) {
                transactionResponse.getTopmostVia().removePort();
            }
        }
        catch (ParseException ex) {
            ex.printStackTrace();
        }
        if (!transactionResponse.getCSeq().getMethod().equals(this.getOriginalRequest().getMethod())) {
            this.sendResponse(transactionResponse);
            return;
        }
        if (this.dialog != null) {
            if (this.dialog.getRemoteTag() == null && transactionResponse.getTo().getTag() != null && ((SIPTransactionStack)this.getSIPStack()).isDialogCreated(transactionResponse.getCSeq().getMethod())) {
                this.dialog.setRemoteTag(transactionResponse.getTo().getTag());
                ((SIPTransactionStack)this.getSIPStack()).putDialog(this.dialog);
                if (statusCode / 100 == 1) {
                    this.dialog.setState(0);
                }
            } else if (((SIPTransactionStack)this.getSIPStack()).isDialogCreated(transactionResponse.getCSeq().getMethod()) && transactionResponse.getCSeq().getMethod().equals(this.getOriginalRequest().getMethod())) {
                if (statusCode / 100 == 2) {
                    if (!this.isInviteTransaction()) {
                        this.dialog.setState(1);
                    } else if (this.dialog.getState() == null) {
                        this.dialog.setState(0);
                    }
                } else if (statusCode >= 300 && statusCode <= 699) {
                    this.dialog.setState(3);
                }
            } else if (transactionResponse.getCSeq().getMethod().equals("BYE") && statusCode / 100 == 2 && dialog != null) {
                if (!this.isReliable()) {
                    this.dialog.setState(2);
                } else {
                    this.dialog.setState(3);
                }
            }
        }
        if (this.getRealState() == TransactionState.TRYING) {
            if (statusCode / 100 == 1) {
                this.setState(TransactionState.PROCEEDING);
            } else if (200 <= statusCode && statusCode <= 699) {
                if (!this.isInviteTransaction()) {
                    this.setState(TransactionState.COMPLETED);
                } else if (statusCode / 100 == 2) {
                    this.setState(TransactionState.TERMINATED);
                } else {
                    this.setState(TransactionState.COMPLETED);
                }
                if (!this.isReliable()) {
                    this.enableRetransmissionTimer();
                }
                this.enableTimeoutTimer(64);
            }
        } else if (this.getRealState() == TransactionState.PROCEEDING) {
            if (this.isInviteTransaction()) {
                if (statusCode / 100 == 2) {
                    if (!transactionResponse.getCSeq().getMethod().equals("CANCEL")) {
                        this.collectionTime = 64;
                        this.setState(TransactionState.TERMINATED);
                        if (!this.isReliable()) {
                            this.dialog.setRetransmissionTicks();
                            this.enableRetransmissionTimer();
                        }
                        this.enableTimeoutTimer(64);
                    }
                } else if (300 <= statusCode && statusCode <= 699) {
                    this.setState(TransactionState.COMPLETED);
                    if (!this.isReliable()) {
                        this.enableRetransmissionTimer();
                    }
                    this.enableTimeoutTimer(64);
                } else if (statusCode / 100 == 2) {
                    this.setState(TransactionState.TERMINATED);
                    this.disableRetransmissionTimer();
                    this.disableTimeoutTimer();
                }
            } else if (200 <= statusCode && statusCode <= 699) {
                this.setState(TransactionState.COMPLETED);
                if (!this.isReliable()) {
                    this.disableRetransmissionTimer();
                    this.enableTimeoutTimer(64);
                } else {
                    this.setState(TransactionState.TERMINATED);
                }
            }
        } else if (TransactionState.COMPLETED == this.getRealState()) {
            return;
        }
        try {
            this.lastResponse = transactionResponse;
            this.sendResponse(transactionResponse);
        }
        catch (IOException e) {
            this.setState(TransactionState.TERMINATED);
            this.collectionTime = 0;
            throw e;
        }
    }

    public String getViaHost() {
        return this.encapsulatedChannel.getViaHost();
    }

    public int getViaPort() {
        return this.encapsulatedChannel.getViaPort();
    }

    protected void fireRetransmissionTimer() {
        try {
            if (this.isInviteTransaction()) {
                if (((SIPTransactionStack)this.getSIPStack()).retransmissionFilter) {
                    super.sendMessage(this.lastResponse);
                } else {
                    this.raiseErrorEvent(3);
                }
            }
        }
        catch (IOException e) {
            if (LogWriter.needsLogging) {
                this.sipStack.logWriter.logException(e);
            }
            this.raiseErrorEvent(2);
        }
    }

    protected void fireTimeoutTimer() {
        if (LogWriter.needsLogging) {
            this.sipStack.logWriter.logMessage("SIPServerTransaction.fireTimeoutTimer " + this.getRealState() + " method = " + this.getOriginalRequest().getMethod());
        }
        SIPDialog dialog = this.dialog;
        if (((SIPTransactionStack)this.getSIPStack()).isDialogCreated(this.getOriginalRequest().getMethod()) && (TransactionState.CALLING == this.getRealState() || TransactionState.TRYING == this.getRealState())) {
            dialog.setState(3);
        } else if (this.getOriginalRequest().getMethod().equals("BYE") && dialog != null) {
            dialog.setState(3);
        }
        if (TransactionState.COMPLETED == this.getRealState() && this.isInviteTransaction()) {
            this.raiseErrorEvent(1);
            this.setState(TransactionState.TERMINATED);
        } else if (TransactionState.CONFIRMED == this.getRealState() && this.isInviteTransaction()) {
            this.setState(TransactionState.TERMINATED);
        } else if (!(this.isInviteTransaction() || TransactionState.COMPLETED != this.getRealState() && TransactionState.CONFIRMED != this.getRealState())) {
            this.setState(TransactionState.TERMINATED);
        } else if (this.isInviteTransaction() && TransactionState.TERMINATED == this.getRealState()) {
            this.raiseErrorEvent(1);
            if (dialog != null) {
                dialog.setState(3);
            }
        }
    }

    public SIPResponse getLastResponse() {
        return this.lastResponse;
    }

    public void setOriginalRequest(SIPRequest originalRequest) {
        super.setOriginalRequest(originalRequest);
        if (originalRequest.getMethod().equals("ACK")) {
            this.setState(TransactionState.TERMINATED);
        }
    }

    public void sendResponse(Response response) throws SipException {
        SIPDialog dialog = this.dialog;
        try {
            String fromTag;
            SIPResponse responseImpl = (SIPResponse)response;
            if (responseImpl.getStatusCode() == 200 && this.sipStack.isDialogCreated(responseImpl.getCSeq().getMethod()) && dialog.getLocalTag() == null && responseImpl.getTo().getTag() == null) {
                throw new SipException("To tag must be set for OK");
            }
            if (responseImpl.getStatusCode() == 200 && responseImpl.getCSeq().getMethod().equals("INVITE") && responseImpl.getHeader("Contact") == null) {
                throw new SipException("Contact Header is mandatory for the OK");
            }
            if (dialog != null && dialog.getLocalTag() != null) {
                responseImpl.getTo().setTag(dialog.getLocalTag());
            }
            if ((fromTag = ((SIPRequest)this.getRequest()).getFrom().getTag()) != null) {
                responseImpl.getFrom().setTag(fromTag);
            } else if (LogWriter.needsLogging) {
                this.sipStack.logWriter.logMessage("WARNING -- Null From tag  Dialog layer in jeopardy!!");
            }
            this.sendMessage((SIPResponse)response);
            if (responseImpl.getCSeq().getMethod().equalsIgnoreCase("CANCEL") && responseImpl.getStatusCode() == 200 && dialog != null && !dialog.isReInvite() && this.sipStack.isDialogCreated(this.getOriginalRequest().getMethod()) && (dialog.getState() == null || dialog.getState().getValue() == 0)) {
                dialog.setState(3);
            }
            if (dialog != null) {
                if (responseImpl.getCSeq().getMethod().equals("BYE") && responseImpl.getStatusCode() == 200) {
                    dialog.setState(3);
                } else if (responseImpl.getCSeq().getMethod().equalsIgnoreCase("CANCEL")) {
                    if (dialog.getState() == null || dialog.getState().getValue() == 0) {
                        dialog.setState(3);
                    }
                } else if (dialog.getLocalTag() == null && responseImpl.getTo().getTag() != null) {
                    if (responseImpl.getStatusCode() != 100) {
                        dialog.setLocalTag(responseImpl.getTo().getTag());
                    }
                    if (this.sipStack.isDialogCreated(responseImpl.getCSeq().getMethod())) {
                        if (response.getStatusCode() / 100 == 1) {
                            dialog.setState(0);
                        }
                        if (responseImpl.getStatusCode() != 100) {
                            this.sipStack.putDialog(dialog);
                        }
                        if (responseImpl.getStatusCode() / 100 == 2) {
                            if (responseImpl.getCSeq().getMethod().equals("INVITE")) {
                                if (dialog.getState() == null) {
                                    dialog.setState(0);
                                }
                                dialog.startTimer(this);
                            } else {
                                dialog.setState(1);
                            }
                        }
                    }
                } else if (response.getStatusCode() / 100 == 2 && this.sipStack.isDialogCreated(responseImpl.getCSeq().getMethod())) {
                    if (!responseImpl.getCSeq().getMethod().equals("INVITE")) {
                        dialog.setState(1);
                    } else {
                        if (this.dialog.getState() == null) {
                            this.dialog.setState(0);
                        }
                        this.dialog.startTimer(this);
                    }
                    this.sipStack.putDialog(dialog);
                }
            }
        }
        catch (IOException ex) {
            throw new SipException(ex.getMessage());
        }
        catch (ParseException ex1) {
            throw new SipException(ex1.getMessage());
        }
    }

    private TransactionState getRealState() {
        return super.getState();
    }

    public TransactionState getState() {
        if (this.isInviteTransaction() && TransactionState.TRYING == super.getState()) {
            return TransactionState.PROCEEDING;
        }
        return super.getState();
    }

    public void setState(TransactionState newState) {
        if (newState == TransactionState.TERMINATED && this.isReliable() && !this.getSIPStack().cacheServerConnections) {
            this.collectionTime = 64;
        }
        super.setState(newState);
    }

    public boolean passToListener() {
        return this.toListener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processPending() {
        PendingRequest pr;
        LinkedList linkedList = this.pendingRequests;
        synchronized (linkedList) {
            if (this.pendingRequests.isEmpty()) {
                return;
            }
            pr = (PendingRequest)this.pendingRequests.removeFirst();
        }
        this.processRequest(pr.sipRequest, pr.messageChannel);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasPending() {
        LinkedList linkedList = this.pendingRequests;
        synchronized (linkedList) {
            return !this.pendingRequests.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearPending() {
        boolean toNotify = false;
        LinkedList linkedList = this.pendingRequests;
        synchronized (linkedList) {
            super.clearPending();
            if (!this.pendingRequests.isEmpty()) {
                toNotify = true;
            }
        }
        if (toNotify) {
            this.sipStack.notifyPendingRecordScanner();
        }
    }

    protected void startTransactionTimer() {
        this.myTimer = new TransactionTimer(this);
        this.sipStack.timer.schedule(this.myTimer, 0L, 500L);
    }

    class TransactionTimer
    extends TimerTask {
        SIPServerTransaction myTransaction;
        SIPTransactionStack sipStack;

        public TransactionTimer(SIPServerTransaction myTransaction) {
            this.myTransaction = myTransaction;
            this.sipStack = myTransaction.sipStack;
        }

        public void run() {
            if (this.myTransaction.isTerminated()) {
                block4: {
                    try {
                        this.cancel();
                    }
                    catch (IllegalStateException ex) {
                        if (this.sipStack.isAlive()) break block4;
                        return;
                    }
                }
                this.myTransaction.myTimer = new SIPTransaction.LingerTimer(SIPServerTransaction.this, this.myTransaction);
                this.sipStack.timer.schedule(SIPServerTransaction.this.myTimer, 32000L);
            } else {
                SIPServerTransaction.this.fireTimer();
            }
        }
    }

    class SendTrying
    extends TimerTask {
        private SIPServerTransaction serverTransaction;

        protected SendTrying(SIPServerTransaction st) {
            if (LogWriter.needsLogging) {
                SIPServerTransaction.this.sipStack.logWriter.logMessage("scheduled timer for " + st);
            }
            this.serverTransaction = st;
        }

        public void run() {
            block5: {
                if (this.serverTransaction.getRealState() == null || TransactionState.TRYING == this.serverTransaction.getRealState()) {
                    if (LogWriter.needsLogging) {
                        SIPServerTransaction.this.sipStack.logWriter.logMessage(" sending Trying current state = " + this.serverTransaction.getRealState());
                    }
                    try {
                        this.serverTransaction.sendMessage(this.serverTransaction.getOriginalRequest().createResponse(100, "Trying"));
                        if (LogWriter.needsLogging) {
                            SIPServerTransaction.this.sipStack.logWriter.logMessage(" trying sent " + this.serverTransaction.getRealState());
                        }
                    }
                    catch (IOException ex) {
                        if (!LogWriter.needsLogging) break block5;
                        SIPServerTransaction.this.sipStack.logWriter.logMessage("IO error sending  TRYING");
                    }
                }
            }
        }
    }

    class PendingRequest {
        protected SIPRequest sipRequest;
        protected MessageChannel messageChannel;

        public PendingRequest(SIPRequest sipRequest, MessageChannel messageChannel) {
            this.sipRequest = sipRequest;
            this.messageChannel = messageChannel;
        }
    }
}

