/*
 * Decompiled with CFR 0.152.
 */
package net.java.stun4j.attribute;

import net.java.stun4j.StunAddress;
import net.java.stun4j.StunException;
import net.java.stun4j.attribute.ChangeRequestAttribute;
import net.java.stun4j.attribute.ChangedAddressAttribute;
import net.java.stun4j.attribute.ErrorCodeAttribute;
import net.java.stun4j.attribute.MappedAddressAttribute;
import net.java.stun4j.attribute.ReflectedFromAttribute;
import net.java.stun4j.attribute.ResponseAddressAttribute;
import net.java.stun4j.attribute.SourceAddressAttribute;
import net.java.stun4j.attribute.UnknownAttributesAttribute;

public class AttributeFactory {
    private AttributeFactory() {
    }

    public static ChangeRequestAttribute createChangeRequestAttribute() {
        return AttributeFactory.createChangeRequestAttribute(false, false);
    }

    public static ChangeRequestAttribute createChangeRequestAttribute(boolean changeIP, boolean changePort) {
        ChangeRequestAttribute attribute = new ChangeRequestAttribute();
        attribute.setChangeIpFlag(changeIP);
        attribute.setChangePortFlag(changePort);
        return attribute;
    }

    public static ChangedAddressAttribute createChangedAddressAttribute(StunAddress address) {
        ChangedAddressAttribute attribute = new ChangedAddressAttribute();
        attribute.setAddress(address);
        return attribute;
    }

    public static ErrorCodeAttribute createErrorCodeAttribute(byte errorClass, byte errorNumber) throws StunException {
        return AttributeFactory.createErrorCodeAttribute(errorClass, errorNumber, null);
    }

    public static ErrorCodeAttribute createErrorCodeAttribute(byte errorClass, byte errorNumber, String reasonPhrase) throws StunException {
        ErrorCodeAttribute attribute = new ErrorCodeAttribute();
        attribute.setErrorClass(errorClass);
        attribute.setErrorNumber(errorNumber);
        attribute.setReasonPhrase(reasonPhrase == null ? ErrorCodeAttribute.getDefaultReasonPhrase(attribute.getErrorCode()) : reasonPhrase);
        return attribute;
    }

    public static ErrorCodeAttribute createErrorCodeAttribute(char errorCode) throws StunException {
        return AttributeFactory.createErrorCodeAttribute(errorCode, null);
    }

    public static ErrorCodeAttribute createErrorCodeAttribute(char errorCode, String reasonPhrase) throws StunException {
        ErrorCodeAttribute attribute = new ErrorCodeAttribute();
        attribute.setErrorCode(errorCode);
        attribute.setReasonPhrase(reasonPhrase == null ? ErrorCodeAttribute.getDefaultReasonPhrase(attribute.getErrorCode()) : reasonPhrase);
        return attribute;
    }

    public static MappedAddressAttribute createMappedAddressAttribute(StunAddress address) {
        MappedAddressAttribute attribute = new MappedAddressAttribute();
        attribute.setAddress(address);
        return attribute;
    }

    public static ReflectedFromAttribute createReflectedFromAttribute(StunAddress address) {
        ReflectedFromAttribute attribute = new ReflectedFromAttribute();
        attribute.setAddress(address);
        return attribute;
    }

    public static ResponseAddressAttribute createResponseAddressAttribute(StunAddress address) {
        ResponseAddressAttribute attribute = new ResponseAddressAttribute();
        attribute.setAddress(address);
        return attribute;
    }

    public static SourceAddressAttribute createSourceAddressAttribute(StunAddress address) {
        SourceAddressAttribute attribute = new SourceAddressAttribute();
        attribute.setAddress(address);
        return attribute;
    }

    public static UnknownAttributesAttribute createUnknownAttributesAttribute() {
        UnknownAttributesAttribute attribute = new UnknownAttributesAttribute();
        return attribute;
    }
}

