/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.jdic.tray.internal.impl;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.LinkedList;
import java.util.ListIterator;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPopupMenu;
import javax.swing.JWindow;
import org.jdesktop.jdic.tray.internal.TrayIconService;
import org.jdesktop.jdic.tray.internal.impl.GnomeTrayAppletService;

public class GnomeTrayIconService
extends GnomeTrayAppletService
implements TrayIconService {
    private JPopupMenu menu;
    private IconPanel iconPanel;
    private Icon icon;
    private HWToolTip tooltip;
    private boolean autoSize;
    private LinkedList actionList = new LinkedList();

    public GnomeTrayIconService() {
        this.iconPanel = new IconPanel();
        this.frame.add(this.iconPanel);
        this.frame.setFocusable(true);
        this.frame.requestFocus();
        this.initListeners();
    }

    void mousePressed(MouseEvent e) {
        if (this.menu != null) {
            if (e.isPopupTrigger() && !this.menu.isShowing()) {
                this.tooltip.hide();
                this.menu.show();
                Dimension d = this.menu.getSize();
                if (d.height == 0 || d.width == 0) {
                    this.menu.show((Component)e.getSource(), e.getX(), e.getY());
                    d = this.menu.getSize();
                    this.menu.show((Component)e.getSource(), e.getX(), e.getY() - d.height);
                } else {
                    this.menu.show((Component)e.getSource(), e.getX(), e.getY() - d.height);
                }
            } else if (!this.menu.isShowing()) {
                this.menu.hide();
                this.tooltip.hide();
                ListIterator li = this.actionList.listIterator(0);
                while (li.hasNext()) {
                    ActionListener al = (ActionListener)li.next();
                    al.actionPerformed(new ActionEvent(e.getSource(), 1001, "PressAction", e.getWhen(), 0));
                }
            }
        }
    }

    void mouseEntered(MouseEvent e) {
        if (this.tooltip != null && (this.menu == null || this.menu != null && !this.menu.isShowing())) {
            Dimension d = this.tooltip.getSize();
            Point p = this.frame.getLocationOnScreen();
            Dimension size = this.tooltip.getPreferredSize();
            this.tooltip.show(p.x, p.y - size.height - 5);
        }
    }

    void mouseExited(MouseEvent e) {
        if (this.tooltip != null) {
            this.tooltip.setVisible(false);
        }
    }

    void initListeners() {
        MouseAdapter ma = new MouseAdapter(){

            public void mousePressed(MouseEvent e) {
                GnomeTrayIconService.this.mousePressed(e);
            }

            public void mouseEntered(MouseEvent e) {
                GnomeTrayIconService.this.mouseEntered(e);
            }

            public void mouseExited(MouseEvent e) {
                GnomeTrayIconService.this.mouseExited(e);
            }
        };
        this.iconPanel.addMouseListener(ma);
        this.frame.addMouseListener(ma);
    }

    public void addNotify() {
    }

    public void setPopupMenu(JPopupMenu m) {
        this.menu = m;
        if (m != null) {
            m.setLightWeightPopupEnabled(false);
        }
    }

    public void setIcon(Icon i) {
        this.icon = i;
        if (this.icon != null) {
            int w = this.icon.getIconWidth();
            int h = this.icon.getIconHeight();
            this.reshape(0, 0, w, h);
            this.frame.setVisible(false);
            this.frame.remove(this.iconPanel);
            this.iconPanel = new IconPanel();
            this.frame.add(this.iconPanel);
            this.frame.setVisible(true);
        }
        this.iconPanel.repaint();
    }

    public void setCaption(String s) {
        if (this.tooltip == null) {
            this.tooltip = new HWToolTip(this.frame);
        }
        this.tooltip.setCaption(s);
    }

    public void setIconAutoSize(boolean b) {
        this.autoSize = b;
        if (this.autoSize && this.icon != null) {
            int w = this.icon.getIconWidth();
            int h = this.icon.getIconHeight();
            this.reshape(0, 0, w, h);
            this.frame.setVisible(false);
            this.frame.remove(this.iconPanel);
            this.iconPanel = new IconPanel();
            this.frame.add(this.iconPanel);
            this.frame.setVisible(true);
        }
    }

    public void addActionListener(ActionListener l) {
        this.actionList.add(l);
    }

    public void removeActionListener(ActionListener l) {
        this.actionList.remove(l);
    }

    public Point getLocationOnScreen() {
        Point p = null;
        if (this.iconPanel != null) {
            p = this.iconPanel.getLocationOnScreen();
        }
        return p;
    }

    class HWToolTip
    extends JWindow {
        JLabel label;

        public HWToolTip(Window parent) {
            super(parent);
            this.setFocusableWindowState(false);
            this.setName("###overrideRedirect###");
            this.label = new JLabel();
            this.getContentPane().add(this.label);
        }

        public void setCaption(String caption) {
            this.label.setText(caption);
        }

        public void show(int x, int y) {
            this.setLocation(x, y);
            Dimension d = this.label.getPreferredSize();
            this.setSize(d.width, d.height);
            this.setVisible(true);
        }
    }

    class IconPanel
    extends JComponent {
        Image img;

        IconPanel() {
        }

        public void paintComponent(Graphics g) {
            Dimension d = GnomeTrayIconService.this.getAppletSize();
            g.clearRect(0, 0, d.width, d.height);
            if (GnomeTrayIconService.this.icon != null) {
                int w = GnomeTrayIconService.this.icon.getIconWidth();
                int h = GnomeTrayIconService.this.icon.getIconHeight();
                if (!GnomeTrayIconService.this.autoSize) {
                    GnomeTrayIconService.this.icon.paintIcon(this, g, 0, 0);
                } else {
                    if (this.img == null) {
                        this.img = this.createImage(w, h);
                    }
                    GnomeTrayIconService.this.icon.paintIcon(this, this.img.getGraphics(), 0, 0);
                    g.drawImage(this.img, 0, 0, d.width, d.height, 0, 0, w, h, this);
                }
            }
            super.paintComponent(g);
        }

        boolean doesIconReferenceImage(Icon icon, Image image) {
            Image iconImage = icon != null && icon instanceof ImageIcon ? ((ImageIcon)icon).getImage() : null;
            return iconImage == image;
        }

        public boolean imageUpdate(Image img, int infoflags, int x, int y, int w, int h) {
            if (!this.isShowing() || !this.doesIconReferenceImage(GnomeTrayIconService.this.icon, img)) {
                return false;
            }
            return super.imageUpdate(img, infoflags, x, y, w, h);
        }
    }
}

