/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.substance;

import java.util.HashMap;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JToggleButton;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicButtonListener;
import org.jvnet.lafwidget.utils.FadeStateListener;
import org.jvnet.lafwidget.utils.FadeTracker;
import org.jvnet.substance.SubstanceImageCreator;
import org.jvnet.substance.SubstanceRadioButtonUI;
import org.jvnet.substance.color.ColorScheme;
import org.jvnet.substance.utils.ComponentState;
import org.jvnet.substance.utils.RolloverButtonListener;
import org.jvnet.substance.utils.SubstanceCoreUtilities;

public class SubstanceCheckBoxUI
extends SubstanceRadioButtonUI {
    protected FadeStateListener fadeStateListener;
    private static Map<String, Icon> icons = new HashMap<String, Icon>();
    private static final int DIMENSION = 15;

    public static ComponentUI createUI(JComponent b) {
        return new SubstanceCheckBoxUI((JToggleButton)b);
    }

    private SubstanceCheckBoxUI(JToggleButton button) {
        super(button);
        button.setRolloverEnabled(true);
    }

    protected void installListeners(AbstractButton b) {
        super.installListeners(b);
        this.fadeStateListener = new FadeStateListener(b, b.getModel(), null);
        this.fadeStateListener.registerListeners();
    }

    protected void uninstallListeners(AbstractButton b) {
        this.fadeStateListener.unregisterListeners();
        this.fadeStateListener = null;
        super.uninstallListeners(b);
    }

    public static synchronized void reset() {
        icons.clear();
    }

    private static synchronized Icon getIcon(JToggleButton button, ComponentState state) {
        ColorScheme colorScheme;
        int visibility;
        FadeTracker fadeTracker = FadeTracker.getInstance();
        int n = visibility = state.isSelected() ? 10 : 0;
        if (fadeTracker.isTracked(button, FadeTracker.FadeKind.SELECTION)) {
            visibility = fadeTracker.getFade(button, FadeTracker.FadeKind.SELECTION);
        }
        if (fadeTracker.isTracked(button, FadeTracker.FadeKind.ROLLOVER)) {
            ColorScheme metallicScheme = SubstanceCoreUtilities.getDefaultScheme(button);
            ColorScheme colorScheme2 = colorScheme = SubstanceCoreUtilities.getActiveScheme(button);
            int cyclePos = 0;
            if (!state.isSelected() && state.isEnabled()) {
                if (state == ComponentState.DEFAULT) {
                    colorScheme2 = metallicScheme;
                    cyclePos = 10 - fadeTracker.getFade(button, FadeTracker.FadeKind.ROLLOVER);
                } else {
                    colorScheme2 = colorScheme;
                    colorScheme = metallicScheme;
                    cyclePos = fadeTracker.getFade(button, FadeTracker.FadeKind.ROLLOVER);
                }
                String key = state.name() + ":" + SubstanceCoreUtilities.getSchemeId(colorScheme) + ":" + SubstanceCoreUtilities.getSchemeId(colorScheme2) + ":" + cyclePos + ":" + visibility;
                Icon result = icons.get(key);
                if (result != null) {
                    return result;
                }
                result = new ImageIcon(SubstanceImageCreator.getCheckBox(15, state, colorScheme, colorScheme2, cyclePos, (float)visibility / 10.0f));
                icons.put(key, result);
                return result;
            }
        }
        ComponentState.ColorSchemeKind kind = state.getColorSchemeKind();
        colorScheme = SubstanceCoreUtilities.getControlColorScheme(button, kind);
        int cyclePos = state.getCycleCount();
        String key = state.name() + ":" + SubstanceCoreUtilities.getSchemeId(colorScheme) + ":" + SubstanceCoreUtilities.getSchemeId(colorScheme) + ":" + cyclePos + ":" + visibility;
        Icon result = icons.get(key);
        if (result != null) {
            return result;
        }
        result = new ImageIcon(SubstanceImageCreator.getCheckBox(15, state, colorScheme, colorScheme, cyclePos, (float)visibility / 10.0f));
        icons.put(key, result);
        return result;
    }

    protected BasicButtonListener createButtonListener(AbstractButton b) {
        return new RolloverButtonListener(b);
    }

    public Icon getDefaultIcon() {
        ButtonModel model = this.button.getModel();
        return SubstanceCheckBoxUI.getIcon(this.button, ComponentState.getState(model, this.button));
    }

    public static String getMemoryUsage() {
        StringBuffer sb = new StringBuffer();
        sb.append("SubstanceCheckBox: \n");
        sb.append("\t" + icons.size() + " icons");
        return sb.toString();
    }
}

