/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.substance;

import java.awt.AlphaComposite;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import java.util.HashMap;
import java.util.Map;
import javax.swing.ComboBoxEditor;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicComboBoxUI;
import javax.swing.plaf.basic.ComboPopup;
import org.jvnet.substance.SubstanceComboBoxButton;
import org.jvnet.substance.SubstanceComboBoxRenderer;
import org.jvnet.substance.SubstanceComboPopup;
import org.jvnet.substance.SubstanceGradientBackgroundDelegate;
import org.jvnet.substance.SubstanceImageCreator;
import org.jvnet.substance.color.ColorScheme;
import org.jvnet.substance.utils.SubstanceConstants;
import org.jvnet.substance.utils.SubstanceCoreUtilities;

public class SubstanceComboBoxUI
extends BasicComboBoxUI {
    public static final Map<String, Icon> COMBO_ARROWS = new HashMap<String, Icon>();
    protected ComboBoxPropertyChangeHandler changeHandler;
    private static SubstanceGradientBackgroundDelegate backgroundDelegate = new SubstanceGradientBackgroundDelegate();

    public static synchronized void reset() {
        COMBO_ARROWS.clear();
    }

    public static synchronized Icon getArrowIcon(ColorScheme colorScheme, int orientation) {
        String key = SubstanceCoreUtilities.getSchemeId(colorScheme) + ":" + orientation;
        Icon result = COMBO_ARROWS.get(key);
        if (result != null) {
            return result;
        }
        result = SubstanceImageCreator.getArrowIcon(9, orientation == 0 ? 12 : 6, orientation, colorScheme);
        COMBO_ARROWS.put(key, result);
        return result;
    }

    public static ComponentUI createUI(JComponent b) {
        SubstanceComboBoxUI ui = new SubstanceComboBoxUI();
        return ui;
    }

    protected JButton createArrowButton() {
        ColorScheme colorScheme = this.comboBox.isEnabled() ? SubstanceCoreUtilities.getActiveScheme(this.comboBox) : SubstanceCoreUtilities.getDefaultScheme(this.comboBox);
        return new SubstanceComboBoxButton(this.comboBox, SubstanceComboBoxUI.getArrowIcon(colorScheme, SubstanceCoreUtilities.getPopupFlyoutOrientation(this.comboBox)));
    }

    protected ListCellRenderer createRenderer() {
        return new SubstanceComboBoxRenderer.SubstanceUIResource(this.comboBox);
    }

    protected void installListeners() {
        super.installListeners();
        this.changeHandler = new ComboBoxPropertyChangeHandler();
        this.comboBox.addPropertyChangeListener(this.changeHandler);
    }

    protected void uninstallListeners() {
        this.comboBox.removePropertyChangeListener(this.changeHandler);
        this.changeHandler = null;
        super.uninstallListeners();
    }

    protected LayoutManager createLayoutManager() {
        return new SubstanceComboBoxLayoutManager();
    }

    public Dimension getPreferredSize(JComponent c) {
        Dimension superRes = super.getPreferredSize(c);
        Dimension res = new Dimension((int)superRes.getWidth() + 4, (int)superRes.getHeight() + 4);
        return res;
    }

    protected ComboPopup createPopup() {
        final SubstanceComboPopup sPopup = new SubstanceComboPopup(this.comboBox);
        final ComponentOrientation currOrientation = this.comboBox.getComponentOrientation();
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                ComboBoxEditor editor;
                ListCellRenderer cellRenderer;
                if (SubstanceComboBoxUI.this.comboBox == null) {
                    return;
                }
                if (sPopup instanceof Component) {
                    Component cPopup = (Component)((Object)sPopup);
                    cPopup.applyComponentOrientation(currOrientation);
                    cPopup.doLayout();
                }
                if ((cellRenderer = SubstanceComboBoxUI.this.comboBox.getRenderer()) instanceof Component) {
                    ((Component)((Object)cellRenderer)).applyComponentOrientation(currOrientation);
                }
                if ((editor = SubstanceComboBoxUI.this.comboBox.getEditor()) != null && editor.getEditorComponent() instanceof Component) {
                    editor.getEditorComponent().applyComponentOrientation(currOrientation);
                }
                SubstanceComboBoxUI.this.comboBox.repaint();
            }
        });
        return sPopup;
    }

    public void paintCurrentValueBackground(Graphics g, Rectangle bounds, boolean hasFocus) {
        ColorScheme scheme = hasFocus ? SubstanceCoreUtilities.getActiveScheme(this.comboBox) : (this.comboBox.isEnabled() ? SubstanceCoreUtilities.getDefaultScheme(this.comboBox) : SubstanceCoreUtilities.getDisabledScheme(this.comboBox));
        Graphics2D graphics = (Graphics2D)g.create();
        if (!SubstanceCoreUtilities.isControlAlwaysPaintedActive(this.comboBox)) {
            graphics.setComposite(AlphaComposite.getInstance(3, 0.5f));
        }
        backgroundDelegate.update(graphics, this.comboBox, bounds, scheme, true);
        graphics.dispose();
    }

    public ComboPopup getPopup() {
        return this.popup;
    }

    public static String getMemoryUsage() {
        StringBuffer sb = new StringBuffer();
        sb.append("SubstanceComboBoxUI: \n");
        sb.append("\t" + COMBO_ARROWS.size() + " arrows");
        return sb.toString();
    }

    public class ComboBoxPropertyChangeHandler
    extends BasicComboBoxUI.PropertyChangeHandler {
        public ComboBoxPropertyChangeHandler() {
            super(SubstanceComboBoxUI.this);
        }

        public void propertyChange(final PropertyChangeEvent e) {
            ColorScheme colorScheme;
            String propertyName = e.getPropertyName();
            if (propertyName.equals("enabled") && SubstanceComboBoxUI.this.arrowButton != null) {
                colorScheme = SubstanceComboBoxUI.this.comboBox.isEnabled() ? SubstanceCoreUtilities.getActiveScheme(SubstanceComboBoxUI.this.comboBox) : SubstanceCoreUtilities.getDefaultScheme(SubstanceComboBoxUI.this.comboBox);
                SubstanceComboBoxUI.this.arrowButton.setIcon(SubstanceComboBoxUI.getArrowIcon(colorScheme, SubstanceCoreUtilities.getPopupFlyoutOrientation(SubstanceComboBoxUI.this.comboBox)));
            }
            if (propertyName.equals("componentOrientation")) {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        if (SubstanceComboBoxUI.this.comboBox == null) {
                            return;
                        }
                        ComponentOrientation newOrientation = (ComponentOrientation)e.getNewValue();
                        SubstanceComboBoxUI.this.arrowButton.putClientProperty("substancelaf.buttonside", newOrientation.isLeftToRight() ? SubstanceConstants.Side.LEFT.name() : SubstanceConstants.Side.RIGHT.name());
                        ListCellRenderer cellRenderer = SubstanceComboBoxUI.this.comboBox.getRenderer();
                        ComboBoxEditor editor = SubstanceComboBoxUI.this.comboBox.getEditor();
                        if (SubstanceComboBoxUI.this.popup instanceof Component) {
                            Component cPopup = (Component)((Object)SubstanceComboBoxUI.this.popup);
                            cPopup.applyComponentOrientation(newOrientation);
                            cPopup.doLayout();
                        }
                        if (cellRenderer instanceof Component) {
                            ((Component)((Object)cellRenderer)).applyComponentOrientation(newOrientation);
                        }
                        if (editor != null && editor.getEditorComponent() instanceof Component) {
                            editor.getEditorComponent().applyComponentOrientation(newOrientation);
                        }
                        if (SubstanceComboBoxUI.this.comboBox != null) {
                            SubstanceComboBoxUI.this.comboBox.repaint();
                        }
                    }
                });
            }
            if ("substancelaf.comboboxpopupFlyoutOrientation".equals(propertyName)) {
                colorScheme = SubstanceComboBoxUI.this.comboBox.isEnabled() ? SubstanceCoreUtilities.getActiveScheme(SubstanceComboBoxUI.this.comboBox) : SubstanceCoreUtilities.getDefaultScheme(SubstanceComboBoxUI.this.comboBox);
                SubstanceComboBoxUI.this.arrowButton.setIcon(SubstanceComboBoxUI.getArrowIcon(colorScheme, SubstanceCoreUtilities.getPopupFlyoutOrientation(SubstanceComboBoxUI.this.comboBox)));
            }
        }
    }

    private class SubstanceComboBoxLayoutManager
    extends BasicComboBoxUI.ComboBoxLayoutManager {
        private SubstanceComboBoxLayoutManager() {
            super(SubstanceComboBoxUI.this);
        }

        public void layoutContainer(Container parent) {
            JComboBox cb = (JComboBox)parent;
            int width = cb.getWidth();
            int height = cb.getHeight();
            Insets insets = SubstanceComboBoxUI.this.getInsets();
            int buttonWidth = UIManager.getInt("ScrollBar.width") - 1;
            int buttonHeight = height - (insets.top + insets.bottom);
            if (SubstanceComboBoxUI.this.arrowButton != null) {
                if (cb.getComponentOrientation().isLeftToRight()) {
                    SubstanceComboBoxUI.this.arrowButton.setBounds(width - (insets.right + buttonWidth), insets.top, buttonWidth, buttonHeight);
                } else {
                    SubstanceComboBoxUI.this.arrowButton.setBounds(insets.left, insets.top, buttonWidth, buttonHeight);
                }
            }
            if (SubstanceComboBoxUI.this.editor != null) {
                SubstanceComboBoxUI.this.editor.setBounds(SubstanceComboBoxUI.this.rectangleForCurrentValue());
            }
        }
    }
}

