/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.substance;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import javax.swing.ButtonModel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.MenuElement;
import javax.swing.MenuSelectionManager;
import org.jvnet.substance.SubstanceFillBackgroundDelegate;
import org.jvnet.substance.SubstanceGradientBackgroundDelegate;
import org.jvnet.substance.color.ColorScheme;
import org.jvnet.substance.utils.SubstanceCoreUtilities;

public class SubstanceMenuBackgroundDelegate {
    private static SubstanceGradientBackgroundDelegate activeBackgroundDelegate = new SubstanceGradientBackgroundDelegate();
    private SubstanceFillBackgroundDelegate fillBackgroundDelegate;

    public SubstanceMenuBackgroundDelegate(float fillAlpha) {
        this.fillBackgroundDelegate = new SubstanceFillBackgroundDelegate(fillAlpha);
    }

    private void paintBackground(Graphics g, Component component, int width, int height, ColorScheme colorScheme, boolean hasDarkBorder) {
        activeBackgroundDelegate.update(g, component, width, height, colorScheme, hasDarkBorder);
    }

    public void paintBackground(Graphics g, JMenuItem menuItem, Color bgColor, boolean hasDarkBorder, int textOffset) {
        Graphics2D graphics = (Graphics2D)g;
        if (!menuItem.isShowing()) {
            return;
        }
        ButtonModel model = menuItem.getModel();
        Color oldColor = g.getColor();
        int menuWidth = menuItem.getWidth();
        int menuHeight = menuItem.getHeight();
        MenuElement[] selectedMenuPath = MenuSelectionManager.defaultManager().getSelectedPath();
        boolean isRollover = selectedMenuPath.length == 0;
        for (MenuElement elem : selectedMenuPath) {
            if (elem != menuItem) continue;
            isRollover = true;
            break;
        }
        boolean bl = isRollover = isRollover && model.isRollover();
        if (menuItem.isOpaque()) {
            if (model.isArmed() || isRollover || menuItem instanceof JMenu && model.isSelected()) {
                this.paintBackground(g, menuItem, menuWidth, menuHeight, SubstanceCoreUtilities.getActiveScheme(menuItem), hasDarkBorder);
            } else {
                g.setColor(menuItem.getBackground());
                g.fillRect(0, 0, menuWidth, menuHeight);
                this.fillBackgroundDelegate.setAlphaComposite(0.4f);
                for (Container comp = menuItem.getParent(); comp != null && !(comp instanceof JMenuItem); comp = comp.getParent()) {
                    if (!(comp instanceof JMenuBar)) continue;
                    this.fillBackgroundDelegate.setAlphaComposite(1.0f);
                    break;
                }
                this.fillBackgroundDelegate.update(g, menuItem);
                if (menuItem.getParent() instanceof JPopupMenu) {
                    if (menuItem.getComponentOrientation().isLeftToRight()) {
                        GradientPaint gp = new GradientPaint(0.0f, 0.0f, SubstanceCoreUtilities.getActiveScheme(menuItem).getUltraLightColor(), textOffset, 0.0f, SubstanceCoreUtilities.getActiveScheme(menuItem).getLightColor());
                        graphics.setPaint(gp);
                        graphics.fillRect(0, 0, textOffset - 2, menuHeight);
                    } else {
                        GradientPaint gp = new GradientPaint(menuWidth - textOffset, 0.0f, SubstanceCoreUtilities.getActiveScheme(menuItem).getUltraLightColor(), menuWidth, 0.0f, SubstanceCoreUtilities.getActiveScheme(menuItem).getLightColor());
                        graphics.setPaint(gp);
                        graphics.fillRect(menuWidth - textOffset - 2, 0, menuWidth, menuHeight);
                    }
                }
            }
            g.setColor(oldColor);
        } else if (model.isArmed() || isRollover || menuItem instanceof JMenu && model.isSelected()) {
            this.paintBackground(g, menuItem, menuWidth, menuHeight, SubstanceCoreUtilities.getActiveScheme(menuItem), hasDarkBorder);
            g.setColor(oldColor);
        }
    }
}

