/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.substance;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.image.BufferedImage;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.MenuElement;
import javax.swing.MenuSelectionManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicMenuUI;
import org.jvnet.substance.SubstanceMenu;
import org.jvnet.substance.SubstanceMenuBackgroundDelegate;
import org.jvnet.substance.utils.MenuUtilities;

public class SubstanceMenuUI
extends BasicMenuUI
implements SubstanceMenu {
    private static SubstanceMenuBackgroundDelegate backgroundDelegate = new SubstanceMenuBackgroundDelegate(0.4f);
    protected MouseListener mouseListener;
    protected MenuUtilities.MenuPropertyListener propertyListener;
    protected FocusListener focusListener;
    protected static Graphics graphics;

    public static ComponentUI createUI(JComponent c) {
        return new SubstanceMenuUI();
    }

    protected void installDefaults() {
        super.installDefaults();
        this.menuItem.setRolloverEnabled(true);
        this.propertyListener = new MenuUtilities.MenuPropertyListener(this.menuItem);
        this.propertyListener.install();
        this.mouseListener = new MouseAdapter(){

            private boolean toRepaint() {
                MenuElement[] selectedMenuPath;
                for (MenuElement elem : selectedMenuPath = MenuSelectionManager.defaultManager().getSelectedPath()) {
                    if (elem != SubstanceMenuUI.this.menuItem) continue;
                    return true;
                }
                return selectedMenuPath.length == 0;
            }

            public void mouseEntered(MouseEvent e) {
                if (this.toRepaint()) {
                    SubstanceMenuUI.this.menuItem.getModel().setRollover(true);
                    SubstanceMenuUI.this.menuItem.repaint();
                }
            }

            public void mouseExited(MouseEvent e) {
                if (this.toRepaint()) {
                    SubstanceMenuUI.this.menuItem.getModel().setRollover(false);
                    SubstanceMenuUI.this.menuItem.repaint();
                }
            }
        };
        this.menuItem.addMouseListener(this.mouseListener);
        this.focusListener = new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                SubstanceMenuUI.this.menuItem.getModel().setRollover(false);
                SubstanceMenuUI.this.menuItem.repaint();
            }
        };
        this.menuItem.addFocusListener(this.focusListener);
    }

    protected void uninstallListeners() {
        super.uninstallListeners();
        this.propertyListener.uninstall();
        this.propertyListener = null;
        this.menuItem.removeMouseListener(this.mouseListener);
        this.mouseListener = null;
        this.menuItem.removeFocusListener(this.focusListener);
        this.focusListener = null;
    }

    protected void paintBackground(Graphics g, JMenuItem menuItem, Color bgColor) {
        int textOffset = MenuUtilities.getTextOffset(g, menuItem);
        if (menuItem.getParent() instanceof JMenuBar) {
            textOffset = 0;
        }
        backgroundDelegate.paintBackground(g, menuItem, bgColor, true, textOffset);
    }

    protected void paintText(Graphics g, JMenuItem menuItem, Rectangle textRect, String text) {
        MenuUtilities.lineupTextRectangle(g, menuItem, textRect, this.defaultTextIconGap);
        super.paintText(g, menuItem, textRect, text);
    }

    public Font getAcceleratorFont() {
        return this.acceleratorFont;
    }

    public Icon getArrowIcon() {
        return this.arrowIcon;
    }

    public Icon getCheckIcon() {
        return this.checkIcon;
    }

    public int getDefaultTextIconGap() {
        return this.defaultTextIconGap;
    }

    protected Dimension getPreferredMenuItemSize(JComponent c, Icon checkIcon, Icon arrowIcon, int defaultTextIconGap) {
        Dimension superDim = super.getPreferredMenuItemSize(c, checkIcon, arrowIcon, defaultTextIconGap);
        SubstanceMenuUI ui = (SubstanceMenuUI)this.menuItem.getUI();
        int textOffset = MenuUtilities.getTextOffset(graphics, this.menuItem) - MenuUtilities.getTextOffset(graphics, this.menuItem, ui.getAcceleratorFont(), checkIcon, arrowIcon, defaultTextIconGap);
        return new Dimension(superDim.width + textOffset, superDim.height);
    }

    static {
        BufferedImage dummy = new BufferedImage(1, 1, 2);
        graphics = dummy.getGraphics();
    }
}

