/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.substance;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicRadioButtonMenuItemUI;
import org.jvnet.substance.SubstanceMenu;
import org.jvnet.substance.SubstanceMenuBackgroundDelegate;
import org.jvnet.substance.utils.MenuUtilities;
import org.jvnet.substance.utils.RolloverMenuItemListener;

public class SubstanceRadioButtonMenuItemUI
extends BasicRadioButtonMenuItemUI
implements SubstanceMenu {
    protected RolloverMenuItemListener rolloverListener;
    private static SubstanceMenuBackgroundDelegate backgroundDelegate = new SubstanceMenuBackgroundDelegate(0.4f);
    protected static Graphics graphics;
    protected MenuUtilities.MenuPropertyListener propertyListener;

    public static ComponentUI createUI(JComponent b) {
        JRadioButtonMenuItem item = (JRadioButtonMenuItem)b;
        item.setRolloverEnabled(true);
        return new SubstanceRadioButtonMenuItemUI();
    }

    protected void installListeners() {
        super.installListeners();
        this.propertyListener = new MenuUtilities.MenuPropertyListener(this.menuItem);
        this.propertyListener.install();
        this.rolloverListener = new RolloverMenuItemListener(this.menuItem);
        this.menuItem.addMouseListener(this.rolloverListener);
    }

    protected void uninstallListeners() {
        super.uninstallListeners();
        this.propertyListener.uninstall();
        this.propertyListener = null;
        this.menuItem.removeMouseListener(this.rolloverListener);
        this.rolloverListener = null;
    }

    protected void paintBackground(Graphics g, JMenuItem menuItem, Color bgColor) {
        int textOffset = MenuUtilities.getTextOffset(g, menuItem);
        backgroundDelegate.paintBackground(g, menuItem, bgColor, true, textOffset);
    }

    protected void paintText(Graphics g, JMenuItem menuItem, Rectangle textRect, String text) {
        MenuUtilities.lineupTextRectangle(g, menuItem, textRect, this.defaultTextIconGap);
        super.paintText(g, menuItem, textRect, text);
    }

    public Font getAcceleratorFont() {
        return this.acceleratorFont;
    }

    public Icon getArrowIcon() {
        return this.arrowIcon;
    }

    public Icon getCheckIcon() {
        return this.checkIcon;
    }

    public int getDefaultTextIconGap() {
        return this.defaultTextIconGap;
    }

    protected Dimension getPreferredMenuItemSize(JComponent c, Icon checkIcon, Icon arrowIcon, int defaultTextIconGap) {
        Dimension superDim = super.getPreferredMenuItemSize(c, checkIcon, arrowIcon, defaultTextIconGap);
        SubstanceRadioButtonMenuItemUI ui = (SubstanceRadioButtonMenuItemUI)this.menuItem.getUI();
        int textOffset = MenuUtilities.getTextOffset(graphics, this.menuItem) - MenuUtilities.getTextOffset(graphics, this.menuItem, ui.getAcceleratorFont(), checkIcon, arrowIcon, defaultTextIconGap);
        return new Dimension(superDim.width + textOffset, superDim.height);
    }

    static {
        BufferedImage dummy = new BufferedImage(1, 1, 2);
        graphics = dummy.getGraphics();
    }
}

