/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.substance;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.geom.GeneralPath;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashMap;
import java.util.Map;
import javax.swing.ButtonModel;
import javax.swing.DefaultButtonModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JScrollBar;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.metal.MetalScrollBarUI;
import org.jvnet.lafwidget.utils.FadeTracker;
import org.jvnet.substance.SubstanceImageCreator;
import org.jvnet.substance.SubstanceLookAndFeel;
import org.jvnet.substance.SubstanceScrollButton;
import org.jvnet.substance.button.BaseButtonShaper;
import org.jvnet.substance.button.ClassicButtonShaper;
import org.jvnet.substance.button.SubstanceButtonShaper;
import org.jvnet.substance.color.ColorScheme;
import org.jvnet.substance.painter.SubstanceGradientPainter;
import org.jvnet.substance.theme.SubstanceTheme;
import org.jvnet.substance.utils.ComponentState;
import org.jvnet.substance.utils.RolloverControlListener;
import org.jvnet.substance.utils.SubstanceCoreUtilities;
import org.jvnet.substance.utils.Trackable;

public class SubstanceScrollBarUI
extends MetalScrollBarUI
implements Trackable {
    protected JButton myDecreaseButton;
    protected JButton myIncreaseButton;
    private ButtonModel thumbModel = new DefaultButtonModel();
    private static Map<String, BufferedImage> thumbVerticalMap = new HashMap<String, BufferedImage>();
    private static Map<String, BufferedImage> thumbHorizontalMap = new HashMap<String, BufferedImage>();
    private MouseListener mouseListener;
    private RolloverControlListener thumbRolloverListener;
    private PropertyChangeListener themeChangeListener;
    private static Map<String, TrackComponents> trackHorizontalCompsMap = new HashMap<String, TrackComponents>();
    private static Map<String, BufferedImage> trackHorizontalMap = new HashMap<String, BufferedImage>();
    private static Map<String, TrackComponents> trackVerticalCompsMap = new HashMap<String, TrackComponents>();
    private static Map<String, BufferedImage> trackVerticalMap = new HashMap<String, BufferedImage>();

    public static synchronized void reset() {
        trackVerticalCompsMap.clear();
        trackHorizontalCompsMap.clear();
        thumbHorizontalMap.clear();
        thumbVerticalMap.clear();
    }

    public static ComponentUI createUI(JComponent b) {
        return new SubstanceScrollBarUI(b);
    }

    private SubstanceScrollBarUI(JComponent b) {
        this.thumbModel.setArmed(false);
        this.thumbModel.setSelected(false);
        this.thumbModel.setPressed(false);
        this.thumbModel.setRollover(false);
    }

    protected JButton createDecreaseButton(int orientation) {
        int width = this.scrollBarWidth / 2;
        if (width % 2 == 0) {
            ++width;
        }
        int height = (int)(0.4 * (double)this.scrollBarWidth);
        Icon icon = SubstanceImageCreator.getArrowIcon(width, height, orientation, SubstanceCoreUtilities.getDefaultScheme(this.scrollbar));
        this.myDecreaseButton = new SubstanceScrollButton(icon, orientation);
        this.myDecreaseButton.setPreferredSize(new Dimension(this.scrollBarWidth, this.scrollBarWidth));
        this.synchDecreaseButtonTheme();
        return this.myDecreaseButton;
    }

    private void synchDecreaseButtonTheme() {
        SubstanceTheme theme = SubstanceCoreUtilities.getTheme(this.scrollbar);
        if (this.scrollbar.getOrientation() == 1) {
            this.myDecreaseButton.putClientProperty("substancelaf.theme", theme.getSecondTheme());
        } else if (this.scrollbar.getComponentOrientation().isLeftToRight()) {
            this.myDecreaseButton.putClientProperty("substancelaf.theme", theme.getFirstTheme());
        } else {
            this.myDecreaseButton.putClientProperty("substancelaf.theme", theme.getSecondTheme());
        }
    }

    protected JButton createIncreaseButton(int orientation) {
        int width = this.scrollBarWidth / 2;
        if (width % 2 == 0) {
            ++width;
        }
        int height = (int)(0.4 * (double)this.scrollBarWidth);
        Icon icon = SubstanceImageCreator.getArrowIcon(width, height, orientation, SubstanceCoreUtilities.getDefaultScheme(this.scrollbar));
        this.myIncreaseButton = new SubstanceScrollButton(icon, orientation);
        this.myIncreaseButton.setPreferredSize(new Dimension(this.scrollBarWidth, this.scrollBarWidth));
        this.synchIncreaseButtonTheme();
        return this.myIncreaseButton;
    }

    private void synchIncreaseButtonTheme() {
        SubstanceTheme theme = SubstanceCoreUtilities.getTheme(this.scrollbar);
        if (this.scrollbar.getOrientation() == 1) {
            this.myIncreaseButton.putClientProperty("substancelaf.theme", theme.getFirstTheme());
        } else if (this.scrollbar.getComponentOrientation().isLeftToRight()) {
            this.myIncreaseButton.putClientProperty("substancelaf.theme", theme.getSecondTheme());
        } else {
            this.myIncreaseButton.putClientProperty("substancelaf.theme", theme.getFirstTheme());
        }
    }

    private static synchronized BufferedImage getTrackHorizontal(JScrollBar scrollBar, Rectangle trackBounds, ComponentState compDecrState, ComponentState compIncrState) {
        int width = Math.max(1, trackBounds.width);
        int height = Math.max(1, trackBounds.height);
        SubstanceButtonShaper shaper = SubstanceLookAndFeel.getCurrentButtonShaper();
        String key = SubstanceCoreUtilities.getTheme(scrollBar).getDisplayName() + ":" + width + "*" + height + ":" + compDecrState.name() + ":" + compIncrState.name() + ":" + shaper.getDisplayName();
        BufferedImage result = trackHorizontalMap.get(key);
        if (result == null) {
            int radius = height / 2;
            if (shaper instanceof ClassicButtonShaper) {
                radius = 2;
            }
            result = SubstanceImageCreator.getCompositeRoundedBackground(scrollBar, width, height, radius, compDecrState, compIncrState, false);
            trackHorizontalMap.put(key, result);
        }
        return result;
    }

    private static synchronized BufferedImage getTrackVertical(JScrollBar scrollBar, Rectangle trackBounds, ComponentState compDecrState, ComponentState compIncrState) {
        int width = Math.max(1, trackBounds.width);
        int height = Math.max(1, trackBounds.height);
        SubstanceButtonShaper shaper = SubstanceLookAndFeel.getCurrentButtonShaper();
        String key = SubstanceCoreUtilities.getTheme(scrollBar).getDisplayName() + ":" + width + "*" + height + ":" + compDecrState.name() + ":" + compIncrState.name() + ":" + shaper.getDisplayName();
        BufferedImage result = trackVerticalMap.get(key);
        if (result == null) {
            int radius = width / 2;
            if (shaper instanceof ClassicButtonShaper) {
                radius = 2;
            }
            result = SubstanceImageCreator.getRotated(SubstanceImageCreator.getCompositeRoundedBackground(scrollBar, height, width, radius, compDecrState, compIncrState, true), 3);
            trackVerticalMap.put(key, result);
        }
        return result;
    }

    private static synchronized BufferedImage getThumbVertical(JScrollBar scrollBar, Rectangle thumbBounds, ButtonModel buttonModel) {
        ColorScheme colorScheme;
        int width = Math.max(1, thumbBounds.width);
        int height = Math.max(1, thumbBounds.height);
        ComponentState state = ComponentState.getState(buttonModel, null);
        ComponentState.ColorSchemeKind kind = state.getColorSchemeKind();
        int cyclePos = state.getCycleCount();
        ColorScheme colorScheme2 = colorScheme = SubstanceCoreUtilities.getControlColorScheme(scrollBar, kind);
        FadeTracker fadeTracker = FadeTracker.getInstance();
        if (fadeTracker.isTracked(scrollBar, FadeTracker.FadeKind.ROLLOVER)) {
            ColorScheme metallicScheme = SubstanceCoreUtilities.getDefaultScheme(scrollBar);
            if (state == ComponentState.DEFAULT) {
                colorScheme = SubstanceCoreUtilities.getActiveScheme(scrollBar);
                colorScheme2 = metallicScheme;
                cyclePos = 10 - fadeTracker.getFade(scrollBar, FadeTracker.FadeKind.ROLLOVER);
            }
            if (state == ComponentState.ROLLOVER_UNSELECTED) {
                colorScheme2 = colorScheme;
                colorScheme = metallicScheme;
                cyclePos = fadeTracker.getFade(scrollBar, FadeTracker.FadeKind.ROLLOVER);
            }
        }
        SubstanceGradientPainter painter = SubstanceLookAndFeel.getCurrentGradientPainter();
        SubstanceButtonShaper shaper = SubstanceLookAndFeel.getCurrentButtonShaper();
        String key = width + ":" + height + ":" + kind.name() + ":" + SubstanceCoreUtilities.getSchemeId(colorScheme) + ":" + SubstanceCoreUtilities.getSchemeId(colorScheme2) + ":" + cyclePos + ":" + painter.getDisplayName() + ":" + shaper.getDisplayName();
        BufferedImage result = thumbVerticalMap.get(key);
        if (result == null) {
            int radius = width / 2;
            if (shaper instanceof ClassicButtonShaper) {
                radius = 2;
            }
            GeneralPath contour = BaseButtonShaper.getBaseOutline(height, width, radius, null);
            result = painter.getContourBackground(height, width, contour, false, colorScheme, colorScheme2, cyclePos, true, colorScheme != colorScheme2);
            result = SubstanceImageCreator.getRotated(result, 3);
            thumbVerticalMap.put(key, result);
        }
        return result;
    }

    private static synchronized BufferedImage getThumbHorizontal(JScrollBar scrollBar, Rectangle thumbBounds, ButtonModel buttonModel) {
        ColorScheme colorScheme;
        int width = Math.max(1, thumbBounds.width);
        int height = Math.max(1, thumbBounds.height);
        ComponentState state = ComponentState.getState(buttonModel, null);
        ComponentState.ColorSchemeKind kind = state.getColorSchemeKind();
        int cyclePos = state.getCycleCount();
        ColorScheme colorScheme2 = colorScheme = SubstanceCoreUtilities.getControlColorScheme(scrollBar, kind);
        FadeTracker fadeTracker = FadeTracker.getInstance();
        if (fadeTracker.isTracked(scrollBar, FadeTracker.FadeKind.ROLLOVER)) {
            ColorScheme metallicScheme = SubstanceCoreUtilities.getDefaultScheme(scrollBar);
            if (state == ComponentState.DEFAULT) {
                colorScheme = SubstanceCoreUtilities.getActiveScheme(scrollBar);
                colorScheme2 = metallicScheme;
                cyclePos = 10 - fadeTracker.getFade(scrollBar, FadeTracker.FadeKind.ROLLOVER);
            }
            if (state == ComponentState.ROLLOVER_UNSELECTED) {
                colorScheme2 = colorScheme;
                colorScheme = metallicScheme;
                cyclePos = fadeTracker.getFade(scrollBar, FadeTracker.FadeKind.ROLLOVER);
            }
        }
        SubstanceGradientPainter painter = SubstanceLookAndFeel.getCurrentGradientPainter();
        SubstanceButtonShaper shaper = SubstanceLookAndFeel.getCurrentButtonShaper();
        String key = width + ":" + height + ":" + kind.name() + ":" + SubstanceCoreUtilities.getSchemeId(colorScheme) + ":" + SubstanceCoreUtilities.getSchemeId(colorScheme2) + ":" + cyclePos + ":" + painter.getDisplayName() + ":" + shaper.getDisplayName();
        BufferedImage result = thumbHorizontalMap.get(key);
        if (result == null) {
            int radius = height / 2;
            if (shaper instanceof ClassicButtonShaper) {
                radius = 2;
            }
            GeneralPath contour = BaseButtonShaper.getBaseOutline(width, height, radius, null);
            result = painter.getContourBackground(width, height, contour, false, colorScheme, colorScheme2, cyclePos, true, colorScheme != colorScheme2);
            thumbHorizontalMap.put(key, result);
        }
        return result;
    }

    protected void paintTrack(Graphics g, JComponent c, Rectangle trackBounds) {
        BufferedImage bi;
        if (!c.isEnabled()) {
            return;
        }
        ComponentState compDecrState = ComponentState.DEFAULT;
        ComponentState compIncrState = ComponentState.DEFAULT;
        if (this.myDecreaseButton.isShowing() && this.myIncreaseButton.isShowing()) {
            ButtonModel decrModel = this.myDecreaseButton.getModel();
            ButtonModel incrModel = this.myIncreaseButton.getModel();
            compDecrState = ComponentState.getState(decrModel, this.decreaseButton);
            compIncrState = ComponentState.getState(incrModel, this.increaseButton);
        }
        if (this.scrollbar.getOrientation() == 1) {
            bi = SubstanceScrollBarUI.getTrackVertical(this.scrollbar, trackBounds, compDecrState, compIncrState);
            g.drawImage(bi, trackBounds.x, trackBounds.y, null);
        } else {
            bi = this.scrollbar.getComponentOrientation().isLeftToRight() ? SubstanceScrollBarUI.getTrackHorizontal(this.scrollbar, trackBounds, compDecrState, compIncrState) : SubstanceScrollBarUI.getTrackHorizontal(this.scrollbar, trackBounds, compIncrState, compDecrState);
            g.drawImage(bi, trackBounds.x, trackBounds.y, null);
        }
    }

    protected void paintThumb(Graphics g, JComponent c, Rectangle thumbBounds) {
        if (!c.isEnabled()) {
            return;
        }
        JScrollBar scrollBar = (JScrollBar)c;
        this.thumbModel.setSelected(this.thumbModel.isSelected() || this.isDragging);
        BufferedImage thumbImage = this.scrollbar.getOrientation() == 1 ? SubstanceScrollBarUI.getThumbVertical(scrollBar, thumbBounds, this.thumbModel) : SubstanceScrollBarUI.getThumbHorizontal(scrollBar, thumbBounds, this.thumbModel);
        g.drawImage(thumbImage, thumbBounds.x, thumbBounds.y, null);
    }

    protected void installListeners() {
        super.installListeners();
        this.mouseListener = new MouseAdapter(){

            public void mouseEntered(MouseEvent e) {
                SubstanceScrollBarUI.this.scrollbar.repaint();
            }

            public void mouseExited(MouseEvent e) {
                SubstanceScrollBarUI.this.scrollbar.repaint();
            }

            public void mousePressed(MouseEvent e) {
                SubstanceScrollBarUI.this.scrollbar.repaint();
            }

            public void mouseReleased(MouseEvent e) {
                SubstanceScrollBarUI.this.scrollbar.repaint();
            }
        };
        this.incrButton.addMouseListener(this.mouseListener);
        this.decrButton.addMouseListener(this.mouseListener);
        this.thumbRolloverListener = new RolloverControlListener(this, this.thumbModel);
        this.scrollbar.addMouseListener(this.thumbRolloverListener);
        this.scrollbar.addMouseMotionListener(this.thumbRolloverListener);
        this.themeChangeListener = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                if ("substancelaf.theme".equals(evt.getPropertyName())) {
                    SubstanceScrollBarUI.this.synchDecreaseButtonTheme();
                    SubstanceScrollBarUI.this.synchIncreaseButtonTheme();
                }
            }
        };
        this.scrollbar.addPropertyChangeListener(this.themeChangeListener);
    }

    protected void uninstallListeners() {
        this.incrButton.removeMouseListener(this.mouseListener);
        this.decrButton.removeMouseListener(this.mouseListener);
        this.mouseListener = null;
        this.scrollbar.removeMouseListener(this.thumbRolloverListener);
        this.scrollbar.removeMouseMotionListener(this.thumbRolloverListener);
        this.thumbRolloverListener = null;
        this.scrollbar.removePropertyChangeListener(this.themeChangeListener);
        this.themeChangeListener = null;
        super.uninstallListeners();
    }

    public boolean isInside(MouseEvent me) {
        Rectangle thumbB = this.getThumbBounds();
        if (thumbB == null) {
            return false;
        }
        return thumbB.contains(me.getX(), me.getY());
    }

    public void scrollByBlock(int direction) {
        int oldValue = this.scrollbar.getValue();
        int blockIncrement = this.scrollbar.getBlockIncrement(direction);
        int delta = blockIncrement * (direction > 0 ? 1 : -1);
        int newValue = oldValue + delta;
        if (delta > 0 && newValue < oldValue) {
            newValue = this.scrollbar.getMaximum();
        } else if (delta < 0 && newValue > oldValue) {
            newValue = this.scrollbar.getMinimum();
        }
        this.scrollbar.setValue(newValue);
    }

    public void scrollByUnits(int direction, int units) {
        for (int i = 0; i < units; ++i) {
            int delta = direction > 0 ? this.scrollbar.getUnitIncrement(direction) : -this.scrollbar.getUnitIncrement(direction);
            int oldValue = this.scrollbar.getValue();
            int newValue = oldValue + delta;
            if (delta > 0 && newValue < oldValue) {
                newValue = this.scrollbar.getMaximum();
            } else if (delta < 0 && newValue > oldValue) {
                newValue = this.scrollbar.getMinimum();
            }
            if (oldValue == newValue) break;
            this.scrollbar.setValue(newValue);
        }
    }

    public static String getMemoryUsage() {
        StringBuffer sb = new StringBuffer();
        sb.append("SubstanceScrollBarUI: \n");
        sb.append("\t" + trackHorizontalCompsMap.size() + " track horizontal, " + trackVerticalCompsMap.size() + " track vertical, " + thumbHorizontalMap.size() + " thumb horizontal, " + thumbVerticalMap.size() + " thumb vertical");
        return sb.toString();
    }

    private static class TrackComponents {
        public BufferedImage downEnd;
        public BufferedImage trackSlice;
        public BufferedImage upEnd;

        private TrackComponents() {
        }
    }
}

