/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.substance;

import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.ContainerAdapter;
import java.awt.event.ContainerEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.metal.MetalTabbedPaneUI;
import javax.swing.text.View;
import org.jvnet.lafwidget.utils.FadeTracker;
import org.jvnet.substance.SubstanceIconFactory;
import org.jvnet.substance.SubstanceImageCreator;
import org.jvnet.substance.SubstanceLookAndFeel;
import org.jvnet.substance.SubstanceScrollButton;
import org.jvnet.substance.TabCloseListener;
import org.jvnet.substance.button.BaseButtonShaper;
import org.jvnet.substance.button.ClassicButtonShaper;
import org.jvnet.substance.button.SubstanceButtonShaper;
import org.jvnet.substance.color.ColorScheme;
import org.jvnet.substance.painter.SubstanceGradientPainter;
import org.jvnet.substance.tabbed.BaseTabCloseListener;
import org.jvnet.substance.tabbed.MultipleTabCloseListener;
import org.jvnet.substance.tabbed.TabCloseCallback;
import org.jvnet.substance.tabbed.VetoableMultipleTabCloseListener;
import org.jvnet.substance.tabbed.VetoableTabCloseListener;
import org.jvnet.substance.theme.SubstanceTheme;
import org.jvnet.substance.utils.SubstanceConstants;
import org.jvnet.substance.utils.SubstanceCoreUtilities;
import org.jvnet.substance.utils.TabAnimationTracker;
import org.jvnet.substance.utils.TabPulseTracker;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SubstanceTabbedPaneUI
extends MetalTabbedPaneUI {
    public static final int TAB_DEFAULT_BUTTON_DIMENSION = 11;
    protected Point mouseLocation;
    private static Map<String, BufferedImage> backgroundMap = new HashMap<String, BufferedImage>();
    private static Map<String, BufferedImage> closeButtonMap = new HashMap<String, BufferedImage>();
    protected MouseRolloverHandler baseRolloverHandler;
    protected TabbedContainerListener containerListener;
    protected ChangeListener selectionListener;

    public static synchronized void reset() {
        backgroundMap.clear();
    }

    public static ComponentUI createUI(JComponent tabPane) {
        SubstanceTabbedPaneUI result = new SubstanceTabbedPaneUI();
        return result;
    }

    @Override
    protected void installListeners() {
        super.installListeners();
        this.baseRolloverHandler = new MouseRolloverHandler();
        this.tabPane.addMouseMotionListener(this.baseRolloverHandler);
        this.tabPane.addMouseListener(this.baseRolloverHandler);
        this.containerListener = new TabbedContainerListener();
        this.containerListener.trackExistingTabs();
        for (int i = 0; i < this.tabPane.getTabCount(); ++i) {
            SubstanceConstants.TabAnimationKind animKind;
            Component tabComp = this.tabPane.getComponentAt(i);
            if (SubstanceCoreUtilities.isTabModified(tabComp)) {
                TabPulseTracker.update(this.tabPane, tabComp);
            }
            if ((animKind = SubstanceCoreUtilities.getTabAnimationKind(tabComp)) == null) continue;
            TabAnimationTracker.startAnimation(this.tabPane, tabComp, animKind);
        }
        this.tabPane.addContainerListener(this.containerListener);
        this.selectionListener = new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        int selected = SubstanceTabbedPaneUI.this.tabPane.getSelectedIndex();
                        FadeTracker fadeTracker = FadeTracker.getInstance();
                        if (selected >= 0 && selected < SubstanceTabbedPaneUI.this.tabPane.getTabCount() && SubstanceTabbedPaneUI.this.tabPane.isEnabledAt(selected)) {
                            fadeTracker.trackFadeIn(FadeTracker.FadeKind.ROLLOVER, SubstanceTabbedPaneUI.this.tabPane, selected, true, new TabRepaintCallback(SubstanceTabbedPaneUI.this.tabPane, selected));
                        }
                    }
                });
            }
        };
        this.tabPane.getModel().addChangeListener(this.selectionListener);
    }

    @Override
    protected void uninstallListeners() {
        super.uninstallListeners();
        if (this.baseRolloverHandler != null) {
            this.tabPane.removeMouseMotionListener(this.baseRolloverHandler);
            this.tabPane.removeMouseListener(this.baseRolloverHandler);
            this.baseRolloverHandler = null;
        }
        if (this.containerListener != null) {
            for (Map.Entry entry : this.containerListener.listeners.entrySet()) {
                Component comp = (Component)entry.getKey();
                for (PropertyChangeListener pcl : (List)entry.getValue()) {
                    comp.removePropertyChangeListener(pcl);
                }
            }
            this.containerListener.listeners.clear();
            this.tabPane.removeContainerListener(this.containerListener);
            this.containerListener = null;
        }
        this.tabPane.getModel().removeChangeListener(this.selectionListener);
        this.selectionListener = null;
    }

    private static synchronized BufferedImage getTabBackground(int width, int height, boolean isSelected, int cyclePos, SubstanceConstants.Side side, ColorScheme colorScheme, ColorScheme colorScheme2) {
        SubstanceGradientPainter gradientPainter = SubstanceLookAndFeel.getCurrentGradientPainter();
        if (gradientPainter == null) {
            return null;
        }
        int dx = 0;
        int ox = 0;
        int oy = 0;
        int dy = 0;
        switch (side) {
            case BOTTOM: {
                dy = 2;
                break;
            }
            case TOP: {
                dy = 2;
                oy = 2;
                break;
            }
            case RIGHT: {
                dx = 2;
                break;
            }
            case LEFT: {
                dx = 2;
                ox = -2;
            }
        }
        SubstanceButtonShaper shaper = SubstanceLookAndFeel.getCurrentButtonShaper();
        String key = width + dx + ":" + (height + dy) + ":" + isSelected + ":" + cyclePos + ":" + side.toString() + ":" + gradientPainter.getDisplayName() + ":" + shaper.getDisplayName() + ":" + SubstanceCoreUtilities.getSchemeId(colorScheme) + ":" + SubstanceCoreUtilities.getSchemeId(colorScheme2);
        BufferedImage result = backgroundMap.get(key);
        if (result == null) {
            HashSet<SubstanceConstants.Side> straightSides = new HashSet<SubstanceConstants.Side>();
            straightSides.add(side);
            int cornerRadius = height / 3;
            if (shaper instanceof ClassicButtonShaper) {
                cornerRadius = 2;
                --width;
            }
            GeneralPath contour = BaseButtonShaper.getBaseOutline(width + dx, height + dy, cornerRadius, straightSides);
            result = gradientPainter.getContourBackground(width + dx, height + dy, contour, false, colorScheme, colorScheme2, cyclePos, true, colorScheme != colorScheme2);
            BufferedImage finalImage = SubstanceCoreUtilities.getBlankImage(width, height);
            Graphics2D finalGraphics = (Graphics2D)finalImage.getGraphics();
            finalGraphics.drawImage((Image)result, ox, oy, null);
            backgroundMap.put(key, finalImage);
            result = finalImage;
        }
        return result;
    }

    private static synchronized BufferedImage getCloseButtonImage(int width, int height, int cyclePos, boolean toPaintBackground, ColorScheme colorScheme, ColorScheme colorScheme2) {
        SubstanceGradientPainter gradientPainter = SubstanceLookAndFeel.getCurrentGradientPainter();
        if (gradientPainter == null) {
            return null;
        }
        String key = width + ":" + height + ":" + toPaintBackground + ":" + cyclePos + ":" + gradientPainter.getDisplayName() + ":" + SubstanceCoreUtilities.getSchemeId(colorScheme) + ":" + SubstanceCoreUtilities.getSchemeId(colorScheme2);
        BufferedImage result = closeButtonMap.get(key);
        if (result == null) {
            result = SubstanceCoreUtilities.getBlankImage(width, height);
            Graphics2D finalGraphics = (Graphics2D)result.getGraphics();
            finalGraphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            if (toPaintBackground) {
                GeneralPath contour = BaseButtonShaper.getBaseOutline(width, height, 1.0f, null);
                BufferedImage background = gradientPainter.getContourBackground(width, height, contour, false, colorScheme, colorScheme2, cyclePos, true, colorScheme != colorScheme2);
                finalGraphics.drawImage((Image)background, 0, 0, null);
            }
            finalGraphics.setColor(colorScheme.getForegroundColor());
            finalGraphics.setStroke(new BasicStroke(1.2f));
            finalGraphics.drawLine(2, 2, width - 3, height - 3);
            finalGraphics.drawLine(2, height - 3, width - 3, 2);
            closeButtonMap.put(key, result);
        }
        return result;
    }

    @Override
    protected void paintTabBackground(Graphics g, int tabPlacement, int tabIndex, int x, int y, int w, int h, boolean isSelected) {
        BufferedImage backgroundImage = null;
        Graphics2D graphics = (Graphics2D)g.create();
        graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics.clip(new Rectangle(x, y, w, h));
        boolean isRollover = this.getRolloverTab() == tabIndex;
        boolean isEnabled = this.tabPane.isEnabledAt(tabIndex);
        ColorScheme colorScheme = SubstanceCoreUtilities.getActiveScheme(this.tabPane);
        if (!isSelected && !isRollover) {
            colorScheme = SubstanceCoreUtilities.getDefaultScheme(this.tabPane);
        }
        if (!isEnabled) {
            colorScheme = SubstanceCoreUtilities.getDisabledScheme(this.tabPane);
        }
        int cyclePos = isRollover && isEnabled ? 5 : 0;
        ColorScheme colorScheme2 = colorScheme;
        Component comp = this.tabPane.getComponentAt(tabIndex);
        boolean isWindowModified = SubstanceCoreUtilities.isTabModified(comp);
        boolean toMarkModifiedCloseButton = SubstanceCoreUtilities.toAnimateCloseIconOfModifiedTab(this.tabPane, tabIndex);
        if (isWindowModified && isEnabled && !toMarkModifiedCloseButton) {
            colorScheme2 = SubstanceTheme.YELLOW;
            colorScheme = SubstanceTheme.ORANGE;
            cyclePos = (int)TabPulseTracker.getCycles(this.tabPane, comp);
            if (cyclePos > 10) {
                cyclePos = 19 - cyclePos;
            }
        }
        FadeTracker fadeTracker = FadeTracker.getInstance();
        if (!isWindowModified && fadeTracker.isTracked(this.tabPane, tabIndex, null)) {
            ColorScheme metallicScheme = SubstanceCoreUtilities.getDefaultScheme(this.tabPane);
            if (!isRollover) {
                colorScheme2 = SubstanceCoreUtilities.getActiveScheme(this.tabPane);
                colorScheme = isSelected ? colorScheme : metallicScheme;
                cyclePos = fadeTracker.getFade(this.tabPane, tabIndex, null);
            } else {
                colorScheme2 = colorScheme;
                colorScheme = isSelected ? colorScheme : metallicScheme;
                cyclePos = fadeTracker.getFade(this.tabPane, tabIndex, null);
            }
        }
        boolean toSwap = SubstanceCoreUtilities.toLayoutVertically(this.tabPane);
        switch (tabPlacement) {
            case 2: {
                backgroundImage = SubstanceTabbedPaneUI.getTabBackground(w, h, isSelected, cyclePos, toSwap ? SubstanceConstants.Side.BOTTOM : SubstanceConstants.Side.RIGHT, colorScheme, colorScheme2);
                ++y;
                break;
            }
            case 4: {
                backgroundImage = SubstanceTabbedPaneUI.getTabBackground(w, h, isSelected, cyclePos, toSwap ? SubstanceConstants.Side.BOTTOM : SubstanceConstants.Side.LEFT, colorScheme, colorScheme2);
                break;
            }
            case 3: {
                backgroundImage = SubstanceTabbedPaneUI.getTabBackground(w, h, isSelected, cyclePos, SubstanceConstants.Side.BOTTOM, colorScheme, colorScheme2);
                backgroundImage = SubstanceImageCreator.getRotated(backgroundImage, 2);
                break;
            }
            default: {
                backgroundImage = SubstanceTabbedPaneUI.getTabBackground(w, h, isSelected, cyclePos, SubstanceConstants.Side.BOTTOM, colorScheme, colorScheme2);
            }
        }
        if (backgroundImage != null) {
            graphics.drawImage((Image)backgroundImage, x, y, null);
        }
        if (SubstanceCoreUtilities.hasCloseButton(this.tabPane, tabIndex) && isEnabled) {
            float alpha;
            float f = alpha = isSelected || isRollover ? 1.0f : 0.0f;
            if (!isSelected && fadeTracker.isTracked(this.tabPane, tabIndex, null)) {
                alpha = (float)fadeTracker.getFade(this.tabPane, tabIndex, null) / 10.0f;
            }
            if ((double)alpha > 0.0) {
                graphics.setComposite(AlphaComposite.getInstance(3, alpha));
                Rectangle orig = this.getCloseButtonRectangleForDraw(tabIndex, x, y, w, h);
                boolean toPaintCloseBorder = false;
                if (isRollover && this.mouseLocation != null) {
                    Rectangle rect;
                    Rectangle bounds = new Rectangle();
                    bounds = this.getTabBounds(tabIndex, bounds);
                    if (toSwap) {
                        bounds = new Rectangle(bounds.x, bounds.y, bounds.height, bounds.width);
                    }
                    if ((rect = this.getCloseButtonRectangleForEvents(tabIndex, bounds.x, bounds.y, bounds.width, bounds.height)).contains(this.mouseLocation)) {
                        toPaintCloseBorder = true;
                    }
                }
                if (isWindowModified && isEnabled && toMarkModifiedCloseButton) {
                    colorScheme2 = SubstanceTheme.YELLOW;
                    colorScheme = SubstanceTheme.ORANGE;
                    cyclePos = (int)TabPulseTracker.getCycles(this.tabPane, comp);
                    if (cyclePos > 10) {
                        cyclePos = 19 - cyclePos;
                    }
                }
                BufferedImage closeButtonImage = SubstanceTabbedPaneUI.getCloseButtonImage(orig.width, orig.height, cyclePos, toPaintCloseBorder, colorScheme, colorScheme2);
                graphics.drawImage((Image)closeButtonImage, orig.x, orig.y, null);
            }
        }
        graphics.dispose();
    }

    @Override
    protected void paintFocusIndicator(Graphics g, int tabPlacement, Rectangle[] rects, int tabIndex, Rectangle iconRect, Rectangle textRect, boolean isSelected) {
    }

    @Override
    protected void paintHighlightBelowTab() {
    }

    @Override
    protected void paintLeftTabBorder(int tabIndex, Graphics g, int x, int y, int w, int h, int btm, int rght, boolean isSelected) {
    }

    @Override
    protected void paintRightTabBorder(int tabIndex, Graphics g, int x, int y, int w, int h, int btm, int rght, boolean isSelected) {
    }

    @Override
    protected void paintTopTabBorder(int tabIndex, Graphics g, int x, int y, int w, int h, int btm, int rght, boolean isSelected) {
    }

    @Override
    protected void paintBottomTabBorder(int tabIndex, Graphics g, int x, int y, int w, int h, int btm, int rght, boolean isSelected) {
    }

    @Override
    protected void paintTabBorder(Graphics g, int tabPlacement, int tabIndex, int x, int y, int w, int h, boolean isSelected) {
    }

    @Override
    protected JButton createScrollButton(int direction) {
        Icon icon = SubstanceImageCreator.getArrowIcon(9, 5, direction, SubstanceCoreUtilities.getDefaultScheme(this.tabPane));
        SubstanceScrollButton ssb = new SubstanceScrollButton(icon, direction);
        return ssb;
    }

    @Override
    protected ChangeListener createChangeListener() {
        return new TabSelectionHandler();
    }

    @Override
    protected Insets getTabAreaInsets(int tabPlacement) {
        Insets result = super.getTabAreaInsets(tabPlacement);
        return result;
    }

    @Override
    protected Insets getTabInsets(int tabPlacement, int tabIndex) {
        Insets result = super.getTabInsets(tabPlacement, tabIndex);
        return result;
    }

    @Override
    protected int calculateTabHeight(int tabPlacement, int tabIndex, int fontHeight) {
        boolean toSwap = SubstanceCoreUtilities.toLayoutVertically(this.tabPane);
        if (toSwap) {
            return this.getTabExtraWidth(tabPlacement, tabIndex) + super.calculateTabWidth(tabPlacement, tabIndex, this.getFontMetrics());
        }
        return super.calculateTabHeight(tabPlacement, tabIndex, fontHeight);
    }

    @Override
    protected int calculateTabWidth(int tabPlacement, int tabIndex, FontMetrics metrics) {
        boolean toSwap = SubstanceCoreUtilities.toLayoutVertically(this.tabPane);
        if (toSwap) {
            return super.calculateTabHeight(tabPlacement, tabIndex, metrics.getHeight());
        }
        return this.getTabExtraWidth(tabPlacement, tabIndex) + super.calculateTabWidth(tabPlacement, tabIndex, metrics);
    }

    @Override
    protected int calculateMaxTabHeight(int tabPlacement) {
        if (tabPlacement == 1 || tabPlacement == 3) {
            return super.calculateMaxTabHeight(tabPlacement);
        }
        int result = 0;
        for (int i = 0; i < this.tabPane.getTabCount(); ++i) {
            result = Math.max(result, this.calculateTabHeight(tabPlacement, i, this.getFontMetrics().getHeight()));
        }
        return result;
    }

    @Override
    protected int getTabRunOverlay(int tabPlacement) {
        boolean toSwap = SubstanceCoreUtilities.toLayoutVertically(this.tabPane);
        if (!toSwap) {
            return super.getTabRunOverlay(tabPlacement);
        }
        return 0;
    }

    @Override
    protected void paintTab(Graphics g, int tabPlacement, Rectangle[] rects, int tabIndex, Rectangle iconRect, Rectangle textRect) {
        boolean toSwap = SubstanceCoreUtilities.toLayoutVertically(this.tabPane);
        if (toSwap) {
            Graphics2D tempG = (Graphics2D)g.create();
            Rectangle tabRect = rects[tabIndex];
            Rectangle correctRect = new Rectangle(tabRect.x, tabRect.y, tabRect.height, tabRect.width);
            if (tabPlacement == 2) {
                tempG.rotate(-1.5707963267948966, tabRect.x, tabRect.y);
                tempG.translate(-tabRect.height, 0);
            } else {
                tempG.rotate(1.5707963267948966, tabRect.x, tabRect.y);
                tempG.translate(0.0, -tabRect.getWidth());
            }
            tempG.setColor(Color.red);
            rects[tabIndex] = correctRect;
            super.paintTab(tempG, tabPlacement, rects, tabIndex, iconRect, textRect);
            rects[tabIndex] = tabRect;
            tempG.dispose();
        } else {
            super.paintTab(g, tabPlacement, rects, tabIndex, iconRect, textRect);
        }
    }

    @Override
    protected Icon getIconForTab(int tabIndex) {
        Icon superResult = super.getIconForTab(tabIndex);
        if (!SubstanceCoreUtilities.toLayoutVertically(this.tabPane)) {
            return superResult;
        }
        if (!SubstanceCoreUtilities.toShowIconUnrotated(this.tabPane, tabIndex)) {
            return superResult;
        }
        boolean rotateClockwise = this.tabPane.getTabPlacement() == 2;
        return new SubstanceIconFactory.RotatableIcon(superResult, rotateClockwise);
    }

    protected Rectangle getCloseButtonRectangleForDraw(int tabIndex, int x, int y, int width, int height) {
        int dimension = SubstanceCoreUtilities.getCloseButtonSize(this.tabPane, tabIndex);
        int xs = this.tabPane.getComponentOrientation().isLeftToRight() ? x + width - dimension - 4 : x + 4;
        int ys = y + (height - dimension) / 2;
        return new Rectangle(xs, ys, dimension, dimension);
    }

    protected Rectangle getCloseButtonRectangleForEvents(int tabIndex, int x, int y, int w, int h) {
        int tabPlacement = this.tabPane.getTabPlacement();
        boolean toSwap = SubstanceCoreUtilities.toLayoutVertically(this.tabPane);
        if (!toSwap) {
            return this.getCloseButtonRectangleForDraw(tabIndex, x, y, w, h);
        }
        int dimension = SubstanceCoreUtilities.getCloseButtonSize(this.tabPane, tabIndex);
        Point2D transCorner = null;
        Rectangle rectForDraw = this.getCloseButtonRectangleForDraw(tabIndex, x, y, h, w);
        if (tabPlacement == 2) {
            AffineTransform trans = new AffineTransform();
            trans.rotate(-1.5707963267948966, x, y);
            trans.translate(-h, 0.0);
            Point2D.Double origCorner = new Point2D.Double(rectForDraw.getMaxX(), rectForDraw.getMinY());
            transCorner = trans.transform(origCorner, null);
        } else {
            AffineTransform trans = new AffineTransform();
            trans.rotate(1.5707963267948966, x, y);
            trans.translate(0.0, -w);
            Point2D.Double origCorner = new Point2D.Double(rectForDraw.getMinX(), rectForDraw.getMaxY());
            transCorner = trans.transform(origCorner, null);
        }
        return new Rectangle((int)transCorner.getX(), (int)transCorner.getY(), dimension, dimension);
    }

    private void ensureCurrentLayout() {
        LayoutManager lm;
        if (!this.tabPane.isValid()) {
            this.tabPane.validate();
        }
        if (!this.tabPane.isValid() && (lm = this.tabPane.getLayout()) instanceof MetalTabbedPaneUI.TabbedPaneLayout) {
            MetalTabbedPaneUI.TabbedPaneLayout layout = (MetalTabbedPaneUI.TabbedPaneLayout)this.tabPane.getLayout();
            layout.calculateLayoutInfo();
        }
    }

    public FadeTracker.FadeTrackerCallback getCallback(int tabIndex) {
        return new TabRepaintCallback(this.tabPane, tabIndex);
    }

    protected void tryCloseTabs(int tabIndex, SubstanceConstants.TabCloseKind tabCloseKind) {
        if (tabCloseKind == null) {
            return;
        }
        if (tabCloseKind == SubstanceConstants.TabCloseKind.NONE) {
            return;
        }
        if (tabCloseKind == SubstanceConstants.TabCloseKind.ALL_BUT_THIS) {
            HashSet<Integer> indexes = new HashSet<Integer>();
            for (int i = 0; i < this.tabPane.getTabCount(); ++i) {
                if (i == tabIndex) continue;
                indexes.add(i);
            }
            this.tryCloseTabs(indexes);
            return;
        }
        if (tabCloseKind == SubstanceConstants.TabCloseKind.ALL) {
            HashSet<Integer> indexes = new HashSet<Integer>();
            for (int i = 0; i < this.tabPane.getTabCount(); ++i) {
                indexes.add(i);
            }
            this.tryCloseTabs(indexes);
            return;
        }
        this.tryCloseTab(tabIndex);
    }

    protected void tryCloseTab(int tabIndex) {
        Component component = this.tabPane.getComponentAt(tabIndex);
        HashSet<Component> componentSet = new HashSet<Component>();
        componentSet.add(component);
        boolean isVetoed = false;
        for (BaseTabCloseListener listener : SubstanceLookAndFeel.getAllTabCloseListeners(this.tabPane)) {
            BaseTabCloseListener vetoableListener;
            if (listener instanceof VetoableTabCloseListener) {
                vetoableListener = (VetoableTabCloseListener)listener;
                boolean bl = isVetoed = isVetoed || vetoableListener.vetoTabClosing(this.tabPane, component);
            }
            if (!(listener instanceof VetoableMultipleTabCloseListener)) continue;
            vetoableListener = (VetoableMultipleTabCloseListener)listener;
            isVetoed = isVetoed || vetoableListener.vetoTabsClosing(this.tabPane, componentSet);
        }
        if (isVetoed) {
            return;
        }
        for (BaseTabCloseListener listener : SubstanceLookAndFeel.getAllTabCloseListeners(this.tabPane)) {
            if (listener instanceof TabCloseListener) {
                ((TabCloseListener)listener).tabClosing(this.tabPane, component);
            }
            if (!(listener instanceof MultipleTabCloseListener)) continue;
            ((MultipleTabCloseListener)listener).tabsClosing(this.tabPane, componentSet);
        }
        this.tabPane.remove(tabIndex);
        if (this.tabPane.getTabCount() > 0) {
            this.selectPreviousTab(0);
            this.selectNextTab(this.tabPane.getSelectedIndex());
        }
        this.tabPane.repaint();
        for (BaseTabCloseListener listener : SubstanceLookAndFeel.getAllTabCloseListeners(this.tabPane)) {
            if (listener instanceof TabCloseListener) {
                ((TabCloseListener)listener).tabClosed(this.tabPane, component);
            }
            if (!(listener instanceof MultipleTabCloseListener)) continue;
            ((MultipleTabCloseListener)listener).tabsClosed(this.tabPane, componentSet);
        }
    }

    protected void tryCloseTabs(Set<Integer> tabIndexes) {
        HashSet<Component> componentSet = new HashSet<Component>();
        for (int tabIndex : tabIndexes) {
            componentSet.add(this.tabPane.getComponentAt(tabIndex));
        }
        boolean isVetoed = false;
        for (BaseTabCloseListener listener : SubstanceLookAndFeel.getAllTabCloseListeners(this.tabPane)) {
            if (!(listener instanceof VetoableMultipleTabCloseListener)) continue;
            VetoableMultipleTabCloseListener vetoableListener = (VetoableMultipleTabCloseListener)listener;
            isVetoed = isVetoed || vetoableListener.vetoTabsClosing(this.tabPane, componentSet);
        }
        if (isVetoed) {
            return;
        }
        for (BaseTabCloseListener listener : SubstanceLookAndFeel.getAllTabCloseListeners(this.tabPane)) {
            if (!(listener instanceof MultipleTabCloseListener)) continue;
            ((MultipleTabCloseListener)listener).tabsClosing(this.tabPane, componentSet);
        }
        for (Component toRemove : componentSet) {
            this.tabPane.remove(toRemove);
        }
        if (this.tabPane.getTabCount() > 0) {
            this.selectPreviousTab(0);
            this.selectNextTab(this.tabPane.getSelectedIndex());
        }
        this.tabPane.repaint();
        for (BaseTabCloseListener listener : SubstanceLookAndFeel.getAllTabCloseListeners(this.tabPane)) {
            if (!(listener instanceof MultipleTabCloseListener)) continue;
            ((MultipleTabCloseListener)listener).tabsClosed(this.tabPane, componentSet);
        }
    }

    @Override
    protected void layoutLabel(int tabPlacement, FontMetrics metrics, int tabIndex, String title, Icon icon, Rectangle tabRect, Rectangle iconRect, Rectangle textRect, boolean isSelected) {
        iconRect.y = 0;
        iconRect.x = 0;
        textRect.y = 0;
        textRect.x = 0;
        View v = this.getTextViewForTab(tabIndex);
        if (v != null) {
            this.tabPane.putClientProperty("html", v);
        }
        SwingUtilities.layoutCompoundLabel(this.tabPane, metrics, title, icon, 0, this.getTextAlignment(tabPlacement), 0, 11, tabRect, iconRect, textRect, this.textIconGap);
        this.tabPane.putClientProperty("html", null);
        int xNudge = this.getTabLabelShiftX(tabPlacement, tabIndex, isSelected);
        int yNudge = this.getTabLabelShiftY(tabPlacement, tabIndex, isSelected);
        iconRect.x += xNudge;
        iconRect.y += yNudge;
        textRect.x += xNudge;
        textRect.y += yNudge;
    }

    protected int getTextAlignment(int tabPlacement) {
        SubstanceConstants.TabTextAlignmentKind textAlignmentKind = SubstanceCoreUtilities.getTabTextAlignmentKind(this.tabPane);
        if (SubstanceCoreUtilities.toLayoutVertically(this.tabPane)) {
            return 0;
        }
        if (tabPlacement == 2) {
            switch (textAlignmentKind) {
                case ALWAYS_LEFT: 
                case FOLLOW_PLACEMENT: {
                    return 2;
                }
                case FOLLOW_ORIENTATION: {
                    if (this.tabPane.getComponentOrientation().isLeftToRight()) {
                        return 2;
                    }
                    return 4;
                }
                case ALWAYS_RIGHT: {
                    return 4;
                }
            }
        }
        if (tabPlacement == 4) {
            switch (textAlignmentKind) {
                case FOLLOW_PLACEMENT: 
                case ALWAYS_RIGHT: {
                    return 4;
                }
                case FOLLOW_ORIENTATION: {
                    if (this.tabPane.getComponentOrientation().isLeftToRight()) {
                        return 2;
                    }
                    return 4;
                }
                case ALWAYS_LEFT: {
                    return 2;
                }
            }
        }
        return 0;
    }

    @Override
    protected int getTabLabelShiftX(int tabPlacement, int tabIndex, boolean isSelected) {
        int textAlignment = this.getTextAlignment(tabPlacement);
        int delta = 0;
        if (textAlignment == 2) {
            delta = 10;
        }
        if (textAlignment == 4) {
            delta = -10 - SubstanceCoreUtilities.getCloseButtonSize(this.tabPane, tabIndex);
        }
        return delta + super.getTabLabelShiftX(tabPlacement, tabIndex, isSelected);
    }

    @Override
    protected int getTabLabelShiftY(int tabPlacement, int tabIndex, boolean isSelected) {
        int result = super.getTabLabelShiftY(tabPlacement, tabIndex, isSelected);
        result = tabPlacement == 3 ? --result : ++result;
        return result;
    }

    protected int getTabExtraWidth(int tabPlacement, int tabIndex) {
        int extraWidth = 0;
        SubstanceButtonShaper shaper = SubstanceLookAndFeel.getCurrentButtonShaper();
        extraWidth = shaper instanceof ClassicButtonShaper ? 2 : super.calculateTabHeight(tabPlacement, tabIndex, this.getFontMetrics().getHeight()) / 3;
        if (SubstanceCoreUtilities.hasCloseButton(this.tabPane, tabIndex) && this.tabPane.isEnabledAt(tabIndex)) {
            extraWidth += SubstanceCoreUtilities.getCloseButtonSize(this.tabPane, tabIndex);
        }
        return extraWidth;
    }

    public int getRolloverTabIndex() {
        return this.getRolloverTab();
    }

    public void setTabAreaInsets(Insets insets) {
        this.tabAreaInsets = insets;
    }

    public Insets getTabAreaInsets() {
        return this.tabAreaInsets;
    }

    public Rectangle getTabRectangle(int tabIndex) {
        return this.rects[tabIndex];
    }

    public static String getMemoryUsage() {
        StringBuffer sb = new StringBuffer();
        sb.append("SubstanceTabbedPaneUI: \n");
        sb.append("\t" + backgroundMap.size() + " backgrounds");
        return sb.toString();
    }

    protected class TabRepaintCallback
    implements FadeTracker.FadeTrackerCallback {
        protected int tabIndex;
        protected JTabbedPane tabbedPane;

        public TabRepaintCallback(JTabbedPane tabComponent, int tabIndex) {
            this.tabbedPane = tabComponent;
            this.tabIndex = tabIndex;
        }

        public void fadePerformed(FadeTracker.FadeKind fadeKind) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    if (SubstanceTabbedPaneUI.this.tabPane == null) {
                        return;
                    }
                    SubstanceTabbedPaneUI.this.ensureCurrentLayout();
                    int tabCount = SubstanceTabbedPaneUI.this.tabPane.getTabCount();
                    if (tabCount > 0 && TabRepaintCallback.this.tabIndex < tabCount && TabRepaintCallback.this.tabIndex < SubstanceTabbedPaneUI.this.rects.length) {
                        Rectangle rect = SubstanceTabbedPaneUI.this.getTabBounds(SubstanceTabbedPaneUI.this.tabPane, TabRepaintCallback.this.tabIndex);
                        SubstanceTabbedPaneUI.this.tabPane.repaint(rect);
                    }
                }
            });
        }
    }

    protected class TabSelectionHandler
    implements ChangeListener {
        protected TabSelectionHandler() {
        }

        public void stateChanged(ChangeEvent e) {
            JTabbedPane tabbedPane = (JTabbedPane)e.getSource();
            tabbedPane.revalidate();
            tabbedPane.repaint();
        }
    }

    protected class MouseRolloverHandler
    implements MouseListener,
    MouseMotionListener {
        int prevRolledOver = -1;
        boolean prevInCloseButton = false;

        protected MouseRolloverHandler() {
        }

        public void mouseClicked(MouseEvent e) {
            final int tabIndex = SubstanceTabbedPaneUI.this.tabForCoordinate(SubstanceTabbedPaneUI.this.tabPane, e.getX(), e.getY());
            TabCloseCallback closeCallback = SubstanceCoreUtilities.getTabCloseCallback(e, SubstanceTabbedPaneUI.this.tabPane, tabIndex);
            if (closeCallback == null) {
                return;
            }
            final SubstanceConstants.TabCloseKind tabCloseKind = closeCallback.onAreaClick(SubstanceTabbedPaneUI.this.tabPane, tabIndex, e);
            if (tabCloseKind == SubstanceConstants.TabCloseKind.NONE) {
                return;
            }
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    SubstanceTabbedPaneUI.this.tryCloseTabs(tabIndex, tabCloseKind);
                }
            });
        }

        public void mouseDragged(MouseEvent e) {
        }

        public void mouseEntered(MouseEvent e) {
        }

        public void mouseReleased(MouseEvent e) {
        }

        public void mouseMoved(MouseEvent e) {
            if (e.getSource() != SubstanceTabbedPaneUI.this.tabPane) {
                return;
            }
            if (SubstanceLookAndFeel.toIgnoreAnimation(SubstanceTabbedPaneUI.this.tabPane.getClass())) {
                return;
            }
            SubstanceTabbedPaneUI.this.mouseLocation = e.getPoint();
            int currRolledOver = SubstanceTabbedPaneUI.this.getRolloverTab();
            TabCloseCallback tabCloseCallback = SubstanceCoreUtilities.getTabCloseCallback(e, SubstanceTabbedPaneUI.this.tabPane, currRolledOver);
            if (currRolledOver == this.prevRolledOver) {
                if (currRolledOver >= 0) {
                    Rectangle rect = new Rectangle();
                    rect = SubstanceTabbedPaneUI.this.getTabBounds(currRolledOver, rect);
                    Rectangle close = SubstanceTabbedPaneUI.this.getCloseButtonRectangleForEvents(currRolledOver, rect.x, rect.y, rect.width, rect.height);
                    boolean inCloseButton = close.contains(e.getPoint());
                    if (this.prevInCloseButton == inCloseButton) {
                        return;
                    }
                    this.prevInCloseButton = inCloseButton;
                    if (tabCloseCallback != null) {
                        if (inCloseButton) {
                            SubstanceTabbedPaneUI.this.tabPane.setToolTipTextAt(currRolledOver, tabCloseCallback.getCloseButtonTooltip(SubstanceTabbedPaneUI.this.tabPane, currRolledOver));
                        } else {
                            SubstanceTabbedPaneUI.this.tabPane.setToolTipTextAt(currRolledOver, tabCloseCallback.getAreaTooltip(SubstanceTabbedPaneUI.this.tabPane, currRolledOver));
                        }
                    }
                    if (currRolledOver >= 0 && currRolledOver < SubstanceTabbedPaneUI.this.tabPane.getTabCount()) {
                        FadeTracker.FadeTrackerCallback currCallback = SubstanceTabbedPaneUI.this.getCallback(currRolledOver);
                        currCallback.fadePerformed(FadeTracker.FadeKind.ROLLOVER);
                    }
                }
            } else {
                FadeTracker fadeTracker = FadeTracker.getInstance();
                if (this.prevRolledOver >= 0 && this.prevRolledOver < SubstanceTabbedPaneUI.this.tabPane.getTabCount() && SubstanceTabbedPaneUI.this.tabPane.isEnabledAt(this.prevRolledOver)) {
                    fadeTracker.trackFadeOut(FadeTracker.FadeKind.ROLLOVER, SubstanceTabbedPaneUI.this.tabPane, this.prevRolledOver, true, new TabRepaintCallback(SubstanceTabbedPaneUI.this.tabPane, this.prevRolledOver));
                }
                if (currRolledOver >= 0 && currRolledOver < SubstanceTabbedPaneUI.this.tabPane.getTabCount() && SubstanceTabbedPaneUI.this.tabPane.isEnabledAt(currRolledOver)) {
                    fadeTracker.trackFadeIn(FadeTracker.FadeKind.ROLLOVER, SubstanceTabbedPaneUI.this.tabPane, currRolledOver, true, new TabRepaintCallback(SubstanceTabbedPaneUI.this.tabPane, currRolledOver));
                }
            }
            this.prevRolledOver = currRolledOver;
        }

        public void mouseExited(MouseEvent e) {
            if (this.prevRolledOver >= 0 && this.prevRolledOver < SubstanceTabbedPaneUI.this.tabPane.getTabCount() && SubstanceTabbedPaneUI.this.tabPane.isEnabledAt(this.prevRolledOver)) {
                FadeTracker fadeTracker = FadeTracker.getInstance();
                fadeTracker.trackFadeOut(FadeTracker.FadeKind.ROLLOVER, SubstanceTabbedPaneUI.this.tabPane, this.prevRolledOver, true, new TabRepaintCallback(SubstanceTabbedPaneUI.this.tabPane, this.prevRolledOver));
            }
            this.prevRolledOver = -1;
        }

        public void mousePressed(final MouseEvent e) {
            final int tabIndex = SubstanceTabbedPaneUI.this.tabForCoordinate(SubstanceTabbedPaneUI.this.tabPane, e.getX(), e.getY());
            if (SubstanceCoreUtilities.hasCloseButton(SubstanceTabbedPaneUI.this.tabPane, tabIndex)) {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        if (tabIndex >= 0 && SubstanceTabbedPaneUI.this.tabPane.isEnabledAt(tabIndex)) {
                            Rectangle rect = new Rectangle();
                            rect = SubstanceTabbedPaneUI.this.getTabBounds(tabIndex, rect);
                            Rectangle close = SubstanceTabbedPaneUI.this.getCloseButtonRectangleForEvents(tabIndex, rect.x, rect.y, rect.width, rect.height);
                            if (close.contains(e.getPoint())) {
                                TabCloseCallback closeCallback = SubstanceCoreUtilities.getTabCloseCallback(e, SubstanceTabbedPaneUI.this.tabPane, tabIndex);
                                SubstanceConstants.TabCloseKind tabCloseKind = closeCallback == null ? SubstanceConstants.TabCloseKind.THIS : closeCallback.onCloseButtonClick(SubstanceTabbedPaneUI.this.tabPane, tabIndex, e);
                                SubstanceTabbedPaneUI.this.tryCloseTabs(tabIndex, tabCloseKind);
                            }
                        }
                    }
                });
            }
        }
    }

    protected final class TabbedContainerListener
    extends ContainerAdapter {
        private Map<Component, List<PropertyChangeListener>> listeners = new HashMap<Component, List<PropertyChangeListener>>();

        protected void trackExistingTabs() {
            for (int i = 0; i < SubstanceTabbedPaneUI.this.tabPane.getTabCount(); ++i) {
                this.trackTab(SubstanceTabbedPaneUI.this.tabPane.getComponentAt(i));
            }
        }

        protected void trackTab(final Component tabComponent) {
            if (tabComponent == null) {
                return;
            }
            PropertyChangeListener tabModifiedListener = new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent evt) {
                    if ("windowModified".equals(evt.getPropertyName())) {
                        TabPulseTracker.update(SubstanceTabbedPaneUI.this.tabPane, tabComponent);
                    }
                    if ("substancelaf.tabbedpanetabAnimationKind".equals(evt.getPropertyName())) {
                        Object newValue = evt.getNewValue();
                        if (newValue == null) {
                            TabAnimationTracker.stopAnimation(SubstanceTabbedPaneUI.this.tabPane, tabComponent);
                        } else if (newValue instanceof SubstanceConstants.TabAnimationKind) {
                            TabAnimationTracker.startAnimation(SubstanceTabbedPaneUI.this.tabPane, tabComponent, (SubstanceConstants.TabAnimationKind)((Object)newValue));
                        }
                    }
                }
            };
            tabComponent.addPropertyChangeListener(tabModifiedListener);
            List<PropertyChangeListener> currList = this.listeners.get(tabComponent);
            if (currList == null) {
                currList = new LinkedList<PropertyChangeListener>();
            }
            currList.add(tabModifiedListener);
            this.listeners.put(tabComponent, currList);
            if (tabComponent instanceof JComponent && Boolean.TRUE.equals(((JComponent)tabComponent).getClientProperty("windowModified"))) {
                TabPulseTracker.update(SubstanceTabbedPaneUI.this.tabPane, tabComponent);
            }
        }

        protected void stopTrackTab(Component tabComponent) {
            if (tabComponent == null) {
                return;
            }
            List<PropertyChangeListener> pclList = this.listeners.get(tabComponent);
            if (pclList != null) {
                for (PropertyChangeListener pcl : pclList) {
                    tabComponent.removePropertyChangeListener(pcl);
                }
            }
            this.listeners.put(tabComponent, null);
        }

        protected void stopTrackExistingTabs() {
            for (int i = 0; i < SubstanceTabbedPaneUI.this.tabPane.getTabCount(); ++i) {
                this.stopTrackTab(SubstanceTabbedPaneUI.this.tabPane.getComponentAt(i));
            }
        }

        public void componentAdded(ContainerEvent e) {
            Component tabComponent = e.getChild();
            if (tabComponent instanceof UIResource) {
                return;
            }
            this.trackTab(tabComponent);
        }

        public void componentRemoved(ContainerEvent e) {
            Component tabComponent = e.getChild();
            if (tabComponent == null) {
                return;
            }
            if (tabComponent instanceof UIResource) {
                return;
            }
            for (PropertyChangeListener pcl : this.listeners.get(tabComponent)) {
                tabComponent.removePropertyChangeListener(pcl);
            }
            this.listeners.get(tabComponent).clear();
            this.listeners.remove(tabComponent);
            this.cleanListeners(tabComponent);
        }

        private void cleanListeners(Component comp) {
            if (comp instanceof Container) {
                Container cont = (Container)comp;
                for (int i = 0; i < cont.getComponentCount(); ++i) {
                    this.cleanListeners(cont.getComponent(i));
                }
            }
            if (comp instanceof JTabbedPane) {
                JTabbedPane jtp = (JTabbedPane)comp;
                SubstanceTabbedPaneUI ui = (SubstanceTabbedPaneUI)jtp.getUI();
                ui.uninstallUI(jtp);
            }
        }
    }
}

