/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.substance.utils;

import java.awt.AlphaComposite;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.geom.GeneralPath;
import java.awt.image.BufferedImage;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.WeakHashMap;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JInternalFrame;
import javax.swing.JRootPane;
import javax.swing.UIManager;
import org.jvnet.lafwidget.utils.FadeTracker;
import org.jvnet.substance.SubstanceImageCreator;
import org.jvnet.substance.SubstanceLookAndFeel;
import org.jvnet.substance.SubstanceScrollButton;
import org.jvnet.substance.SubstanceSpinnerButton;
import org.jvnet.substance.button.BaseButtonShaper;
import org.jvnet.substance.button.RectangularButtonShaper;
import org.jvnet.substance.button.StandardButtonShaper;
import org.jvnet.substance.button.SubstanceButtonShaper;
import org.jvnet.substance.color.ColorScheme;
import org.jvnet.substance.painter.StandardGradientPainter;
import org.jvnet.substance.painter.SubstanceGradientPainter;
import org.jvnet.substance.theme.SubstanceTheme;
import org.jvnet.substance.utils.ComponentState;
import org.jvnet.substance.utils.PulseTracker;
import org.jvnet.substance.utils.SubstanceConstants;
import org.jvnet.substance.utils.SubstanceCoreUtilities;

public class ButtonBackgroundDelegate {
    private static Map<String, BufferedImage> regularBackgrounds = new HashMap<String, BufferedImage>();
    private static Map<String, BufferedImage> pairwiseBackgrounds = new HashMap<String, BufferedImage>();
    private static WeakHashMap<AbstractButton, SubstanceConstants.ButtonTitleKind> titleButtons = new WeakHashMap();

    public static synchronized void reset() {
        regularBackgrounds.clear();
        pairwiseBackgrounds.clear();
    }

    public static synchronized void trackTitleButton(AbstractButton button, SubstanceConstants.ButtonTitleKind kind) {
        titleButtons.put(button, kind);
    }

    public static synchronized SubstanceConstants.ButtonTitleKind getKind(AbstractButton button) {
        SubstanceConstants.ButtonTitleKind result = titleButtons.get(button);
        if (result == null) {
            result = SubstanceConstants.ButtonTitleKind.NONE;
        }
        return result;
    }

    private static synchronized BufferedImage getBackground(AbstractButton button, GeneralPath contour, SubstanceButtonShaper shaper, SubstanceGradientPainter painter, int width, int height) {
        String key;
        ColorScheme colorScheme;
        JButton jb;
        ComponentState state = ComponentState.getState(button.getModel(), button);
        ComponentState.ColorSchemeKind kind = state.getColorSchemeKind();
        int cyclePos = state.getCycleCount();
        boolean isPulsating = false;
        if (button instanceof JButton && PulseTracker.isPulsating(jb = (JButton)button) && state != ComponentState.PRESSED_SELECTED && state != ComponentState.PRESSED_UNSELECTED) {
            isPulsating = true;
            cyclePos = (int)(PulseTracker.getCycles(jb) % 20L);
            if (cyclePos > 10) {
                cyclePos = 19 - cyclePos;
            }
        }
        ColorScheme colorScheme2 = colorScheme = SubstanceCoreUtilities.getControlColorScheme(button, kind);
        SubstanceConstants.ButtonTitleKind buttonKind = ButtonBackgroundDelegate.getKind(button);
        boolean isWindowModified = false;
        if (buttonKind == SubstanceConstants.ButtonTitleKind.CLOSE || buttonKind == SubstanceConstants.ButtonTitleKind.CLOSE_DI) {
            for (Container comp = button; comp != null; comp = comp.getParent()) {
                if (comp instanceof JInternalFrame) {
                    JInternalFrame jif = (JInternalFrame)comp;
                    isWindowModified = Boolean.TRUE.equals(jif.getClientProperty("windowModified"));
                    break;
                }
                if (comp instanceof JRootPane) {
                    JRootPane jrp = (JRootPane)comp;
                    isWindowModified = Boolean.TRUE.equals(jrp.getClientProperty("windowModified"));
                    break;
                }
                if (!(comp instanceof JInternalFrame.JDesktopIcon)) continue;
                JInternalFrame.JDesktopIcon jdi = (JInternalFrame.JDesktopIcon)comp;
                JInternalFrame jif = jdi.getInternalFrame();
                isWindowModified = Boolean.TRUE.equals(jif.getClientProperty("windowModified"));
                break;
            }
            if (isWindowModified) {
                colorScheme2 = SubstanceTheme.YELLOW;
                colorScheme = SubstanceTheme.ORANGE;
            }
        }
        if (!isWindowModified && !isPulsating) {
            ColorScheme metallicScheme;
            FadeTracker fadeTracker = FadeTracker.getInstance();
            if (fadeTracker.isTracked(button, FadeTracker.FadeKind.SELECTION)) {
                boolean isActive = SubstanceCoreUtilities.isControlAlwaysPaintedActive(button);
                metallicScheme = SubstanceCoreUtilities.getDefaultScheme(button);
                if (state == ComponentState.DEFAULT) {
                    colorScheme = SubstanceCoreUtilities.getActiveScheme(button);
                    colorScheme2 = isActive ? colorScheme : metallicScheme;
                    cyclePos = 10 - fadeTracker.getFade(button, FadeTracker.FadeKind.SELECTION);
                }
                if (state == ComponentState.SELECTED) {
                    colorScheme2 = colorScheme;
                    colorScheme = isActive ? colorScheme : metallicScheme;
                    cyclePos = fadeTracker.getFade(button, FadeTracker.FadeKind.SELECTION);
                }
                if (SubstanceCoreUtilities.isToolBarButton(button) && SubstanceCoreUtilities.isToolbarButtonFlat(button) || SubstanceCoreUtilities.hasFlatProperty(button)) {
                    colorScheme2 = colorScheme = state.isEnabled() ? SubstanceCoreUtilities.getActiveScheme(button) : SubstanceCoreUtilities.getDisabledScheme(button);
                }
            }
            if (fadeTracker.isTracked(button, FadeTracker.FadeKind.ROLLOVER)) {
                boolean isActive = SubstanceCoreUtilities.isControlAlwaysPaintedActive(button);
                metallicScheme = SubstanceCoreUtilities.getDefaultScheme(button);
                if (state == ComponentState.DEFAULT) {
                    colorScheme = SubstanceCoreUtilities.getActiveScheme(button);
                    colorScheme2 = isActive ? colorScheme : metallicScheme;
                    cyclePos = 10 - fadeTracker.getFade(button, FadeTracker.FadeKind.ROLLOVER);
                }
                if (state == ComponentState.ROLLOVER_UNSELECTED) {
                    colorScheme2 = colorScheme;
                    colorScheme = isActive ? colorScheme : metallicScheme;
                    cyclePos = fadeTracker.getFade(button, FadeTracker.FadeKind.ROLLOVER);
                }
                if (SubstanceCoreUtilities.isToolBarButton(button) && SubstanceCoreUtilities.isToolbarButtonFlat(button) || SubstanceCoreUtilities.hasFlatProperty(button)) {
                    colorScheme2 = colorScheme = state.isEnabled() ? SubstanceCoreUtilities.getActiveScheme(button) : SubstanceCoreUtilities.getDisabledScheme(button);
                }
            }
        }
        Object sideProp = button.getClientProperty("substancelaf.buttonside");
        SubstanceConstants.Side side = null;
        if (sideProp != null) {
            side = SubstanceConstants.Side.valueOf((String)sideProp);
        }
        boolean isRoundButton = StandardButtonShaper.isRoundButton(button);
        float radius = 0.0f;
        if (shaper instanceof RectangularButtonShaper) {
            radius = ((RectangularButtonShaper)((Object)shaper)).getCornerRadius(button, null);
        }
        if (!regularBackgrounds.containsKey(key = width + ":" + height + ":" + kind.name() + ":" + cyclePos + ":" + SubstanceCoreUtilities.getSchemeId(colorScheme) + ":" + SubstanceCoreUtilities.getSchemeId(colorScheme2) + ":" + shaper.getClass().getName() + ":" + painter.getClass().getName() + ":" + (Object)((Object)side) + ":" + button.getClass().getName() + ":" + isRoundButton + ":" + radius)) {
            BufferedImage newBackground = painter.getContourBackground(width, height, contour, false, colorScheme, colorScheme2, cyclePos, true, colorScheme != colorScheme2);
            regularBackgrounds.put(key, newBackground);
        }
        return regularBackgrounds.get(key);
    }

    private static synchronized BufferedImage getPairwiseBackground(AbstractButton button, int width, int height, SubstanceConstants.Side side) {
        String key;
        ColorScheme colorScheme;
        ComponentState state = ComponentState.getState(button.getModel(), button);
        ComponentState.ColorSchemeKind kind = state.getColorSchemeKind();
        int cyclePos = state.getCycleCount();
        ColorScheme colorScheme2 = colorScheme = SubstanceCoreUtilities.getControlColorScheme(button, kind);
        FadeTracker fadeTracker = FadeTracker.getInstance();
        if (fadeTracker.isTracked(button, FadeTracker.FadeKind.ROLLOVER)) {
            boolean isActive = SubstanceCoreUtilities.isControlAlwaysPaintedActive(button);
            ColorScheme metallicScheme = SubstanceCoreUtilities.getDefaultScheme(button);
            if (state == ComponentState.DEFAULT) {
                colorScheme = SubstanceCoreUtilities.getActiveScheme(button);
                colorScheme2 = isActive ? colorScheme : metallicScheme;
                cyclePos = 10 - fadeTracker.getFade(button, FadeTracker.FadeKind.ROLLOVER);
            }
            if (state == ComponentState.ROLLOVER_UNSELECTED) {
                colorScheme2 = colorScheme;
                colorScheme = isActive ? colorScheme : metallicScheme;
                cyclePos = fadeTracker.getFade(button, FadeTracker.FadeKind.ROLLOVER);
            }
        }
        if (!pairwiseBackgrounds.containsKey(key = width + ":" + height + ":" + side.toString() + ":" + cyclePos + ":" + SubstanceCoreUtilities.getSchemeId(colorScheme) + ":" + SubstanceCoreUtilities.getSchemeId(colorScheme2) + ":" + button.getClass().getName())) {
            BufferedImage newBackground = null;
            boolean radius = false;
            HashSet<SubstanceConstants.Side> straightSides = new HashSet<SubstanceConstants.Side>();
            GeneralPath contour = null;
            StandardGradientPainter painter = new StandardGradientPainter();
            int delta = 3;
            switch (side) {
                case TOP: 
                case BOTTOM: {
                    straightSides.add(side.getAdjacentSide());
                    contour = BaseButtonShaper.getBaseOutline(height + delta, width, (float)radius, straightSides);
                    newBackground = painter.getContourBackground(height + delta, width, contour, false, colorScheme, colorScheme2, cyclePos, true, colorScheme != colorScheme2);
                    newBackground = SubstanceImageCreator.getRotated(newBackground, 3);
                    break;
                }
                case RIGHT: 
                case LEFT: {
                    straightSides.add(side);
                    contour = BaseButtonShaper.getBaseOutline(width + delta, height, (float)radius, straightSides);
                    newBackground = painter.getContourBackground(width + delta, height, contour, false, colorScheme, colorScheme2, cyclePos, true, colorScheme != colorScheme2);
                }
            }
            BufferedImage finalBackground = SubstanceCoreUtilities.getBlankImage(width, height);
            Graphics2D finalGraphics = (Graphics2D)finalBackground.getGraphics();
            switch (side) {
                case BOTTOM: 
                case RIGHT: {
                    finalGraphics.drawImage(newBackground, 0, 0, null);
                    break;
                }
                case TOP: {
                    finalGraphics.drawImage(newBackground, 0, -delta, null);
                    break;
                }
                case LEFT: {
                    finalGraphics.drawImage(newBackground, -delta, 0, null);
                }
            }
            pairwiseBackgrounds.put(key, finalBackground);
        }
        return pairwiseBackgrounds.get(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateBackground(Graphics g, AbstractButton button) {
        if (!(UIManager.getLookAndFeel() instanceof SubstanceLookAndFeel)) {
            return;
        }
        button.setOpaque(false);
        if (SubstanceCoreUtilities.isButtonNeverPainted(button)) {
            return;
        }
        Graphics2D graphics = (Graphics2D)g.create();
        try {
            int width = button.getWidth();
            int height = button.getHeight();
            if (SubstanceCoreUtilities.isScrollButton(button)) {
                SubstanceScrollButton ssbButton = (SubstanceScrollButton)button;
                graphics.drawImage((Image)ButtonBackgroundDelegate.getPairwiseBackground(button, width, height, ssbButton.getSide()), 0, 0, null);
                return;
            }
            if (SubstanceCoreUtilities.isSpinnerButton(button)) {
                SubstanceSpinnerButton ssbButton = (SubstanceSpinnerButton)button;
                graphics.drawImage((Image)ButtonBackgroundDelegate.getPairwiseBackground(button, width, height, ssbButton.getSide()), 0, 0, null);
                return;
            }
            SubstanceConstants.ButtonTitleKind buttonKind = ButtonBackgroundDelegate.getKind(button);
            if (buttonKind == SubstanceConstants.ButtonTitleKind.CLOSE_DI || buttonKind == SubstanceConstants.ButtonTitleKind.REGULAR_DI) {
                graphics.setComposite(AlphaComposite.getInstance(3, 0.8f));
            }
            SubstanceButtonShaper shaper = SubstanceCoreUtilities.getButtonShaper(button);
            GeneralPath contour = shaper.getButtonOutline(button);
            SubstanceGradientPainter painter = SubstanceCoreUtilities.getGradientPainter(button);
            BufferedImage bgImage = ButtonBackgroundDelegate.getBackground(button, contour, shaper, painter, width, height);
            if (SubstanceCoreUtilities.isToolBarButton(button) && SubstanceCoreUtilities.isToolbarButtonFlat(button) || SubstanceCoreUtilities.hasFlatProperty(button)) {
                ComponentState state = ComponentState.getState(button.getModel(), button);
                if (FadeTracker.getInstance().isTracked(button, FadeTracker.FadeKind.ROLLOVER) && !state.isSelected() && state.isEnabled()) {
                    int fadeCoef = FadeTracker.getInstance().getFade(button, FadeTracker.FadeKind.ROLLOVER);
                    graphics.setComposite(AlphaComposite.getInstance(3, (float)fadeCoef / 10.0f));
                } else if (state == ComponentState.DEFAULT) {
                    return;
                }
                if (state != ComponentState.DISABLED_UNSELECTED) {
                    graphics.drawImage((Image)bgImage, 0, 0, null);
                }
            } else {
                graphics.drawImage((Image)bgImage, 0, 0, null);
            }
        }
        finally {
            graphics.dispose();
        }
    }

    public static boolean isRoundButton(AbstractButton button) {
        return !SubstanceCoreUtilities.isComboBoxButton(button) && !SubstanceCoreUtilities.isScrollButton(button) && SubstanceCoreUtilities.hasText(button);
    }

    public static boolean contains(AbstractButton button, int x, int y) {
        if (!(UIManager.getLookAndFeel() instanceof SubstanceLookAndFeel)) {
            return false;
        }
        SubstanceButtonShaper shaper = SubstanceCoreUtilities.getButtonShaper(button);
        GeneralPath contour = shaper.getButtonOutline(button);
        return contour.contains(x, y);
    }

    static String getMemoryUsage() {
        StringBuffer sb = new StringBuffer();
        sb.append("SubstanceBackgroundDelegate: \n");
        sb.append("\t" + regularBackgrounds.size() + " regular, " + pairwiseBackgrounds.size() + " pairwise");
        return sb.toString();
    }
}

