/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.substance.utils;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;
import javax.swing.Icon;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JTabbedPane;
import javax.swing.Timer;
import javax.swing.UIManager;
import org.jvnet.lafwidget.utils.FadeTracker;
import org.jvnet.substance.SubstanceImageCreator;
import org.jvnet.substance.SubstanceLookAndFeel;
import org.jvnet.substance.SubstanceTabbedPaneUI;
import org.jvnet.substance.color.SunfireRedColorScheme;
import org.jvnet.substance.color.SunsetColorScheme;
import org.jvnet.substance.utils.MixIcon;
import org.jvnet.substance.utils.ProgressIcon;
import org.jvnet.substance.utils.SubstanceConstants;

public class TabAnimationTracker
implements ActionListener {
    private static WeakHashMap<JTabbedPane, Map<Component, TabAnimationTracker>> trackers = new WeakHashMap();
    private static WeakHashMap<JTabbedPane, Map<Component, Long>> cycles = new WeakHashMap();
    private WeakReference<JTabbedPane> tabbedPane;
    private WeakReference<Component> tabComponent;
    private SubstanceConstants.TabAnimationKind kind;
    private boolean toStopAtCycleBreak;
    private SubstanceConstants.TabAnimationKind nextCycleKind;
    private Timer timer;

    private TabAnimationTracker(JTabbedPane tabbedPane, Component tabComponent) {
        this.tabbedPane = new WeakReference<JTabbedPane>(tabbedPane);
        this.tabComponent = new WeakReference<Component>(tabComponent);
        this.timer = new Timer(50, this);
        this.timer.setCoalesce(true);
    }

    private static boolean hasGlassPane(Component component) {
        if (component == null) {
            return false;
        }
        Component glassPane = null;
        if (component instanceof JDialog) {
            glassPane = ((JDialog)component).getGlassPane();
        }
        if (component instanceof JFrame) {
            glassPane = ((JFrame)component).getGlassPane();
        }
        return glassPane != null && glassPane.isVisible();
    }

    public void actionPerformed(ActionEvent event) {
        JTabbedPane jtp = (JTabbedPane)this.tabbedPane.get();
        if (jtp == null) {
            return;
        }
        Component comp = (Component)this.tabComponent.get();
        if (comp == null) {
            return;
        }
        if (TabAnimationTracker.hasGlassPane(jtp.getTopLevelAncestor())) {
            return;
        }
        int tabIndex = jtp.indexOfComponent(comp);
        if (comp.getParent() != jtp) {
            TabAnimationTracker tracker = TabAnimationTracker.getTracker(jtp, comp);
            tracker.stopTimer();
            tracker.tabbedPane.clear();
            tracker.tabComponent.clear();
            TabAnimationTracker.removeTracker(jtp, comp);
            TabAnimationTracker.removeCycleCount(jtp, comp);
        } else {
            long oldCycle = TabAnimationTracker.getRealCycles(jtp, comp);
            if (oldCycle == 20L) {
                oldCycle = -1L;
            }
            long newCycle = oldCycle + 1L;
            if (this.toStopAtCycleBreak && newCycle == 0L) {
                boolean toStopTimer;
                Icon origIcon = null;
                switch (this.kind) {
                    case ERROR: 
                    case WARNING: {
                        MixIcon mIcon = (MixIcon)jtp.getIconAt(tabIndex);
                        origIcon = mIcon.getOriginalIcon();
                        break;
                    }
                    case LOADING: {
                        ProgressIcon pIcon = (ProgressIcon)jtp.getIconAt(tabIndex);
                        origIcon = pIcon.getOriginalIcon();
                    }
                }
                boolean bl = toStopTimer = this.nextCycleKind == null;
                if (toStopTimer) {
                    jtp.setIconAt(tabIndex, origIcon);
                } else {
                    this.kind = this.nextCycleKind;
                    this.nextCycleKind = null;
                    this.toStopAtCycleBreak = false;
                    switch (this.kind) {
                        case ERROR: {
                            MixIcon mErrorIcon = new MixIcon(origIcon, SubstanceImageCreator.getErrorMarkerIcon(origIcon.getIconWidth(), new SunfireRedColorScheme()));
                            jtp.setIconAt(tabIndex, mErrorIcon);
                            break;
                        }
                        case WARNING: {
                            MixIcon mWarningIcon = new MixIcon(origIcon, SubstanceImageCreator.getWarningMarkerIcon(origIcon.getIconWidth(), new SunsetColorScheme()));
                            jtp.setIconAt(tabIndex, mWarningIcon);
                            break;
                        }
                        case LOADING: {
                            ProgressIcon pIcon = new ProgressIcon(origIcon);
                            jtp.setIconAt(tabIndex, pIcon);
                        }
                    }
                }
                SubstanceTabbedPaneUI ui = (SubstanceTabbedPaneUI)jtp.getUI();
                FadeTracker.FadeTrackerCallback callback = ui.getCallback(tabIndex);
                callback.fadePerformed(null);
                if (toStopTimer) {
                    this.stopTimer();
                    this.tabbedPane.clear();
                    this.tabComponent.clear();
                    TabAnimationTracker.removeTracker(jtp, comp);
                    TabAnimationTracker.removeCycleCount(jtp, comp);
                }
            }
            TabAnimationTracker.saveCycleCount(jtp, comp, newCycle);
            Icon icon = jtp.getIconAt(tabIndex);
            switch (this.kind) {
                case ERROR: 
                case WARNING: {
                    double mixPos;
                    double d = mixPos = newCycle < 10L ? (double)newCycle / 10.0 : (double)(20L - newCycle) / 10.0;
                    if (!(icon instanceof MixIcon)) break;
                    MixIcon mIcon = (MixIcon)jtp.getIconAt(tabIndex);
                    mIcon.setCyclePos(mixPos);
                    break;
                }
                case LOADING: {
                    double cyclePos = (double)newCycle / 20.0;
                    if (!(icon instanceof ProgressIcon)) break;
                    ProgressIcon pIcon = (ProgressIcon)jtp.getIconAt(tabIndex);
                    pIcon.setCyclePos(cyclePos);
                }
            }
        }
        if (UIManager.getLookAndFeel() instanceof SubstanceLookAndFeel) {
            if (tabIndex < 0) {
                this.stopTimer();
                return;
            }
            SubstanceTabbedPaneUI ui = (SubstanceTabbedPaneUI)jtp.getUI();
            FadeTracker.FadeTrackerCallback callback = ui.getCallback(tabIndex);
            callback.fadePerformed(null);
        }
    }

    private void startTimer() {
        if (!this.timer.isRunning()) {
            this.timer.start();
        }
    }

    private void stopTimer() {
        if (this.timer.isRunning()) {
            this.timer.stop();
        }
    }

    private boolean isRunning() {
        return this.timer.isRunning();
    }

    public static synchronized void startAnimation(JTabbedPane tabbedPane, Component tabComponent, SubstanceConstants.TabAnimationKind kind) {
        TabAnimationTracker tracker = TabAnimationTracker.getTracker(tabbedPane, tabComponent);
        int tabIndex = tabbedPane.indexOfComponent(tabComponent);
        if (tracker != null) {
            tracker.nextCycleKind = kind;
            tracker.toStopAtCycleBreak = true;
            return;
        }
        tracker = new TabAnimationTracker(tabbedPane, tabComponent);
        Icon currTabIcon = tabbedPane.getIconAt(tabIndex);
        int iconDim = currTabIcon != null ? Math.min(currTabIcon.getIconHeight(), currTabIcon.getIconWidth()) : 12;
        switch (kind) {
            case ERROR: {
                MixIcon mErrorIcon = new MixIcon(currTabIcon, SubstanceImageCreator.getErrorMarkerIcon(iconDim, new SunfireRedColorScheme()));
                tabbedPane.setIconAt(tabIndex, mErrorIcon);
                break;
            }
            case WARNING: {
                MixIcon mWarningIcon = new MixIcon(currTabIcon, SubstanceImageCreator.getWarningMarkerIcon(iconDim, new SunsetColorScheme()));
                tabbedPane.setIconAt(tabIndex, mWarningIcon);
                break;
            }
            case LOADING: {
                ProgressIcon pIcon = new ProgressIcon(currTabIcon);
                tabbedPane.setIconAt(tabIndex, pIcon);
            }
        }
        tracker.kind = kind;
        tracker.startTimer();
        TabAnimationTracker.saveTracker(tabbedPane, tabComponent, tracker);
        long initialCycle = 0L;
        TabAnimationTracker.saveCycleCount(tabbedPane, tabComponent, initialCycle);
    }

    public static synchronized void stopAnimation(JTabbedPane tabbedPane, Component tabComponent) {
        TabAnimationTracker tracker = TabAnimationTracker.getTracker(tabbedPane, tabComponent);
        if (tracker == null) {
            return;
        }
        tracker.toStopAtCycleBreak = true;
        tracker.nextCycleKind = null;
    }

    protected static long getRealCycles(JTabbedPane tabbedPane, Component tabComponent) {
        Map<Component, Long> map = cycles.get(tabbedPane);
        if (map == null) {
            return 0L;
        }
        Long cycleCount = map.get(tabComponent);
        if (cycleCount == null) {
            return 0L;
        }
        long result = cycleCount;
        return result;
    }

    public static long getCycles(JTabbedPane tabbedPane, Component tabComponent) {
        long result = TabAnimationTracker.getRealCycles(tabbedPane, tabComponent);
        if (result < 0L) {
            result = 0L;
        }
        return result;
    }

    public static boolean isAnimating(JTabbedPane tabbedPane, Component tabComponent) {
        Map<Component, TabAnimationTracker> map = trackers.get(tabbedPane);
        if (map == null) {
            return false;
        }
        TabAnimationTracker tracker = map.get(tabComponent);
        if (tracker == null) {
            return false;
        }
        return tracker.isRunning();
    }

    private static TabAnimationTracker getTracker(JTabbedPane tabbedPane, Component tabComponent) {
        Map<Component, TabAnimationTracker> map = trackers.get(tabbedPane);
        if (map == null) {
            return null;
        }
        return map.get(tabComponent);
    }

    private static void saveTracker(JTabbedPane tabbedPane, Component tabComponent, TabAnimationTracker tracker) {
        if (!trackers.containsKey(tabbedPane)) {
            trackers.put(tabbedPane, new HashMap());
        }
        trackers.get(tabbedPane).put(tabComponent, tracker);
    }

    private static void saveCycleCount(JTabbedPane tabbedPane, Component tabComponent, long cycleCount) {
        if (!cycles.containsKey(tabbedPane)) {
            cycles.put(tabbedPane, new HashMap());
        }
        cycles.get(tabbedPane).put(tabComponent, cycleCount);
    }

    private static void removeTracker(JTabbedPane tabbedPane, Component tabComponent) {
        if (!trackers.containsKey(tabbedPane)) {
            return;
        }
        trackers.get(tabbedPane).remove(tabComponent);
        if (trackers.get(tabbedPane).size() == 0) {
            trackers.remove(tabbedPane);
        }
    }

    private static void removeCycleCount(JTabbedPane tabbedPane, Component tabComponent) {
        if (!cycles.containsKey(tabbedPane)) {
            return;
        }
        cycles.get(tabbedPane).remove(tabComponent);
        if (cycles.get(tabbedPane).size() == 0) {
            cycles.remove(tabbedPane);
        }
    }

    public static void stopAllTimers() {
        for (Map<Component, TabAnimationTracker> map : trackers.values()) {
            for (TabAnimationTracker tracker : map.values()) {
                Component comp;
                tracker.stopTimer();
                JTabbedPane jtp = (JTabbedPane)tracker.tabbedPane.get();
                if (jtp == null || (comp = (Component)tracker.tabComponent.get()) == null) continue;
                int tabIndex = jtp.indexOfComponent(comp);
                Icon origIcon = null;
                Icon currIcon = jtp.getIconAt(tabIndex);
                switch (tracker.kind) {
                    case ERROR: 
                    case WARNING: {
                        if (!(currIcon instanceof MixIcon)) break;
                        MixIcon mIcon = (MixIcon)currIcon;
                        origIcon = mIcon.getOriginalIcon();
                        break;
                    }
                    case LOADING: {
                        if (!(currIcon instanceof ProgressIcon)) break;
                        ProgressIcon pIcon = (ProgressIcon)currIcon;
                        origIcon = pIcon.getOriginalIcon();
                    }
                }
                jtp.setIconAt(tabIndex, origIcon);
            }
            map.clear();
        }
        trackers.clear();
    }
}

