/*
 * Decompiled with CFR 0.152.
 */
package com.fujitsu.fla.upnp;

import com.fujitsu.fla.upnp.Device;
import com.fujitsu.fla.upnp.DeviceList;
import com.fujitsu.fla.upnp.Service;
import com.fujitsu.fla.upnp.ServiceList;
import com.fujitsu.fla.upnp.UPnP;
import com.fujitsu.fla.upnp.control.RenewSubscriber;
import com.fujitsu.fla.upnp.device.DeviceChangeListener;
import com.fujitsu.fla.upnp.device.Disposer;
import com.fujitsu.fla.upnp.device.NotifyListener;
import com.fujitsu.fla.upnp.device.SearchResponseListener;
import com.fujitsu.fla.upnp.device.USN;
import com.fujitsu.fla.upnp.event.EventListener;
import com.fujitsu.fla.upnp.event.NotifyRequest;
import com.fujitsu.fla.upnp.event.Property;
import com.fujitsu.fla.upnp.event.PropertyList;
import com.fujitsu.fla.upnp.event.SubscriptionRequest;
import com.fujitsu.fla.upnp.event.SubscriptionResponse;
import com.fujitsu.fla.upnp.http.HTTPRequest;
import com.fujitsu.fla.upnp.http.HTTPRequestListener;
import com.fujitsu.fla.upnp.http.HTTPServerList;
import com.fujitsu.fla.upnp.ssdp.SSDPNotifySocketList;
import com.fujitsu.fla.upnp.ssdp.SSDPPacket;
import com.fujitsu.fla.upnp.ssdp.SSDPSearchRequest;
import com.fujitsu.fla.upnp.ssdp.SSDPSearchResponseSocketList;
import com.fujitsu.fla.upnp.util.HostInterface;
import com.fujitsu.fla.upnp.util.ListenerList;
import com.fujitsu.fla.upnp.util.Mutex;
import com.fujitsu.fla.upnp.xml.Node;
import com.fujitsu.fla.upnp.xml.NodeList;
import com.fujitsu.fla.upnp.xml.Parser;
import com.fujitsu.fla.upnp.xml.ParserException;
import java.net.URL;
import java.util.Vector;

public class ControlPoint
implements HTTPRequestListener {
    private static final int DEFAULT_EVENTSUB_PORT = 8058;
    private static final int DEFAULT_SSDP_PORT = 8008;
    private static final int DEFAULT_EXPIRED_DEVICE_MONITORING_INTERVAL = 60;
    private static final String DEFAULT_EVENTSUB_URI = "/evetSub";
    private SSDPNotifySocketList ssdpNotifySocketList;
    private SSDPSearchResponseSocketList ssdpSearchResponseSocketList;
    private Mutex mutex = new Mutex();
    private int searchMx = 3;
    private int ssdpPort = 0;
    private int httpPort = 0;
    private boolean nmprMode;
    private NodeList devNodeList = new NodeList();
    private String eventSubURI = "/evetSub";
    private Disposer deviceDisposer;
    private long expiredDeviceMonitoringInterval;
    private RenewSubscriber renewSubscriber;
    private ListenerList deviceNotifyListenerList = new ListenerList();
    private ListenerList deviceSearchResponseListenerList = new ListenerList();
    private ListenerList deviceChangeListenerList = new ListenerList();
    private HTTPServerList httpServerList = new HTTPServerList();
    private ListenerList eventListenerList = new ListenerList();
    private Vector inaccessibleURLs = new Vector();

    static {
        UPnP.initialize();
    }

    private SSDPNotifySocketList getSSDPNotifySocketList() {
        return this.ssdpNotifySocketList;
    }

    private SSDPSearchResponseSocketList getSSDPSearchResponseSocketList() {
        return this.ssdpSearchResponseSocketList;
    }

    public ControlPoint(int ssdpPort, int httpPort) {
        this.ssdpNotifySocketList = new SSDPNotifySocketList();
        this.ssdpSearchResponseSocketList = new SSDPSearchResponseSocketList();
        this.setSSDPPort(ssdpPort);
        this.setHTTPPort(httpPort);
        this.setDeviceDisposer(null);
        this.setExpiredDeviceMonitoringInterval(60L);
        this.setRenewSubscriber(null);
        this.setNMPRMode(false);
        this.setRenewSubscriber(null);
    }

    public ControlPoint() {
        this(8008, 8058);
    }

    public void finalize() {
        this.stop();
    }

    public void lock() {
        this.mutex.lock();
    }

    public void unlock() {
        this.mutex.unlock();
    }

    public int getSSDPPort() {
        return this.ssdpPort;
    }

    public void setSSDPPort(int port) {
        this.ssdpPort = port;
    }

    public int getHTTPPort() {
        return this.httpPort;
    }

    public void setHTTPPort(int port) {
        this.httpPort = port;
    }

    public void setNMPRMode(boolean flag) {
        this.nmprMode = flag;
    }

    public boolean isNMPRMode() {
        return this.nmprMode;
    }

    private void addDevice(Node rootNode) {
        this.devNodeList.add(rootNode);
    }

    private synchronized void addDevice(final SSDPPacket ssdpPacket) {
        if (!ssdpPacket.isRootDevice()) {
            return;
        }
        String usn = ssdpPacket.getUSN();
        String udn = USN.getUDN(usn);
        Device dev = this.getDevice(udn);
        if (dev != null) {
            dev.setSSDPPacket(ssdpPacket);
            return;
        }
        final String location = ssdpPacket.getLocation();
        if (this.inaccessibleURLs.contains(location)) {
            return;
        }
        new Thread("Parse and add device"){

            public void run() {
                try {
                    Parser parser = UPnP.getXMLParser();
                    Node rootNode = parser.parse(location);
                    Device rootDev = ControlPoint.this.getDevice(rootNode);
                    if (rootDev == null) {
                        return;
                    }
                    rootDev.setSSDPPacket(ssdpPacket);
                    ControlPoint.this.addDevice(rootNode);
                    ControlPoint.this.performAddDeviceListener(rootDev);
                }
                catch (ParserException e) {
                    ControlPoint.this.inaccessibleURLs.add(location);
                }
            }
        }.start();
    }

    private Device getDevice(Node rootNode) {
        if (rootNode == null) {
            return null;
        }
        Node devNode = rootNode.getNode("device");
        if (devNode == null) {
            return null;
        }
        return new Device(rootNode, devNode);
    }

    public DeviceList getDeviceList() {
        DeviceList devList = new DeviceList();
        int nRoots = this.devNodeList.size();
        int n = 0;
        while (n < nRoots) {
            Node rootNode = this.devNodeList.getNode(n);
            Device dev = this.getDevice(rootNode);
            if (dev != null) {
                devList.add(dev);
            }
            ++n;
        }
        return devList;
    }

    public Device getDevice(String name) {
        int nRoots = this.devNodeList.size();
        int n = 0;
        while (n < nRoots) {
            Node rootNode = this.devNodeList.getNode(n);
            Device dev = this.getDevice(rootNode);
            if (dev != null) {
                if (dev.isDevice(name)) {
                    return dev;
                }
                Device cdev = dev.getDevice(name);
                if (cdev != null) {
                    return cdev;
                }
            }
            ++n;
        }
        return null;
    }

    public Device getProxyDevice(URL url) {
        try {
            Parser parser = UPnP.getXMLParser();
            Node rootNode = parser.parse(url);
            if (rootNode == null) {
                return null;
            }
            Node deviceNode = rootNode.getNode("device");
            if (deviceNode == null) {
                return null;
            }
            Device dev = new Device(rootNode, deviceNode);
            dev.setLocation(url.toString());
            return dev;
        }
        catch (Exception e) {
            return null;
        }
    }

    public Device getProxyDevice(String u) {
        try {
            URL url = new URL(u);
            return this.getProxyDevice(url);
        }
        catch (Exception e) {
            return null;
        }
    }

    public boolean hasDevice(String name) {
        return this.getDevice(name) != null;
    }

    private void removeDevice(Node rootNode) {
        Device dev = this.getDevice(rootNode);
        if (dev != null && dev.isRootDevice()) {
            this.performRemoveDeviceListener(dev);
        }
        this.devNodeList.remove(rootNode);
    }

    private void removeDevice(Device dev) {
        if (dev == null) {
            return;
        }
        this.removeDevice(dev.getRootNode());
    }

    private void removeDevice(String name) {
        Device dev = this.getDevice(name);
        this.removeDevice(dev);
    }

    private void removeDevice(SSDPPacket packet) {
        if (!packet.isByeBye()) {
            return;
        }
        String usn = packet.getUSN();
        String udn = USN.getUDN(usn);
        this.removeDevice(udn);
    }

    public void removeExpiredDevices() {
        DeviceList devList = this.getDeviceList();
        int devCnt = devList.size();
        Device[] dev = new Device[devCnt];
        int n = 0;
        while (n < devCnt) {
            dev[n] = devList.getDevice(n);
            ++n;
        }
        n = 0;
        while (n < devCnt) {
            if (dev[n].isExpired()) {
                this.removeDevice(dev[n]);
            }
            ++n;
        }
    }

    public void setExpiredDeviceMonitoringInterval(long interval) {
        this.expiredDeviceMonitoringInterval = interval;
    }

    public long getExpiredDeviceMonitoringInterval() {
        return this.expiredDeviceMonitoringInterval;
    }

    public void setDeviceDisposer(Disposer disposer) {
        this.deviceDisposer = disposer;
    }

    public Disposer getDeviceDisposer() {
        return this.deviceDisposer;
    }

    public void addNotifyListener(NotifyListener listener) {
        this.deviceNotifyListenerList.add(listener);
    }

    public void removeNotifyListener(NotifyListener listener) {
        this.deviceNotifyListenerList.remove(listener);
    }

    public void performNotifyListener(SSDPPacket ssdpPacket) {
        int listenerSize = this.deviceNotifyListenerList.size();
        int n = 0;
        while (n < listenerSize) {
            NotifyListener listener = (NotifyListener)this.deviceNotifyListenerList.get(n);
            listener.deviceNotifyReceived(ssdpPacket);
            ++n;
        }
    }

    public void addSearchResponseListener(SearchResponseListener listener) {
        this.deviceSearchResponseListenerList.add(listener);
    }

    public void removeSearchResponseListener(SearchResponseListener listener) {
        this.deviceSearchResponseListenerList.remove(listener);
    }

    public void performSearchResponseListener(SSDPPacket ssdpPacket) {
        int listenerSize = this.deviceSearchResponseListenerList.size();
        int n = 0;
        while (n < listenerSize) {
            SearchResponseListener listener = (SearchResponseListener)this.deviceSearchResponseListenerList.get(n);
            listener.deviceSearchResponseReceived(ssdpPacket);
            ++n;
        }
    }

    public void addDeviceChangeListener(DeviceChangeListener listener) {
        this.deviceChangeListenerList.add(listener);
    }

    public void removeDeviceChangeListener(DeviceChangeListener listener) {
        this.deviceChangeListenerList.remove(listener);
    }

    public void performAddDeviceListener(Device dev) {
        int listenerSize = this.deviceChangeListenerList.size();
        int n = 0;
        while (n < listenerSize) {
            DeviceChangeListener listener = (DeviceChangeListener)this.deviceChangeListenerList.get(n);
            listener.deviceAdded(dev);
            ++n;
        }
    }

    public void performRemoveDeviceListener(Device dev) {
        int listenerSize = this.deviceChangeListenerList.size();
        int n = 0;
        while (n < listenerSize) {
            DeviceChangeListener listener = (DeviceChangeListener)this.deviceChangeListenerList.get(n);
            listener.deviceRemoved(dev);
            ++n;
        }
    }

    public void notifyReceived(SSDPPacket packet) {
        if (packet.isRootDevice()) {
            if (packet.isAlive()) {
                this.addDevice(packet);
            }
            if (packet.isByeBye()) {
                this.removeDevice(packet);
            }
        }
        this.performNotifyListener(packet);
    }

    public void searchResponseReceived(SSDPPacket packet) {
        if (packet.isRootDevice()) {
            this.addDevice(packet);
        }
        this.performSearchResponseListener(packet);
    }

    public int getSearchMx() {
        return this.searchMx;
    }

    public void setSearchMx(int mx) {
        this.searchMx = mx;
    }

    public void search(String target, int mx) {
        SSDPSearchRequest msReq = new SSDPSearchRequest(target, mx);
        SSDPSearchResponseSocketList ssdpSearchResponseSocketList = this.getSSDPSearchResponseSocketList();
        ssdpSearchResponseSocketList.post(msReq);
    }

    public void search(String target) {
        this.search(target, 3);
    }

    public void search() {
        this.search("upnp:rootdevice", 3);
    }

    private HTTPServerList getHTTPServerList() {
        return this.httpServerList;
    }

    public void httpRequestReceived(HTTPRequest httpReq) {
        if (httpReq.isNotifyRequest()) {
            NotifyRequest notifyReq = new NotifyRequest(httpReq);
            String uuid = notifyReq.getSID();
            long seq = notifyReq.getSEQ();
            PropertyList props = notifyReq.getPropertyList();
            int propCnt = props.size();
            int n = 0;
            while (n < propCnt) {
                Property prop = props.getProperty(n);
                String varName = prop.getName();
                String varValue = prop.getValue();
                this.performEventListener(uuid, seq, varName, varValue);
                ++n;
            }
            httpReq.returnOK();
            return;
        }
        httpReq.returnBadRequest();
    }

    public void addEventListener(EventListener listener) {
        this.eventListenerList.add(listener);
    }

    public void removeEventListener(EventListener listener) {
        this.eventListenerList.remove(listener);
    }

    public void performEventListener(String uuid, long seq, String name, String value) {
        int listenerSize = this.eventListenerList.size();
        int n = 0;
        while (n < listenerSize) {
            EventListener listener = (EventListener)this.eventListenerList.get(n);
            listener.eventNotifyReceived(uuid, seq, name, value);
            ++n;
        }
    }

    public String getEventSubURI() {
        return this.eventSubURI;
    }

    public void setEventSubURI(String url) {
        this.eventSubURI = url;
    }

    private String getEventSubCallbackURL(String host) {
        return HostInterface.getHostURL(host, this.getHTTPPort(), this.getEventSubURI());
    }

    public boolean subscribe(Service service, long timeout) {
        if (service.isSubscribed()) {
            String sid = service.getSID();
            return this.subscribe(service, sid, timeout);
        }
        Device rootDev = service.getRootDevice();
        if (rootDev == null) {
            return false;
        }
        String ifAddress = rootDev.getInterfaceAddress();
        SubscriptionRequest subReq = new SubscriptionRequest();
        subReq.setSubscribeRequest(service, this.getEventSubCallbackURL(ifAddress), timeout);
        SubscriptionResponse subRes = subReq.post();
        if (subRes.isSuccessful()) {
            service.setSID(subRes.getSID());
            service.setTimeout(subRes.getTimeout());
            return true;
        }
        service.clearSID();
        return false;
    }

    public boolean subscribe(Service service) {
        return this.subscribe(service, -1L);
    }

    public boolean subscribe(Service service, String uuid, long timeout) {
        SubscriptionRequest subReq = new SubscriptionRequest();
        subReq.setRenewRequest(service, uuid, timeout);
        SubscriptionResponse subRes = subReq.post();
        if (subRes.isSuccessful()) {
            service.setSID(subRes.getSID());
            service.setTimeout(subRes.getTimeout());
            return true;
        }
        service.clearSID();
        return false;
    }

    public boolean subscribe(Service service, String uuid) {
        return this.subscribe(service, uuid, -1L);
    }

    public boolean isSubscribed(Service service) {
        if (service == null) {
            return false;
        }
        return service.isSubscribed();
    }

    public boolean unsubscribe(Service service) {
        SubscriptionRequest subReq = new SubscriptionRequest();
        subReq.setUnsubscribeRequest(service);
        SubscriptionResponse subRes = subReq.post();
        if (subRes.isSuccessful()) {
            service.clearSID();
            return true;
        }
        return false;
    }

    public void unsubscribe(Device device) {
        ServiceList serviceList = device.getServiceList();
        int serviceCnt = serviceList.size();
        int n = 0;
        while (n < serviceCnt) {
            Service service = serviceList.getService(n);
            if (service.hasSID()) {
                this.unsubscribe(service);
            }
            ++n;
        }
        DeviceList childDevList = device.getDeviceList();
        int childDevCnt = childDevList.size();
        int n2 = 0;
        while (n2 < childDevCnt) {
            Device cdev = childDevList.getDevice(n2);
            this.unsubscribe(cdev);
            ++n2;
        }
    }

    public void unsubscribe() {
        DeviceList devList = this.getDeviceList();
        int devCnt = devList.size();
        int n = 0;
        while (n < devCnt) {
            Device dev = devList.getDevice(n);
            this.unsubscribe(dev);
            ++n;
        }
    }

    public Service getSubscriberService(String uuid) {
        DeviceList devList = this.getDeviceList();
        int devCnt = devList.size();
        int n = 0;
        while (n < devCnt) {
            Device dev = devList.getDevice(n);
            Service service = dev.getSubscriberService(uuid);
            if (service != null) {
                return service;
            }
            ++n;
        }
        return null;
    }

    public void renewSubscriberService(Device dev, long timeout) {
        ServiceList serviceList = dev.getServiceList();
        int serviceCnt = serviceList.size();
        int n = 0;
        while (n < serviceCnt) {
            String sid;
            boolean isRenewed;
            Service service = serviceList.getService(n);
            if (service.isSubscribed() && !(isRenewed = this.subscribe(service, sid = service.getSID(), timeout))) {
                this.subscribe(service, timeout);
            }
            ++n;
        }
        DeviceList cdevList = dev.getDeviceList();
        int cdevCnt = cdevList.size();
        int n2 = 0;
        while (n2 < cdevCnt) {
            Device cdev = cdevList.getDevice(n2);
            this.renewSubscriberService(cdev, timeout);
            ++n2;
        }
    }

    public void renewSubscriberService(long timeout) {
        DeviceList devList = this.getDeviceList();
        int devCnt = devList.size();
        int n = 0;
        while (n < devCnt) {
            Device dev = devList.getDevice(n);
            this.renewSubscriberService(dev, timeout);
            ++n;
        }
    }

    public void renewSubscriberService() {
        this.renewSubscriberService(-1L);
    }

    public void setRenewSubscriber(RenewSubscriber sub) {
        this.renewSubscriber = sub;
    }

    public RenewSubscriber getRenewSubscriber() {
        return this.renewSubscriber;
    }

    public boolean start(String target, int mx) {
        this.stop();
        int retryCnt = 0;
        int bindPort = this.getHTTPPort();
        HTTPServerList httpServerList = this.getHTTPServerList();
        while (!httpServerList.open(bindPort)) {
            if (100 < ++retryCnt) {
                return false;
            }
            this.setHTTPPort(bindPort + 1);
            bindPort = this.getHTTPPort();
        }
        httpServerList.addRequestListener(this);
        httpServerList.start();
        SSDPNotifySocketList ssdpNotifySocketList = this.getSSDPNotifySocketList();
        if (!ssdpNotifySocketList.open()) {
            return false;
        }
        ssdpNotifySocketList.setControlPoint(this);
        ssdpNotifySocketList.start();
        int ssdpPort = this.getSSDPPort();
        retryCnt = 0;
        SSDPSearchResponseSocketList ssdpSearchResponseSocketList = this.getSSDPSearchResponseSocketList();
        while (!ssdpSearchResponseSocketList.open(ssdpPort)) {
            if (100 < ++retryCnt) {
                return false;
            }
            this.setSSDPPort(ssdpPort + 1);
            ssdpPort = this.getSSDPPort();
        }
        ssdpSearchResponseSocketList.setControlPoint(this);
        ssdpSearchResponseSocketList.start();
        this.search(target, mx);
        Disposer disposer = new Disposer(this);
        this.setDeviceDisposer(disposer);
        disposer.start();
        if (this.isNMPRMode()) {
            RenewSubscriber renewSub = new RenewSubscriber(this);
            this.setRenewSubscriber(renewSub);
            renewSub.start();
        }
        return true;
    }

    public boolean start(String target) {
        return this.start(target, 3);
    }

    public boolean start() {
        return this.start("upnp:rootdevice", 3);
    }

    public boolean stop() {
        RenewSubscriber renewSub;
        this.unsubscribe();
        SSDPNotifySocketList ssdpNotifySocketList = this.getSSDPNotifySocketList();
        ssdpNotifySocketList.stop();
        ssdpNotifySocketList.close();
        ssdpNotifySocketList.clear();
        SSDPSearchResponseSocketList ssdpSearchResponseSocketList = this.getSSDPSearchResponseSocketList();
        ssdpSearchResponseSocketList.stop();
        ssdpSearchResponseSocketList.close();
        ssdpSearchResponseSocketList.clear();
        HTTPServerList httpServerList = this.getHTTPServerList();
        httpServerList.stop();
        httpServerList.close();
        httpServerList.clear();
        Disposer disposer = this.getDeviceDisposer();
        if (disposer != null) {
            disposer.stop();
            this.setDeviceDisposer(null);
        }
        if ((renewSub = this.getRenewSubscriber()) != null) {
            renewSub.stop();
            this.setRenewSubscriber(null);
        }
        return true;
    }

    public void print() {
        DeviceList devList = this.getDeviceList();
        int devCnt = devList.size();
        System.err.println("Device Num = " + devCnt);
        int n = 0;
        while (n < devCnt) {
            Device dev = devList.getDevice(n);
            System.err.println("[" + n + "] " + dev.getFriendlyName() + ", " + dev.getLeaseTime() + ", " + dev.getElapsedTime());
            ++n;
        }
    }
}

