/*
 * Decompiled with CFR 0.152.
 */
package com.fujitsu.fla.upnp;

import com.fujitsu.fla.upnp.Action;
import com.fujitsu.fla.upnp.ActionList;
import com.fujitsu.fla.upnp.ArgumentList;
import com.fujitsu.fla.upnp.DeviceList;
import com.fujitsu.fla.upnp.Icon;
import com.fujitsu.fla.upnp.IconList;
import com.fujitsu.fla.upnp.Service;
import com.fujitsu.fla.upnp.ServiceList;
import com.fujitsu.fla.upnp.StateVariable;
import com.fujitsu.fla.upnp.UPnP;
import com.fujitsu.fla.upnp.control.ActionListener;
import com.fujitsu.fla.upnp.control.ActionRequest;
import com.fujitsu.fla.upnp.control.ActionResponse;
import com.fujitsu.fla.upnp.control.ControlRequest;
import com.fujitsu.fla.upnp.control.QueryListener;
import com.fujitsu.fla.upnp.control.QueryRequest;
import com.fujitsu.fla.upnp.device.Advertiser;
import com.fujitsu.fla.upnp.device.InvalidDescriptionException;
import com.fujitsu.fla.upnp.device.ST;
import com.fujitsu.fla.upnp.device.SearchListener;
import com.fujitsu.fla.upnp.event.Subscriber;
import com.fujitsu.fla.upnp.event.Subscription;
import com.fujitsu.fla.upnp.event.SubscriptionRequest;
import com.fujitsu.fla.upnp.event.SubscriptionResponse;
import com.fujitsu.fla.upnp.http.HTTPRequest;
import com.fujitsu.fla.upnp.http.HTTPRequestListener;
import com.fujitsu.fla.upnp.http.HTTPResponse;
import com.fujitsu.fla.upnp.http.HTTPServerList;
import com.fujitsu.fla.upnp.soap.SOAPResponse;
import com.fujitsu.fla.upnp.ssdp.SSDPNotifyRequest;
import com.fujitsu.fla.upnp.ssdp.SSDPNotifySocket;
import com.fujitsu.fla.upnp.ssdp.SSDPPacket;
import com.fujitsu.fla.upnp.ssdp.SSDPSearchResponse;
import com.fujitsu.fla.upnp.ssdp.SSDPSearchResponseSocket;
import com.fujitsu.fla.upnp.ssdp.SSDPSearchSocketList;
import com.fujitsu.fla.upnp.util.FileUtil;
import com.fujitsu.fla.upnp.util.HostInterface;
import com.fujitsu.fla.upnp.util.Mutex;
import com.fujitsu.fla.upnp.util.TimerUtil;
import com.fujitsu.fla.upnp.xml.DeviceData;
import com.fujitsu.fla.upnp.xml.Node;
import com.fujitsu.fla.upnp.xml.Parser;
import com.fujitsu.fla.upnp.xml.ParserException;
import java.io.File;
import java.net.URL;

public class Device
implements HTTPRequestListener,
SearchListener {
    public static final String ELEM_NAME = "device";
    public static final String UPNP_ROOTDEVICE = "upnp:rootdevice";
    public static final int DEFAULT_STARTUP_WAIT_TIME = 1000;
    public static final int DEFAULT_DISCOVERY_WAIT_TIME = 300;
    public static final int DEFAULT_LEASE_TIME = 1800;
    public static final int HTTP_DEFAULT_PORT = 4004;
    public static final String DEFAULT_DESCRIPTION_URI = "/description.xml";
    private Node rootNode;
    private Node deviceNode;
    private Mutex mutex = new Mutex();
    private boolean wirelessMode;
    private String devUUID;
    private static final String URLBASE_NAME = "URLBase";
    private static final String DEVICE_TYPE = "deviceType";
    private static final String FRIENDLY_NAME = "friendlyName";
    private static final String MANUFACTURE = "manufacture";
    private static final String MANUFACTURE_URL = "manufactureURL";
    private static final String MODEL_DESCRIPTION = "modelDescription";
    private static final String MODEL_NAME = "modelName";
    private static final String MODEL_NUMBER = "modelNumber";
    private static final String MODEL_URL = "modelURL";
    private static final String SERIAL_NUMBER = "serialNumber";
    private static final String UDN = "UDN";
    private static final String UPC = "UPC";
    private static final String presentationURL = "presentationURL";

    static {
        UPnP.initialize();
    }

    public Node getRootNode() {
        if (this.rootNode != null) {
            return this.rootNode;
        }
        if (this.deviceNode == null) {
            return null;
        }
        return this.deviceNode.getRootNode();
    }

    public Node getDeviceNode() {
        return this.deviceNode;
    }

    public void setRootNode(Node node) {
        this.rootNode = node;
    }

    public void setDeviceNode(Node node) {
        this.deviceNode = node;
    }

    public Device(Node root, Node device) {
        this.rootNode = root;
        this.deviceNode = device;
        this.setUUID(UPnP.createUUID());
        this.setWirelessMode(false);
    }

    public Device() {
        this(null, null);
    }

    public Device(Node device) {
        this(null, device);
    }

    public Device(File descriptionFile) throws InvalidDescriptionException {
        this(null, null);
        this.loadDescription(descriptionFile);
    }

    public Device(String descriptionFileName) throws InvalidDescriptionException {
        this(new File(descriptionFileName));
    }

    public void lock() {
        this.mutex.lock();
    }

    public void unlock() {
        this.mutex.unlock();
    }

    public void setNMPRMode(boolean flag) {
        Node devNode = this.getDeviceNode();
        if (devNode == null) {
            return;
        }
        if (flag) {
            devNode.setNode("INMPR03", "1.0");
            devNode.removeNode(URLBASE_NAME);
        } else {
            devNode.removeNode("INMPR03");
        }
    }

    public boolean isNMPRMode() {
        Node devNode = this.getDeviceNode();
        if (devNode == null) {
            return false;
        }
        return devNode.getNode("INMPR03") != null;
    }

    public void setWirelessMode(boolean flag) {
        this.wirelessMode = flag;
    }

    public boolean isWirelessMode() {
        return this.wirelessMode;
    }

    public int getSSDPAnnounceCount() {
        if (this.isNMPRMode() && this.isWirelessMode()) {
            return 4;
        }
        return 1;
    }

    private void setUUID(String uuid) {
        this.devUUID = uuid;
    }

    private String getUUID() {
        return this.devUUID;
    }

    private void updateUDN() {
        this.setUDN("uuid:" + this.getUUID());
    }

    public Device getRootDevice() {
        Node rootNode = this.getRootNode();
        if (rootNode == null) {
            return null;
        }
        Node devNode = rootNode.getNode(ELEM_NAME);
        if (devNode == null) {
            return null;
        }
        return new Device(rootNode, devNode);
    }

    public Device getParentDevice() {
        if (this.isRootDevice()) {
            return null;
        }
        Node devNode = this.getDeviceNode();
        devNode = devNode.getParentNode().getParentNode().getNode(ELEM_NAME);
        return new Device(devNode);
    }

    private DeviceData getDeviceData() {
        Node node = this.getDeviceNode();
        DeviceData userData = (DeviceData)node.getUserData();
        if (userData == null) {
            userData = new DeviceData();
            node.setUserData(userData);
            userData.setNode(node);
        }
        return userData;
    }

    private void setDescriptionFile(File file) {
        this.getDeviceData().setDescriptionFile(file);
    }

    public File getDescriptionFile() {
        return this.getDeviceData().getDescriptionFile();
    }

    private void setDescriptionURI(String uri) {
        this.getDeviceData().setDescriptionURI(uri);
    }

    private String getDescriptionURI() {
        return this.getDeviceData().getDescriptionURI();
    }

    private boolean isDescriptionURI(String uri) {
        String descriptionURI = this.getDescriptionURI();
        if (uri == null || descriptionURI == null) {
            return false;
        }
        return descriptionURI.equals(uri);
    }

    public String getDescriptionFilePath() {
        File descriptionFile = this.getDescriptionFile();
        if (descriptionFile == null) {
            return "";
        }
        return descriptionFile.getAbsoluteFile().getParent();
    }

    public boolean loadDescription(File file) throws InvalidDescriptionException {
        try {
            Parser parser = UPnP.getXMLParser();
            this.rootNode = parser.parse(file);
            if (this.rootNode == null) {
                throw new InvalidDescriptionException("Couldn't find a root node", file);
            }
            this.deviceNode = this.rootNode.getNode(ELEM_NAME);
            if (this.deviceNode == null) {
                throw new InvalidDescriptionException("Couldn't find a root device node", file);
            }
        }
        catch (ParserException e) {
            throw new InvalidDescriptionException(e);
        }
        this.setDescriptionFile(file);
        this.setDescriptionURI(DEFAULT_DESCRIPTION_URI);
        this.setLeaseTime(1800);
        this.setHTTPPort(4004);
        if (!this.hasUDN()) {
            this.updateUDN();
        }
        return true;
    }

    public static boolean isDeviceNode(Node node) {
        return ELEM_NAME.equals(node.getName());
    }

    public boolean isRootDevice() {
        return this.getRootNode() != null;
    }

    public void setSSDPPacket(SSDPPacket packet) {
        this.getDeviceData().setSSDPPacket(packet);
    }

    public SSDPPacket getSSDPPacket() {
        if (!this.isRootDevice()) {
            return null;
        }
        return this.getDeviceData().getSSDPPacket();
    }

    public void setLocation(String value) {
        this.getDeviceData().setLocation(value);
    }

    public String getLocation() {
        SSDPPacket packet = this.getSSDPPacket();
        if (packet != null) {
            return packet.getLocation();
        }
        return this.getDeviceData().getLocation();
    }

    public void setLeaseTime(int value) {
        this.getDeviceData().setLeaseTime(value);
        Advertiser adv = this.getAdvertiser();
        if (adv != null) {
            this.announce();
            adv.restart();
        }
    }

    public int getLeaseTime() {
        SSDPPacket packet = this.getSSDPPacket();
        if (packet != null) {
            return packet.getLeaseTime();
        }
        return this.getDeviceData().getLeaseTime();
    }

    public long getTimeStamp() {
        SSDPPacket packet = this.getSSDPPacket();
        if (packet != null) {
            return packet.getTimeStamp();
        }
        return 0L;
    }

    public long getElapsedTime() {
        return (System.currentTimeMillis() - this.getTimeStamp()) / 1000L;
    }

    public boolean isExpired() {
        long elipsedTime = this.getElapsedTime();
        long leaseTime = this.getLeaseTime() + 60;
        return leaseTime < elipsedTime;
    }

    private void setURLBase(String value) {
        if (this.isRootDevice()) {
            Node node = this.getRootNode().getNode(URLBASE_NAME);
            if (node != null) {
                node.setValue(value);
                return;
            }
            node = new Node(URLBASE_NAME);
            node.setValue(value);
            int index = 1;
            if (!this.getRootNode().hasNodes()) {
                index = 1;
            }
            this.getRootNode().insertNode(node, index);
        }
    }

    private void updateURLBase(String host) {
        String urlBase = HostInterface.getHostURL(host, this.getHTTPPort(), "");
        this.setURLBase(urlBase);
    }

    public String getURLBase() {
        if (this.isRootDevice()) {
            String urlBase = this.getRootNode().getNodeValue(URLBASE_NAME);
            if (urlBase.length() == 0) {
                urlBase = this.getDeviceNode().getNodeValue(URLBASE_NAME);
            }
            return urlBase;
        }
        return "";
    }

    public void setDeviceType(String value) {
        this.getDeviceNode().setNode(DEVICE_TYPE, value);
    }

    public String getDeviceType() {
        return this.getDeviceNode().getNodeValue(DEVICE_TYPE);
    }

    public boolean isDeviceType(String value) {
        if (value == null) {
            return false;
        }
        return value.equals(this.getDeviceType());
    }

    public void setFriendlyName(String value) {
        this.getDeviceNode().setNode(FRIENDLY_NAME, value);
    }

    public String getFriendlyName() {
        return this.getDeviceNode().getNodeValue(FRIENDLY_NAME);
    }

    public void setManufacture(String value) {
        this.getDeviceNode().setNode(MANUFACTURE, value);
    }

    public String getManufacture() {
        return this.getDeviceNode().getNodeValue(MANUFACTURE);
    }

    public void setManufactureURL(String value) {
        this.getDeviceNode().setNode(MANUFACTURE_URL, value);
    }

    public String getManufactureURL() {
        return this.getDeviceNode().getNodeValue(MANUFACTURE_URL);
    }

    public void setModelDescription(String value) {
        this.getDeviceNode().setNode(MODEL_DESCRIPTION, value);
    }

    public String getModelDescription() {
        return this.getDeviceNode().getNodeValue(MODEL_DESCRIPTION);
    }

    public void setModelName(String value) {
        this.getDeviceNode().setNode(MODEL_NAME, value);
    }

    public String getModelName() {
        return this.getDeviceNode().getNodeValue(MODEL_NAME);
    }

    public void setModelNumber(String value) {
        this.getDeviceNode().setNode(MODEL_NUMBER, value);
    }

    public String getModelNumber() {
        return this.getDeviceNode().getNodeValue(MODEL_NUMBER);
    }

    public void setModelURL(String value) {
        this.getDeviceNode().setNode(MODEL_URL, value);
    }

    public String getModelURL() {
        return this.getDeviceNode().getNodeValue(MODEL_URL);
    }

    public void setSerialNumber(String value) {
        this.getDeviceNode().setNode(SERIAL_NUMBER, value);
    }

    public String getSerialNumber() {
        return this.getDeviceNode().getNodeValue(SERIAL_NUMBER);
    }

    public void setUDN(String value) {
        this.getDeviceNode().setNode(UDN, value);
    }

    public String getUDN() {
        return this.getDeviceNode().getNodeValue(UDN);
    }

    public boolean hasUDN() {
        String udn = this.getUDN();
        return udn != null && udn.length() > 0;
    }

    public void setUPC(String value) {
        this.getDeviceNode().setNode(UPC, value);
    }

    public String getUPC() {
        return this.getDeviceNode().getNodeValue(UPC);
    }

    public void setPresentationURL(String value) {
        this.getDeviceNode().setNode(presentationURL, value);
    }

    public String getPresentationURL() {
        return this.getDeviceNode().getNodeValue(presentationURL);
    }

    public DeviceList getDeviceList() {
        DeviceList devList = new DeviceList();
        Node devListNode = this.getDeviceNode().getNode("deviceList");
        if (devListNode == null) {
            return devList;
        }
        int nNode = devListNode.getNNodes();
        int n = 0;
        while (n < nNode) {
            Node node = devListNode.getNode(n);
            if (Device.isDeviceNode(node)) {
                Device dev = new Device(node);
                devList.add(dev);
            }
            ++n;
        }
        return devList;
    }

    public boolean isDevice(String name) {
        if (name == null) {
            return false;
        }
        if (name.endsWith(this.getUDN())) {
            return true;
        }
        if (name.equals(this.getFriendlyName())) {
            return true;
        }
        return name.endsWith(this.getDeviceType());
    }

    public Device getDevice(String name) {
        DeviceList devList = this.getDeviceList();
        int devCnt = devList.size();
        int n = 0;
        while (n < devCnt) {
            Device dev = devList.getDevice(n);
            if (dev.isDevice(name)) {
                return dev;
            }
            Device cdev = dev.getDevice(name);
            if (cdev != null) {
                return cdev;
            }
            ++n;
        }
        return null;
    }

    public ServiceList getServiceList() {
        ServiceList serviceList = new ServiceList();
        Node serviceListNode = this.getDeviceNode().getNode("serviceList");
        if (serviceListNode == null) {
            return serviceList;
        }
        int nNode = serviceListNode.getNNodes();
        int n = 0;
        while (n < nNode) {
            Node node = serviceListNode.getNode(n);
            if (Service.isServiceNode(node)) {
                Service service = new Service(node);
                serviceList.add(service);
            }
            ++n;
        }
        return serviceList;
    }

    public Service getService(String name) {
        ServiceList serviceList = this.getServiceList();
        int serviceCnt = serviceList.size();
        int n = 0;
        while (n < serviceCnt) {
            Service service = serviceList.getService(n);
            if (service.isService(name)) {
                return service;
            }
            ++n;
        }
        DeviceList devList = this.getDeviceList();
        int devCnt = devList.size();
        int n2 = 0;
        while (n2 < devCnt) {
            Device dev = devList.getDevice(n2);
            Service service = dev.getService(name);
            if (service != null) {
                return service;
            }
            ++n2;
        }
        return null;
    }

    public Service getServiceByControlURL(String searchUrl) {
        ServiceList serviceList = this.getServiceList();
        int serviceCnt = serviceList.size();
        int n = 0;
        while (n < serviceCnt) {
            Service service = serviceList.getService(n);
            if (service.isControlURL(searchUrl)) {
                return service;
            }
            ++n;
        }
        DeviceList devList = this.getDeviceList();
        int devCnt = devList.size();
        int n2 = 0;
        while (n2 < devCnt) {
            Device dev = devList.getDevice(n2);
            Service service = dev.getServiceByControlURL(searchUrl);
            if (service != null) {
                return service;
            }
            ++n2;
        }
        return null;
    }

    public Service getServiceByEventSubURL(String searchUrl) {
        ServiceList serviceList = this.getServiceList();
        int serviceCnt = serviceList.size();
        int n = 0;
        while (n < serviceCnt) {
            Service service = serviceList.getService(n);
            if (service.isEventSubURL(searchUrl)) {
                return service;
            }
            ++n;
        }
        DeviceList devList = this.getDeviceList();
        int devCnt = devList.size();
        int n2 = 0;
        while (n2 < devCnt) {
            Device dev = devList.getDevice(n2);
            Service service = dev.getServiceByEventSubURL(searchUrl);
            if (service != null) {
                return service;
            }
            ++n2;
        }
        return null;
    }

    public Service getSubscriberService(String uuid) {
        ServiceList serviceList = this.getServiceList();
        int serviceCnt = serviceList.size();
        int n = 0;
        while (n < serviceCnt) {
            Service service = serviceList.getService(n);
            String sid = service.getSID();
            if (uuid.equals(sid)) {
                return service;
            }
            ++n;
        }
        DeviceList devList = this.getDeviceList();
        int devCnt = devList.size();
        int n2 = 0;
        while (n2 < devCnt) {
            Device dev = devList.getDevice(n2);
            Service service = dev.getSubscriberService(uuid);
            if (service != null) {
                return service;
            }
            ++n2;
        }
        return null;
    }

    public StateVariable getStateVariable(String serviceType, String name) {
        if (serviceType == null && name == null) {
            return null;
        }
        ServiceList serviceList = this.getServiceList();
        int serviceCnt = serviceList.size();
        int n = 0;
        while (n < serviceCnt) {
            StateVariable stateVar;
            Service service = serviceList.getService(n);
            if ((serviceType == null || service.getServiceType().equals(serviceType)) && (stateVar = service.getStateVariable(name)) != null) {
                return stateVar;
            }
            ++n;
        }
        DeviceList devList = this.getDeviceList();
        int devCnt = devList.size();
        int n2 = 0;
        while (n2 < devCnt) {
            Device dev = devList.getDevice(n2);
            StateVariable stateVar = dev.getStateVariable(serviceType, name);
            if (stateVar != null) {
                return stateVar;
            }
            ++n2;
        }
        return null;
    }

    public StateVariable getStateVariable(String name) {
        return this.getStateVariable(null, name);
    }

    public Action getAction(String name) {
        ServiceList serviceList = this.getServiceList();
        int serviceCnt = serviceList.size();
        int n = 0;
        while (n < serviceCnt) {
            Service service = serviceList.getService(n);
            ActionList actionList = service.getActionList();
            int actionCnt = actionList.size();
            int i = 0;
            while (i < actionCnt) {
                Action action = actionList.getAction(i);
                String actionName = action.getName();
                if (actionName != null && actionName.equals(name)) {
                    return action;
                }
                ++i;
            }
            ++n;
        }
        DeviceList devList = this.getDeviceList();
        int devCnt = devList.size();
        int n2 = 0;
        while (n2 < devCnt) {
            Device dev = devList.getDevice(n2);
            Action action = dev.getAction(name);
            if (action != null) {
                return action;
            }
            ++n2;
        }
        return null;
    }

    public IconList getIconList() {
        IconList iconList = new IconList();
        Node iconListNode = this.getDeviceNode().getNode("iconList");
        if (iconListNode == null) {
            return iconList;
        }
        int nNode = iconListNode.getNNodes();
        int n = 0;
        while (n < nNode) {
            Node node = iconListNode.getNode(n);
            if (Icon.isIconNode(node)) {
                Icon icon = new Icon(node);
                iconList.add(icon);
            }
            ++n;
        }
        return iconList;
    }

    public Icon getIcon(int n) {
        IconList iconList = this.getIconList();
        if (n < 0 && iconList.size() - 1 < n) {
            return null;
        }
        return iconList.getIcon(n);
    }

    public String getLocationURL(String host) {
        return HostInterface.getHostURL(host, this.getHTTPPort(), this.getDescriptionURI());
    }

    private String getNotifyDeviceNT() {
        if (!this.isRootDevice()) {
            return this.getUDN();
        }
        return UPNP_ROOTDEVICE;
    }

    private String getNotifyDeviceUSN() {
        if (!this.isRootDevice()) {
            return this.getUDN();
        }
        return String.valueOf(this.getUDN()) + "::" + UPNP_ROOTDEVICE;
    }

    private String getNotifyDeviceTypeNT() {
        return this.getDeviceType();
    }

    private String getNotifyDeviceTypeUSN() {
        return String.valueOf(this.getUDN()) + "::" + this.getDeviceType();
    }

    public static final void notifyWait() {
        TimerUtil.waitRandom(300);
    }

    public void announce(String bindAddr) {
        String devUSN;
        String devNT;
        String devLocation = this.getLocationURL(bindAddr);
        SSDPNotifySocket ssdpSock = new SSDPNotifySocket(bindAddr);
        SSDPNotifyRequest ssdpReq = new SSDPNotifyRequest();
        ssdpReq.setServer(UPnP.getServerName());
        ssdpReq.setLeaseTime(this.getLeaseTime());
        ssdpReq.setLocation(devLocation);
        ssdpReq.setNTS("ssdp:alive");
        if (this.isRootDevice()) {
            devNT = this.getNotifyDeviceNT();
            devUSN = this.getNotifyDeviceUSN();
            ssdpReq.setNT(devNT);
            ssdpReq.setUSN(devUSN);
            ssdpSock.post(ssdpReq);
        }
        devNT = this.getNotifyDeviceTypeNT();
        devUSN = this.getNotifyDeviceTypeUSN();
        ssdpReq.setNT(devNT);
        ssdpReq.setUSN(devUSN);
        ssdpSock.post(ssdpReq);
        ServiceList serviceList = this.getServiceList();
        int serviceCnt = serviceList.size();
        int n = 0;
        while (n < serviceCnt) {
            Service service = serviceList.getService(n);
            service.announce(bindAddr);
            ++n;
        }
        DeviceList childDeviceList = this.getDeviceList();
        int childDeviceCnt = childDeviceList.size();
        int n2 = 0;
        while (n2 < childDeviceCnt) {
            Device childDevice = childDeviceList.getDevice(n2);
            childDevice.announce(bindAddr);
            ++n2;
        }
    }

    public void announce() {
        Device.notifyWait();
        int nHostAddrs = HostInterface.getNHostAddresses();
        int n = 0;
        while (n < nHostAddrs) {
            String bindAddr = HostInterface.getHostAddress(n);
            if (bindAddr != null && bindAddr.length() > 0) {
                int ssdpCount = this.getSSDPAnnounceCount();
                int i = 0;
                while (i < ssdpCount) {
                    this.announce(bindAddr);
                    ++i;
                }
            }
            ++n;
        }
    }

    public void byebye(String bindAddr) {
        String devUSN;
        String devNT;
        SSDPNotifySocket ssdpSock = new SSDPNotifySocket(bindAddr);
        SSDPNotifyRequest ssdpReq = new SSDPNotifyRequest();
        ssdpReq.setNTS("ssdp:byebye");
        if (this.isRootDevice()) {
            devNT = this.getNotifyDeviceNT();
            devUSN = this.getNotifyDeviceUSN();
            ssdpReq.setNT(devNT);
            ssdpReq.setUSN(devUSN);
            ssdpSock.post(ssdpReq);
        }
        devNT = this.getNotifyDeviceTypeNT();
        devUSN = this.getNotifyDeviceTypeUSN();
        ssdpReq.setNT(devNT);
        ssdpReq.setUSN(devUSN);
        ssdpSock.post(ssdpReq);
        ServiceList serviceList = this.getServiceList();
        int serviceCnt = serviceList.size();
        int n = 0;
        while (n < serviceCnt) {
            Service service = serviceList.getService(n);
            service.byebye(bindAddr);
            ++n;
        }
        DeviceList childDeviceList = this.getDeviceList();
        int childDeviceCnt = childDeviceList.size();
        int n2 = 0;
        while (n2 < childDeviceCnt) {
            Device childDevice = childDeviceList.getDevice(n2);
            childDevice.byebye(bindAddr);
            ++n2;
        }
    }

    public void byebye() {
        int nHostAddrs = HostInterface.getNHostAddresses();
        int n = 0;
        while (n < nHostAddrs) {
            String bindAddr = HostInterface.getHostAddress(n);
            if (bindAddr != null && bindAddr.length() > 0) {
                int ssdpCount = this.getSSDPAnnounceCount();
                int i = 0;
                while (i < ssdpCount) {
                    this.byebye(bindAddr);
                    ++i;
                }
            }
            ++n;
        }
    }

    public boolean postSearchResponse(SSDPPacket ssdpPacket, String st, String usn) {
        String localAddr = ssdpPacket.getLocalAddress();
        Device rootDev = this.getRootDevice();
        String rootDevLocation = rootDev.getLocationURL(localAddr);
        SSDPSearchResponse ssdpRes = new SSDPSearchResponse();
        ssdpRes.setLeaseTime(this.getLeaseTime());
        ssdpRes.setDate();
        ssdpRes.setST(st);
        ssdpRes.setUSN(usn);
        ssdpRes.setLocation(rootDevLocation);
        ssdpRes.setMYNAME(this.getFriendlyName());
        int mx = ssdpPacket.getMX();
        TimerUtil.waitRandom(mx * 1000);
        String remoteAddr = ssdpPacket.getRemoteAddress();
        int remotePort = ssdpPacket.getRemotePort();
        SSDPSearchResponseSocket ssdpResSock = new SSDPSearchResponseSocket();
        int ssdpCount = this.getSSDPAnnounceCount();
        int i = 0;
        while (i < ssdpCount) {
            ssdpResSock.post(remoteAddr, remotePort, ssdpRes);
            ++i;
        }
        return true;
    }

    public void deviceSearchResponse(SSDPPacket ssdpPacket) {
        String devType;
        int n;
        String ssdpST = ssdpPacket.getST();
        if (ssdpST == null) {
            return;
        }
        boolean isRootDevice = this.isRootDevice();
        String devUSN = this.getUDN();
        if (isRootDevice) {
            devUSN = String.valueOf(devUSN) + "::upnp:rootdevice";
        }
        if (ST.isAllDevice(ssdpST)) {
            String devNT = this.getNotifyDeviceNT();
            int repeatCnt = isRootDevice ? 3 : 2;
            n = 0;
            while (n < repeatCnt) {
                this.postSearchResponse(ssdpPacket, devNT, devUSN);
                ++n;
            }
        } else if (ST.isRootDevice(ssdpST)) {
            if (isRootDevice) {
                this.postSearchResponse(ssdpPacket, UPNP_ROOTDEVICE, devUSN);
            }
        } else if (ST.isUUIDDevice(ssdpST)) {
            String devUDN = this.getUDN();
            if (ssdpST.equals(devUDN)) {
                this.postSearchResponse(ssdpPacket, devUDN, devUSN);
            }
        } else if (ST.isURNDevice(ssdpST) && ssdpST.equals(devType = this.getDeviceType())) {
            this.postSearchResponse(ssdpPacket, devType, devUSN);
        }
        ServiceList serviceList = this.getServiceList();
        int serviceCnt = serviceList.size();
        n = 0;
        while (n < serviceCnt) {
            Service service = serviceList.getService(n);
            service.serviceSearchResponse(ssdpPacket);
            ++n;
        }
        DeviceList childDeviceList = this.getDeviceList();
        int childDeviceCnt = childDeviceList.size();
        int n2 = 0;
        while (n2 < childDeviceCnt) {
            Device childDevice = childDeviceList.getDevice(n2);
            childDevice.deviceSearchResponse(ssdpPacket);
            ++n2;
        }
    }

    public void deviceSearchReceived(SSDPPacket ssdpPacket) {
        this.deviceSearchResponse(ssdpPacket);
    }

    public void setHTTPPort(int port) {
        this.getDeviceData().setHTTPPort(port);
    }

    public int getHTTPPort() {
        return this.getDeviceData().getHTTPPort();
    }

    public void httpRequestReceived(HTTPRequest httpReq) {
        if (httpReq.isGetRequest()) {
            this.httpGetRequestRecieved(httpReq);
            return;
        }
        if (httpReq.isPostRequest()) {
            this.httpPostRequestRecieved(httpReq);
            return;
        }
        if (httpReq.isSubscribeRequest() || httpReq.isUnsubscribeRequest()) {
            SubscriptionRequest subReq = new SubscriptionRequest(httpReq);
            this.deviceEventSubscriptionRecieved(subReq);
            return;
        }
        httpReq.returnBadRequest();
    }

    private synchronized byte[] getDescriptionData(String host) {
        Node rootNode;
        if (!this.isNMPRMode()) {
            this.updateURLBase(host);
        }
        if ((rootNode = this.getRootNode()) == null) {
            return new byte[0];
        }
        return rootNode.toString().getBytes();
    }

    private void httpGetRequestRecieved(HTTPRequest httpReq) {
        String uri = httpReq.getURI();
        if (uri == null) {
            httpReq.returnBadRequest();
            return;
        }
        String rootPath = this.getDescriptionFilePath();
        byte[] fileByte = new byte[]{};
        try {
            if (this.isDescriptionURI(uri)) {
                String localAddr = httpReq.getLocalAddress();
                fileByte = this.getDescriptionData(localAddr);
            } else {
                File docFile = new File(rootPath, uri);
                if (!docFile.exists()) {
                    httpReq.returnBadRequest();
                    return;
                }
                fileByte = FileUtil.load(docFile);
            }
        }
        catch (Exception e) {
            httpReq.returnBadRequest();
            return;
        }
        HTTPResponse httpRes = new HTTPResponse();
        if (FileUtil.isXMLFileName(uri)) {
            httpRes.setContentType("text/xml; charset=\"utf-8\"");
        }
        httpRes.setStatusCode(200);
        httpRes.setContent(fileByte);
        httpReq.post(httpRes);
    }

    private void httpPostRequestRecieved(HTTPRequest httpReq) {
        if (httpReq.isSOAPAction()) {
            this.soapActionRecieved(httpReq);
        }
    }

    private void soapBadActionRecieved(HTTPRequest soapReq) {
        SOAPResponse soapRes = new SOAPResponse();
        soapRes.setStatusCode(400);
        soapReq.post(soapRes);
    }

    private void soapActionRecieved(HTTPRequest soapReq) {
        String uri = soapReq.getURI();
        Service ctlService = this.getServiceByControlURL(uri);
        if (ctlService != null) {
            ActionRequest crlReq = new ActionRequest(soapReq);
            this.deviceControlRequestRecieved(crlReq, ctlService);
            return;
        }
        this.soapBadActionRecieved(soapReq);
    }

    private void deviceControlRequestRecieved(ControlRequest ctlReq, Service service) {
        if (ctlReq.isQueryControl()) {
            this.deviceQueryControlRecieved(new QueryRequest(ctlReq), service);
        } else {
            this.deviceActionControlRecieved(new ActionRequest(ctlReq), service);
        }
    }

    private void invalidActionControlRecieved(ControlRequest ctlReq) {
        ActionResponse actRes = new ActionResponse();
        actRes.setFaultResponse(401);
        ctlReq.post(actRes);
    }

    private void deviceActionControlRecieved(ActionRequest ctlReq, Service service) {
        String actionName = ctlReq.getActionName();
        Action action = service.getAction(actionName);
        if (action == null) {
            this.invalidActionControlRecieved(ctlReq);
            return;
        }
        ArgumentList actionArgList = action.getArgumentList();
        ArgumentList reqArgList = ctlReq.getArgumentList();
        actionArgList.set(reqArgList);
        if (!action.performActionListener(ctlReq)) {
            this.invalidActionControlRecieved(ctlReq);
        }
    }

    private void deviceQueryControlRecieved(QueryRequest ctlReq, Service service) {
        String varName = ctlReq.getVarName();
        if (!service.hasStateVariable(varName)) {
            this.invalidActionControlRecieved(ctlReq);
            return;
        }
        StateVariable stateVar = this.getStateVariable(varName);
        if (!stateVar.performQueryListener(ctlReq)) {
            this.invalidActionControlRecieved(ctlReq);
        }
    }

    private void upnpBadSubscriptionRecieved(SubscriptionRequest subReq, int code) {
        SubscriptionResponse subRes = new SubscriptionResponse();
        subRes.setErrorResponse(code);
        subReq.post(subRes);
    }

    private void deviceEventSubscriptionRecieved(SubscriptionRequest subReq) {
        String uri = subReq.getURI();
        Service service = this.getServiceByEventSubURL(uri);
        if (service == null) {
            subReq.returnBadRequest();
            return;
        }
        if (!subReq.hasCallback() && !subReq.hasSID()) {
            this.upnpBadSubscriptionRecieved(subReq, 412);
            return;
        }
        if (subReq.isUnsubscribeRequest()) {
            this.deviceEventUnsubscriptionRecieved(service, subReq);
            return;
        }
        if (subReq.hasCallback()) {
            this.deviceEventNewSubscriptionRecieved(service, subReq);
            return;
        }
        if (subReq.hasSID()) {
            this.deviceEventRenewSubscriptionRecieved(service, subReq);
            return;
        }
        this.upnpBadSubscriptionRecieved(subReq, 412);
    }

    private void deviceEventNewSubscriptionRecieved(Service service, SubscriptionRequest subReq) {
        String callback = subReq.getCallback();
        try {
            URL url = new URL(callback);
        }
        catch (Exception e) {
            this.upnpBadSubscriptionRecieved(subReq, 412);
            return;
        }
        long timeOut = subReq.getTimeout();
        String sid = Subscription.createSID();
        Subscriber sub = new Subscriber();
        sub.setDeliveryURL(callback);
        sub.setTimeOut(timeOut);
        sub.setSID(sid);
        service.addSubscriber(sub);
        SubscriptionResponse subRes = new SubscriptionResponse();
        subRes.setStatusCode(200);
        subRes.setSID(sid);
        subRes.setTimeout(timeOut);
        subReq.post(subRes);
        service.notifyAllStateVariables();
    }

    private void deviceEventRenewSubscriptionRecieved(Service service, SubscriptionRequest subReq) {
        String sid = subReq.getSID();
        Subscriber sub = service.getSubscriber(sid);
        if (sub == null) {
            this.upnpBadSubscriptionRecieved(subReq, 412);
            return;
        }
        long timeOut = subReq.getTimeout();
        sub.setTimeOut(timeOut);
        sub.renew();
        SubscriptionResponse subRes = new SubscriptionResponse();
        subRes.setStatusCode(200);
        subRes.setSID(sid);
        subRes.setTimeout(timeOut);
        subReq.post(subRes);
    }

    private void deviceEventUnsubscriptionRecieved(Service service, SubscriptionRequest subReq) {
        String sid = subReq.getSID();
        Subscriber sub = service.getSubscriber(sid);
        if (sub == null) {
            this.upnpBadSubscriptionRecieved(subReq, 412);
            return;
        }
        service.removeSubscriber(sub);
        SubscriptionResponse subRes = new SubscriptionResponse();
        subRes.setStatusCode(200);
        subReq.post(subRes);
    }

    private HTTPServerList getHTTPServerList() {
        return this.getDeviceData().getHTTPServerList();
    }

    private SSDPSearchSocketList getSSDPSearchSocketList() {
        return this.getDeviceData().getSSDPSearchSocketList();
    }

    private void setAdvertiser(Advertiser adv) {
        this.getDeviceData().setAdvertiser(adv);
    }

    private Advertiser getAdvertiser() {
        return this.getDeviceData().getAdvertiser();
    }

    public boolean start() {
        this.stop(true);
        int retryCnt = 0;
        int bindPort = this.getHTTPPort();
        HTTPServerList httpServerList = this.getHTTPServerList();
        while (!httpServerList.open(bindPort)) {
            if (100 < ++retryCnt) {
                return false;
            }
            this.setHTTPPort(bindPort + 1);
            bindPort = this.getHTTPPort();
        }
        httpServerList.addRequestListener(this);
        httpServerList.start();
        SSDPSearchSocketList ssdpSearchSockList = this.getSSDPSearchSocketList();
        if (!ssdpSearchSockList.open()) {
            return false;
        }
        ssdpSearchSockList.addSearchListener(this);
        ssdpSearchSockList.start();
        this.announce();
        Advertiser adv = new Advertiser(this);
        this.setAdvertiser(adv);
        adv.start();
        return true;
    }

    private boolean stop(boolean doByeBye) {
        if (doByeBye) {
            this.byebye();
        }
        HTTPServerList httpServerList = this.getHTTPServerList();
        httpServerList.stop();
        httpServerList.close();
        httpServerList.clear();
        SSDPSearchSocketList ssdpSearchSockList = this.getSSDPSearchSocketList();
        ssdpSearchSockList.stop();
        ssdpSearchSockList.close();
        ssdpSearchSockList.clear();
        Advertiser adv = this.getAdvertiser();
        if (adv != null) {
            adv.stop();
            this.setAdvertiser(null);
        }
        return true;
    }

    public boolean stop() {
        return this.stop(true);
    }

    public String getInterfaceAddress() {
        SSDPPacket ssdpPacket = this.getSSDPPacket();
        if (ssdpPacket == null) {
            return "";
        }
        return ssdpPacket.getLocalAddress();
    }

    public void setActionListener(ActionListener listener) {
        ServiceList serviceList = this.getServiceList();
        int nServices = serviceList.size();
        int n = 0;
        while (n < nServices) {
            Service service = serviceList.getService(n);
            service.setActionListener(listener);
            ++n;
        }
    }

    public void setQueryListener(QueryListener listener) {
        ServiceList serviceList = this.getServiceList();
        int nServices = serviceList.size();
        int n = 0;
        while (n < nServices) {
            Service service = serviceList.getService(n);
            service.setQueryListener(listener);
            ++n;
        }
    }
}

