/*
 * Decompiled with CFR 0.152.
 */
package com.fujitsu.fla.upnp;

import com.fujitsu.fla.upnp.soap.SOAP;
import com.fujitsu.fla.upnp.util.HostInterface;
import com.fujitsu.fla.upnp.xml.JaxpParser;
import com.fujitsu.fla.upnp.xml.Parser;

public class UPnP {
    public static final String NAME = "FLACP";
    public static final String VERSION = "1.0";
    public static final int SERVER_RETRY_COUNT = 100;
    public static final int DEFAULT_EXPIRED_DEVICE_EXTRA_TIME = 60;
    private static Parser xmlParser;
    public static final String INMPR03 = "INMPR03";
    public static final String INMPR03_VERSION = "1.0";
    public static final int INMPR03_DISCOVERY_OVER_WIRELESS_COUNT = 4;
    public static final int USE_LOOPBACK_ADDR = 2;

    static {
        UPnP.setXMLParser(new JaxpParser());
    }

    public static final String getServerName() {
        String osName = System.getProperty("os.name");
        String osVer = System.getProperty("os.version");
        return String.valueOf(osName) + "/" + osVer + " UPnP/1.0 " + NAME + "/" + "1.0";
    }

    public static final void setEnable(int value) {
        switch (value) {
            case 2: {
                HostInterface.USE_LOOPBACK_ADDR = true;
            }
        }
    }

    public static final void setDisable(int value) {
        switch (value) {
            case 2: {
                HostInterface.USE_LOOPBACK_ADDR = false;
            }
        }
    }

    public static final boolean isEnabled(int value) {
        switch (value) {
            case 2: {
                return HostInterface.USE_LOOPBACK_ADDR;
            }
        }
        return false;
    }

    private static final String toUUID(int seed) {
        String id = Integer.toString(seed & 0xFFFF, 16);
        int idLen = id.length();
        String uuid = "";
        int n = 0;
        while (n < 4 - idLen) {
            uuid = String.valueOf(uuid) + "0";
            ++n;
        }
        uuid = String.valueOf(uuid) + id;
        return uuid;
    }

    public static final String createUUID() {
        long time1 = System.currentTimeMillis();
        long time2 = (long)((double)System.currentTimeMillis() * Math.random());
        return String.valueOf(UPnP.toUUID((int)(time1 & 0xFFFFL))) + "-" + UPnP.toUUID((int)(time1 >> 32 | 0xA000L) & 0xFFFF) + "-" + UPnP.toUUID((int)(time2 & 0xFFFFL)) + "-" + UPnP.toUUID((int)(time2 >> 32 | 0xE000L) & 0xFFFF);
    }

    public static final void setXMLParser(Parser parser) {
        xmlParser = parser;
        SOAP.setXMLParser(parser);
    }

    public static final Parser getXMLParser() {
        return xmlParser;
    }

    public static final void initialize() {
    }
}

