/*
 * Decompiled with CFR 0.152.
 */
package com.fujitsu.fla.upnp.control;

import com.fujitsu.fla.upnp.Action;
import com.fujitsu.fla.upnp.Argument;
import com.fujitsu.fla.upnp.ArgumentList;
import com.fujitsu.fla.upnp.Service;
import com.fujitsu.fla.upnp.control.ActionResponse;
import com.fujitsu.fla.upnp.control.ControlRequest;
import com.fujitsu.fla.upnp.http.HTTPRequest;
import com.fujitsu.fla.upnp.soap.SOAP;
import com.fujitsu.fla.upnp.soap.SOAPResponse;
import com.fujitsu.fla.upnp.xml.Node;

public class ActionRequest
extends ControlRequest {
    public ActionRequest() {
    }

    public ActionRequest(HTTPRequest httpReq) {
        this.set(httpReq);
    }

    public Node getActionNode() {
        Node bodyNode = this.getBodyNode();
        if (bodyNode == null) {
            return null;
        }
        if (!bodyNode.hasNodes()) {
            return null;
        }
        return bodyNode.getNode(0);
    }

    public String getActionName() {
        Node node = this.getActionNode();
        if (node == null) {
            return "";
        }
        String name = node.getName();
        if (name == null) {
            return "";
        }
        int idx = name.indexOf(":") + 1;
        return name.substring(idx, name.length());
    }

    public ArgumentList getArgumentList() {
        Node actNode = this.getActionNode();
        int nArgNodes = actNode.getNNodes();
        ArgumentList argList = new ArgumentList();
        int n = 0;
        while (n < nArgNodes) {
            Argument arg = new Argument();
            Node argNode = actNode.getNode(n);
            arg.setName(argNode.getName());
            arg.setValue(argNode.getValue());
            argList.add(arg);
            ++n;
        }
        return argList;
    }

    public void setRequest(Action action, ArgumentList argList) {
        Service service = action.getService();
        this.setRequestHost(service);
        this.setEnvelopeNode(SOAP.createEnvelopeBodyNode());
        Node envNode = this.getEnvelopeNode();
        Node bodyNode = this.getBodyNode();
        Node argNode = this.createContentNode(service, action, argList);
        bodyNode.addNode(argNode);
        this.setContent(envNode);
        String serviceType = service.getServiceType();
        String actionName = action.getName();
        String soapAction = "\"" + serviceType + "#" + actionName + "\"";
        this.setSOAPAction(soapAction);
    }

    private Node createContentNode(Service service, Action action, ArgumentList argList) {
        String actionName = action.getName();
        String serviceType = service.getServiceType();
        Node actionNode = new Node();
        actionNode.setName("u", actionName);
        actionNode.setNameSpace("u", serviceType);
        int argListCnt = argList.size();
        int n = 0;
        while (n < argListCnt) {
            Argument arg = argList.getArgument(n);
            Node argNode = new Node();
            argNode.setName(arg.getName());
            argNode.setValue(arg.getValue());
            actionNode.addNode(argNode);
            ++n;
        }
        return actionNode;
    }

    public ActionResponse post() {
        SOAPResponse soapRes = this.postMessage(this.getRequestHost(), this.getRequestPort());
        return new ActionResponse(soapRes);
    }
}

