/*
 * Decompiled with CFR 0.152.
 */
package com.fujitsu.fla.upnp.control;

import com.fujitsu.fla.upnp.Action;
import com.fujitsu.fla.upnp.Argument;
import com.fujitsu.fla.upnp.ArgumentList;
import com.fujitsu.fla.upnp.Service;
import com.fujitsu.fla.upnp.control.ControlResponse;
import com.fujitsu.fla.upnp.soap.SOAPResponse;
import com.fujitsu.fla.upnp.xml.Node;

public class ActionResponse
extends ControlResponse {
    public ActionResponse() {
        this.setHeader("EXT", "");
    }

    public ActionResponse(SOAPResponse soapRes) {
        super(soapRes);
        this.setHeader("EXT", "");
    }

    public void setResponse(Action action) {
        this.setStatusCode(200);
        Node bodyNode = this.getBodyNode();
        Node resNode = this.createResponseNode(action);
        bodyNode.addNode(resNode);
        Node envNode = this.getEnvelopeNode();
        this.setContent(envNode);
    }

    private Node createResponseNode(Action action) {
        String actionName = action.getName();
        Node actionNameResNode = new Node("u:" + actionName + "Response");
        Service service = action.getService();
        if (service != null) {
            actionNameResNode.setAttribute("xmlns:u", service.getServiceType());
        }
        ArgumentList argList = action.getArgumentList();
        int nArgs = argList.size();
        int n = 0;
        while (n < nArgs) {
            Argument arg = argList.getArgument(n);
            if (arg.isOutDirection()) {
                Node argNode = new Node();
                argNode.setName(arg.getName());
                argNode.setValue(arg.getValue());
                actionNameResNode.addNode(argNode);
            }
            ++n;
        }
        return actionNameResNode;
    }

    private Node getActionResponseNode() {
        Node bodyNode = this.getBodyNode();
        if (bodyNode == null || !bodyNode.hasNodes()) {
            return null;
        }
        return bodyNode.getNode(0);
    }

    public ArgumentList getResponse() {
        ArgumentList argList = new ArgumentList();
        Node resNode = this.getActionResponseNode();
        if (resNode == null) {
            return argList;
        }
        int nArgs = resNode.getNNodes();
        int n = 0;
        while (n < nArgs) {
            Node node = resNode.getNode(n);
            String name = node.getName();
            String value = node.getValue();
            Argument arg = new Argument(name, value);
            argList.add(arg);
            ++n;
        }
        return argList;
    }
}

