/*
 * Decompiled with CFR 0.152.
 */
package com.fujitsu.fla.upnp.event;

import java.net.URL;

public class Subscriber {
    private String SID = null;
    private String ifAddr = "";
    private String deliveryURL = "";
    private String deliveryHost = "";
    private String deliveryPath = "";
    private int deliveryPort = 0;
    private long timeOut = 0L;
    private long notifyCount = 0L;
    private long subscriptionTime = 0L;

    public Subscriber() {
        this.renew();
    }

    public String getSID() {
        return this.SID;
    }

    public void setSID(String sid) {
        this.SID = sid;
    }

    public void setInterfaceAddress(String addr) {
        this.ifAddr = addr;
    }

    public String getInterfaceAddress() {
        return this.ifAddr;
    }

    public String getDeliveryURL() {
        return this.deliveryURL;
    }

    public void setDeliveryURL(String deliveryURL) {
        this.deliveryURL = deliveryURL;
        try {
            URL url = new URL(deliveryURL);
            this.deliveryHost = url.getHost();
            this.deliveryPath = url.getPath();
            this.deliveryPort = url.getPort();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public String getDeliveryHost() {
        return this.deliveryHost;
    }

    public String getDeliveryPath() {
        return this.deliveryPath;
    }

    public int getDeliveryPort() {
        return this.deliveryPort;
    }

    public long getTimeOut() {
        return this.timeOut;
    }

    public void setTimeOut(long value) {
        this.timeOut = value;
    }

    public boolean isExpired() {
        long currTime = System.currentTimeMillis();
        if (this.timeOut == -1L) {
            return false;
        }
        long expiredTime = this.getSubscriptionTime() + this.getTimeOut() * 1000L;
        return expiredTime < currTime;
    }

    public long getSubscriptionTime() {
        return this.subscriptionTime;
    }

    public void setSubscriptionTime(long time) {
        this.subscriptionTime = time;
    }

    public long getNotifyCount() {
        return this.notifyCount;
    }

    public void setNotifyCount(int cnt) {
        this.notifyCount = cnt;
    }

    public void incrementNotifyCount() {
        if (this.notifyCount == Long.MAX_VALUE) {
            this.notifyCount = 1L;
            return;
        }
        ++this.notifyCount;
    }

    public void renew() {
        this.setSubscriptionTime(System.currentTimeMillis());
        this.setNotifyCount(0);
    }
}

