/*
 * Decompiled with CFR 0.152.
 */
package com.fujitsu.fla.upnp.http;

import com.fujitsu.fla.upnp.http.HTTPRequest;
import com.fujitsu.fla.upnp.http.HTTPRequestListener;
import com.fujitsu.fla.upnp.http.HTTPServerThread;
import com.fujitsu.fla.upnp.util.ListenerList;
import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.Iterator;

public class HTTPServer
implements Runnable {
    public static final String NAME = "FLAMiniHTTP";
    public static final String VERSION = "1.0";
    public static final int DEFAULT_PORT = 80;
    protected ServerSocket serverSock = null;
    protected InetAddress bindAddr = null;
    protected int bindPort = 0;
    protected ListenerList requestListener = new ListenerList();
    protected Thread httpServerThread = null;

    public static String getName() {
        String osName = System.getProperty("os.name");
        String osVer = System.getProperty("os.version");
        return String.valueOf(osName) + "/" + osVer + " " + NAME + "/" + VERSION;
    }

    public void run() {
        if (!this.isOpened()) {
            return;
        }
        Thread thisThread = Thread.currentThread();
        while (this.httpServerThread == thisThread) {
            Socket sock;
            Thread.yield();
            try {
                sock = this.accept();
            }
            catch (Exception e) {
                break;
            }
            HTTPServerThread httpServThread = new HTTPServerThread(this, sock);
            httpServThread.start();
        }
    }

    public boolean start() {
        this.httpServerThread = new Thread(this);
        this.httpServerThread.start();
        return true;
    }

    public boolean stop() {
        this.httpServerThread = null;
        return true;
    }

    public ServerSocket getServerSock() {
        return this.serverSock;
    }

    public String getBindAddr() {
        if (this.bindAddr == null) {
            return "";
        }
        return this.bindAddr.toString();
    }

    public int getBindPort() {
        return this.bindPort;
    }

    public boolean open(String addr, int port) {
        if (this.serverSock != null) {
            return true;
        }
        try {
            this.bindAddr = InetAddress.getByName(addr);
            this.bindPort = port;
            this.serverSock = new ServerSocket(this.bindPort, 0, this.bindAddr);
        }
        catch (IOException e) {
            return false;
        }
        return true;
    }

    public boolean close() {
        if (this.serverSock == null) {
            return true;
        }
        try {
            this.serverSock.close();
            this.serverSock = null;
            this.bindAddr = null;
            this.bindPort = 0;
        }
        catch (IOException e) {
            return false;
        }
        return true;
    }

    public Socket accept() {
        if (this.serverSock == null) {
            return null;
        }
        try {
            Socket sock = this.serverSock.accept();
            sock.setSoTimeout(60000);
            return sock;
        }
        catch (IOException e) {
            return null;
        }
    }

    public boolean isOpened() {
        return this.serverSock != null;
    }

    public void addRequestListener(HTTPRequestListener l) {
        this.requestListener.add(l);
    }

    public void removeRequestListener(HTTPRequestListener l) {
        this.requestListener.remove(l);
    }

    public void performRequest(HTTPRequest req) {
        Iterator iter = this.requestListener.iterator();
        while (iter.hasNext()) {
            HTTPRequestListener listener = (HTTPRequestListener)iter.next();
            listener.httpRequestReceived(req);
        }
    }

    public static void main(String[] args) {
        System.out.println("Web Server start at port 8080");
        HTTPServer server = new HTTPServer();
        server.open("localhost", 8080);
        server.start();
    }
}

