/*
 * Decompiled with CFR 0.152.
 */
package com.fujitsu.fla.upnp.ssdp;

import com.fujitsu.fla.upnp.http.HTTPRequest;
import com.fujitsu.fla.upnp.ssdp.SSDPPacket;
import java.net.DatagramPacket;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.MulticastSocket;
import java.net.NetworkInterface;
import java.util.Enumeration;

public class HTTPMUSocket {
    private InetSocketAddress ssdpMultiGroup = null;
    private MulticastSocket ssdpMultiSock = null;
    private NetworkInterface ssdpMultiIf = null;

    public HTTPMUSocket() {
    }

    public HTTPMUSocket(String addr, int port, String bindAddr) {
        this.open(addr, port, bindAddr);
    }

    protected void finalize() {
        this.close();
    }

    public String getLocalAddress() {
        InetAddress mcastAddr = this.ssdpMultiGroup.getAddress();
        Enumeration<InetAddress> addrs = this.ssdpMultiIf.getInetAddresses();
        while (addrs.hasMoreElements()) {
            InetAddress addr = addrs.nextElement();
            if (mcastAddr instanceof Inet6Address && addr instanceof Inet6Address) {
                return addr.getHostAddress();
            }
            if (!(mcastAddr instanceof Inet4Address) || !(addr instanceof Inet4Address)) continue;
            return addr.getHostAddress();
        }
        return "";
    }

    public InetAddress getMulticastInetAddress() {
        return this.ssdpMultiGroup.getAddress();
    }

    public String getMulticastAddress() {
        return this.getMulticastInetAddress().getHostAddress();
    }

    public boolean open(String addr, int port, String bindAddr) {
        try {
            this.ssdpMultiSock = new MulticastSocket(null);
            this.ssdpMultiSock.setReuseAddress(true);
            InetSocketAddress bindSockAddr = new InetSocketAddress(port);
            this.ssdpMultiSock.bind(bindSockAddr);
            this.ssdpMultiGroup = new InetSocketAddress(InetAddress.getByName(addr), port);
            this.ssdpMultiIf = NetworkInterface.getByInetAddress(InetAddress.getByName(bindAddr));
            this.ssdpMultiSock.joinGroup(this.ssdpMultiGroup, this.ssdpMultiIf);
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public boolean close() {
        if (this.ssdpMultiSock == null) {
            return true;
        }
        try {
            this.ssdpMultiSock.leaveGroup(this.ssdpMultiGroup, this.ssdpMultiIf);
            this.ssdpMultiSock = null;
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public boolean send(String msg, String bindAddr, int bindPort) {
        try {
            MulticastSocket msock;
            if (bindAddr != null && bindPort > 0) {
                msock = new MulticastSocket(null);
                msock.bind(new InetSocketAddress(bindAddr, bindPort));
            } else {
                msock = new MulticastSocket();
            }
            DatagramPacket dgmPacket = new DatagramPacket(msg.getBytes(), msg.length(), this.ssdpMultiGroup);
            msock.setTimeToLive(4);
            msock.send(dgmPacket);
            msock.close();
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public boolean send(String msg) {
        return this.send(msg, null, -1);
    }

    public boolean post(HTTPRequest req, String bindAddr, int bindPort) {
        return this.send(req.toString(), bindAddr, bindPort);
    }

    public boolean post(HTTPRequest req) {
        return this.send(req.toString(), null, -1);
    }

    public SSDPPacket receive() {
        byte[] ssdvRecvBuf = new byte[1024];
        SSDPPacket recvPacket = new SSDPPacket(ssdvRecvBuf, ssdvRecvBuf.length);
        recvPacket.setLocalAddress(this.getLocalAddress());
        try {
            this.ssdpMultiSock.receive(recvPacket.getDatagramPacket());
            recvPacket.setTimeStamp(System.currentTimeMillis());
        }
        catch (Exception exception) {
            // empty catch block
        }
        return recvPacket;
    }
}

