/*
 * Decompiled with CFR 0.152.
 */
package com.fujitsu.fla.upnp.ssdp;

import com.fujitsu.fla.upnp.ControlPoint;
import com.fujitsu.fla.upnp.ssdp.HTTPUSocket;
import com.fujitsu.fla.upnp.ssdp.SSDPPacket;
import com.fujitsu.fla.upnp.ssdp.SSDPSearchRequest;
import com.fujitsu.fla.upnp.ssdp.SSDPSearchResponse;

public class SSDPSearchResponseSocket
extends HTTPUSocket
implements Runnable {
    private ControlPoint controlPoint = null;
    private Thread deviceSearchResponseThread = null;

    public SSDPSearchResponseSocket() {
        this.setControlPoint(null);
    }

    public SSDPSearchResponseSocket(String bindAddr, int port) throws Exception {
        super(bindAddr, port);
        this.setControlPoint(null);
    }

    public void setControlPoint(ControlPoint ctrlp) {
        this.controlPoint = ctrlp;
    }

    public ControlPoint getControlPoint() {
        return this.controlPoint;
    }

    public void run() {
        Thread thisThread = Thread.currentThread();
        ControlPoint ctrlPoint = this.getControlPoint();
        while (this.deviceSearchResponseThread == thisThread) {
            Thread.yield();
            SSDPPacket packet = this.receive();
            if (packet == null) break;
            if (ctrlPoint == null) continue;
            ctrlPoint.searchResponseReceived(packet);
        }
    }

    public void start() {
        this.deviceSearchResponseThread = new Thread(this);
        this.deviceSearchResponseThread.start();
    }

    public void stop() {
        this.deviceSearchResponseThread = null;
    }

    public boolean post(String addr, int port, SSDPSearchResponse res) {
        return this.post(addr, port, res.getHeader());
    }

    public boolean post(String addr, int port, SSDPSearchRequest req) {
        return this.post(addr, port, req.toString());
    }
}

