/*
 * Decompiled with CFR 0.152.
 */
package com.fujitsu.fla.upnp.ssdp;

import com.fujitsu.fla.upnp.ControlPoint;
import com.fujitsu.fla.upnp.ssdp.SSDPSearchRequest;
import com.fujitsu.fla.upnp.ssdp.SSDPSearchResponseSocket;
import com.fujitsu.fla.upnp.util.HostInterface;
import java.util.Vector;

public class SSDPSearchResponseSocketList
extends Vector {
    public void setControlPoint(ControlPoint ctrlPoint) {
        int nSockets = this.size();
        int n = 0;
        while (n < nSockets) {
            SSDPSearchResponseSocket sock = this.getSSDPSearchResponseSocket(n);
            sock.setControlPoint(ctrlPoint);
            ++n;
        }
    }

    public SSDPSearchResponseSocket getSSDPSearchResponseSocket(int n) {
        return (SSDPSearchResponseSocket)this.get(n);
    }

    public boolean open(int port) {
        try {
            int nHostAddrs = HostInterface.getNHostAddresses();
            int n = 0;
            while (n < nHostAddrs) {
                String bindAddr = HostInterface.getHostAddress(n);
                SSDPSearchResponseSocket socket = new SSDPSearchResponseSocket(bindAddr, port);
                this.add(socket);
                ++n;
            }
        }
        catch (Exception e) {
            this.stop();
            this.close();
            this.clear();
            return false;
        }
        return true;
    }

    public boolean open() {
        return this.open(1900);
    }

    public void close() {
        int nSockets = this.size();
        int n = 0;
        while (n < nSockets) {
            SSDPSearchResponseSocket sock = this.getSSDPSearchResponseSocket(n);
            sock.close();
            ++n;
        }
        this.clear();
    }

    public void start() {
        int nSockets = this.size();
        int n = 0;
        while (n < nSockets) {
            SSDPSearchResponseSocket sock = this.getSSDPSearchResponseSocket(n);
            sock.start();
            ++n;
        }
    }

    public void stop() {
        int nSockets = this.size();
        int n = 0;
        while (n < nSockets) {
            SSDPSearchResponseSocket sock = this.getSSDPSearchResponseSocket(n);
            sock.stop();
            ++n;
        }
    }

    public boolean post(SSDPSearchRequest req) {
        boolean ret = true;
        int nSockets = this.size();
        int n = 0;
        while (n < nSockets) {
            SSDPSearchResponseSocket sock = this.getSSDPSearchResponseSocket(n);
            String bindAddr = sock.getLocalAddress();
            req.setLocalAddress(bindAddr);
            String ssdpAddr = "239.255.255.250";
            if (!sock.post(ssdpAddr, 1900, req)) {
                ret = false;
            }
            ++n;
        }
        return ret;
    }
}

