/*
 * Decompiled with CFR 0.152.
 */
package com.fujitsu.fla.upnp.ssdp;

import com.fujitsu.fla.upnp.device.SearchListener;
import com.fujitsu.fla.upnp.ssdp.HTTPMUSocket;
import com.fujitsu.fla.upnp.ssdp.SSDPPacket;
import com.fujitsu.fla.upnp.util.ListenerList;

public class SSDPSearchSocket
extends HTTPMUSocket
implements Runnable {
    private ListenerList deviceSearchListenerList = new ListenerList();
    private Thread deviceSearchThread = null;

    public SSDPSearchSocket() {
    }

    public SSDPSearchSocket(String bindAddr) {
        this.open(bindAddr);
    }

    public boolean open(String bindAddr) {
        String addr = "239.255.255.250";
        return this.open(addr, 1900, bindAddr);
    }

    public void addSearchListener(SearchListener listener) {
        this.deviceSearchListenerList.add(listener);
    }

    public void removeSearchListener(SearchListener listener) {
        this.deviceSearchListenerList.remove(listener);
    }

    public void performSearchListener(SSDPPacket ssdpPacket) {
        int listenerSize = this.deviceSearchListenerList.size();
        int n = 0;
        while (n < listenerSize) {
            SearchListener listener = (SearchListener)this.deviceSearchListenerList.get(n);
            listener.deviceSearchReceived(ssdpPacket);
            ++n;
        }
    }

    public void run() {
        Thread thisThread = Thread.currentThread();
        while (this.deviceSearchThread == thisThread) {
            Thread.yield();
            SSDPPacket packet = this.receive();
            if (!packet.isDiscover()) continue;
            this.performSearchListener(packet);
        }
    }

    public void start() {
        this.deviceSearchThread = new Thread(this);
        this.deviceSearchThread.start();
    }

    public void stop() {
        this.deviceSearchThread = null;
    }
}

