/*
 * Decompiled with CFR 0.152.
 */
package com.fujitsu.fla.upnp.test;

import com.fujitsu.fla.upnp.Action;
import com.fujitsu.fla.upnp.Argument;
import com.fujitsu.fla.upnp.ArgumentList;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class ActionDialog
extends JDialog
implements ActionListener {
    private Action action;
    private JButton okButton;
    private JButton cancelButton;
    private boolean result;
    private ArgumentList inArgList;
    private Vector inArgFieldList;

    public ActionDialog(Frame frame, Action action) {
        super(frame, true);
        this.getContentPane().setLayout(new BorderLayout());
        this.action = action;
        this.inArgList = new ArgumentList();
        this.inArgFieldList = new Vector();
        JPanel argListPane = new JPanel();
        argListPane.setLayout(new GridLayout(0, 2));
        this.getContentPane().add((Component)argListPane, "Center");
        ArgumentList argList = action.getArgumentList();
        int nArgs = argList.size();
        int n = 0;
        while (n < nArgs) {
            Argument arg = argList.getArgument(n);
            if (arg.isInDirection()) {
                JLabel argLabel = new JLabel(arg.getName());
                JTextField argField = new JTextField();
                this.inArgFieldList.add(argField);
                argListPane.add(argLabel);
                argListPane.add(argField);
                Argument inArg = new Argument();
                inArg.setName(arg.getName());
                this.inArgList.add(inArg);
            }
            ++n;
        }
        this.okButton = new JButton("OK");
        this.okButton.addActionListener(this);
        this.cancelButton = new JButton("Cancel");
        this.cancelButton.addActionListener(this);
        JPanel buttonPane = new JPanel();
        buttonPane.add(this.okButton);
        buttonPane.add(this.cancelButton);
        this.getContentPane().add((Component)buttonPane, "South");
        this.pack();
        Dimension size = this.getSize();
        Point fpos = frame.getLocationOnScreen();
        Dimension fsize = frame.getSize();
        this.setLocation(fpos.x + (fsize.width - size.width) / 2, fpos.y + (fsize.height - size.height) / 2);
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.okButton) {
            this.result = true;
            int fieldCnt = this.inArgFieldList.size();
            int n = 0;
            while (n < fieldCnt) {
                JTextField field = (JTextField)this.inArgFieldList.get(n);
                String value = field.getText();
                Argument arg = this.inArgList.getArgument(n);
                arg.setValue(value);
                ++n;
            }
            this.action.setArgumentValues(this.inArgList);
            this.dispose();
        }
        if (e.getSource() == this.cancelButton) {
            this.result = false;
            this.dispose();
        }
    }

    public boolean doModal() {
        this.show();
        return this.result;
    }
}

