/*
 * Decompiled with CFR 0.152.
 */
package com.fujitsu.fla.upnp.test;

import com.fujitsu.fla.upnp.ControlPoint;
import com.fujitsu.fla.upnp.device.NotifyListener;
import com.fujitsu.fla.upnp.device.SearchResponseListener;
import com.fujitsu.fla.upnp.event.EventListener;
import com.fujitsu.fla.upnp.ssdp.SSDPPacket;
import com.fujitsu.fla.upnp.test.CtrlPointPane;
import com.fujitsu.fla.upnp.test.MenuBar;
import com.fujitsu.fla.upnp.test.TreeComp;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import javax.swing.JFrame;

public class CtrlPoint
extends ControlPoint
implements NotifyListener,
EventListener,
SearchResponseListener {
    private static final String TITLE = "CyberLink Sample Control Point";
    public static int DEFAULT_WIDTH = 640;
    public static final int DEFAULT_HEIGHT = 480;
    private JFrame frame;
    private CtrlPointPane ctrlPointPane;
    private MenuBar menuBar;

    public CtrlPoint() {
        this.addNotifyListener(this);
        this.addSearchResponseListener(this);
        this.addEventListener(this);
        this.initFrame();
    }

    private void initFrame() {
        this.frame = new JFrame(TITLE);
        this.frame.getContentPane().setLayout(new BorderLayout());
        this.menuBar = new MenuBar(this);
        this.frame.setJMenuBar(this.menuBar);
        this.ctrlPointPane = new CtrlPointPane(this);
        this.getContentPane().add((Component)this.ctrlPointPane, "Center");
        this.frame.setSize(new Dimension(DEFAULT_WIDTH, 480));
        this.frame.setDefaultCloseOperation(3);
        this.frame.setVisible(true);
    }

    public JFrame getFrame() {
        return this.frame;
    }

    public Container getContentPane() {
        return this.getFrame().getContentPane();
    }

    public void printConsole(String msg) {
        this.ctrlPointPane.printConsole(msg);
    }

    public void clearConsole() {
        this.ctrlPointPane.clearConsole();
    }

    public void updateTreeComp() {
        TreeComp upnpTree = this.ctrlPointPane.getTreeComp();
        upnpTree.update(this);
    }

    public void deviceNotifyReceived(SSDPPacket packet) {
        System.out.println(packet.toString());
        if (packet.isDiscover()) {
            String st = packet.getST();
            this.printConsole("ssdp:discover : ST = " + st);
        } else if (packet.isAlive()) {
            String usn = packet.getUSN();
            String nt = packet.getNT();
            String url = packet.getLocation();
            this.printConsole("ssdp:alive : uuid = " + usn + ", NT = " + nt + ", location = " + url);
        } else if (packet.isByeBye()) {
            String usn = packet.getUSN();
            String nt = packet.getNT();
            this.printConsole("ssdp:byebye : uuid = " + usn + ", NT = " + nt);
        }
        this.updateTreeComp();
    }

    public void deviceSearchResponseReceived(SSDPPacket packet) {
        String uuid = packet.getUSN();
        String st = packet.getST();
        String url = packet.getLocation();
        this.printConsole("device search res : uuid = " + uuid + ", ST = " + st + ", location = " + url);
        this.updateTreeComp();
    }

    public void eventNotifyReceived(String uuid, long seq, String name, String value) {
        this.printConsole("event notify : uuid = " + uuid + ", seq = " + seq + ", name = " + name + ", value =" + value);
    }

    public static void main(String[] args) {
        CtrlPoint ctrlPoint = new CtrlPoint();
        ctrlPoint.start();
    }
}

