/*
 * Decompiled with CFR 0.152.
 */
package com.fujitsu.fla.upnp.test;

import com.fujitsu.fla.upnp.Action;
import com.fujitsu.fla.upnp.Argument;
import com.fujitsu.fla.upnp.Device;
import com.fujitsu.fla.upnp.Icon;
import com.fujitsu.fla.upnp.Service;
import com.fujitsu.fla.upnp.StateVariable;
import com.fujitsu.fla.upnp.test.ActionPane;
import com.fujitsu.fla.upnp.test.ArgumentTable;
import com.fujitsu.fla.upnp.test.CtrlPoint;
import com.fujitsu.fla.upnp.test.DeviceTable;
import com.fujitsu.fla.upnp.test.IconTable;
import com.fujitsu.fla.upnp.test.ServicePane;
import com.fujitsu.fla.upnp.test.StateVariablePane;
import com.fujitsu.fla.upnp.test.TableComp;
import com.fujitsu.fla.upnp.test.TreeComp;
import com.fujitsu.fla.upnp.test.TreeNode;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.tree.TreePath;

public class CtrlPointPane
extends JPanel
implements MouseListener {
    private CtrlPoint ctrlPoint;
    private JSplitPane devSplitPane;
    private JTextArea consoleArea;
    private JScrollPane consoleScrPane;
    private TreeComp deviceTree;

    public CtrlPointPane(CtrlPoint ctrlPoint) {
        this.setLayout(new BorderLayout());
        this.ctrlPoint = ctrlPoint;
        TreeNode root = new TreeNode("root");
        JSplitPane mainSplitPane = new JSplitPane(0, false);
        this.add((Component)mainSplitPane, "Center");
        this.devSplitPane = new JSplitPane(1, false);
        mainSplitPane.setTopComponent(this.devSplitPane);
        this.deviceTree = new TreeComp(root);
        this.deviceTree.addMouseListener(this);
        JScrollPane devScrPane = new JScrollPane(this.deviceTree);
        devScrPane.setPreferredSize(new Dimension(CtrlPoint.DEFAULT_WIDTH / 2, 360));
        this.devSplitPane.setLeftComponent(devScrPane);
        JPanel dummyPane = new JPanel();
        this.devSplitPane.setRightComponent(dummyPane);
        this.consoleArea = new JTextArea();
        this.consoleScrPane = new JScrollPane(this.consoleArea);
        mainSplitPane.setBottomComponent(this.consoleScrPane);
    }

    public Frame getFrame() {
        return this.ctrlPoint.getFrame();
    }

    private JSplitPane getDeviceSplitPane() {
        return this.devSplitPane;
    }

    public JTextArea getConsoleArea() {
        return this.consoleArea;
    }

    public void printConsole(String str) {
        this.consoleArea.append(String.valueOf(str) + "\n");
        JScrollBar scrBar = this.consoleScrPane.getVerticalScrollBar();
        int maxPos = scrBar.getMaximum();
        scrBar.setValue(maxPos);
    }

    public void clearConsole() {
        this.consoleArea.setText("");
    }

    public TreeComp getTreeComp() {
        return this.deviceTree;
    }

    public void mouseClicked(MouseEvent e) {
        if (e.getComponent() == this.getTreeComp()) {
            this.deviceTreeClicked(e);
        }
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mousePressed(MouseEvent e) {
    }

    public void mouseReleased(MouseEvent e) {
    }

    private void setRightComponent(Component comp) {
        JSplitPane spane = this.getDeviceSplitPane();
        Component newComp = comp;
        Component currComp = spane.getRightComponent();
        newComp.setSize(currComp.getSize());
        spane.setRightComponent(newComp);
    }

    public void deviceTreeClicked(MouseEvent e) {
        TreePath path = this.getTreeComp().getPathForLocation(e.getX(), e.getY());
        if (path == null) {
            return;
        }
        Object lastComp = path.getLastPathComponent();
        if (lastComp instanceof TreeNode) {
            TreeNode devTreeNode = (TreeNode)lastComp;
            Object data = devTreeNode.getUserData();
            if (data instanceof Device) {
                Device dev = (Device)data;
                DeviceTable devTable = new DeviceTable(dev);
                this.setRightComponent(new TableComp(devTable));
                return;
            }
            if (data instanceof Service) {
                Service service = (Service)data;
                ServicePane servicePane = new ServicePane(this.ctrlPoint, service);
                this.setRightComponent(servicePane);
                return;
            }
            if (data instanceof Icon) {
                Icon icon = (Icon)data;
                IconTable iconTable = new IconTable(icon);
                this.setRightComponent(new TableComp(iconTable));
                return;
            }
            if (data instanceof Action) {
                Action action = (Action)data;
                ActionPane actionPane = new ActionPane(this.ctrlPoint, action);
                this.setRightComponent(actionPane);
                return;
            }
            if (data instanceof Argument) {
                Argument arg = (Argument)data;
                ArgumentTable argTable = new ArgumentTable(arg);
                this.setRightComponent(new TableComp(argTable));
                return;
            }
            if (data instanceof StateVariable) {
                StateVariable state = (StateVariable)data;
                StateVariablePane servicePane = new StateVariablePane(this.ctrlPoint, state);
                this.setRightComponent(servicePane);
                return;
            }
        }
        this.getDeviceSplitPane().setRightComponent(new JPanel());
    }
}

