/*
 * Decompiled with CFR 0.152.
 */
package com.fujitsu.fla.upnp.test;

import com.fujitsu.fla.upnp.Action;
import com.fujitsu.fla.upnp.ActionList;
import com.fujitsu.fla.upnp.Argument;
import com.fujitsu.fla.upnp.ArgumentList;
import com.fujitsu.fla.upnp.ControlPoint;
import com.fujitsu.fla.upnp.Device;
import com.fujitsu.fla.upnp.Service;
import com.fujitsu.fla.upnp.ServiceList;
import com.fujitsu.fla.upnp.device.DeviceChangeListener;
import java.util.Hashtable;
import java.util.Iterator;

public class TestControlPoint
extends ControlPoint
implements DeviceChangeListener {
    protected Hashtable deviceList = new Hashtable();

    public static void main(String[] args) {
        TestControlPoint pt = new TestControlPoint();
        Device dev = pt.getProxyDevice("http://128.8.244.12:35001/");
        ServiceList slist = dev.getServiceList();
        Iterator iter = slist.iterator();
        while (iter.hasNext()) {
            Service service = (Service)iter.next();
            ActionList actionList = service.getActionList();
        }
        if (dev == null) {
            return;
        }
        Action act = dev.getAction("getStreamURL");
        if (act == null) {
            return;
        }
        int i = 0;
        while (i < act.getInputArgumentList().size()) {
            Argument arg = act.getInputArgumentList().getArgument(i);
            arg.setValue("");
            ++i;
        }
        boolean ret = act.postControlAction();
        if (!ret) {
            return;
        }
        System.out.println(act.getOutputArgumentList().getArgument(0).getValue());
    }

    public void deviceAdded(Device dev) {
        ServiceList sl = dev.getServiceList();
        Action act = dev.getAction("getDescriptionURL");
        boolean ret = act.postControlAction();
        if (ret) {
            ArgumentList list = act.getOutputArgumentList();
            String url = list.getArgument(0).getValue();
            String uuid = dev.getUDN();
            this.deviceList.put(uuid, url);
            System.out.println("Found new service: " + url);
            System.out.println("There are " + this.deviceList.size() + " services.");
        }
    }

    public void deviceRemoved(Device dev) {
        String uuid = dev.getUDN();
        if (this.deviceList.get(uuid) == null) {
            return;
        }
        String url = (String)this.deviceList.get(uuid);
        System.out.println("Remove services: " + url);
        this.deviceList.remove(uuid);
        System.out.println("There are " + this.deviceList.size() + " services.");
    }
}

