/*
 * Decompiled with CFR 0.152.
 */
package com.fujitsu.fla.upnp.test;

import com.fujitsu.fla.upnp.Action;
import com.fujitsu.fla.upnp.ActionList;
import com.fujitsu.fla.upnp.Argument;
import com.fujitsu.fla.upnp.ArgumentList;
import com.fujitsu.fla.upnp.ControlPoint;
import com.fujitsu.fla.upnp.Device;
import com.fujitsu.fla.upnp.DeviceList;
import com.fujitsu.fla.upnp.Icon;
import com.fujitsu.fla.upnp.IconList;
import com.fujitsu.fla.upnp.Service;
import com.fujitsu.fla.upnp.ServiceList;
import com.fujitsu.fla.upnp.ServiceStateTable;
import com.fujitsu.fla.upnp.StateVariable;
import com.fujitsu.fla.upnp.test.TreeNode;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeModel;

public class TreeComp
extends JTree {
    private TreeNode rootNode;

    public TreeComp(TreeNode root) {
        super(root);
        this.setRootNode(root);
    }

    public void setRootNode(TreeNode node) {
        this.rootNode = node;
    }

    public TreeNode getRootNode() {
        return this.rootNode;
    }

    void update(ControlPoint ctrlp) {
        TreeNode rootNode = this.getRootNode();
        if (rootNode == null) {
            return;
        }
        rootNode.removeAllChildren();
        DeviceList rootDevList = ctrlp.getDeviceList();
        this.updateDeviceList(rootNode, rootDevList);
        ((DefaultTreeModel)this.getModel()).reload();
        this.repaint();
    }

    void updateDeviceList(TreeNode parentNode, DeviceList devList) {
        int nDevs = devList.size();
        int n = 0;
        while (n < nDevs) {
            Device dev = devList.getDevice(n);
            String friendlyName = dev.getFriendlyName();
            TreeNode devNode = new TreeNode(friendlyName);
            devNode.setUserData(dev);
            parentNode.add(devNode);
            this.updateServiceList(devNode, dev);
            this.updateIconList(devNode, dev);
            this.updateDeviceList(devNode, dev.getDeviceList());
            ++n;
        }
    }

    void updateIconList(TreeNode parentNode, Device device) {
        IconList iconList = device.getIconList();
        int nIcons = iconList.size();
        int n = 0;
        while (n < nIcons) {
            Icon icon = iconList.getIcon(n);
            String url = icon.getURL();
            TreeNode iconNode = new TreeNode(url);
            iconNode.setUserData(icon);
            parentNode.add(iconNode);
            ++n;
        }
    }

    void updateServiceList(TreeNode parentNode, Device device) {
        ServiceList serviceList = device.getServiceList();
        int nServices = serviceList.size();
        int n = 0;
        while (n < nServices) {
            Service service = serviceList.getService(n);
            String serviceType = service.getServiceType();
            TreeNode serviceNode = new TreeNode(serviceType);
            serviceNode.setUserData(service);
            parentNode.add(serviceNode);
            this.updateActionList(serviceNode, service);
            this.updateStateVariableList(serviceNode, service);
            ++n;
        }
    }

    void updateActionList(TreeNode parentNode, Service service) {
        ActionList actionList = service.getActionList();
        int nActions = actionList.size();
        int n = 0;
        while (n < nActions) {
            Action action = actionList.getAction(n);
            String actionName = action.getName();
            TreeNode actionNode = new TreeNode(actionName);
            actionNode.setUserData(action);
            parentNode.add(actionNode);
            this.updateArgumentList(actionNode, action);
            ++n;
        }
    }

    void updateArgumentList(TreeNode parentNode, Action action) {
        ArgumentList argList = action.getArgumentList();
        int nArguments = argList.size();
        int n = 0;
        while (n < nArguments) {
            Argument arg = argList.getArgument(n);
            String argName = String.valueOf(arg.getName()) + "(" + arg.getDirection() + ")";
            TreeNode argNode = new TreeNode(argName);
            argNode.setUserData(arg);
            parentNode.add(argNode);
            ++n;
        }
    }

    void updateStateVariableList(TreeNode parentNode, Service service) {
        ServiceStateTable stateList = service.getServiceStateTable();
        int nStateVariables = stateList.size();
        int n = 0;
        while (n < nStateVariables) {
            StateVariable state = stateList.getStateVariable(n);
            String stateName = state.getName();
            TreeNode stateNode = new TreeNode(stateName);
            stateNode.setUserData(state);
            parentNode.add(stateNode);
            ++n;
        }
    }
}

