/*
 * Decompiled with CFR 0.152.
 */
package com.fujitsu.fla.upnp.util;

import java.net.InetAddress;
import java.net.NetworkInterface;
import java.util.Enumeration;

public class HostInterface {
    public static boolean USE_LOOPBACK_ADDR = false;
    private static String ifAddress = "";

    public static final void setInterface(String ifaddr) {
        ifAddress = ifaddr;
    }

    public static final String getInterface() {
        return ifAddress;
    }

    private static final boolean hasAssignedInterface() {
        return ifAddress.length() > 0;
    }

    private static final boolean isUsableAddress(InetAddress addr) {
        return USE_LOOPBACK_ADDR || !addr.isLoopbackAddress();
    }

    public static final int getNHostAddresses() {
        if (HostInterface.hasAssignedInterface()) {
            return 1;
        }
        int nHostAddrs = 0;
        try {
            Enumeration<NetworkInterface> nis = NetworkInterface.getNetworkInterfaces();
            while (nis.hasMoreElements()) {
                NetworkInterface ni = nis.nextElement();
                Enumeration<InetAddress> addrs = ni.getInetAddresses();
                while (addrs.hasMoreElements()) {
                    InetAddress addr = addrs.nextElement();
                    if (!HostInterface.isUsableAddress(addr)) continue;
                    ++nHostAddrs;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return nHostAddrs;
    }

    public static final String getHostAddress(int n) {
        if (HostInterface.hasAssignedInterface()) {
            return HostInterface.getInterface();
        }
        int hostAddrCnt = 0;
        try {
            Enumeration<NetworkInterface> nis = NetworkInterface.getNetworkInterfaces();
            while (nis.hasMoreElements()) {
                NetworkInterface ni = nis.nextElement();
                Enumeration<InetAddress> addrs = ni.getInetAddresses();
                while (addrs.hasMoreElements()) {
                    InetAddress addr = addrs.nextElement();
                    if (!HostInterface.isUsableAddress(addr)) continue;
                    if (hostAddrCnt < n) {
                        ++hostAddrCnt;
                        continue;
                    }
                    String host = addr.getHostAddress();
                    return host;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return "";
    }

    public static final String getIPv4Address() {
        int addrCnt = HostInterface.getNHostAddresses();
        int n = 0;
        if (n < addrCnt) {
            String addr = HostInterface.getHostAddress(n);
            return addr;
        }
        return "";
    }

    public static final String getHostURL(String host, int port, String uri) {
        return "http://" + host + ":" + Integer.toString(port) + uri;
    }
}

