/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.media.protocol;

import com.ibm.media.protocol.CloneableSourceStreamAdapter;
import com.ibm.media.protocol.SourceStreamSlave;
import java.io.IOException;
import java.util.Vector;
import javax.media.Time;
import javax.media.protocol.DataSource;
import javax.media.protocol.PullBufferDataSource;
import javax.media.protocol.PullDataSource;
import javax.media.protocol.PushBufferDataSource;
import javax.media.protocol.PushBufferStream;
import javax.media.protocol.PushDataSource;
import javax.media.protocol.PushSourceStream;
import javax.media.protocol.SourceStream;

class SuperCloneableDataSource
extends DataSource {
    protected DataSource input;
    public CloneableSourceStreamAdapter[] streamsAdapters;
    public SourceStream[] streams = null;
    private Vector clones = new Vector();

    SuperCloneableDataSource(DataSource dataSource) {
        this.input = dataSource;
        SourceStream[] sourceStreamArray = null;
        if (dataSource instanceof PullDataSource) {
            sourceStreamArray = ((PullDataSource)dataSource).getStreams();
        }
        if (dataSource instanceof PushDataSource) {
            sourceStreamArray = ((PushDataSource)dataSource).getStreams();
        }
        if (dataSource instanceof PullBufferDataSource) {
            sourceStreamArray = ((PullBufferDataSource)dataSource).getStreams();
        }
        if (dataSource instanceof PushBufferDataSource) {
            sourceStreamArray = ((PushBufferDataSource)dataSource).getStreams();
        }
        this.streamsAdapters = new CloneableSourceStreamAdapter[sourceStreamArray.length];
        int n2 = 0;
        while (n2 < sourceStreamArray.length) {
            this.streamsAdapters[n2] = new CloneableSourceStreamAdapter(sourceStreamArray[n2]);
            ++n2;
        }
    }

    DataSource createClone() {
        DataSource dataSource = this.input instanceof PullDataSource || this.input instanceof PushDataSource ? new PushDataSourceSlave() : new PushBufferDataSourceSlave();
        this.clones.addElement(dataSource);
        try {
            dataSource.connect();
        }
        catch (IOException iOException) {
            return null;
        }
        return dataSource;
    }

    public String getContentType() {
        return this.input.getContentType();
    }

    public void connect() throws IOException {
        this.input.connect();
    }

    public void disconnect() {
        this.input.disconnect();
    }

    public void start() throws IOException {
        this.input.start();
    }

    public void stop() throws IOException {
        this.input.stop();
    }

    public Object[] getControls() {
        return this.input.getControls();
    }

    public Object getControl(String string) {
        return this.input.getControl(string);
    }

    public Time getDuration() {
        return this.input.getDuration();
    }

    class PushBufferDataSourceSlave
    extends PushBufferDataSource {
        PushBufferStream[] streams = null;

        public PushBufferDataSourceSlave() {
            this.streams = new PushBufferStream[SuperCloneableDataSource.this.streamsAdapters.length];
            int n2 = 0;
            while (n2 < this.streams.length) {
                this.streams[n2] = (PushBufferStream)SuperCloneableDataSource.this.streamsAdapters[n2].createSlave();
                ++n2;
            }
        }

        public String getContentType() {
            return SuperCloneableDataSource.this.input.getContentType();
        }

        public void connect() throws IOException {
            int n2 = 0;
            while (n2 < this.streams.length) {
                ((SourceStreamSlave)((Object)this.streams[n2])).connect();
                ++n2;
            }
        }

        public void disconnect() {
            int n2 = 0;
            while (n2 < this.streams.length) {
                ((SourceStreamSlave)((Object)this.streams[n2])).disconnect();
                ++n2;
            }
        }

        public void start() throws IOException {
        }

        public void stop() throws IOException {
        }

        public PushBufferStream[] getStreams() {
            return this.streams;
        }

        public Object[] getControls() {
            return SuperCloneableDataSource.this.input.getControls();
        }

        public Object getControl(String string) {
            return SuperCloneableDataSource.this.input.getControl(string);
        }

        public Time getDuration() {
            return SuperCloneableDataSource.this.input.getDuration();
        }
    }

    class PushDataSourceSlave
    extends PushDataSource {
        PushSourceStream[] streams = null;

        public PushDataSourceSlave() {
            this.streams = new PushSourceStream[SuperCloneableDataSource.this.streamsAdapters.length];
            int n2 = 0;
            while (n2 < this.streams.length) {
                this.streams[n2] = (PushSourceStream)SuperCloneableDataSource.this.streamsAdapters[n2].createSlave();
                ++n2;
            }
        }

        public String getContentType() {
            return SuperCloneableDataSource.this.input.getContentType();
        }

        public void connect() throws IOException {
            int n2 = 0;
            while (n2 < this.streams.length) {
                ((SourceStreamSlave)((Object)this.streams[n2])).connect();
                ++n2;
            }
        }

        public void disconnect() {
            int n2 = 0;
            while (n2 < this.streams.length) {
                ((SourceStreamSlave)((Object)this.streams[n2])).disconnect();
                ++n2;
            }
        }

        public void start() throws IOException {
        }

        public void stop() throws IOException {
        }

        public PushSourceStream[] getStreams() {
            return this.streams;
        }

        public Object[] getControls() {
            return SuperCloneableDataSource.this.input.getControls();
        }

        public Object getControl(String string) {
            return SuperCloneableDataSource.this.input.getControl(string);
        }

        public Time getDuration() {
            return SuperCloneableDataSource.this.input.getDuration();
        }
    }
}

