/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media;

import com.sun.media.BasicInputConnector;
import com.sun.media.BasicModule;
import com.sun.media.BasicOutputConnector;
import com.sun.media.Connector;
import com.sun.media.InputConnector;
import com.sun.media.Log;
import com.sun.media.OutputConnector;
import com.sun.media.PlaybackEngine;
import com.sun.media.SimpleGraphBuilder;
import java.awt.Frame;
import javax.media.Buffer;
import javax.media.Codec;
import javax.media.Format;
import javax.media.ResourceUnavailableException;
import javax.media.control.FrameProcessingControl;

public class BasicFilterModule
extends BasicModule {
    protected Codec codec;
    protected InputConnector ic = new BasicInputConnector();
    protected OutputConnector oc;
    protected FrameProcessingControl frameControl = null;
    protected float curFramesBehind = 0.0f;
    protected float prevFramesBehind = 0.0f;
    protected Frame controlFrame;
    protected final boolean VERBOSE_CONTROL = false;
    protected Buffer storedInputBuffer;
    protected Buffer storedOutputBuffer;
    protected boolean readPendingFlag = false;
    protected boolean writePendingFlag = false;
    private boolean failed = false;
    private boolean markerSet = false;
    private Object lastHdr = null;

    public BasicFilterModule(Codec codec) {
        this.registerInputConnector("input", this.ic);
        this.oc = new BasicOutputConnector();
        this.registerOutputConnector("output", this.oc);
        this.setCodec(codec);
        this.protocol = 0;
        Object object = codec.getControl("javax.media.control.FrameProcessingControl");
        if (object instanceof FrameProcessingControl) {
            this.frameControl = (FrameProcessingControl)object;
        }
    }

    public boolean doRealize() {
        if (this.codec != null) {
            try {
                this.codec.open();
            }
            catch (ResourceUnavailableException resourceUnavailableException) {
                return false;
            }
        }
        return true;
    }

    public boolean doPrefetch() {
        return super.doPrefetch();
    }

    public void doClose() {
        if (this.codec != null) {
            this.codec.close();
        }
        if (this.controlFrame != null) {
            this.controlFrame.dispose();
            this.controlFrame = null;
        }
    }

    public void setFormat(Connector connector, Format format) {
        if (connector == this.ic) {
            if (this.codec != null) {
                this.codec.setInputFormat(format);
            }
        } else if (connector == this.oc && this.codec != null) {
            this.codec.setOutputFormat(format);
        }
    }

    public boolean setCodec(String string) {
        return true;
    }

    public boolean setCodec(Codec codec) {
        this.codec = codec;
        return true;
    }

    public Codec getCodec() {
        return this.codec;
    }

    public boolean isThreaded() {
        return this.getProtocol() == 1;
    }

    public Object[] getControls() {
        return this.codec.getControls();
    }

    public Object getControl(String string) {
        return this.codec.getControl(string);
    }

    protected void setFramesBehind(float f2) {
        this.curFramesBehind = f2;
    }

    protected boolean reinitCodec(Format format) {
        Codec codec;
        if (this.codec != null) {
            if (this.codec.setInputFormat(format) != null) {
                return true;
            }
            this.codec.close();
            this.codec = null;
        }
        if ((codec = SimpleGraphBuilder.findCodec(format, null, null, null)) == null) {
            return false;
        }
        this.setCodec(codec);
        return true;
    }

    public void process() {
        do {
            int n2;
            Buffer buffer;
            Buffer buffer2;
            block43: {
                block44: {
                    block42: {
                        if (this.readPendingFlag) {
                            buffer2 = this.storedInputBuffer;
                        } else {
                            buffer2 = this.ic.getValidBuffer();
                            Format format = buffer2.getFormat();
                            if (format == null) {
                                format = this.ic.getFormat();
                                buffer2.setFormat(format);
                            }
                            if (format != this.ic.getFormat() && format != null && !format.equals(this.ic.getFormat()) && !buffer2.isDiscard()) {
                                if (this.writePendingFlag) {
                                    this.storedOutputBuffer.setDiscard(true);
                                    this.oc.writeReport();
                                    this.writePendingFlag = false;
                                }
                                if (!this.reinitCodec(buffer2.getFormat())) {
                                    buffer2.setDiscard(true);
                                    this.ic.readReport();
                                    this.failed = true;
                                    if (this.moduleListener != null) {
                                        this.moduleListener.formatChangedFailure(this, this.ic.getFormat(), buffer2.getFormat());
                                    }
                                    return;
                                }
                                Format format2 = this.ic.getFormat();
                                this.ic.setFormat(buffer2.getFormat());
                                if (this.moduleListener != null) {
                                    this.moduleListener.formatChanged(this, format2, buffer2.getFormat());
                                }
                            }
                            if ((buffer2.getFlags() & 0x400) != 0) {
                                this.markerSet = true;
                            }
                            if (PlaybackEngine.DEBUG && buffer2 != null) {
                                this.jmd.moduleIn(this, 0, buffer2, true);
                            }
                        }
                        if (this.writePendingFlag) {
                            buffer = this.storedOutputBuffer;
                        } else {
                            buffer = this.oc.getEmptyBuffer();
                            if (buffer != null) {
                                if (PlaybackEngine.DEBUG) {
                                    this.jmd.moduleOut(this, 0, buffer, true);
                                }
                                buffer.setLength(0);
                                buffer.setOffset(0);
                                this.lastHdr = buffer.getHeader();
                            }
                        }
                        buffer.setTimeStamp(buffer2.getTimeStamp());
                        buffer.setDuration(buffer2.getDuration());
                        buffer.setSequenceNumber(buffer2.getSequenceNumber());
                        buffer.setFlags(buffer2.getFlags());
                        buffer.setHeader(buffer2.getHeader());
                        if (this.resetted) {
                            if ((buffer2.getFlags() & 0x200) != 0) {
                                this.codec.reset();
                                this.resetted = false;
                            }
                            this.writePendingFlag = false;
                            this.readPendingFlag = false;
                            this.ic.readReport();
                            this.oc.writeReport();
                            return;
                        }
                        if (this.failed || buffer2.isDiscard()) {
                            if (this.markerSet) {
                                buffer.setFlags(buffer.getFlags() & 0xFFFFFBFF);
                                this.markerSet = false;
                            }
                            this.curFramesBehind = 0.0f;
                            this.ic.readReport();
                            if (!this.writePendingFlag) {
                                this.oc.writeReport();
                            }
                            return;
                        }
                        if (this.frameControl != null && this.curFramesBehind != this.prevFramesBehind && (buffer2.getFlags() & 0x20) == 0) {
                            this.frameControl.setFramesBehind(this.curFramesBehind);
                            this.prevFramesBehind = this.curFramesBehind;
                        }
                        n2 = 0;
                        try {
                            n2 = this.codec.process(buffer2, buffer);
                        }
                        catch (Throwable throwable) {
                            Log.dumpStack(throwable);
                            if (this.moduleListener == null) break block42;
                            this.moduleListener.internalErrorOccurred(this);
                        }
                    }
                    if (PlaybackEngine.TRACE_ON && !this.verifyBuffer(buffer)) {
                        System.err.println("verify buffer failed: " + this.codec);
                        Thread.dumpStack();
                        if (this.moduleListener != null) {
                            this.moduleListener.internalErrorOccurred(this);
                        }
                    }
                    if ((n2 & 8) != 0) {
                        this.failed = true;
                        if (this.moduleListener != null) {
                            this.moduleListener.pluginTerminated(this);
                        }
                        this.writePendingFlag = false;
                        this.readPendingFlag = false;
                        this.ic.readReport();
                        this.oc.writeReport();
                        return;
                    }
                    if (this.curFramesBehind > 0.0f && buffer.isDiscard()) {
                        this.curFramesBehind -= 1.0f;
                        if (this.curFramesBehind < 0.0f) {
                            this.curFramesBehind = 0.0f;
                        }
                        n2 &= ~4;
                    }
                    if ((n2 & 1) != 0) {
                        buffer.setDiscard(true);
                        if (this.markerSet) {
                            buffer.setFlags(buffer.getFlags() & 0xFFFFFBFF);
                            this.markerSet = false;
                        }
                        if (PlaybackEngine.DEBUG) {
                            this.jmd.moduleIn(this, 0, buffer2, false);
                        }
                        this.ic.readReport();
                        if (PlaybackEngine.DEBUG) {
                            this.jmd.moduleOut(this, 0, buffer, false);
                        }
                        this.oc.writeReport();
                        this.writePendingFlag = false;
                        this.readPendingFlag = false;
                        return;
                    }
                    if (!buffer.isEOM()) break block43;
                    if ((n2 & 2) != 0) break block44;
                    if ((n2 & 4) == 0) break block43;
                }
                buffer.setEOM(false);
            }
            if ((n2 & 4) != 0) {
                this.writePendingFlag = true;
                this.storedOutputBuffer = buffer;
            } else {
                if (PlaybackEngine.DEBUG) {
                    this.jmd.moduleOut(this, 0, buffer, false);
                }
                if (this.markerSet) {
                    buffer.setFlags(buffer.getFlags() | 0x400);
                    this.markerSet = false;
                }
                this.oc.writeReport();
                this.writePendingFlag = false;
            }
            if ((n2 & 2) != 0 || buffer2.isEOM() && !buffer.isEOM()) {
                this.readPendingFlag = true;
                this.storedInputBuffer = buffer2;
                continue;
            }
            if (PlaybackEngine.DEBUG) {
                this.jmd.moduleIn(this, 0, buffer2, false);
            }
            buffer2.setHeader(this.lastHdr);
            this.ic.readReport();
            this.readPendingFlag = false;
        } while (this.readPendingFlag);
    }
}

