/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media;

import com.sun.media.BasicController;
import com.sun.media.util.MediaThread;

abstract class TimedActionThread
extends MediaThread {
    protected BasicController controller;
    protected long wakeupTime;
    protected boolean aborted = false;

    TimedActionThread(BasicController basicController, long l2) {
        this.controller = basicController;
        this.useControlPriority();
        this.wakeupTime = l2;
    }

    protected abstract long getTime();

    protected abstract void action();

    public synchronized void abort() {
        this.aborted = true;
        this.notify();
    }

    public void run() {
        long l2;
        while ((l2 = this.getTime()) < this.wakeupTime && !this.aborted) {
            long l3 = this.wakeupTime - l2;
            if (l3 > 1000000000L) {
                l3 = 1000000000L;
            }
            TimedActionThread timedActionThread = this;
            synchronized (timedActionThread) {
                try {
                    this.wait(l3 / 1000000L);
                }
                catch (InterruptedException interruptedException) {
                    break;
                }
            }
        }
        if (!this.aborted) {
            this.action();
        }
    }
}

