/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.codec.audio.mpa;

import com.sun.media.BasicPlugIn;
import com.sun.media.codec.audio.AudioCodec;
import com.sun.media.codec.audio.mpa.MPAHeader;
import com.sun.media.codec.audio.mpa.MPAParse;
import javax.media.Buffer;
import javax.media.Format;
import javax.media.format.AudioFormat;

public class DePacketizer
extends AudioCodec {
    private static int OUT_BUF_SIZE = 4096;
    private static int MAX_SEQ = 65535;
    private static Format[] defaultSupportedOutputFormats = new Format[]{new AudioFormat("mpegaudio", 44100.0, 16, -1, 1, 1), new AudioFormat("mpegaudio", 48000.0, 16, -1, 1, 1), new AudioFormat("mpegaudio", 32000.0, 16, -1, 1, 1), new AudioFormat("mpegaudio", 22050.0, 16, -1, 1, 1), new AudioFormat("mpegaudio", 24000.0, 16, -1, 1, 1), new AudioFormat("mpegaudio", 16000.0, 16, -1, 1, 1), new AudioFormat("mpegaudio", 11025.0, 16, -1, 1, 1), new AudioFormat("mpegaudio", 12000.0, 16, -1, 1, 1), new AudioFormat("mpegaudio", 8000.0, 16, -1, 1, 1), new AudioFormat("mpeglayer3", 44100.0, 16, -1, 1, 1), new AudioFormat("mpeglayer3", 48000.0, 16, -1, 1, 1), new AudioFormat("mpeglayer3", 32000.0, 16, -1, 1, 1), new AudioFormat("mpeglayer3", 22050.0, 16, -1, 1, 1), new AudioFormat("mpeglayer3", 24000.0, 16, -1, 1, 1), new AudioFormat("mpeglayer3", 16000.0, 16, -1, 1, 1), new AudioFormat("mpeglayer3", 11025.0, 16, -1, 1, 1), new AudioFormat("mpeglayer3", 12000.0, 16, -1, 1, 1), new AudioFormat("mpeglayer3", 8000.0, 16, -1, 1, 1)};
    private boolean bufferContinued = false;
    private boolean frameContinued = false;
    private int frameSize = 0;
    private int frameBegin = 0;
    private int frameOffset = 0;
    private long frameTimeStamp = 0L;
    private long bufTimeStamp = 0L;
    private long prevSeq = -1L;
    private long outSeq = 0L;
    private MPAParse mpaParse = new MPAParse();
    private MPAHeader mpaHeader = new MPAHeader();
    private static final boolean debug = false;

    public DePacketizer() {
        this.inputFormats = new Format[]{new AudioFormat("mpegaudio/rtp")};
    }

    public String getName() {
        return "MPEG Audio DePacketizer";
    }

    public Format[] getSupportedOutputFormats(Format format) {
        if (format == null) {
            return defaultSupportedOutputFormats;
        }
        if (BasicPlugIn.matches(format, this.inputFormats) == null) {
            return new Format[1];
        }
        if (!(format instanceof AudioFormat)) {
            return defaultSupportedOutputFormats;
        }
        if (this.outputFormat != null) {
            return new Format[]{this.outputFormat};
        }
        AudioFormat audioFormat = (AudioFormat)format;
        AudioFormat audioFormat2 = new AudioFormat("mpegaudio", audioFormat.getSampleRate() == -1.0 ? 44100.0 : audioFormat.getSampleRate(), audioFormat.getSampleSizeInBits() == -1 ? 16 : audioFormat.getSampleSizeInBits(), audioFormat.getChannels() == -1 ? 2 : audioFormat.getChannels());
        return new Format[]{audioFormat2};
    }

    public void open() {
    }

    public void close() {
    }

    public int process(Buffer buffer, Buffer buffer2) {
        try {
            return this.doProcess(buffer, buffer2);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return 1;
        }
    }

    public int doProcess(Buffer buffer, Buffer buffer2) {
        if (!this.checkInputBuffer(buffer)) {
            return 1;
        }
        if (this.isEOM(buffer)) {
            this.propagateEOM(buffer2);
            this.mpaParse.reset();
            return 0;
        }
        byte[] byArray = (byte[])buffer.getData();
        int n2 = buffer.getOffset();
        int n3 = buffer.getLength();
        int n4 = ((byArray[n2 + 2] & 0xFF) << 8) + (byArray[n2 + 3] & 0xFF);
        n2 += 4;
        n3 -= 4;
        if (n4 > 0) {
            if (!this.frameContinued) {
                return 4;
            }
            if (buffer.getTimeStamp() != this.frameTimeStamp) {
                this.dropFrame(buffer2);
                return 4;
            }
            if (this.getSequenceDiff(this.prevSeq, buffer.getSequenceNumber()) != 1) {
                this.dropFrame(buffer2);
                return 4;
            }
            this.prevSeq = buffer.getSequenceNumber();
            if (!this.copyBuffer(byArray, n2, n3, buffer2, this.frameBegin + this.frameOffset)) {
                this.dropFrame(buffer2);
                return 4;
            }
            this.frameOffset += n3;
            if (this.frameOffset < this.frameSize) {
                return 4;
            }
            this.frameContinued = false;
            this.frameOffset = 0;
            if (this.mpaHeader.layer == 3 && this.frameBegin == 0) {
                return 4;
            }
            buffer2.setTimeStamp(this.bufTimeStamp);
            buffer2.setFlags(buffer2.getFlags() | 0x20);
            this.bufferContinued = false;
            return 0;
        }
        if (this.frameContinued) {
            this.dropFrame(buffer2);
        }
        this.frameContinued = false;
        this.prevSeq = buffer.getSequenceNumber();
        this.frameTimeStamp = buffer.getTimeStamp();
        int n5 = this.mpaParse.getHeader(this.mpaHeader, byArray, n2, n3);
        if (n5 != MPAParse.MPA_OK) {
            if (n5 != MPAParse.MPA_HDR_DOUBTED) {
                return 1;
            }
        }
        String string = this.mpaHeader.layer == 3 ? "mpeglayer3" : "mpegaudio";
        AudioFormat audioFormat = (AudioFormat)this.outputFormat;
        if (audioFormat == null || !string.equalsIgnoreCase(audioFormat.getEncoding()) || audioFormat.getSampleRate() != (double)this.mpaHeader.samplingRate || audioFormat.getChannels() != this.mpaHeader.nChannels) {
            this.outputFormat = new AudioFormat(string, this.mpaHeader.samplingRate, 16, this.mpaHeader.nChannels, 1, 1);
        }
        this.frameSize = this.mpaHeader.bitsInFrame >> 3;
        if (this.frameSize > n3) {
            if (!this.bufferContinued) {
                buffer2.setLength(0);
                buffer2.setOffset(0);
                this.bufTimeStamp = this.frameTimeStamp;
                buffer2.setFormat(this.outputFormat);
                buffer2.setSequenceNumber(this.outSeq++);
            }
            this.bufferContinued = true;
            this.frameContinued = true;
            this.frameBegin = buffer2.getLength();
            this.frameOffset = n3;
            this.copyBuffer(byArray, n2, n3, buffer2, buffer2.getLength());
            return 4;
        }
        if (this.mpaHeader.layer == 3 && n3 < this.frameSize * 2 - 2) {
            if (!this.bufferContinued) {
                buffer2.setLength(0);
                buffer2.setOffset(0);
                this.bufTimeStamp = this.frameTimeStamp;
                byte[] byArray2 = (byte[])buffer2.getData();
                if (byArray2 == null || byArray2.length < OUT_BUF_SIZE) {
                    byArray2 = new byte[OUT_BUF_SIZE];
                    buffer2.setData(byArray2);
                }
            }
            if (!this.copyBuffer(byArray, n2, n3, buffer2, buffer2.getLength())) {
                buffer2.setFormat(this.outputFormat);
                buffer2.setSequenceNumber(this.outSeq++);
                buffer2.setTimeStamp(this.bufTimeStamp);
                buffer2.setFlags(buffer2.getFlags() | 0x20);
                this.bufferContinued = false;
                return 2;
            }
            if (buffer2.getLength() + this.frameSize + 4 > OUT_BUF_SIZE) {
                buffer2.setFormat(this.outputFormat);
                buffer2.setSequenceNumber(this.outSeq++);
                buffer2.setTimeStamp(this.bufTimeStamp);
                buffer2.setFlags(buffer2.getFlags() | 0x20);
                this.bufferContinued = false;
                return 0;
            }
            this.bufferContinued = true;
            return 4;
        }
        Object object = buffer2.getData();
        buffer2.setData(buffer.getData());
        buffer.setData(object);
        buffer2.setLength(n3);
        buffer2.setFormat(this.outputFormat);
        buffer2.setOffset(n2);
        buffer2.setSequenceNumber(this.outSeq++);
        buffer2.setTimeStamp(this.frameTimeStamp);
        buffer2.setFlags(buffer2.getFlags() | 0x20);
        return 0;
    }

    private boolean copyBuffer(byte[] byArray, int n2, int n3, Buffer buffer, int n4) {
        byte[] byArray2 = (byte[])buffer.getData();
        if (byArray2 == null || n4 + n3 > byArray2.length) {
            if (n4 + n3 > OUT_BUF_SIZE) {
                return false;
            }
            byte[] byArray3 = new byte[OUT_BUF_SIZE];
            if (n4 > 0) {
                System.arraycopy(byArray2, 0, byArray3, 0, byArray2.length);
            }
            byArray2 = byArray3;
            buffer.setData(byArray2);
        }
        System.arraycopy(byArray, n2, byArray2, n4, n3);
        buffer.setLength(buffer.getLength() + n3);
        return true;
    }

    private int getSequenceDiff(long l2, long l3) {
        if (l3 > l2) {
            return (int)(l3 - l2);
        }
        if (l3 == l2) {
            return 0;
        }
        if (l2 > (long)(MAX_SEQ - 100) && l3 < 100L) {
            return (int)((long)MAX_SEQ - l2 + l3 + 1L);
        }
        return (int)(l3 - l2);
    }

    private void dropFrame(Buffer buffer) {
        buffer.setLength(this.frameBegin - buffer.getOffset());
        this.frameBegin = buffer.getLength() + buffer.getOffset();
        this.frameSize = 0;
        this.frameOffset = 0;
        this.frameContinued = false;
    }
}

