/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.codec.video.cinepak;

import com.ibm.media.codec.video.VideoCodec;
import com.sun.media.JMFSecurityManager;
import com.sun.media.NBA;
import com.sun.media.util.Arch;
import java.awt.Dimension;
import javax.media.Buffer;
import javax.media.Format;
import javax.media.ResourceUnavailableException;
import javax.media.format.RGBFormat;
import javax.media.format.VideoFormat;

public final class NativeDecoder
extends VideoCodec {
    private int rMask = 255;
    private int gMask = 65280;
    private int bMask = 0xFF0000;
    private NBA refData;
    private int nativeData;
    private int[] colorMap = null;

    private native boolean initNative(int var1, int var2, int var3, int var4);

    private native boolean freeNative();

    private native boolean decodeNative(int var1, Object var2, long var3, Object var5, long var6, int var8);

    public NativeDecoder() {
        this.supportedInputFormats = new VideoFormat[]{new VideoFormat("cvid")};
        this.defaultOutputFormats = new VideoFormat[]{new RGBFormat(null, -1, Format.intArray, -1.0f, 32, 255, 65280, 0xFF0000, 1, -1, 0, -1), new RGBFormat(null, -1, Format.intArray, -1.0f, 32, 0xFF0000, 65280, 255, 1, -1, 0, -1), new RGBFormat(null, -1, Format.shortArray, -1.0f, 16, 63488, 2016, 31, 1, -1, 0, -1), new RGBFormat(null, -1, Format.shortArray, -1.0f, 16, 31744, 992, 31, 1, -1, 0, -1), new RGBFormat(null, -1, Format.byteArray, -1.0f, 24, 1, 2, 3, 3, -1, 0, -1), new RGBFormat(null, -1, Format.byteArray, -1.0f, 24, 3, 2, 1, 3, -1, 0, -1)};
        this.PLUGIN_NAME = "Cinepak Decoder";
    }

    protected Format[] getMatchingOutputFormats(Format format) {
        VideoFormat videoFormat = (VideoFormat)format;
        Dimension dimension = videoFormat.getSize();
        int n2 = dimension.width + 3 & 0xFFFFFFFC;
        int n3 = dimension.height + 3 & 0xFFFFFFFC;
        int n4 = n2 * n3;
        this.supportedOutputFormats = new VideoFormat[]{new RGBFormat(dimension, n4, Format.intArray, videoFormat.getFrameRate(), 32, 255, 65280, 0xFF0000, 1, n2, 0, -1), new RGBFormat(dimension, n4, Format.intArray, videoFormat.getFrameRate(), 32, 0xFF0000, 65280, 255, 1, n2, 0, -1), new RGBFormat(dimension, n4, Format.shortArray, videoFormat.getFrameRate(), 16, 63488, 2016, 31, 1, n2, 0, -1), new RGBFormat(dimension, n4, Format.shortArray, videoFormat.getFrameRate(), 16, 31744, 992, 31, 1, n2, 0, -1), new RGBFormat(dimension, n4 * 3, Format.byteArray, videoFormat.getFrameRate(), 24, 1, 2, 3, 3, n2 * 3, 0, -1), new RGBFormat(dimension, n4 * 3, Format.byteArray, videoFormat.getFrameRate(), 24, 3, 2, 1, 3, n2 * 3, 0, -1)};
        return this.supportedOutputFormats;
    }

    public void open() throws ResourceUnavailableException {
        try {
            this.initDecoder();
            super.open();
            return;
        }
        catch (Throwable throwable) {
            System.err.println("could not open " + this.PLUGIN_NAME);
            throw new ResourceUnavailableException("could not open " + this.PLUGIN_NAME);
        }
    }

    public void close() {
        this.freeNative();
        super.close();
    }

    public void reset() {
    }

    public Format setInputFormat(Format format) {
        Format format2 = super.setInputFormat(format);
        if (format2 == null) {
            return null;
        }
        if (this.opened) {
            Dimension dimension = ((VideoFormat)format).getSize();
            RGBFormat rGBFormat = (RGBFormat)this.outputFormat;
            int n2 = (dimension.width + 3 & 0xFFFFFFFC) * rGBFormat.getPixelStride();
            int n3 = dimension.height + 3 & 0xFFFFFFFC;
            int n4 = n2 * n3;
            this.outputFormat = new RGBFormat(dimension, n4, rGBFormat.getDataType(), ((VideoFormat)format).getFrameRate(), rGBFormat.getBitsPerPixel(), rGBFormat.getRedMask(), rGBFormat.getGreenMask(), rGBFormat.getBlueMask(), rGBFormat.getPixelStride(), n2, rGBFormat.getFlipped(), rGBFormat.getEndian());
        }
        return format2;
    }

    protected void videoResized() {
        this.initDecoder();
    }

    protected void initDecoder() {
        RGBFormat rGBFormat = (RGBFormat)this.outputFormat;
        this.rMask = rGBFormat.getRedMask();
        this.gMask = rGBFormat.getGreenMask();
        this.bMask = rGBFormat.getBlueMask();
        int n2 = rGBFormat.getBitsPerPixel();
        if (n2 == 24 && rGBFormat.getDataType() == Format.byteArray) {
            int n3 = n2 / 8;
            if (Arch.isLittleEndian()) {
                this.rMask = 255 << (this.rMask - 1) * 8;
                this.gMask = 255 << (this.gMask - 1) * 8;
                this.bMask = 255 << (this.bMask - 1) * 8;
            } else {
                this.rMask = 255 << (this.rMask - 1) * 8;
                this.gMask = 255 << (this.gMask - 1) * 8;
                this.bMask = 255 << (this.bMask - 1) * 8;
            }
        }
        this.initNative(n2, this.rMask, this.gMask, this.bMask);
    }

    public int process(Buffer buffer, Buffer buffer2) {
        if (!this.checkInputBuffer(buffer)) {
            return 1;
        }
        if (this.isEOM(buffer)) {
            this.propagateEOM(buffer2);
            return 0;
        }
        VideoFormat videoFormat = (VideoFormat)buffer.getFormat();
        int n2 = buffer.getLength();
        int n3 = videoFormat.getMaxDataLength();
        int n4 = this.outputFormat.getMaxDataLength();
        Class clazz = this.outputFormat.getDataType();
        buffer2.setFormat(this.outputFormat);
        byte[] byArray = (byte[])buffer.getData();
        Object object = this.validateData(buffer2, 0, true);
        int n5 = ((RGBFormat)this.outputFormat).getBitsPerPixel() / 8;
        long l2 = 0L;
        if (object instanceof NBA) {
            l2 = ((NBA)object).getNativeData();
        }
        if (this.refData == null || this.refData.getSize() < n4) {
            this.refData = new NBA(this.outputFormat.getDataType(), n4);
        }
        this.decodeNative(n5, byArray, this.refData.getNativeData(), object, l2, n4);
        this.updateOutput(buffer2, this.outputFormat, n4, 0);
        return 0;
    }

    static {
        JMFSecurityManager.loadLibrary("jmutil");
        JMFSecurityManager.loadLibrary("jmcvid");
    }
}

