/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.codec.video.jmpx;

import com.sun.media.BasicController;
import com.sun.media.JMFSecurity;
import com.sun.media.JMFSecurityManager;
import com.sun.media.MediaTimeBase;
import com.sun.media.SeekFailedEvent;
import com.sun.media.SimpleGraphBuilder;
import com.sun.media.codec.video.jmpx.DataThread;
import com.sun.media.codec.video.jmpx.JmpxAckNotifyEvent;
import com.sun.media.codec.video.jmpx.JmpxAudio;
import com.sun.media.codec.video.jmpx.JmpxEvent;
import com.sun.media.codec.video.jmpx.JmpxListener;
import com.sun.media.codec.video.jmpx.MpxCmd;
import com.sun.media.codec.video.jmpx.MpxThread;
import com.sun.media.controls.BitRateAdapter;
import com.sun.media.controls.FrameRateAdapter;
import com.sun.media.controls.GainControlAdapter;
import com.sun.media.protocol.file.DataSource;
import com.sun.media.util.MediaThread;
import com.sun.media.util.jdk12;
import com.sun.media.util.jdk12CreateThreadRunnableAction;
import com.sun.media.util.jdk12PriorityAction;
import java.awt.Canvas;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.ColorModel;
import java.awt.image.DirectColorModel;
import java.awt.image.MemoryImageSource;
import java.io.IOException;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Vector;
import javax.media.AudioDeviceUnavailableEvent;
import javax.media.Buffer;
import javax.media.ConnectionErrorEvent;
import javax.media.Control;
import javax.media.Duration;
import javax.media.DurationUpdateEvent;
import javax.media.EndOfMediaEvent;
import javax.media.Format;
import javax.media.GainControl;
import javax.media.IncompatibleSourceException;
import javax.media.IncompatibleTimeBaseException;
import javax.media.MediaLocator;
import javax.media.NotRealizedError;
import javax.media.RestartingEvent;
import javax.media.SizeChangeEvent;
import javax.media.StartEvent;
import javax.media.StopByRequestEvent;
import javax.media.Time;
import javax.media.TimeBase;
import javax.media.control.BitRateControl;
import javax.media.control.FrameRateControl;
import javax.media.format.AudioFormat;
import javax.media.format.RGBFormat;
import javax.media.format.VideoFormat;
import javax.media.format.YUVFormat;
import javax.media.protocol.PullDataSource;
import javax.media.protocol.PullSourceStream;
import javax.media.protocol.PushDataSource;
import javax.media.protocol.PushSourceStream;
import javax.media.protocol.Seekable;
import javax.media.protocol.SourceStream;
import javax.media.protocol.SourceTransferHandler;
import javax.media.renderer.VideoRenderer;

public final class Jmpx
extends BasicController
implements Runnable {
    private PipedInputStream cmdPipe;
    protected PipedOutputStream mpxCmdPipe;
    protected boolean killCommandThread = false;
    private Vector listeners;
    private MpxThread mpxThread;
    private DataThread dataThread;
    private int audioRate = 0;
    private int audioChannels = 0;
    private boolean sourceIsOn = false;
    private Component monitor;
    private long lastStatTime = 0L;
    private VideoRenderer renderer = null;
    private VideoFormat videoformat = null;
    protected JmpxAudio audio = null;
    public static boolean BIG_ENDIAN = true;
    public static boolean LITTLE_ENDIAN = false;
    public static final int MpxStrm_11172 = 1;
    public static final int MpxStrm_VSEQ = 2;
    public static final int MpxStrm_ASEQ = 4;
    public static final int MpxStrm_Unknown = 0;
    public static final int MpxAudioLeft = 1;
    public static final int MpxAudioRight = 2;
    public static final int MpxAudioStereo = 3;
    public static final int MpxAudioLowQ = 8;
    public static final int MpxAudioMedQ = 16;
    public static final int MpxAudioHiQ = 24;
    protected static final int MCMD_NULL = 0;
    protected static final int MCMD_EXIT = 1;
    protected static final int MCMD_OPENSRC = 2;
    protected static final int MCMD_CLOSESRC = 3;
    protected static final int MCMD_REENTER = 4;
    protected static final int MCMD_PLAYCTR = 5;
    protected static final int MCMD_PRESCTR = 6;
    protected static final int MCMD_STREAM = 7;
    protected static final int MCMD_SENDSTAT = 8;
    protected static final int MCMD_STATUS = 9;
    protected static final int MCMD_ACK = 10;
    protected static final int MCMD_SETRSRC = 11;
    protected static final int MCMD_CAPTURE = 12;
    protected static final int MCMD_CDOP = 13;
    protected static final int MCMD_TEST = 255;
    protected static final int MCMD_QSIZE = 30;
    protected static final int MCMD_QSTATS = 31;
    protected static final double MULF = 65535.0;
    protected static final int MCFL_SNDACK = 1;
    protected static final int MCFL_NOACK = 2;
    protected static final int MCFL_ORGMPX = 4;
    protected static final int MCFL_MPXRSV1 = 65536;
    protected static final int MSC_NONE = 0;
    protected static final int MSC_FNAME = 1;
    protected static final int MSC_CDFILE = 2;
    protected static final int MSC_NETWORK = 3;
    protected static final int MSC_FDSCP = 4;
    protected static final int MSC_JAVASTRM = 5;
    protected static final int MRE_FOFS = 1;
    protected static final int MRE_RELOFS = 2;
    protected static final int MRE_ASOPEN = 4;
    protected static final int MRE_STRMS = 8;
    protected static final int MRE_SEEKVSEQ = 16;
    public static final int PC_PLAY = 1;
    public static final int PC_FWDSPEED = 2;
    public static final int PC_FWDSTEP = 4;
    public static final int PC_PAUSE = 8;
    public static final int PC_AUDMSK = 13;
    protected static final int STRM_IGNOREID = 128;
    protected static final int STRM_SBCOFF = 64;
    protected static final int STRM_AUTOSBC = 32;
    protected static final int STRM_IDBITS = 63;
    protected static final int PCTR_VMD = 1;
    protected static final int PCTR_AMD = 2;
    protected static final int PCTR_AVOL = 4;
    protected static final int PCTR_LUM = 8;
    protected static final int PCTR_SAT = 16;
    protected static final int PCTR_GAM = 32;
    protected static final int PCTR_LSG = 56;
    protected static final int VDM_NONE = 0;
    protected static final int VDM_COL = 1;
    protected static final int VDM_COLB = 2;
    protected static final int VDM_COL8 = 3;
    protected static final int TRYSET_DONE = 0;
    protected static final int TRYSET_CANT = 1;
    protected static final int TRYSET_PASTEOM = 2;
    protected MediaThread cmdInputThread;
    protected int ackSeq = 0;
    protected int strmType;
    protected float fwdSpeed = 1.0f;
    protected int width;
    protected int height;
    protected int outWidth;
    protected int outHeight;
    protected int zoom;
    protected float java_zoom;
    protected int cmap;
    protected boolean interleaved;
    protected boolean muted = false;
    protected boolean reloaded = false;
    protected float fps;
    protected float kbps;
    protected float loc;
    protected float oldLoc;
    protected long time;
    protected long size;
    protected long frames;
    private long peer = 0L;
    protected int possibleLength = -1;
    protected int possibleWidth = -1;
    protected int possibleHeight = -1;
    protected int useJavaRenderer = 1;
    protected Object rgbBuffer = null;
    protected FrameRateControl frameRateControl = null;
    protected BitRateControl bitRateControl = null;
    protected GainControl gainControl = null;
    protected Control[] controls;
    protected int needYUVBuffer = 0;
    protected int needXBGR = 1;
    protected boolean windowAvailable = false;
    protected javax.media.protocol.DataSource source;
    protected TimeBase timeBase;
    protected String filename;
    protected SourceStream sourceStream;
    protected byte[] tempArray = new byte[65536];
    protected MemoryImageSource sourceImage = null;
    protected Image displayImage = null;
    int rMask = 255;
    int gMask = 65280;
    int bMask = 0xFF0000;
    protected Time knownDuration = Duration.DURATION_UNKNOWN;
    protected Time eomDuration = Duration.DURATION_UNKNOWN;
    protected Time requestedMediaTime = new Time(0L);
    protected boolean mediaTimeChanged = false;
    protected boolean outputSizeSet = false;
    protected int contentLength = -1;
    private static JMFSecurity jmfSecurity = null;
    private static boolean securityPrivelege = false;
    private Method[] mSecurity = new Method[1];
    private Class[] clSecurity = new Class[1];
    private Object[][] argsSecurity = new Object[1][0];
    private Buffer outBuffer = new Buffer();
    static /* synthetic */ Class class$com$sun$media$codec$video$jmpx$MpxThread;
    static /* synthetic */ Class class$com$sun$media$codec$video$jmpx$DataThread;
    static /* synthetic */ Class class$com$sun$media$util$MediaThread;

    private native boolean initMPX(Component var1);

    private native void sendMPX(byte[] var1);

    private native void broadcastMPX(byte[] var1);

    private native void setStream(SourceStream var1);

    private native int checkMpegFile(String var1);

    private native int getMediaDuration(String var1);

    private native int checkMpegStream(SourceStream var1);

    private native boolean bigEndian();

    public Jmpx() {
        this(0);
    }

    public Jmpx(int n2) {
        this.strmType = n2;
        this.width = 320;
        this.height = 240;
        this.outWidth = 320;
        this.outHeight = 240;
        this.zoom = 1;
        this.java_zoom = 1.0f;
        this.cmap = 0;
        this.interleaved = true;
        this.fps = 0.0f;
        this.kbps = 0.0f;
        this.loc = 0.0f;
        this.time = 0L;
        this.size = 0L;
        this.frames = 0L;
        this.listeners = new Vector();
    }

    public void setSource(javax.media.protocol.DataSource dataSource) throws IOException, IncompatibleSourceException {
        if (!(dataSource instanceof PullDataSource) && !(dataSource instanceof PushDataSource)) {
            System.out.println("Unsupported data source: " + dataSource);
            throw new IncompatibleSourceException(this + ": doesn't support " + dataSource);
        }
        this.source = dataSource;
    }

    protected boolean isConfigurable() {
        return false;
    }

    public void finalize() throws Throwable {
        super.finalize();
        if (this.isInitialized()) {
            this.close();
        }
    }

    protected int readFromStream(int n2, int n3) {
        if (this.tempArray == null) {
            this.tempArray = new byte[65536];
        }
        return this.readFromStream(this.tempArray, n2, n3);
    }

    protected int readFromStream(byte[] byArray, int n2, int n3) {
        if (this.sourceStream == null) {
            this.sendEvent(new ConnectionErrorEvent(this, "No source stream specified!"));
            return -1;
        }
        try {
            if (this.sourceStream instanceof PullSourceStream) {
                return ((PullSourceStream)this.sourceStream).read(byArray, n2, n3);
            }
            if (this.sourceStream instanceof PushSourceStream) {
                return this.readFromPushStream(byArray, n2, n3);
            }
        }
        catch (IOException iOException) {
            this.sendEvent(new ConnectionErrorEvent(this, iOException.getMessage()));
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    protected int readFromPushStream(byte[] byArray, int n2, int n3) throws IOException {
        int n4;
        PushSourceStream pushSourceStream = (PushSourceStream)this.sourceStream;
        boolean bl = false;
        boolean bl2 = false;
        Jmpx jmpx = this;
        // MONITORENTER : jmpx
        while ((n4 = pushSourceStream.read(byArray, n2, n3)) == 0) {
            if (!bl) {
                try {
                    this.wait(1000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                bl = true;
                continue;
            }
            super.stop();
            this.pause();
            this.sendEvent(new RestartingEvent(this, 600, 400, 600, this.getMediaTime()));
            bl2 = true;
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        // MONITOREXIT : jmpx
        if (bl2) {
            this.sendEvent(new StartEvent(this, 500, 600, 600, this.getMediaTime(), this.getTimeBase().getTime()));
        }
        if (n4 != -1) return n4;
        return 0;
    }

    protected synchronized void notifyPushDataArrival() {
        this.notifyAll();
    }

    protected boolean doRealize() {
        try {
            JMFSecurityManager.loadLibrary("jmutil");
            JMFSecurityManager.loadLibrary("jmmpx");
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            return false;
        }
        if (this.bigEndian()) {
            BIG_ENDIAN = true;
            LITTLE_ENDIAN = false;
        } else {
            BIG_ENDIAN = false;
            LITTLE_ENDIAN = true;
        }
        if (this.source == null) {
            return false;
        }
        this.mediaTimeChanged = false;
        this.startSource(true);
        this.sourceStream = null;
        this.filename = null;
        if (this.source instanceof PullDataSource) {
            PullDataSource pullDataSource = (PullDataSource)this.source;
            URL uRL = null;
            String string = null;
            MediaLocator mediaLocator = pullDataSource.getLocator();
            if (mediaLocator != null) {
                string = mediaLocator.getProtocol();
                try {
                    uRL = mediaLocator.getURL();
                }
                catch (MalformedURLException malformedURLException) {
                    uRL = null;
                }
            }
            if (this.source instanceof DataSource && string != null && string.equals("file") && uRL != null) {
                this.filename = uRL.getFile();
            } else {
                PullSourceStream[] pullSourceStreamArray = pullDataSource.getStreams();
                if (pullSourceStreamArray.length >= 1) {
                    this.sourceStream = pullSourceStreamArray[0];
                }
                this.contentLength = (int)this.sourceStream.getContentLength();
                if (this.contentLength <= 0) {
                    this.contentLength = -1;
                }
            }
        } else {
            PushDataSource pushDataSource = (PushDataSource)this.source;
            PushSourceStream[] pushSourceStreamArray = pushDataSource.getStreams();
            if (pushSourceStreamArray.length >= 1) {
                this.sourceStream = pushSourceStreamArray[0];
                ((PushSourceStream)this.sourceStream).setTransferHandler(new PushStreamHandler());
            }
        }
        if (this.sourceStream == null && this.filename == null) {
            System.err.println("No source stream");
            return false;
        }
        if (!this.checkStreamType()) {
            System.err.println("The data is not an MPEG stream.\n");
            return false;
        }
        this.reloaded = true;
        this.timeBase = new MPXTimeBase();
        this.monitor = this.createMonitor(this.width, this.height);
        this.startSource(false);
        return true;
    }

    protected void abortRealize() {
        this.startSource(false);
    }

    protected boolean doPrefetch() {
        boolean bl;
        if (this.isInitialized()) {
            return true;
        }
        if (this.strmType != 2 && !(bl = this.audioRate == 0 || this.audioChannels == 0 ? this.setAudio(22050, 1) : this.setAudio(this.audioRate, this.audioChannels))) {
            this.sendEvent(new AudioDeviceUnavailableEvent(this));
            if (this.strmType == 4) {
                return false;
            }
        }
        this.cmdPipe = new PipedInputStream();
        this.mpxCmdPipe = new PipedOutputStream();
        try {
            this.cmdPipe.connect(this.mpxCmdPipe);
        }
        catch (IOException iOException) {
            System.err.println("Failed to connect the command pipes " + iOException);
            return false;
        }
        if (jmfSecurity != null) {
            String string = null;
            try {
                if (jmfSecurity.getName().startsWith("jmf-security")) {
                    string = "thread";
                    jmfSecurity.requestPermission(this.mSecurity, this.clSecurity, this.argsSecurity, 16);
                    this.mSecurity[0].invoke((Object)this.clSecurity[0], this.argsSecurity[0]);
                    string = "thread group";
                    jmfSecurity.requestPermission(this.mSecurity, this.clSecurity, this.argsSecurity, 32);
                    this.mSecurity[0].invoke((Object)this.clSecurity[0], this.argsSecurity[0]);
                }
            }
            catch (Throwable throwable) {
                securityPrivelege = false;
            }
        }
        if (jmfSecurity != null && jmfSecurity.getName().startsWith("jdk12")) {
            try {
                Constructor constructor = jdk12CreateThreadRunnableAction.cons;
                this.mpxThread = (MpxThread)jdk12.doPrivM.invoke((Object)jdk12.ac, constructor.newInstance(class$com$sun$media$codec$video$jmpx$MpxThread == null ? (class$com$sun$media$codec$video$jmpx$MpxThread = Jmpx.class$("com.sun.media.codec.video.jmpx.MpxThread")) : class$com$sun$media$codec$video$jmpx$MpxThread, this));
                this.dataThread = (DataThread)jdk12.doPrivM.invoke((Object)jdk12.ac, constructor.newInstance(class$com$sun$media$codec$video$jmpx$DataThread == null ? (class$com$sun$media$codec$video$jmpx$DataThread = Jmpx.class$("com.sun.media.codec.video.jmpx.DataThread")) : class$com$sun$media$codec$video$jmpx$DataThread, this));
                if (!this.initMPX(this.monitor)) {
                    return false;
                }
                this.cmdInputThread = (MediaThread)jdk12.doPrivM.invoke((Object)jdk12.ac, constructor.newInstance(class$com$sun$media$util$MediaThread == null ? (class$com$sun$media$util$MediaThread = Jmpx.class$("com.sun.media.util.MediaThread")) : class$com$sun$media$util$MediaThread, this));
                this.cmdInputThread.setName("Jmpx command input thread");
                constructor = jdk12PriorityAction.cons;
                Object[] objectArray = new Object[1];
                Object[] objectArray2 = new Object[2];
                objectArray2[0] = this.cmdInputThread;
                Jmpx jmpx = this;
                objectArray2[1] = new Integer(jmpx.cmdInputThread.getControlPriority());
                objectArray[0] = constructor.newInstance(objectArray2);
                jdk12.doPrivM.invoke((Object)jdk12.ac, objectArray);
                this.cmdInputThread.start();
            }
            catch (Exception exception) {}
        } else {
            this.mpxThread = new MpxThread(this);
            this.dataThread = new DataThread(this);
            if (!this.initMPX(this.monitor)) {
                return false;
            }
            this.cmdInputThread = new MediaThread(this);
            this.cmdInputThread.setName("Jmpx command input thread");
            this.cmdInputThread.useControlPriority();
            this.cmdInputThread.start();
        }
        return true;
    }

    protected void abortPrefetch() {
        this.closeMPX();
        this.reloaded = true;
        this.startSource(false);
    }

    protected void doStart() {
        this.oldLoc = 0.0f;
        if (this.timeBase instanceof MPXTimeBase) {
            ((MPXTimeBase)this.timeBase).reset();
        }
        this.startSource(true);
        if (this.reloaded) {
            if (this.filename != null) {
                this.openFile(this.filename);
            } else if (this.sourceStream != null) {
                this.openStream(this.sourceStream);
            }
            this.reloaded = false;
        }
        if (!this.mediaTimeChanged) {
            this.play();
            return;
        }
        int n2 = this.trySetMediaTime(this.requestedMediaTime);
        if (n2 == 0) {
            this.play();
            this.mediaTimeChanged = false;
        } else if (n2 == 1) {
            super.stop();
            this.sendEvent(new SeekFailedEvent(this, 600, 500, this.getTargetState(), this.getMediaTime()));
        } else if (n2 == 2) {
            super.stop();
            this.sendEvent(new EndOfMediaEvent(this, 600, 500, this.getTargetState(), this.getMediaTime()));
        }
    }

    public void stop() {
        super.stop();
        this.pause();
        this.startSource(false);
        if (this.timeBase instanceof MPXTimeBase) {
            ((MPXTimeBase)this.timeBase).reset();
        }
        this.sendEvent(new StopByRequestEvent(this, 600, 500, this.getTargetState(), this.getMediaTime()));
    }

    public boolean startSource(boolean bl) {
        if (this.sourceIsOn == bl) {
            return true;
        }
        try {
            if (bl) {
                this.source.start();
            } else {
                this.source.stop();
            }
        }
        catch (Exception exception) {
            System.err.println("Couldn't stop the data source");
            return false;
        }
        this.sourceIsOn = bl;
        return true;
    }

    protected void closeMPX() {
        block2: {
            if (!this.isInitialized()) break block2;
            this.killCommandThread = true;
            this.exit();
            try {
                this.mpxCmdPipe.flush();
                this.mpxCmdPipe.close();
                this.cmdPipe.close();
            }
            catch (IOException iOException) {
                System.err.println("closing command pipe: " + iOException);
            }
        }
    }

    public synchronized void doClose() {
        block3: {
            if (this.isInitialized()) {
                this.windowAvailable = false;
                this.closeMPX();
                this.mpxThread = null;
                this.dataThread = null;
                this.cmdInputThread = null;
                this.monitor = null;
            }
            if (this.source == null) break block3;
            try {
                this.source.disconnect();
            }
            catch (Exception exception) {}
        }
    }

    public void setTimeBase(TimeBase timeBase) throws IncompatibleTimeBaseException {
        super.setTimeBase(timeBase);
        if (timeBase == null || timeBase != this.timeBase) {
            // empty if block
        }
        this.timeBase = timeBase;
    }

    public TimeBase getTimeBase() {
        super.getTimeBase();
        return this.timeBase;
    }

    public void setMediaTime(Time time) {
        if (this.getState() == 100 || this.getState() == 200) {
            throw new NotRealizedError("Cannot set media time on an unrealized controller");
        }
        Time time2 = this.getMediaTime();
        this.requestedMediaTime = time;
        this.mediaTimeChanged = true;
        super.setMediaTime(time);
    }

    protected int trySetMediaTime(Time time) {
        Time time2 = this.getDuration();
        double d2 = time.getSeconds();
        double d3 = time2.getSeconds();
        if (time2 != Duration.DURATION_UNKNOWN) {
            if (d2 > d3) {
                return 2;
            }
        } else if (d2 != 0.0) {
            return 1;
        }
        if (this.sourceStream != null) {
            if (this.sourceStream instanceof Seekable) {
                Seekable seekable = (Seekable)((Object)this.sourceStream);
                if (d2 == 0.0) {
                    seekable.seek(0L);
                    this.seek(0.0);
                    return 0;
                }
                if (seekable.isRandomAccess() && this.getContentLength() > 0) {
                    double d4 = d2 / d3;
                    long l2 = (long)(d4 * (double)this.getContentLength());
                    seekable.seek(l2);
                    this.seek(d4);
                    return 0;
                }
                return 1;
            }
            return 0;
        }
        if (d2 == 0.0) {
            this.seek(0.0);
            return 0;
        }
        double d5 = d2 / d3;
        if (d5 > 1.0) {
            d5 = 1.0;
        }
        this.seek(d5);
        return 0;
    }

    public long getMediaNanoseconds() {
        return this.getMediaTime().getNanoseconds();
    }

    public int getContentLength() {
        return this.contentLength;
    }

    public Time getDuration() {
        Time time;
        if (this.eomDuration != Duration.DURATION_UNKNOWN) {
            return this.eomDuration;
        }
        if (this.source instanceof Duration && (time = this.source.getDuration()) != null && time != Duration.DURATION_UNKNOWN && time != Duration.DURATION_UNBOUNDED) {
            return time;
        }
        if (this.mediaTimeChanged) {
            return this.knownDuration;
        }
        long l2 = this.getMediaNanoseconds();
        double d2 = this.getLoc();
        if (d2 == 0.0 || l2 < 3000000000L) {
            return this.knownDuration;
        }
        long l3 = (long)((double)l2 / d2);
        long l4 = this.knownDuration.getNanoseconds();
        if ((double)Math.abs(l3 - l4) > 5.0E9) {
            this.knownDuration = new Time(l3);
            this.sendEvent(new DurationUpdateEvent(this, this.knownDuration));
        }
        return this.knownDuration;
    }

    public Component getVisualComponent() {
        if (this.strmType == 4) {
            return null;
        }
        return this.monitor;
    }

    public Control[] getControls() {
        if (this.strmType != 4 && this.frameRateControl == null) {
            this.frameRateControl = new FrameRateAdapter(this, 0.0f, 0.0f, 30.0f, false){

                public float setFrameRate(float f2) {
                    this.value = f2;
                    return this.value;
                }

                public Component getControlComponent() {
                    return null;
                }

                public Object getOwner() {
                    return Jmpx.this;
                }
            };
        }
        if (this.strmType != 2 && this.gainControl == null) {
            this.gainControl = new GCA(this);
        }
        if (this.bitRateControl == null) {
            this.bitRateControl = new BitRateAdapter(0, -1, -1, false){

                public int setBitRate(int n2) {
                    this.value = n2;
                    return this.value;
                }

                public Component getControlComponent() {
                    return null;
                }
            };
        }
        int n2 = 0;
        if (this.frameRateControl != null) {
            ++n2;
        }
        if (this.gainControl != null) {
            ++n2;
        }
        if (this.bitRateControl != null) {
            ++n2;
        }
        this.controls = new Control[n2];
        n2 = 0;
        if (this.frameRateControl != null) {
            this.controls[n2++] = this.frameRateControl;
        }
        if (this.gainControl != null) {
            this.controls[n2++] = this.gainControl;
        }
        if (this.bitRateControl != null) {
            this.controls[n2++] = this.bitRateControl;
        }
        return this.controls;
    }

    public void play() {
        if (this.fwdSpeed == 1.0f) {
            this.setAction(1);
        } else {
            this.setAction(2);
        }
    }

    public void pause() {
        this.setAction(8);
    }

    protected float doSetRate(float f2) {
        if (this.strmType == 4) {
            return 1.0f;
        }
        if (f2 < 0.1f) {
            f2 = 0.1f;
        } else if (f2 > 10.0f) {
            f2 = 10.0f;
        }
        this.fwdSpeed = f2;
        return this.fwdSpeed;
    }

    public boolean checkStreamType() {
        if (this.strmType != 0) {
            this.possibleLength = -1;
            if (this.filename != null) {
                this.getMediaDuration(this.filename);
            }
            if (this.possibleLength > 0) {
                this.eomDuration = new Time((double)this.possibleLength);
            }
            return true;
        }
        this.possibleLength = -1;
        if (this.filename != null) {
            this.strmType = this.checkMpegFile(this.filename);
            if (this.strmType == 0) {
                return false;
            }
        } else if (this.sourceStream != null) {
            this.strmType = this.checkMpegStream(this.sourceStream);
            if (this.strmType == 0) {
                return false;
            }
            if (this.sourceStream instanceof Seekable) {
                ((Seekable)((Object)this.sourceStream)).seek(0L);
            }
        } else {
            return false;
        }
        if (this.possibleWidth != -1 && this.possibleHeight != -1) {
            this.width = this.possibleWidth;
            this.height = this.possibleHeight;
            this.outWidth = this.width;
            this.outHeight = this.height;
        }
        if (this.possibleLength > 0) {
            this.eomDuration = new Time((double)this.possibleLength);
        }
        return true;
    }

    protected boolean initAudio() {
        return this.audio != null;
    }

    protected void closeAudio() {
        if (this.audio != null) {
            this.audio.pause();
            this.audio.flush();
            this.audio.dispose();
            this.audio = null;
        }
    }

    protected boolean setAudio(int n2, int n3) {
        boolean bl = false;
        float f2 = -1.0f;
        if (this.audio != null) {
            if (this.audioRate == n2 && this.audioChannels == n3) {
                this.audio.flush();
                this.audio.resetSamples();
                return true;
            }
            bl = this.audio.getMute();
            f2 = (float)this.audio.getGain();
            this.audio.pause();
            this.audio.flush();
            this.audio.dispose();
        }
        AudioFormat audioFormat = new AudioFormat("LINEAR", n2, 16, n3, BIG_ENDIAN ? 1 : 0, 1);
        this.audioRate = n2;
        this.audioChannels = n3;
        this.audio = new JmpxAudio();
        if (!this.audio.initialize(audioFormat)) {
            this.audio = null;
            return false;
        }
        this.audio.resume();
        if (this.timeBase instanceof MPXTimeBase) {
            ((MPXTimeBase)this.timeBase).reset();
        }
        if (this.gainControl != null) {
            this.audio.setMute(this.gainControl.getMute());
            if (this.gainControl.getDB() != -1.0f) {
                this.audio.setGain(this.gainControl.getDB());
            }
        } else {
            if (bl) {
                this.audio.setMute(bl);
            }
            if (f2 != -1.0f) {
                this.audio.setGain(f2);
            }
        }
        return true;
    }

    public boolean isInitialized() {
        return this.peer != 0L;
    }

    public boolean isMuted() {
        return this.muted;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public int getStreamType() {
        return this.strmType;
    }

    public int getDisplayWidth() {
        if (this.useJavaRenderer == 1) {
            return this.outWidth;
        }
        return this.width * this.zoom;
    }

    public int getDisplayHeight() {
        if (this.useJavaRenderer == 1) {
            return this.outHeight;
        }
        return this.height * this.zoom;
    }

    public double getLoc() {
        return this.loc;
    }

    public void setMute(boolean bl) {
        if (this.audio != null) {
            this.audio.setMute(bl);
        }
    }

    public void setGain(float f2) {
        if (this.audio != null) {
            this.audio.setGain(f2);
        }
    }

    private synchronized void exit() {
        MpxCmd mpxCmd = new MpxCmd();
        mpxCmd.packInt(7, -859045887);
        mpxCmd.packInt(9, 1);
        this.sendMPX(mpxCmd.getBytes());
        this.peer = 0L;
    }

    private synchronized void openFile(String string) {
        MpxCmd mpxCmd = new MpxCmd();
        mpxCmd.packInt(9, 2);
        mpxCmd.packInt(10, 0);
        mpxCmd.packInt(11, 0);
        mpxCmd.packInt(12, this.strmType);
        mpxCmd.packInt(13, 0);
        mpxCmd.packInt(14, 1);
        mpxCmd.packInt(15, 1);
        mpxCmd.packStr(16, string);
        this.sendMPX(mpxCmd.getBytes());
    }

    public synchronized void openStream(SourceStream sourceStream) {
        this.setStream(sourceStream);
        MpxCmd mpxCmd = new MpxCmd();
        mpxCmd.packInt(9, 2);
        mpxCmd.packInt(10, 0);
        mpxCmd.packInt(11, 0);
        mpxCmd.packInt(12, this.strmType);
        mpxCmd.packInt(13, 0);
        mpxCmd.packInt(14, 1);
        mpxCmd.packInt(15, 5);
        this.sendMPX(mpxCmd.getBytes());
    }

    public synchronized void setAction(int n2) {
        MpxCmd mpxCmd = new MpxCmd();
        mpxCmd.packInt(9, 5);
        mpxCmd.packInt(10, n2);
        mpxCmd.packInt(11, (int)((double)this.fwdSpeed * 65535.0));
        this.sendMPX(mpxCmd.getBytes());
    }

    public synchronized void seek(double d2) {
        MpxCmd mpxCmd = new MpxCmd();
        mpxCmd.packInt(9, 4);
        mpxCmd.packInt(10, 0);
        mpxCmd.packInt(11, (int)(d2 * 65535.0));
        mpxCmd.packInt(12, this.strmType);
        mpxCmd.packInt(13, 0);
        mpxCmd.packInt(14, 1);
        this.sendMPX(mpxCmd.getBytes());
    }

    public synchronized void flush() {
        MpxCmd mpxCmd = new MpxCmd();
        mpxCmd.packInt(9, 4);
        mpxCmd.packInt(10, 0);
        mpxCmd.packInt(11, 0);
        mpxCmd.packInt(12, this.strmType);
        mpxCmd.packInt(13, 8224);
        mpxCmd.packInt(14, 4);
        this.sendMPX(mpxCmd.getBytes());
    }

    public synchronized void mute(boolean bl) {
        MpxCmd mpxCmd = new MpxCmd();
        mpxCmd.packInt(9, 7);
        if (bl) {
            mpxCmd.packInt(10, 192);
        } else {
            mpxCmd.packInt(10, 0);
        }
        this.sendMPX(mpxCmd.getBytes());
        this.muted = bl;
    }

    public synchronized void muteAll(boolean bl) {
        MpxCmd mpxCmd = new MpxCmd();
        mpxCmd.packInt(9, 7);
        if (bl) {
            mpxCmd.packInt(10, 192);
        } else {
            mpxCmd.packInt(10, 0);
        }
        this.broadcastMPX(mpxCmd.getBytes());
    }

    public synchronized void zoom(int n2) {
        if (this.useJavaRenderer != 1) {
            MpxCmd mpxCmd = new MpxCmd();
            mpxCmd.packInt(9, 6);
            mpxCmd.packInt(10, 1);
            int n3 = this.interleaved ? 2 : 1;
            n3 <<= 8;
            mpxCmd.packInt(11, n3 |= n2);
            this.sendMPX(mpxCmd.getBytes());
        } else {
            this.java_zoom = n2;
        }
    }

    public synchronized void zoomIn() {
        if (this.useJavaRenderer == 1) {
            if (this.java_zoom >= 2.0f) {
                return;
            }
            this.java_zoom *= 2.0f;
            this.updateSizeChanged(this.width, this.height);
        } else {
            this.zoom(this.zoom + 1);
        }
    }

    public synchronized void zoomOut() {
        if (this.useJavaRenderer == 1) {
            if (this.java_zoom <= 0.25f) {
                return;
            }
            this.java_zoom /= 2.0f;
            this.updateSizeChanged(this.width, this.height);
        } else {
            if (this.zoom <= 1) {
                return;
            }
            this.zoom(this.zoom - 1);
        }
    }

    public void updateSizeChanged(int n2, int n3) {
        this.sendEvent(new SizeChangeEvent(this, n2, n3, 1.0f));
    }

    public synchronized void setInterleave(boolean bl) {
        MpxCmd mpxCmd = new MpxCmd();
        mpxCmd.packInt(9, 6);
        mpxCmd.packInt(10, 1);
        int n2 = bl ? 2 : 1;
        n2 <<= 8;
        n2 = this.useJavaRenderer == 1 ? (n2 |= 1) : (n2 |= this.zoom);
        mpxCmd.packInt(11, n2);
        this.sendMPX(mpxCmd.getBytes());
    }

    public synchronized void setAudioMode(int n2) {
        MpxCmd mpxCmd = new MpxCmd();
        mpxCmd.packInt(9, 6);
        mpxCmd.packInt(10, 2);
        if ((n2 & 3) == 3) {
            mpxCmd.packInt(12, 56);
        } else if ((n2 & 2) == 2) {
            mpxCmd.packInt(12, 48);
        } else {
            mpxCmd.packInt(12, 40);
        }
        this.sendMPX(mpxCmd.getBytes());
    }

    public synchronized void setAudioQuality(int n2) {
        MpxCmd mpxCmd = new MpxCmd();
        mpxCmd.packInt(9, 6);
        mpxCmd.packInt(10, 2);
        if ((n2 & 0x18) == 24) {
            mpxCmd.packInt(12, 4);
        } else if ((n2 & 0x10) == 16) {
            mpxCmd.packInt(12, 5);
        } else {
            mpxCmd.packInt(12, 6);
        }
        this.sendMPX(mpxCmd.getBytes());
    }

    public synchronized void setGamma(double d2) {
        MpxCmd mpxCmd = new MpxCmd();
        mpxCmd.packInt(9, 6);
        mpxCmd.packInt(10, 32);
        mpxCmd.packInt(16, (int)(d2 * 65535.0));
        this.sendMPX(mpxCmd.getBytes());
    }

    public synchronized void sendAck() {
        MpxCmd mpxCmd = new MpxCmd();
        mpxCmd.packInt(7, -859045887);
        mpxCmd.packInt(9, 10);
        mpxCmd.packInt(6, this.ackSeq);
        this.sendMPX(mpxCmd.getBytes());
    }

    public void addJmpxListener(JmpxListener jmpxListener) {
        this.listeners.addElement(jmpxListener);
    }

    public void removeJmpxListener(JmpxListener jmpxListener) {
        this.listeners.removeElement(jmpxListener);
    }

    public void updateListeners(JmpxEvent jmpxEvent) {
        int n2 = 0;
        while (n2 < this.listeners.size()) {
            ((JmpxListener)this.listeners.elementAt(n2)).jmpxUpdate(jmpxEvent);
            ++n2;
        }
    }

    protected void listenCommand() {
        byte[] byArray = new byte[128];
        int n2 = 0;
        try {
            if (!this.killCommandThread) {
                n2 = this.cmdPipe.read(byArray);
            }
        }
        catch (IOException iOException) {
            return;
        }
        if (n2 > 0) {
            this.processCommand(byArray, n2);
        }
    }

    protected int processCommand(byte[] byArray, int n2) {
        int n3;
        int[] nArray = new int[n2 /= 4];
        if (BIG_ENDIAN) {
            n3 = 0;
            while (n3 < n2) {
                nArray[n3] = 0;
                int n4 = n3;
                nArray[n4] = nArray[n4] | byArray[n3 * 4] & 0x7F;
                int n5 = n3;
                nArray[n5] = nArray[n5] | byArray[n3 * 4] & 0x80;
                int n6 = n3;
                nArray[n6] = nArray[n6] << 8;
                int n7 = n3;
                nArray[n7] = nArray[n7] | byArray[n3 * 4 + 1] & 0x7F;
                int n8 = n3;
                nArray[n8] = nArray[n8] | byArray[n3 * 4 + 1] & 0x80;
                int n9 = n3;
                nArray[n9] = nArray[n9] << 8;
                int n10 = n3;
                nArray[n10] = nArray[n10] | byArray[n3 * 4 + 2] & 0x7F;
                int n11 = n3;
                nArray[n11] = nArray[n11] | byArray[n3 * 4 + 2] & 0x80;
                int n12 = n3;
                nArray[n12] = nArray[n12] << 8;
                int n13 = n3;
                nArray[n13] = nArray[n13] | byArray[n3 * 4 + 3] & 0x7F;
                int n14 = n3;
                nArray[n14] = nArray[n14] | byArray[n3 * 4 + 3] & 0x80;
                ++n3;
            }
        } else {
            n3 = 0;
            while (n3 < n2) {
                nArray[n3] = 0;
                int n15 = n3;
                nArray[n15] = nArray[n15] | byArray[n3 * 4 + 3] & 0x7F;
                int n16 = n3;
                nArray[n16] = nArray[n16] | byArray[n3 * 4 + 3] & 0x80;
                int n17 = n3;
                nArray[n17] = nArray[n17] << 8;
                int n18 = n3;
                nArray[n18] = nArray[n18] | byArray[n3 * 4 + 2] & 0x7F;
                int n19 = n3;
                nArray[n19] = nArray[n19] | byArray[n3 * 4 + 2] & 0x80;
                int n20 = n3;
                nArray[n20] = nArray[n20] << 8;
                int n21 = n3;
                nArray[n21] = nArray[n21] | byArray[n3 * 4 + 1] & 0x7F;
                int n22 = n3;
                nArray[n22] = nArray[n22] | byArray[n3 * 4 + 1] & 0x80;
                int n23 = n3;
                nArray[n23] = nArray[n23] << 8;
                int n24 = n3;
                nArray[n24] = nArray[n24] | byArray[n3 * 4 + 0] & 0x7F;
                int n25 = n3;
                nArray[n25] = nArray[n25] | byArray[n3 * 4 + 0] & 0x80;
                ++n3;
            }
        }
        n3 = 0;
        while (n3 < 4) {
            if (nArray[n3] != MpxCmd.SyncPat[n3]) {
                return 0;
            }
            ++n3;
        }
        if (nArray[4] != -1431699455) {
            return 0;
        }
        if (nArray[7] >>> 16 != 52428) {
            return 0;
        }
        int n26 = nArray[7] & 0xFFFF;
        if ((n26 & 4) == 0) {
            return 0;
        }
        if (nArray[8] >>> 16 != 56797) {
            return 0;
        }
        int n27 = nArray[8] & 0xFFFF;
        if (n27 != 1 && n27 != 2) {
            return 0;
        }
        if (n27 == 1 && n2 != 32 || n27 == 2 && n2 != 128) {
            return 0;
        }
        int n28 = nArray[6];
        int n29 = nArray[9];
        switch (n29 & 0xFF) {
            case 30: {
                this.width = nArray[10];
                this.height = nArray[11];
                if (this.useJavaRenderer != 1) {
                    this.zoom = nArray[12];
                }
                this.cmap = nArray[13];
                this.updateSize(this.width, this.height);
                this.sendEvent(new SizeChangeEvent(this, this.width, this.height, 1.0f));
                break;
            }
            case 31: {
                long l2 = System.currentTimeMillis();
                float f2 = (float)(l2 - this.lastStatTime) / 1000.0f;
                this.lastStatTime = l2;
                this.size = nArray[10];
                this.loc = (float)((double)nArray[11] / 65535.0);
                this.time = nArray[12];
                long l3 = nArray[13] + nArray[14] + nArray[15];
                this.fps = (float)(nArray[13] + nArray[14] + nArray[15]) / f2;
                this.fps = (float)((int)(this.fps * 10.0f)) / 10.0f;
                this.kbps = (float)(nArray[16] * 8) / f2 / 1000.0f;
                this.kbps = (float)((int)(this.kbps * 10.0f)) / 10.0f;
                this.frames += (long)(nArray[13] + nArray[14] + nArray[15]);
                if (this.frameRateControl != null) {
                    this.frameRateControl.setFrameRate(this.fps);
                }
                if (this.bitRateControl != null) {
                    this.bitRateControl.setBitRate((int)(this.kbps * 1000.0f));
                }
                if ((double)this.loc >= 1.0 && (this.frames != 0L || this.strmType == 4)) {
                    this.pause();
                    super.stop();
                    this.startSource(false);
                    if ((double)this.oldLoc < 1.0) {
                        this.knownDuration = this.eomDuration = this.getMediaTime();
                        this.sendEvent(new EndOfMediaEvent(this, 600, 500, this.getTargetState(), this.getMediaTime()));
                        this.sendEvent(new DurationUpdateEvent(this, this.eomDuration));
                    }
                }
                this.oldLoc = this.loc;
                this.getDuration();
                break;
            }
            case 10: {
                if (this.listeners.size() <= 0) break;
                JmpxAckNotifyEvent jmpxAckNotifyEvent = new JmpxAckNotifyEvent();
                jmpxAckNotifyEvent.sequence = n28;
                this.updateListeners(jmpxAckNotifyEvent);
                break;
            }
        }
        return n29;
    }

    public void run() {
        while (!this.killCommandThread) {
            this.listenCommand();
        }
    }

    public synchronized void resizeWindow(int n2, int n3) {
        if (this.monitor == null) {
            return;
        }
        this.width = n2;
        this.height = n3;
        if (this.videoformat instanceof RGBFormat) {
            this.rgbBuffer = new int[this.width * this.height];
            this.videoformat = new RGBFormat(new Dimension(this.width, this.height), this.width * this.height, Format.intArray, 30.0f, 32, this.rMask, this.gMask, this.bMask, 1, this.width, 0, 0);
            this.outWidth = this.width;
            this.outHeight = this.height;
            this.monitor.setSize(this.outWidth, this.outHeight);
        } else {
            this.videoformat = new YUVFormat(new Dimension(this.width, this.height), this.width * this.height * 2, Format.byteArray, -1.0f, 4, this.width, this.width / 2, 0, this.width * this.height, this.width * this.height + this.width * this.height / 4);
            this.rgbBuffer = new byte[this.width * this.height * 2];
            this.monitor.setSize(this.outWidth, this.outHeight);
        }
    }

    public Component getImage(int n2, int n3) {
        if (this.width != n2 || this.height != n3 || this.rgbBuffer == null) {
            this.resizeWindow(n2, n3);
        }
        return this.monitor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void displayImage() {
        if (this.monitor == null) {
            return;
        }
        Component component = this.monitor;
        synchronized (component) {
            if (this.videoformat instanceof RGBFormat) {
                this.outBuffer.setData((int[])this.rgbBuffer);
                this.outBuffer.setLength(this.width * this.height);
            } else {
                this.outBuffer.setData((byte[])this.rgbBuffer);
                this.outBuffer.setLength(this.width * this.height + this.width * this.height / 2);
            }
            this.outBuffer.setFormat(this.videoformat);
            this.outBuffer.setTimeStamp(-1L);
            this.outBuffer.setFlags(0);
            this.outBuffer.setHeader(null);
            this.renderer.process(this.outBuffer);
        }
    }

    private Component createMonitor(int n2, int n3) {
        ColorModel colorModel;
        Dimension dimension = new Dimension(n2, n3);
        this.videoformat = new YUVFormat(dimension, n2 * n3 * 2, Format.byteArray, -1.0f, 4, n2, n2 / 2, 0, n2 * n3, n2 * n3 + n2 * n3 / 4);
        this.renderer = (VideoRenderer)SimpleGraphBuilder.findRenderer(this.videoformat);
        if (this.renderer != null) {
            this.needYUVBuffer = 1;
            this.rgbBuffer = new byte[n2 * n3 * 2];
            return this.renderer.getComponent();
        }
        this.needXBGR = 1;
        if (LITTLE_ENDIAN) {
            this.rMask = 0xFF0000;
            this.bMask = 255;
        }
        if ((colorModel = Toolkit.getDefaultToolkit().getColorModel()) instanceof DirectColorModel) {
            DirectColorModel directColorModel = (DirectColorModel)colorModel;
            if (directColorModel.getPixelSize() > 16) {
                this.rMask = directColorModel.getRedMask();
                this.gMask = directColorModel.getGreenMask();
                this.bMask = directColorModel.getBlueMask();
            }
            if (this.rMask != 255 && !LITTLE_ENDIAN) {
                this.needXBGR = 0;
            }
        }
        this.videoformat = new RGBFormat(dimension, dimension.width * dimension.height, Format.intArray, 30.0f, 32, this.rMask, this.gMask, this.bMask, 1, dimension.width + 7 & 0xFFFFFFF8, 0, -1);
        this.rgbBuffer = new int[n2 * n3];
        this.renderer = (VideoRenderer)SimpleGraphBuilder.findRenderer(this.videoformat);
        if (this.renderer == null) {
            System.err.println("No renderer");
            return null;
        }
        return this.renderer.getComponent();
    }

    private void updateSize(int n2, int n3) {
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        try {
            jmfSecurity = JMFSecurityManager.getJMFSecurity();
            securityPrivelege = true;
        }
        catch (SecurityException securityException) {}
    }

    class GCA
    extends GainControlAdapter {
        Jmpx jmpx;

        protected GCA(Jmpx jmpx2) {
            super(false);
            this.jmpx = jmpx2;
        }

        public void setMute(boolean bl) {
            if (Jmpx.this.audio != null) {
                Jmpx.this.audio.setMute(bl);
            }
            super.setMute(bl);
        }

        public float setLevel(float f2) {
            if (this.jmpx == null) {
                return f2;
            }
            float f3 = super.setLevel(f2);
            if (Jmpx.this.audio != null) {
                Jmpx.this.audio.setGain(this.getDB());
            }
            return f3;
        }
    }

    class PushStreamHandler
    implements SourceTransferHandler {
        PushStreamHandler() {
        }

        public void transferData(PushSourceStream pushSourceStream) {
            Jmpx.this.notifyPushDataArrival();
        }
    }

    class Monitor
    extends Canvas {
        public Monitor(int n2, int n3) {
            super.setSize(n2, n3);
        }

        public void updateSize(int n2, int n3) {
            if (Jmpx.this.outputSizeSet) {
                return;
            }
            Component component = this;
            while (component.getParent() != null) {
                component = component.getParent();
            }
            super.setSize(n2, n3);
            if (component != null) {
                component.validate();
            }
            this.repaint();
        }

        public Dimension getMinimumSize() {
            return new Dimension(1, 1);
        }

        public Dimension getPreferredSize() {
            return new Dimension(Jmpx.this.getWidth(), Jmpx.this.getHeight());
        }

        public synchronized void removeNotify() {
            Jmpx.this.windowAvailable = false;
            super.removeNotify();
        }

        public synchronized void addNotify() {
            super.addNotify();
            Jmpx.this.windowAvailable = true;
        }

        public synchronized void paint(Graphics graphics) {
            if (Jmpx.this.getTargetState() == 600) {
                return;
            }
        }

        public void update(Graphics graphics) {
            if (Jmpx.this.getTargetState() == 600) {
                return;
            }
        }
    }

    class MPXTimeBase
    extends MediaTimeBase {
        MPXTimeBase() {
        }

        public long getMediaTime() {
            return Jmpx.this.audio != null ? Jmpx.this.audio.getMediaNanoseconds() : 0L;
        }

        protected void reset() {
            if (Jmpx.this.audio == null || Jmpx.this.getState() != 600) {
                this.mediaStopped();
            } else {
                this.mediaStarted();
            }
        }
    }
}

