/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.codec.video.jmpx;

import com.sun.media.renderer.audio.device.JavaSoundOutput;
import javax.media.format.AudioFormat;

public class JmpxAudio
extends JavaSoundOutput {
    private long count = 0L;
    private long JSHackIncr = 0L;
    private long JSHackCount = 0L;
    private long JSHackSample = 0L;
    private long JSHackSampleCount = 0L;
    private Object pauseSync = new Object();
    static final long MAX_TOLERENCE = 50L;
    static final long OFFSET = 0L;
    private int sampleCountLow;
    long lastPos = 0L;
    long originPos = 0L;
    long totalCount = 0L;

    public boolean initialize(AudioFormat audioFormat) {
        this.JSHackIncr = (long)(audioFormat.getSampleRate() / 60.0);
        return super.initialize(audioFormat, JmpxAudio.bufferSize(audioFormat));
    }

    public int getSampleCountHigh() {
        long l2 = this.dataLine.getFramePosition();
        if (l2 < this.lastPos) {
            this.totalCount += this.lastPos - this.originPos;
            this.originPos = l2;
        }
        this.lastPos = l2;
        long l3 = this.totalCount + l2 - this.originPos - this.count + this.JSHackSampleCount;
        if (l3 == this.JSHackSample) {
            if (this.JSHackCount++ > 50L) {
                this.JSHackSampleCount += this.JSHackIncr;
                this.JSHackCount = 0L;
            }
        } else {
            this.JSHackCount = 0L;
            this.JSHackSample = l3;
        }
        this.sampleCountLow = (int)(l3 & 0xFFFFFFFFL);
        return (int)(l3 >> 32 & 0xFFFFFFFFL);
    }

    public int getSampleCountLow() {
        return this.sampleCountLow;
    }

    public void pause() {
        Object object = this.pauseSync;
        synchronized (object) {
            super.pause();
        }
    }

    public void resume() {
        Object object = this.pauseSync;
        synchronized (object) {
            super.resume();
        }
    }

    public int write(byte[] byArray, int n2, int n3) {
        Object object = this.pauseSync;
        synchronized (object) {
            if (this.paused) {
                System.err.println("writing when paused: " + n3);
                int n4 = n3;
                return n4;
            }
            int n5 = super.write(byArray, n2, n3);
            return n5;
        }
    }

    public void flush() {
        super.flush();
    }

    public void resetSamples() {
        if (this.dataLine != null) {
            this.lastPos = this.count = (long)this.dataLine.getFramePosition();
            this.originPos = this.count;
            this.totalCount = this.count;
        }
        this.JSHackSampleCount = 0L;
    }

    private static int bufferSize(AudioFormat audioFormat) {
        int n2 = 0;
        n2 = 262144;
        return ++n2;
    }
}

