/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.codec.video.jpeg;

import com.sun.media.codec.video.jpeg.RTPDePacketizer;
import java.awt.Dimension;
import javax.media.Buffer;
import javax.media.format.VideoFormat;

class JPEGFrame {
    public long rtptimestamp = -1L;
    public int dataLength = 0;
    private RTPDePacketizer depacketizer;
    private int hdrOffset = 0;
    private long firstSeq;
    private long numPkts = 0L;
    final int FRAME_BUFFER_INITIAL_SIZE = 32000;
    int lquantOffset = 2 + APP0.length + 2 + 2 + 1;
    int cquantOffset = this.lquantOffset + 64 + 2 + 2 + 1;
    static final byte[] APP0 = new byte[]{-1, -32, 0, 16, 74, 70, 73, 70, 0, 1, 1, 0, 0, 1, 0, 1, 0, 0};
    static int[] lum_dc_codelens = new int[]{0, 1, 5, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0};
    static int[] lum_dc_symbols = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11};
    static int[] lum_ac_codelens = new int[]{0, 2, 1, 3, 3, 2, 4, 3, 5, 5, 4, 4, 0, 0, 1, 125};
    static int[] lum_ac_symbols = new int[]{1, 2, 3, 0, 4, 17, 5, 18, 33, 49, 65, 6, 19, 81, 97, 7, 34, 113, 20, 50, 129, 145, 161, 8, 35, 66, 177, 193, 21, 82, 209, 240, 36, 51, 98, 114, 130, 9, 10, 22, 23, 24, 25, 26, 37, 38, 39, 40, 41, 42, 52, 53, 54, 55, 56, 57, 58, 67, 68, 69, 70, 71, 72, 73, 74, 83, 84, 85, 86, 87, 88, 89, 90, 99, 100, 101, 102, 103, 104, 105, 106, 115, 116, 117, 118, 119, 120, 121, 122, 131, 132, 133, 134, 135, 136, 137, 138, 146, 147, 148, 149, 150, 151, 152, 153, 154, 162, 163, 164, 165, 166, 167, 168, 169, 170, 178, 179, 180, 181, 182, 183, 184, 185, 186, 194, 195, 196, 197, 198, 199, 200, 201, 202, 210, 211, 212, 213, 214, 215, 216, 217, 218, 225, 226, 227, 228, 229, 230, 231, 232, 233, 234, 241, 242, 243, 244, 245, 246, 247, 248, 249, 250};
    static int[] chm_dc_codelens = new int[]{0, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0};
    static int[] chm_dc_symbols = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11};
    static int[] chm_ac_codelens = new int[]{0, 2, 1, 2, 4, 4, 3, 4, 7, 5, 4, 4, 0, 1, 2, 119};
    static int[] chm_ac_symbols = new int[]{0, 1, 2, 3, 17, 4, 5, 33, 49, 6, 18, 65, 81, 7, 97, 113, 19, 34, 50, 129, 8, 20, 66, 145, 161, 177, 193, 9, 35, 51, 82, 240, 21, 98, 114, 209, 10, 22, 36, 52, 225, 37, 241, 23, 24, 25, 26, 38, 39, 40, 41, 42, 53, 54, 55, 56, 57, 58, 67, 68, 69, 70, 71, 72, 73, 74, 83, 84, 85, 86, 87, 88, 89, 90, 99, 100, 101, 102, 103, 104, 105, 106, 115, 116, 117, 118, 119, 120, 121, 122, 130, 131, 132, 133, 134, 135, 136, 137, 138, 146, 147, 148, 149, 150, 151, 152, 153, 154, 162, 163, 164, 165, 166, 167, 168, 169, 170, 178, 179, 180, 181, 182, 183, 184, 185, 186, 194, 195, 196, 197, 198, 199, 200, 201, 202, 210, 211, 212, 213, 214, 215, 216, 217, 218, 226, 227, 228, 229, 230, 231, 232, 233, 234, 242, 243, 244, 245, 246, 247, 248, 249, 250};
    static int[] ZigZag = new int[]{0, 1, 8, 16, 9, 2, 3, 10, 17, 24, 32, 25, 18, 11, 4, 5, 12, 19, 26, 33, 40, 48, 41, 34, 27, 20, 13, 6, 7, 14, 21, 28, 35, 42, 49, 56, 57, 50, 43, 36, 29, 22, 15, 23, 30, 37, 44, 51, 58, 59, 52, 45, 38, 31, 39, 46, 53, 60, 61, 54, 47, 55, 62, 63};
    static int[] jpeg_luma_quantizer = new int[]{16, 11, 10, 16, 24, 40, 51, 61, 12, 12, 14, 19, 26, 58, 60, 55, 14, 13, 16, 24, 40, 57, 69, 56, 14, 17, 22, 29, 51, 87, 80, 62, 18, 22, 37, 56, 68, 109, 103, 77, 24, 35, 55, 64, 81, 104, 113, 92, 49, 64, 78, 87, 103, 121, 120, 101, 72, 92, 95, 98, 112, 100, 103, 99};
    static int[] jpeg_chroma_quantizer = new int[]{17, 18, 24, 47, 99, 99, 99, 99, 18, 21, 26, 66, 99, 99, 99, 99, 24, 26, 56, 99, 99, 99, 99, 99, 47, 66, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99};

    public JPEGFrame(RTPDePacketizer rTPDePacketizer, Buffer buffer, byte[] byArray) {
        this.depacketizer = rTPDePacketizer;
        this.firstSeq = buffer.getSequenceNumber();
        if (rTPDePacketizer.frameBuffer == null) {
            rTPDePacketizer.frameBuffer = byArray != null ? byArray : new byte[32000];
        }
        this.rtptimestamp = buffer.getTimeStamp();
        int n2 = 0;
        if (!this.hasJFIFHeader(buffer)) {
            n2 = this.generateJFIFHeader(buffer);
        }
        this.add(buffer, n2);
    }

    public void add(Buffer buffer, int n2) {
        int n3 = buffer.getLength() - 8 - n2;
        int n4 = this.depacketizer.getFragOffset((byte[])buffer.getData(), buffer.getOffset());
        if (this.depacketizer.frameBuffer.length >= (n4 += this.hdrOffset) + n3 + 2) {
            System.arraycopy((byte[])buffer.getData(), buffer.getOffset() + 8 + n2, this.depacketizer.frameBuffer, n4, n3);
            this.dataLength += n3;
            ++this.numPkts;
        } else {
            this.increaseFrameBuffer(n4 + n3 + 2);
            this.add(buffer, n2);
        }
    }

    public boolean gotAllPackets(long l2) {
        return l2 - this.firstSeq + 1L == this.numPkts;
    }

    public void completeTransfer(Buffer buffer, Buffer buffer2) {
        int n2 = buffer.getOffset();
        byte[] byArray = (byte[])buffer.getData();
        int n3 = byArray[n2 + 7] & 0xFF;
        int n4 = byArray[n2 + 6] & 0xFF;
        this.depacketizer.quality = byArray[n2 + 5] & 0xFF;
        this.depacketizer.type = byArray[n2 + 4] & 0xFF;
        Dimension dimension = new Dimension(n4 * 8, n3 * 8);
        buffer.setFormat(new VideoFormat("jpeg", dimension, 0, buffer.getFormat().getDataType(), -1.0f));
        if (this.depacketizer.frameBuffer[this.dataLength - 2] != -1 || this.depacketizer.frameBuffer[this.dataLength - 1] != -39) {
            this.depacketizer.frameBuffer[this.dataLength++] = -1;
            this.depacketizer.frameBuffer[this.dataLength++] = -39;
        }
        buffer2.setData(this.depacketizer.frameBuffer);
        buffer2.setSequenceNumber(this.depacketizer.sequenceNumber++);
        buffer2.setLength(this.dataLength);
        this.depacketizer.frameBuffer = null;
    }

    private void increaseFrameBuffer(int n2) {
        byte[] byArray = new byte[n2];
        System.arraycopy(this.depacketizer.frameBuffer, 0, byArray, 0, this.depacketizer.frameBuffer.length);
        this.depacketizer.frameBuffer = byArray;
    }

    private boolean hasJFIFHeader(Buffer buffer) {
        int n2;
        byte[] byArray = (byte[])buffer.getData();
        return (byArray[(n2 = buffer.getOffset()) + 8] & 0xFF) == 255 && (byArray[n2 + 9] & 0xFF) == 216;
    }

    private int generateJFIFHeader(Buffer buffer) {
        int n2 = 0;
        byte[] byArray = (byte[])buffer.getData();
        int n3 = buffer.getOffset();
        int n4 = byArray[n3 + 4] & 0xFF;
        int n5 = byArray[n3 + 5] & 0xFF;
        int n6 = byArray[n3 + 6] & 0xFF;
        int n7 = byArray[n3 + 7] & 0xFF;
        if (n5 == this.depacketizer.lastQuality && n6 == this.depacketizer.lastWidth && n7 == this.depacketizer.lastHeight && n4 == this.depacketizer.lastType) {
            System.arraycopy(this.depacketizer.lastJFIFHeader, 0, this.depacketizer.frameBuffer, 0, this.depacketizer.lastJFIFHeader.length);
            this.hdrOffset = this.depacketizer.lastJFIFHeader.length;
        } else {
            this.hdrOffset = this.makeHeaders(this.depacketizer.frameBuffer, 0, n4, n5, n6, n7);
            this.depacketizer.lastJFIFHeader = new byte[this.hdrOffset];
            System.arraycopy(this.depacketizer.frameBuffer, 0, this.depacketizer.lastJFIFHeader, 0, this.hdrOffset);
            this.depacketizer.lastQuality = n5;
            this.depacketizer.lastType = n4;
            this.depacketizer.lastWidth = n6;
            this.depacketizer.lastHeight = n7;
        }
        if (n5 >= 100) {
            n2 = 132;
            System.arraycopy(byArray, n3 + 8 + 4, this.depacketizer.frameBuffer, this.lquantOffset, 64);
            System.arraycopy(byArray, n3 + 8 + 4 + 64, this.depacketizer.frameBuffer, this.cquantOffset, 64);
        }
        this.dataLength += this.depacketizer.lastJFIFHeader.length;
        return n2;
    }

    private int makeHeaders(byte[] byArray, int n2, int n3, int n4, int n5, int n6) {
        int[] nArray = new int[64];
        int[] nArray2 = new int[64];
        n5 *= 8;
        n6 *= 8;
        this.makeQTables(n4, nArray, nArray2);
        byArray[n2++] = -1;
        byArray[n2++] = -40;
        int n7 = 0;
        while (n7 < APP0.length) {
            byArray[n2++] = APP0[n7];
            ++n7;
        }
        n2 = this.makeQuantHeader(byArray, n2, nArray, 0);
        n2 = this.makeQuantHeader(byArray, n2, nArray2, 1);
        n2 = this.makeHuffmanHeader(byArray, n2, lum_dc_codelens, lum_dc_codelens.length, lum_dc_symbols, lum_dc_symbols.length, 0, 0);
        n2 = this.makeHuffmanHeader(byArray, n2, lum_ac_codelens, lum_ac_codelens.length, lum_ac_symbols, lum_ac_symbols.length, 0, 1);
        n2 = this.makeHuffmanHeader(byArray, n2, chm_dc_codelens, chm_dc_codelens.length, chm_dc_symbols, chm_dc_symbols.length, 1, 0);
        n2 = this.makeHuffmanHeader(byArray, n2, chm_ac_codelens, chm_ac_codelens.length, chm_ac_symbols, chm_ac_symbols.length, 1, 1);
        byArray[n2++] = -1;
        byArray[n2++] = -64;
        byArray[n2++] = 0;
        byArray[n2++] = 17;
        byArray[n2++] = 8;
        byArray[n2++] = (byte)(n6 >> 8 & 0xFF);
        byArray[n2++] = (byte)(n6 & 0xFF);
        byArray[n2++] = (byte)(n5 >> 8 & 0xFF);
        byArray[n2++] = (byte)(n5 & 0xFF);
        byArray[n2++] = 3;
        byArray[n2++] = 0;
        byArray[n2++] = n3 == 2 ? 17 : (n3 == 1 ? 34 : 33);
        byArray[n2++] = 0;
        byArray[n2++] = 1;
        byArray[n2++] = 17;
        byArray[n2++] = 1;
        byArray[n2++] = 2;
        byArray[n2++] = 17;
        byArray[n2++] = 1;
        byArray[n2++] = -1;
        byArray[n2++] = -38;
        byArray[n2++] = 0;
        byArray[n2++] = 12;
        byArray[n2++] = 3;
        byArray[n2++] = 0;
        byArray[n2++] = 0;
        byArray[n2++] = 1;
        byArray[n2++] = 17;
        byArray[n2++] = 2;
        byArray[n2++] = 17;
        byArray[n2++] = 0;
        byArray[n2++] = 63;
        byArray[n2++] = 0;
        return n2;
    }

    private int makeQuantHeader(byte[] byArray, int n2, int[] nArray, int n3) {
        byArray[n2++] = -1;
        byArray[n2++] = -37;
        byArray[n2++] = 0;
        byArray[n2++] = 67;
        byArray[n2++] = (byte)n3;
        int n4 = 0;
        while (n4 < 64) {
            byArray[n2++] = (byte)nArray[n4];
            ++n4;
        }
        return n2;
    }

    private int makeHuffmanHeader(byte[] byArray, int n2, int[] nArray, int n3, int[] nArray2, int n4, int n5, int n6) {
        byArray[n2++] = -1;
        byArray[n2++] = -60;
        byArray[n2++] = 0;
        byArray[n2++] = (byte)(3 + n3 + n4);
        byArray[n2++] = (byte)(n6 << 4 | n5);
        int n7 = 0;
        while (n7 < n3) {
            byArray[n2++] = (byte)nArray[n7];
            ++n7;
        }
        n7 = 0;
        while (n7 < n4) {
            byArray[n2++] = (byte)nArray2[n7];
            ++n7;
        }
        return n2;
    }

    private void makeQTables(int n2, int[] nArray, int[] nArray2) {
        int n3 = n2;
        if (n2 < 1) {
            n3 = 1;
        }
        if (n2 > 99) {
            n3 = 99;
        }
        n2 = n2 < 50 ? 5000 / n3 : 200 - n3 * 2;
        int n4 = 0;
        while (n4 < 64) {
            int n5 = (jpeg_luma_quantizer[ZigZag[n4]] * n2 + 50) / 100;
            int n6 = (jpeg_chroma_quantizer[ZigZag[n4]] * n2 + 50) / 100;
            if (n5 < 1) {
                n5 = 1;
            } else if (n5 > 255) {
                n5 = 255;
            }
            nArray[n4] = n5;
            if (n6 < 1) {
                n6 = 1;
            } else if (n6 > 255) {
                n6 = 255;
            }
            nArray2[n4] = n6;
            ++n4;
        }
    }
}

