/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.codec.video.jpeg;

import com.sun.media.BasicCodec;
import com.sun.media.BasicPlugIn;
import com.sun.media.Log;
import java.awt.Component;
import java.awt.Dimension;
import javax.media.Buffer;
import javax.media.Control;
import javax.media.Format;
import javax.media.ResourceUnavailableException;
import javax.media.control.FrameProcessingControl;
import javax.media.format.JPEGFormat;
import javax.media.format.VideoFormat;

public class Packetizer
extends BasicCodec {
    static final JPEGFormat fJPEG = new JPEGFormat();
    private VideoFormat inputFormat = null;
    private VideoFormat outputFormat = null;
    private int PACKET_SIZE = 960;
    private int currentSeq = 0;
    private int copyLength = this.PACKET_SIZE;
    private boolean newFrame = true;
    private boolean dropFrame = false;
    private boolean minimal = false;
    private int offset = 0;
    private int frameLength = 0;
    private static final int J_SOF = 192;
    private static final int J_SOF1 = 193;
    private int decimation = -1;
    private static final int DEFAULT_FRAMERATE = 15;
    private float frame_duration = -1.0f;

    public Packetizer() {
        this.inputFormats = new VideoFormat[]{new VideoFormat("jpeg")};
        this.outputFormats = new VideoFormat[]{new VideoFormat("jpeg/rtp")};
        FrameProcessingControl frameProcessingControl = new FrameProcessingControl(){

            public boolean setMinimalProcessing(boolean bl) {
                Packetizer.this.minimal = bl;
                return Packetizer.this.minimal;
            }

            public void setFramesBehind(float f2) {
                if (f2 >= 1.0f) {
                    Packetizer.this.dropFrame = true;
                } else {
                    Packetizer.this.dropFrame = false;
                }
            }

            public Component getControlComponent() {
                return null;
            }

            public int getFramesDropped() {
                return 0;
            }
        };
        this.controls = new Control[1];
        this.controls[0] = frameProcessingControl;
    }

    protected Format getInputFormat() {
        return this.inputFormat;
    }

    protected Format getOutputFormat() {
        return this.outputFormat;
    }

    public Format[] getSupportedOutputFormats(Format format) {
        if (format == null) {
            return this.outputFormats;
        }
        if (!this.verifyInputFormat(format)) {
            return new Format[0];
        }
        Format[] formatArray = new Format[]{((VideoFormat)format).getFrameRate() == -1.0f ? new VideoFormat("jpeg/rtp", ((VideoFormat)format).getSize(), ((VideoFormat)format).getMaxDataLength(), Format.byteArray, 15.0f) : new VideoFormat("jpeg/rtp", ((VideoFormat)format).getSize(), ((VideoFormat)format).getMaxDataLength(), Format.byteArray, ((VideoFormat)format).getFrameRate())};
        return formatArray;
    }

    private boolean verifyInputFormat(Format format) {
        return fJPEG.matches(format);
    }

    public Format setInputFormat(Format format) {
        if (!this.verifyInputFormat(format)) {
            return null;
        }
        this.inputFormat = (VideoFormat)format;
        float f2 = this.inputFormat.getFrameRate();
        if (f2 != -1.0f) {
            this.frame_duration = 1000.0f / f2;
        }
        if (this.opened) {
            this.outputFormat = (VideoFormat)this.getSupportedOutputFormats(format)[0];
        }
        return format;
    }

    public Format setOutputFormat(Format format) {
        if (BasicPlugIn.matches(format, this.outputFormats) == null) {
            return null;
        }
        this.outputFormat = (VideoFormat)format;
        return format;
    }

    public void open() throws ResourceUnavailableException {
        if (this.inputFormat == null || this.outputFormat == null) {
            throw new ResourceUnavailableException("Incorrect formats set on JPEG Packetizer");
        }
        Dimension dimension = this.inputFormat.getSize();
        if (dimension != null && (dimension.width % 8 != 0 || dimension.height % 8 != 0)) {
            Log.error("Class: " + this);
            Log.error("  can only packetize in sizes of multiple of 8 pixels.");
            throw new ResourceUnavailableException("Incorrect formats set on JPEG Packetizer");
        }
        super.open();
    }

    public void reset() {
    }

    public synchronized int process(Buffer buffer, Buffer buffer2) {
        if (this.isEOM(buffer)) {
            this.propagateEOM(buffer2);
            return 0;
        }
        if (buffer.isDiscard()) {
            this.updateOutput(buffer2, this.outputFormat, 0, 0);
            buffer2.setDiscard(true);
            return 4;
        }
        if (buffer.getLength() <= 0) {
            buffer2.setDiscard(true);
            return 4;
        }
        byte[] byArray = (byte[])buffer.getData();
        buffer2.setFormat(this.outputFormat);
        Dimension dimension = this.inputFormat.getSize();
        int n2 = 0;
        if (this.newFrame) {
            if (this.dropFrame || this.minimal) {
                buffer2.setDiscard(true);
                return 0;
            }
            int n3 = this.peekJPEGDecimation(byArray, buffer.getLength());
            if (n3 >= 0) {
                this.decimation = n3;
            }
            if (this.inputFormat instanceof JPEGFormat) {
                this.stripTables(buffer);
            }
            this.frameLength = buffer.getLength();
            this.offset = 0;
            this.newFrame = false;
            n2 = 16;
        }
        this.copyLength = this.frameLength - this.offset < this.PACKET_SIZE ? this.frameLength - this.offset : this.PACKET_SIZE;
        byte[] byArray2 = (byte[])buffer2.getData();
        if (byArray2 == null || byArray2.length < this.copyLength + 8) {
            byArray2 = new byte[this.copyLength + 8];
            buffer2.setData(byArray2);
        }
        System.arraycopy(byArray, this.offset + buffer.getOffset(), byArray2, 8, this.copyLength);
        int n4 = this.inputFormat instanceof JPEGFormat ? ((JPEGFormat)this.inputFormat).getQFactor() : 80;
        int n5 = this.decimation = this.inputFormat instanceof JPEGFormat ? ((JPEGFormat)this.inputFormat).getDecimation() : this.decimation;
        if (this.decimation == -1) {
            this.decimation = 1;
        }
        buffer2.setLength(this.copyLength + 8);
        buffer2.setOffset(0);
        buffer2.setSequenceNumber(this.currentSeq++);
        buffer2.setFormat(this.outputFormat);
        byArray2[0] = 0;
        byArray2[1] = (byte)(this.offset >> 16);
        byArray2[2] = (byte)(this.offset >> 8);
        byArray2[3] = (byte)this.offset;
        byArray2[4] = (byte)this.decimation;
        byArray2[5] = (byte)n4;
        byArray2[6] = (byte)(dimension.width / 8);
        byArray2[7] = (byte)(dimension.height / 8);
        this.offset += this.copyLength;
        buffer2.setFlags(buffer2.getFlags() | n2);
        if (this.offset == this.frameLength) {
            buffer2.setFlags(buffer2.getFlags() | 0x800);
            this.newFrame = true;
            return 0;
        }
        return 2;
    }

    public void finalize() {
        this.close();
    }

    public String getName() {
        return "JPEG Packetizer";
    }

    /*
     * Unable to fully structure code
     */
    int peekJPEGDecimation(byte[] var1_1, int var2_2) {
        var3_3 = 0;
        if ((var1_1[0] & 255) == 255 && var1_1[1] != 0) ** GOTO lbl12
        return -1;
lbl-1000:
        // 1 sources

        {
            if ((var1_1[var3_3] & 255) == 255) {
                var4_4 = var1_1[++var3_3] & 255;
                ++var3_3;
                switch (var4_4) {
                    case 192: 
                    case 193: {
                        return this.getDecimationFromSOF(var1_1, var3_3, var2_2);
                    }
                }
                continue;
            }
            ++var3_3;
lbl12:
            // 3 sources

            ** while (var3_3 < var2_2 - 2)
        }
lbl13:
        // 1 sources

        return -1;
    }

    private void stripTables(Buffer buffer) {
        byte[] byArray = (byte[])buffer.getData();
        int n2 = buffer.getOffset();
        int n3 = buffer.getLength();
        int n4 = n2;
        while (n4 < n3 + n2 - 8) {
            if (byArray[n4] == -1 && byArray[n4 + 1] == -38) {
                int n5 = (byArray[n4 + 2] & 0xFF) << 8 | byArray[n4 + 3] & 0xFF;
                System.arraycopy(byArray, n4 += 2 + n5, byArray, 0, n3 + n2 - n4);
                buffer.setOffset(0);
                buffer.setLength(n3 + n2 - n4);
                break;
            }
            ++n4;
        }
    }

    int getDecimationFromSOF(byte[] byArray, int n2, int n3) {
        int n4;
        int n5 = (byArray[n2++] & 0xFF) << 8;
        int n6 = n2++;
        n2 += 5;
        if ((n5 |= byArray[n6] & 0xFF) != (n4 = byArray[n2++] & 0xFF) * 3 + 8) {
            System.err.println("Bogus SOF length");
        }
        int n7 = byArray[n2++] & 0xFF;
        int n8 = byArray[n2++] & 0xFF;
        int n9 = n8 >> 4 & 0xF;
        int n10 = n8 & 0xF;
        if (n10 == 2 && n9 == 2) {
            return 1;
        }
        if (n10 == 1 && n9 == 1) {
            return 2;
        }
        return 0;
    }
}

