/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.content.rtp;

import com.sun.media.BasicPlayer;
import com.sun.media.JMFSecurity;
import com.sun.media.Log;
import com.sun.media.protocol.BufferListener;
import com.sun.media.rtp.RTPMediaLocator;
import com.sun.media.rtp.RTPSessionMgr;
import java.awt.Component;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.util.Vector;
import javax.media.ClockStartedError;
import javax.media.Control;
import javax.media.Controller;
import javax.media.ControllerClosedEvent;
import javax.media.ControllerErrorEvent;
import javax.media.ControllerEvent;
import javax.media.ControllerListener;
import javax.media.Format;
import javax.media.IncompatibleSourceException;
import javax.media.IncompatibleTimeBaseException;
import javax.media.Manager;
import javax.media.MediaLocator;
import javax.media.NotRealizedError;
import javax.media.Owned;
import javax.media.Player;
import javax.media.RealizeCompleteEvent;
import javax.media.SystemTimeBase;
import javax.media.Time;
import javax.media.TimeBase;
import javax.media.control.BufferControl;
import javax.media.format.AudioFormat;
import javax.media.format.FormatChangeEvent;
import javax.media.format.VideoFormat;
import javax.media.protocol.DataSource;
import javax.media.rtp.RTPControl;
import javax.media.rtp.RTPManager;
import javax.media.rtp.RTPSocket;
import javax.media.rtp.ReceiveStreamListener;
import javax.media.rtp.SessionAddress;
import javax.media.rtp.event.NewReceiveStreamEvent;
import javax.media.rtp.event.ReceiveStreamEvent;
import javax.media.rtp.event.RemotePayloadChangeEvent;

public class Handler
extends BasicPlayer
implements ReceiveStreamListener,
BufferListener {
    RTPSessionMgr[] mgrs = null;
    DataSource[] sources = null;
    Player[] players = null;
    Format[] formats = null;
    Format[] formatChanged = null;
    boolean[] realized = null;
    boolean[] dataReady = null;
    Vector locators = null;
    ControllerListener listener = new PlayerListener(this);
    boolean playersRealized = false;
    Object realizedSync = new Object();
    Object closeSync = new Object();
    Object dataSync = new Object();
    Object stateLock = new Object();
    private boolean closed = false;
    private boolean audioEnabled = false;
    private boolean videoEnabled = false;
    private boolean prebuffer = false;
    private boolean dataAllReady = false;
    private static JMFSecurity jmfSecurity = null;
    private static boolean securityPrivelege = false;
    private Method[] m = new Method[1];
    private Class[] cl = new Class[1];
    private Object[][] args = new Object[1][0];
    String sessionError = "cannot create and initialize the RTP session.";

    public Handler() {
        this.framePositioning = false;
        this.bufferControl = new BC();
        this.stopThreadEnabled = true;
    }

    protected boolean doRealize() {
        Object object;
        super.doRealize();
        try {
            if (this.source instanceof RTPSocket) {
                this.mgrs = new RTPSessionMgr[1];
                this.mgrs[1] = new RTPSessionMgr((RTPSocket)this.source);
                this.mgrs[1].addReceiveStreamListener(this);
                this.sources = new DataSource[1];
                this.players = new Player[1];
                this.formats = new Format[1];
                this.realized = new boolean[1];
                this.dataReady = new boolean[1];
                this.formatChanged = new Format[1];
                this.sources[0] = this.source;
                this.dataReady[0] = false;
            } else {
                SessionAddress sessionAddress = new SessionAddress();
                this.mgrs = new RTPSessionMgr[this.locators.size()];
                this.sources = new DataSource[this.locators.size()];
                this.players = new Player[this.locators.size()];
                this.formats = new Format[this.locators.size()];
                this.realized = new boolean[this.locators.size()];
                this.dataReady = new boolean[this.locators.size()];
                this.formatChanged = new Format[this.locators.size()];
                int n2 = 0;
                while (n2 < this.locators.size()) {
                    SessionAddress sessionAddress2;
                    object = (RTPMediaLocator)this.locators.elementAt(n2);
                    this.realized[n2] = false;
                    this.mgrs[n2] = (RTPSessionMgr)RTPManager.newInstance();
                    this.mgrs[n2].addReceiveStreamListener(this);
                    InetAddress inetAddress = InetAddress.getByName(((RTPMediaLocator)object).getSessionAddress());
                    if (inetAddress.isMulticastAddress()) {
                        sessionAddress = new SessionAddress(inetAddress, ((RTPMediaLocator)object).getSessionPort(), ((RTPMediaLocator)object).getTTL());
                        sessionAddress2 = new SessionAddress(inetAddress, ((RTPMediaLocator)object).getSessionPort(), ((RTPMediaLocator)object).getTTL());
                    } else {
                        sessionAddress = new SessionAddress(InetAddress.getLocalHost(), ((RTPMediaLocator)object).getSessionPort());
                        sessionAddress2 = new SessionAddress(inetAddress, ((RTPMediaLocator)object).getSessionPort());
                    }
                    this.mgrs[n2].initialize(sessionAddress);
                    if (this.prebuffer) {
                        BufferControl bufferControl = (BufferControl)this.mgrs[n2].getControl("javax.media.control.BufferControl");
                        bufferControl.setBufferLength(this.bufferControl.getBufferLength());
                        bufferControl.setMinimumThreshold(this.bufferControl.getMinimumThreshold());
                    }
                    this.mgrs[n2].addTarget(sessionAddress2);
                    ++n2;
                }
            }
        }
        catch (Exception exception) {
            Log.error("Cannot create the RTP Session: " + exception.getMessage());
            this.processError = this.sessionError;
            return false;
        }
        try {
            object = this.realizedSync;
            synchronized (object) {
                while (!(this.playersRealized || this.isInterrupted() || this.closed)) {
                    this.realizedSync.wait();
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.closed || this.isInterrupted()) {
            this.resetInterrupt();
            this.processError = "no RTP data was received.";
            return false;
        }
        return true;
    }

    protected void completeRealize() {
        this.state = 300;
        super.completeRealize();
    }

    protected void doStart() {
        int n2;
        super.doStart();
        Object object = this.dataSync;
        synchronized (object) {
            if (this.prebuffer) {
                this.dataAllReady = false;
                n2 = 0;
                while (n2 < this.dataReady.length) {
                    this.dataReady[n2] = false;
                    ((com.sun.media.protocol.rtp.DataSource)this.sources[n2]).flush();
                    ((com.sun.media.protocol.rtp.DataSource)this.sources[n2]).prebuffer();
                    ++n2;
                }
                if (!this.dataAllReady && !this.closed) {
                    try {
                        this.dataSync.wait(3000L);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        }
        n2 = 0;
        while (n2 < this.players.length) {
            try {
                if (this.players[n2] != null) {
                    this.waitForStart(this.players[n2]);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            ++n2;
        }
    }

    protected void doStop() {
        super.doStop();
        Object object = this.dataSync;
        synchronized (object) {
            if (this.prebuffer) {
                this.dataSync.notify();
            }
        }
        int n2 = 0;
        while (n2 < this.players.length) {
            try {
                if (this.players[n2] != null) {
                    this.waitForStop(this.players[n2]);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            ++n2;
        }
    }

    protected void doDeallocate() {
        int n2 = 0;
        while (n2 < this.players.length) {
            try {
                if (this.players[n2] != null) {
                    this.players[n2].deallocate();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            ++n2;
        }
        Object object = this.realizedSync;
        synchronized (object) {
            this.realizedSync.notify();
        }
    }

    protected void doFailedRealize() {
        Object object = this.closeSync;
        synchronized (object) {
            int n2 = 0;
            while (n2 < this.mgrs.length) {
                if (this.mgrs[n2] != null) {
                    this.mgrs[n2].removeTargets("Closing session from the RTP Handler");
                    this.mgrs[n2].dispose();
                    this.mgrs[n2] = null;
                }
                ++n2;
            }
        }
        super.doFailedRealize();
    }

    protected void doClose() {
        this.closed = true;
        Object object = this.realizedSync;
        synchronized (object) {
            this.realizedSync.notify();
        }
        Object object2 = this.dataSync;
        synchronized (object2) {
            this.dataSync.notifyAll();
        }
        this.stop();
        int n2 = 0;
        while (n2 < this.players.length) {
            try {
                if (this.players[n2] != null) {
                    this.players[n2].close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            ++n2;
        }
        Object object3 = this.closeSync;
        synchronized (object3) {
            int n3 = 0;
            while (n3 < this.mgrs.length) {
                if (this.mgrs[n3] != null) {
                    this.mgrs[n3].removeTargets("Closing session from the RTP Handler");
                    this.mgrs[n3].dispose();
                    this.mgrs[n3] = null;
                }
                ++n3;
            }
        }
        super.doClose();
    }

    public void setTimeBase(TimeBase timeBase) throws IncompatibleTimeBaseException {
    }

    protected TimeBase getMasterTimeBase() {
        return new SystemTimeBase();
    }

    public float setRate(float f2) {
        if (this.getState() < 300) {
            this.throwError(new NotRealizedError("Cannot set rate on an unrealized Player."));
        }
        return 1.0f;
    }

    public void setStopTime(Time time) {
        this.controllerSetStopTime(time);
    }

    protected void stopAtTime() {
        this.controllerStopAtTime();
    }

    public synchronized void addController(Controller controller) throws IncompatibleTimeBaseException {
        int n2 = this.getState();
        if (n2 == 600) {
            this.throwError(new ClockStartedError("Cannot add controller to a started player"));
        }
        if (n2 == 100 || n2 == 200) {
            this.throwError(new NotRealizedError("A Controller cannot be added to an Unrealized Player"));
        }
        throw new IncompatibleTimeBaseException();
    }

    protected boolean audioEnabled() {
        return this.audioEnabled;
    }

    protected boolean videoEnabled() {
        return this.videoEnabled;
    }

    private void sendMyEvent(ControllerEvent controllerEvent) {
        super.sendEvent(controllerEvent);
    }

    public void update(ReceiveStreamEvent receiveStreamEvent) {
        Object object;
        RTPSessionMgr rTPSessionMgr = (RTPSessionMgr)receiveStreamEvent.getSource();
        int n2 = 0;
        while (n2 < this.mgrs.length) {
            if (this.mgrs[n2] == rTPSessionMgr) break;
            ++n2;
        }
        if (n2 >= this.mgrs.length) {
            System.err.println("Unknown manager: " + rTPSessionMgr);
            return;
        }
        if (receiveStreamEvent instanceof RemotePayloadChangeEvent) {
            Log.comment("Received an RTP PayloadChangeEvent");
            object = (RTPControl)this.sources[n2].getControl("javax.media.rtp.RTPControl");
            if (object != null) {
                this.formatChanged[n2] = object.getFormat();
            }
            if (this.players[n2] != null) {
                this.stop();
                this.waitForClose(this.players[n2]);
            }
            try {
                this.sources[n2].connect();
                this.players[n2] = Manager.createPlayer(this.sources[n2]);
                if (this.players[n2] == null) {
                    Log.error("Could not create player for the new RTP payload.");
                    return;
                }
                this.players[n2].addControllerListener(this.listener);
                this.players[n2].realize();
            }
            catch (Exception exception) {
                Log.error("Could not create player for the new payload.");
            }
        }
        if (receiveStreamEvent instanceof NewReceiveStreamEvent) {
            if (this.players[n2] != null) {
                return;
            }
            object = null;
            try {
                object = ((NewReceiveStreamEvent)receiveStreamEvent).getReceiveStream();
                this.sources[n2] = object.getDataSource();
                RTPControl rTPControl = (RTPControl)this.sources[n2].getControl("javax.media.rtp.RTPControl");
                if (rTPControl != null) {
                    this.formats[n2] = rTPControl.getFormat();
                    if (this.formats[n2] instanceof AudioFormat) {
                        this.audioEnabled = true;
                    } else if (this.formats[n2] instanceof VideoFormat) {
                        this.videoEnabled = true;
                    }
                }
                if (this.source instanceof RTPSocket) {
                    ((RTPSocket)this.source).setChild(this.sources[n2]);
                } else {
                    ((com.sun.media.protocol.rtp.DataSource)this.source).setChild((com.sun.media.protocol.rtp.DataSource)this.sources[n2]);
                }
                this.players[n2] = Manager.createPlayer(this.sources[n2]);
                if (this.players[n2] == null) {
                    return;
                }
                this.players[n2].addControllerListener(this.listener);
                this.players[n2].realize();
                if (this.prebuffer) {
                    ((com.sun.media.protocol.rtp.DataSource)this.sources[n2]).setBufferListener(this);
                }
            }
            catch (Exception exception) {
                Log.error("NewReceiveStreamEvent exception " + exception.getMessage());
                return;
            }
        }
    }

    private void waitForStart(Player player) {
        new StateWaiter().waitForStart(player, true);
    }

    private void waitForStop(Player player) {
        new StateWaiter().waitForStart(player, false);
    }

    private void waitForClose(Player player) {
        new StateWaiter().waitForClose(player);
    }

    public void setSource(DataSource dataSource) throws IOException, IncompatibleSourceException {
        Object object;
        super.setSource(dataSource);
        if (dataSource instanceof com.sun.media.protocol.rtp.DataSource) {
            object = dataSource.getLocator();
            String string = ((MediaLocator)object).getRemainder();
            int n2 = 0;
            while (string.charAt(n2) == '/') {
                ++n2;
            }
            this.locators = new Vector();
            try {
                RTPMediaLocator rTPMediaLocator;
                String string2;
                int n3;
                while (n2 < string.length() && (n3 = string.indexOf("&", n2)) != -1) {
                    string2 = string.substring(n2, n3);
                    rTPMediaLocator = new RTPMediaLocator("rtp://" + string2);
                    this.locators.addElement(rTPMediaLocator);
                    n2 = n3 + 1;
                }
                string2 = n2 != 0 ? string.substring(n2) : string;
                rTPMediaLocator = new RTPMediaLocator("rtp://" + string2);
                this.locators.addElement(rTPMediaLocator);
            }
            catch (Exception exception) {
                throw new IncompatibleSourceException();
            }
            if (this.locators.size() > 1) {
                this.prebuffer = true;
            }
        } else if (!(dataSource instanceof RTPSocket)) {
            throw new IncompatibleSourceException();
        }
        if ((object = (RTPControl)dataSource.getControl("javax.media.rtp.RTPControl")) != null) {
            object.addFormat(new AudioFormat("dvi/rtp", 44100.0, 4, 1), 18);
        }
    }

    private void invalidateComp() {
        this.controlComp = null;
        this.controls = null;
    }

    public Component getVisualComponent() {
        super.getVisualComponent();
        int n2 = 0;
        while (n2 < this.players.length) {
            if (this.players[n2] != null && this.players[n2].getVisualComponent() != null) {
                return this.players[n2].getVisualComponent();
            }
            ++n2;
        }
        return null;
    }

    public Control[] getControls() {
        if (this.controls != null) {
            return this.controls;
        }
        Vector<Control> vector = new Vector<Control>();
        if (this.cachingControl != null) {
            vector.addElement(this.cachingControl);
        }
        if (this.bufferControl != null) {
            vector.addElement(this.bufferControl);
        }
        int n2 = this.players.length;
        int n3 = 0;
        while (n3 < n2) {
            Player player = this.players[n3];
            Control[] controlArray = player.getControls();
            if (controlArray != null) {
                int n4 = 0;
                while (n4 < controlArray.length) {
                    vector.addElement(controlArray[n4]);
                    ++n4;
                }
            }
            ++n3;
        }
        n2 = vector.size();
        Control[] controlArray = new Control[n2];
        n3 = 0;
        while (n3 < n2) {
            controlArray[n3] = (Control)vector.elementAt(n3);
            ++n3;
        }
        if (this.getState() >= 300) {
            this.controls = controlArray;
        }
        return controlArray;
    }

    public void updateStats() {
        int n2 = 0;
        while (n2 < this.players.length) {
            if (this.players[n2] != null) {
                ((BasicPlayer)this.players[n2]).updateStats();
            }
            ++n2;
        }
    }

    public void minThresholdReached(DataSource dataSource) {
        boolean bl = true;
        Object object = this.dataSync;
        synchronized (object) {
            int n2 = 0;
            while (n2 < this.sources.length) {
                if (this.sources[n2] == dataSource) {
                    this.dataReady[n2] = true;
                } else if (!this.dataReady[n2]) {
                    bl = false;
                }
                ++n2;
            }
            if (!bl) {
                return;
            }
            this.dataAllReady = true;
            this.dataSync.notify();
        }
    }

    class BC
    implements BufferControl,
    Owned {
        long len = -1L;
        long min = -1L;

        BC() {
        }

        public long getBufferLength() {
            if (this.len < 0L) {
                return Handler.this.prebuffer ? 750L : 125L;
            }
            return this.len;
        }

        public long setBufferLength(long l2) {
            this.len = l2;
            Log.comment("RTP Handler buffer length set: " + this.len);
            return this.len;
        }

        public long getMinimumThreshold() {
            if (this.min < 0L) {
                return Handler.this.prebuffer ? 125L : 0L;
            }
            return this.min;
        }

        public long setMinimumThreshold(long l2) {
            this.min = l2;
            Log.comment("RTP Handler buffer minimum threshold: " + this.min);
            return this.min;
        }

        public void setEnabledThreshold(boolean bl) {
        }

        public boolean getEnabledThreshold() {
            return this.getMinimumThreshold() > 0L;
        }

        public Component getControlComponent() {
            return null;
        }

        public Object getOwner() {
            return Handler.this;
        }
    }

    class PlayerListener
    implements ControllerListener {
        Handler handler;

        public PlayerListener(Handler handler2) {
            this.handler = handler2;
        }

        public synchronized void controllerUpdate(ControllerEvent controllerEvent) {
            Player player = (Player)controllerEvent.getSourceController();
            if (player == null) {
                return;
            }
            int n2 = 0;
            while (n2 < Handler.this.players.length) {
                if (Handler.this.players[n2] == player) break;
                ++n2;
            }
            if (n2 >= Handler.this.players.length) {
                System.err.println("Unknown player: " + player);
                return;
            }
            if (controllerEvent instanceof RealizeCompleteEvent) {
                if (Handler.this.formatChanged[n2] != null) {
                    try {
                        Handler.this.invalidateComp();
                        FormatChangeEvent formatChangeEvent = new FormatChangeEvent(this.handler, Handler.this.formats[n2], Handler.this.formatChanged[n2]);
                        this.handler.sendMyEvent(formatChangeEvent);
                        Handler.this.formats[n2] = Handler.this.formatChanged[n2];
                        Handler.this.formatChanged[n2] = null;
                    }
                    catch (Exception exception) {
                        exception.getMessage();
                    }
                }
                Handler.this.realized[n2] = true;
                int n3 = 0;
                while (n3 < Handler.this.realized.length) {
                    if (!Handler.this.realized[n3]) {
                        return;
                    }
                    ++n3;
                }
                Object object = Handler.this.realizedSync;
                synchronized (object) {
                    Handler.this.playersRealized = true;
                    Handler.this.realizedSync.notifyAll();
                }
            }
            if (controllerEvent instanceof ControllerErrorEvent) {
                Handler.this.players[n2].removeControllerListener(this);
                Log.error("RTP Handler internal error: " + controllerEvent);
                Handler.this.players[n2] = null;
            }
        }
    }

    class StateWaiter
    implements ControllerListener {
        boolean closeDown = false;
        Object stateLock = new Object();

        StateWaiter() {
        }

        public void waitForStart(Player player, boolean bl) {
            player.addControllerListener(this);
            if (bl) {
                player.start();
            } else {
                player.stop();
            }
            Object object = this.stateLock;
            synchronized (object) {
                while ((bl && player.getState() != 600 || !bl && player.getState() == 600) && !this.closeDown) {
                    try {
                        this.stateLock.wait(1000L);
                    }
                    catch (InterruptedException interruptedException) {
                        break;
                    }
                }
            }
            player.removeControllerListener(this);
        }

        public void waitForClose(Player player) {
            player.addControllerListener(this);
            player.close();
            Object object = this.stateLock;
            synchronized (object) {
                while (!this.closeDown) {
                    try {
                        this.stateLock.wait(1000L);
                    }
                    catch (InterruptedException interruptedException) {
                        break;
                    }
                }
            }
            player.removeControllerListener(this);
        }

        public void controllerUpdate(ControllerEvent controllerEvent) {
            if (controllerEvent instanceof ControllerClosedEvent || controllerEvent instanceof ControllerErrorEvent) {
                this.closeDown = true;
            }
            Object object = this.stateLock;
            synchronized (object) {
                this.stateLock.notify();
            }
        }
    }
}

