/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.controls;

import com.ms.security.PermissionID;
import com.ms.security.PolicyEngine;
import com.sun.media.CircularBuffer;
import com.sun.media.JMFSecurity;
import com.sun.media.JMFSecurityManager;
import com.sun.media.Log;
import com.sun.media.controls.CreateWorkThreadAction;
import com.sun.media.controls.MonitorThread;
import com.sun.media.util.AudioCodecChain;
import com.sun.media.util.CodecChain;
import com.sun.media.util.LoopThread;
import com.sun.media.util.VideoCodecChain;
import com.sun.media.util.jdk12;
import java.awt.BorderLayout;
import java.awt.Checkbox;
import java.awt.Color;
import java.awt.Component;
import java.awt.MenuItem;
import java.awt.Panel;
import java.awt.PopupMenu;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import javax.media.Buffer;
import javax.media.Format;
import javax.media.Owned;
import javax.media.control.MonitorControl;
import javax.media.format.AudioFormat;
import javax.media.format.UnsupportedFormatException;
import javax.media.format.VideoFormat;

public class MonitorAdapter
implements MonitorControl,
Owned {
    protected CodecChain cc = null;
    protected boolean enabled = false;
    protected boolean closed = false;
    protected Component visualComponent = null;
    protected Component controlComponent = null;
    protected Checkbox cbEnabled = null;
    protected Format format = null;
    protected float inFrameRate = 0.0f;
    protected float previewFrameRate = 30.0f;
    protected long lastPreviewTime = 0L;
    protected long previewInterval = 33333333L;
    protected MouseListener ml = null;
    protected PopupMenu rateMenu = null;
    protected LoopThread loopThread;
    protected int[] frameRates = new int[]{0, 1, 2, 5, 7, 10, 15, 20, 30, 60, 90};
    CircularBuffer bufferQ;
    Object owner;
    private static JMFSecurity jmfSecurity = null;
    private static boolean securityPrivelege = false;
    private Method[] mSecurity = new Method[1];
    private Class[] clSecurity = new Class[1];
    private Object[][] argsSecurity = new Object[1][0];
    static VideoFormat mpegVideo = new VideoFormat("mpeg/rtp");
    static /* synthetic */ Class class$com$sun$media$controls$MonitorThread;
    static /* synthetic */ Class class$com$sun$media$controls$MonitorAdapter;

    public MonitorAdapter(Format format, Object object) {
        this.format = format;
        this.owner = object;
    }

    protected boolean open() {
        Object object;
        try {
            if (this.format instanceof VideoFormat) {
                object = (VideoFormat)this.format;
                this.cc = new VideoCodecChain((VideoFormat)object);
                this.inFrameRate = ((VideoFormat)object).getFrameRate();
                if (this.inFrameRate < 0.0f) {
                    this.inFrameRate = 30.0f;
                }
                this.inFrameRate = (float)((int)((double)(this.inFrameRate * 10.0f) + 0.5)) / 10.0f;
            } else if (this.format instanceof AudioFormat) {
                this.cc = new AudioCodecChain((AudioFormat)this.format);
            }
        }
        catch (UnsupportedFormatException unsupportedFormatException) {
            Log.warning("Failed to initialize the monitor control: " + unsupportedFormatException);
            return false;
        }
        if (this.cc == null) {
            return false;
        }
        this.bufferQ = new CircularBuffer(2);
        if (jmfSecurity != null) {
            object = null;
            try {
                if (jmfSecurity.getName().startsWith("jmf-security")) {
                    object = "thread";
                    jmfSecurity.requestPermission(this.mSecurity, this.clSecurity, this.argsSecurity, 16);
                    this.mSecurity[0].invoke((Object)this.clSecurity[0], this.argsSecurity[0]);
                    object = "thread group";
                    jmfSecurity.requestPermission(this.mSecurity, this.clSecurity, this.argsSecurity, 32);
                    this.mSecurity[0].invoke((Object)this.clSecurity[0], this.argsSecurity[0]);
                } else if (jmfSecurity.getName().startsWith("internet")) {
                    PolicyEngine.checkPermission((PermissionID)PermissionID.THREAD);
                    PolicyEngine.assertPermission((PermissionID)PermissionID.THREAD);
                }
            }
            catch (Throwable throwable) {
                securityPrivelege = false;
            }
        }
        if (jmfSecurity != null && jmfSecurity.getName().startsWith("jdk12")) {
            try {
                object = CreateWorkThreadAction.cons;
                this.loopThread = (MonitorThread)jdk12.doPrivM.invoke((Object)jdk12.ac, ((Constructor)object).newInstance(class$com$sun$media$controls$MonitorThread == null ? (class$com$sun$media$controls$MonitorThread = MonitorAdapter.class$("com.sun.media.controls.MonitorThread")) : class$com$sun$media$controls$MonitorThread, class$com$sun$media$controls$MonitorAdapter == null ? (class$com$sun$media$controls$MonitorAdapter = MonitorAdapter.class$("com.sun.media.controls.MonitorAdapter")) : class$com$sun$media$controls$MonitorAdapter, this));
            }
            catch (Exception exception) {}
        } else {
            this.loopThread = new MonitorThread(this);
        }
        return true;
    }

    public Object getOwner() {
        return this.owner;
    }

    public boolean setEnabled(boolean bl) {
        if (bl) {
            if (this.cc == null) {
                if (!this.open()) {
                    return false;
                }
            } else {
                this.cc.reset();
            }
            if (!this.cc.prefetch()) {
                return false;
            }
            CircularBuffer circularBuffer = this.bufferQ;
            synchronized (circularBuffer) {
                while (this.bufferQ.canRead()) {
                    this.bufferQ.read();
                    this.bufferQ.readReport();
                }
            }
            this.enabled = true;
            this.loopThread.start();
        } else if (!bl && this.cc != null) {
            this.loopThread.pause();
            CircularBuffer circularBuffer = this.bufferQ;
            synchronized (circularBuffer) {
                this.enabled = false;
                this.bufferQ.notifyAll();
            }
            this.cc.deallocate();
        }
        return this.enabled;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void reset() {
        if (this.cc != null) {
            this.cc.reset();
        }
    }

    public void close() {
        if (this.cc == null) {
            return;
        }
        this.loopThread.kill();
        CircularBuffer circularBuffer = this.bufferQ;
        synchronized (circularBuffer) {
            this.closed = true;
            this.bufferQ.notifyAll();
        }
        this.cc.close();
        this.cc = null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void process(Buffer buffer) {
        if (buffer == null) return;
        if (this.previewFrameRate <= 0.0f) return;
        if (this.format == null) return;
        if (buffer.isEOM()) return;
        if (buffer.isDiscard()) return;
        if ((buffer.getFlags() & 0x200) != 0) {
            return;
        }
        if (!this.format.matches(buffer.getFormat())) {
            return;
        }
        Buffer buffer2 = null;
        CircularBuffer circularBuffer = this.bufferQ;
        synchronized (circularBuffer) {
            while (!this.bufferQ.canWrite() && this.enabled && !this.closed) {
                try {
                    this.bufferQ.wait();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (!this.enabled) return;
            if (this.closed) {
                return;
            }
            buffer2 = this.bufferQ.getEmptyBuffer();
        }
        buffer2.setData(this.copyData(buffer.getData()));
        buffer2.setFlags(buffer.getFlags());
        buffer2.setFormat(buffer.getFormat());
        buffer2.setSequenceNumber(buffer.getSequenceNumber());
        buffer2.setHeader(buffer.getHeader());
        buffer2.setLength(buffer.getLength());
        buffer2.setOffset(buffer.getOffset());
        buffer2.setTimeStamp(buffer.getTimeStamp());
        CircularBuffer circularBuffer2 = this.bufferQ;
        synchronized (circularBuffer2) {
            this.bufferQ.writeReport();
            this.bufferQ.notifyAll();
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean doProcess() {
        boolean bl;
        Buffer buffer;
        block13: {
            block14: {
                block12: {
                    CircularBuffer circularBuffer = this.bufferQ;
                    synchronized (circularBuffer) {
                        while (!this.bufferQ.canRead() && this.enabled && !this.closed) {
                            try {
                                this.bufferQ.wait();
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                        if (this.closed) {
                            return false;
                        }
                        if (!this.enabled) {
                            return true;
                        }
                        buffer = this.bufferQ.read();
                    }
                    bl = false;
                    if (!(buffer.getFormat() instanceof AudioFormat)) break block12;
                    bl = true;
                    break block13;
                }
                long l2 = buffer.getTimeStamp();
                if (l2 < this.lastPreviewTime + this.previewInterval && l2 > this.lastPreviewTime) break block14;
                if (mpegVideo.matches(this.format)) {
                    int n2;
                    byte[] byArray = (byte[])buffer.getData();
                    int n3 = byArray[(n2 = buffer.getOffset()) + 2] & 7;
                    if (n3 == 1) {
                        this.lastPreviewTime = l2;
                        bl = true;
                    }
                    break block13;
                } else {
                    this.lastPreviewTime = l2;
                    bl = true;
                }
                break block13;
            }
            bl = false;
        }
        this.cc.process(buffer, bl);
        CircularBuffer circularBuffer = this.bufferQ;
        synchronized (circularBuffer) {
            this.bufferQ.readReport();
            this.bufferQ.notifyAll();
            return true;
        }
    }

    private Object copyData(Object object) {
        if (object instanceof byte[]) {
            byte[] byArray = new byte[((byte[])object).length];
            System.arraycopy(object, 0, byArray, 0, byArray.length);
            return byArray;
        }
        if (object instanceof short[]) {
            short[] sArray = new short[((short[])object).length];
            System.arraycopy(object, 0, sArray, 0, sArray.length);
            return sArray;
        }
        if (object instanceof int[]) {
            int[] nArray = new int[((int[])object).length];
            System.arraycopy(object, 0, nArray, 0, nArray.length);
            return nArray;
        }
        return object;
    }

    public float setPreviewFrameRate(float f2) {
        if (f2 > this.inFrameRate) {
            f2 = this.inFrameRate;
        }
        this.previewFrameRate = f2;
        this.previewInterval = (long)(1.0E9 / (double)f2);
        return f2;
    }

    public Component getControlComponent() {
        Panel panel;
        if (this.controlComponent != null) {
            return this.controlComponent;
        }
        if (this.cc == null && !this.open()) {
            return null;
        }
        this.controlComponent = this.cc.getControlComponent();
        if (this.format instanceof AudioFormat && this.controlComponent != null) {
            panel = new Panel();
            panel.setLayout(new BorderLayout());
            this.cbEnabled = new Checkbox("Monitor Audio");
            panel.add("West", this.cbEnabled);
            panel.add("Center", this.controlComponent);
            this.controlComponent = panel;
            panel.setBackground(Color.lightGray);
        }
        if (this.format instanceof VideoFormat && this.controlComponent != null) {
            panel = new Panel();
            panel.setLayout(new BorderLayout());
            this.cbEnabled = new Checkbox("Monitor Video");
            panel.add("South", this.cbEnabled);
            panel.add("Center", this.controlComponent);
            this.addPopupMenu(this.controlComponent);
            this.controlComponent = panel;
            panel.setBackground(Color.lightGray);
        }
        if (this.cbEnabled != null) {
            this.cbEnabled.setState(this.isEnabled());
            this.cbEnabled.addItemListener(new ItemListener(){

                public void itemStateChanged(ItemEvent itemEvent) {
                    MonitorAdapter.this.setEnabled(MonitorAdapter.this.cbEnabled.getState());
                }
            });
        }
        return this.controlComponent;
    }

    private void addPopupMenu(Component component) {
        MenuItem menuItem;
        this.visualComponent = component;
        this.rateMenu = new PopupMenu("Monitor Rate");
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                block2: {
                    String string = actionEvent.getActionCommand();
                    int n2 = string.indexOf(" ");
                    String string2 = string.substring(0, n2);
                    try {
                        int n3 = Integer.parseInt(string2);
                        MonitorAdapter.this.setPreviewFrameRate(n3);
                    }
                    catch (Throwable throwable) {
                        if (!(throwable instanceof ThreadDeath)) break block2;
                        throw (ThreadDeath)throwable;
                    }
                }
            }
        };
        component.add(this.rateMenu);
        int n2 = 0;
        int n3 = 0;
        while (n3 < this.frameRates.length) {
            if ((float)this.frameRates[n3] < this.inFrameRate) {
                menuItem = new MenuItem(this.frameRates[n3] + " fps");
                this.rateMenu.add(menuItem);
                menuItem.addActionListener(actionListener);
                n2 = this.frameRates[n3];
            }
            ++n3;
        }
        if ((float)n2 < this.inFrameRate) {
            menuItem = new MenuItem(this.inFrameRate + " fps");
            this.rateMenu.add(menuItem);
            menuItem.addActionListener(actionListener);
        }
        this.ml = new MouseAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                if (mouseEvent.isPopupTrigger()) {
                    MonitorAdapter.this.rateMenu.show(MonitorAdapter.this.visualComponent, mouseEvent.getX(), mouseEvent.getY());
                }
            }

            public void mouseReleased(MouseEvent mouseEvent) {
                if (mouseEvent.isPopupTrigger()) {
                    MonitorAdapter.this.rateMenu.show(MonitorAdapter.this.visualComponent, mouseEvent.getX(), mouseEvent.getY());
                }
            }

            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.isPopupTrigger()) {
                    MonitorAdapter.this.rateMenu.show(MonitorAdapter.this.visualComponent, mouseEvent.getX(), mouseEvent.getY());
                }
            }
        };
        component.addMouseListener(this.ml);
    }

    public void finalize() {
        if (this.visualComponent != null) {
            this.visualComponent.remove(this.rateMenu);
            this.visualComponent.removeMouseListener(this.ml);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        try {
            jmfSecurity = JMFSecurityManager.getJMFSecurity();
            securityPrivelege = true;
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
    }
}

